/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.customer;

import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.customer.MessageRecord;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class AIChatPanel
extends JPanel {
    private static final String SEPE = "=====";
    private JTextPane chatPane;
    private StyledDocument doc;
    private JScrollPane scrollPane;
    private SimpleAttributeSet leftAlign;
    private SimpleAttributeSet rightAlignAI;
    private SimpleAttributeSet rightAlignAgent;
    private List<MessageRecord> messages = new ArrayList<MessageRecord>();

    public AIChatPanel() {
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new FlowLayout(2));
        JButton clearButton = new JButton(I18NUtil.getString("ai_chat_btn_clear"));
        clearButton.setFont(UIConstants.FONT_13_BOLD);
        clearButton.addActionListener(e -> this.clearChat());
        topPanel.add(clearButton);
        this.add((Component)topPanel, "North");
        this.chatPane = new JTextPane();
        this.chatPane.setEditable(false);
        this.chatPane.setFont(UIConstants.FONT_13_BOLD);
        this.chatPane.setBackground(new Color(245, 245, 245));
        this.chatPane.setForeground(Color.DARK_GRAY);
        this.chatPane.setMargin(new Insets(7, 7, 7, 7));
        this.doc = this.chatPane.getStyledDocument();
        this.scrollPane = new JScrollPane(this.chatPane);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.leftAlign = new SimpleAttributeSet();
        StyleConstants.setForeground(this.leftAlign, new Color(30, 144, 255));
        StyleConstants.setFontSize(this.leftAlign, 13);
        StyleConstants.setBold(this.leftAlign, true);
        StyleConstants.setAlignment(this.leftAlign, 0);
        StyleConstants.setLeftIndent(this.leftAlign, 5.0f);
        StyleConstants.setRightIndent(this.leftAlign, 5.0f);
        StyleConstants.setSpaceAbove(this.leftAlign, 5.0f);
        StyleConstants.setSpaceBelow(this.leftAlign, 5.0f);
        this.rightAlignAI = new SimpleAttributeSet();
        StyleConstants.setForeground(this.rightAlignAI, Color.RED);
        StyleConstants.setFontSize(this.rightAlignAI, 13);
        StyleConstants.setBold(this.rightAlignAI, true);
        StyleConstants.setAlignment(this.rightAlignAI, 0);
        StyleConstants.setLeftIndent(this.rightAlignAI, 5.0f);
        StyleConstants.setRightIndent(this.rightAlignAI, 5.0f);
        StyleConstants.setSpaceAbove(this.rightAlignAI, 5.0f);
        StyleConstants.setSpaceBelow(this.rightAlignAI, 5.0f);
        this.rightAlignAgent = new SimpleAttributeSet();
        StyleConstants.setForeground(this.rightAlignAgent, new Color(0, 100, 0));
        StyleConstants.setFontSize(this.rightAlignAgent, 13);
        StyleConstants.setBold(this.rightAlignAgent, true);
        StyleConstants.setAlignment(this.rightAlignAgent, 0);
        StyleConstants.setLeftIndent(this.rightAlignAgent, 5.0f);
        StyleConstants.setRightIndent(this.rightAlignAgent, 5.0f);
        StyleConstants.setSpaceAbove(this.rightAlignAgent, 5.0f);
        StyleConstants.setSpaceBelow(this.rightAlignAgent, 5.0f);
        this.add((Component)this.scrollPane, "Center");
    }

    public void addMessage(String msgId, String messagex, int role, String time, String thinkTime, boolean finish) {
        try {
            Object message = messagex;
            if (time != null) {
                message = finish ? time + " " + (String)message : time + " " + (String)message;
            }
            if (thinkTime != null) {
                message = (String)message + " (" + I18NUtil.getString("ai_chat_think_time") + thinkTime + ")";
            }
            SimpleAttributeSet attr = this.leftAlign;
            if (role == 1) {
                attr = this.rightAlignAgent;
            } else if (role == 2) {
                attr = this.rightAlignAI;
            }
            MessageRecord target = null;
            for (MessageRecord rec : this.messages) {
                if (!rec.msgId.equals(msgId)) continue;
                target = rec;
                break;
            }
            if (target != null) {
                this.doc.remove(target.offset, target.length);
                this.doc.insertString(target.offset, (String)message + "\n", target.attr);
                target.length = ((String)message).length() + 1;
            } else {
                int offset = this.doc.getLength();
                this.doc.insertString(offset, (String)message + "\n", attr);
                this.messages.add(new MessageRecord(msgId, offset, ((String)message).length() + 1, attr));
            }
            SwingUtilities.invokeLater(() -> this.chatPane.setCaretPosition(this.doc.getLength()));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void clearChat() {
        try {
            this.doc.remove(0, this.doc.getLength());
            this.messages.clear();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("\u804a\u5929\u9762\u677f");
        frame.setDefaultCloseOperation(3);
        frame.setSize(400, 500);
        frame.add(new AIChatPanel());
        frame.setVisible(true);
    }

    public void onAiSubtitleReceived(String msgId, String msg, int role, int usage, boolean finish, long callStartTime, long analysisReceivedTime) {
        String time = this.getDurationDisp(callStartTime, analysisReceivedTime);
        if (role == 0) {
            this.addMessage(msgId, I18NUtil.getString("ai_chat_customer_prefix") + msg, role, time, null, finish);
        } else if (role == 1) {
            this.addMessage(msgId, I18NUtil.getString("ai_chat_agent_prefix") + msg, role, time, null, finish);
        } else {
            this.addMessage(msgId, I18NUtil.getString("ai_chat_ai_prefix") + msg, role, time, null, finish);
        }
    }

    private String getDurationDisp(long callStartTime, long analysisReceivedTime) {
        long diff = analysisReceivedTime - callStartTime;
        long hours = diff / 3600000L;
        long minutes = diff / 60000L % 60L;
        long seconds = diff / 1000L % 60L;
        String time = null;
        time = hours > 0L ? String.format("%02d:%02d:%02d", hours, minutes, seconds) : String.format("%02d:%02d", minutes, seconds);
        return time;
    }

    private String getDurationDisp2(long callStartTime, long analysisReceivedTime) {
        long diff = analysisReceivedTime - callStartTime;
        double seconds = (double)diff / 1000.0;
        return String.format(I18NUtil.getString("ai_chat_think_time_sec"), seconds);
    }

    public void onAiSummaryReceived(JSONObject summaryObj, long callStartTime, long analysisReceivedTime, long lastCustomerTime) {
        try {
            String text;
            JSONObject convObj;
            int i;
            JSONArray cdsAry;
            String time = this.getDurationDisp(callStartTime, analysisReceivedTime);
            String thinkTime = null;
            if (lastCustomerTime > 0L) {
                thinkTime = this.getDurationDisp2(lastCustomerTime, analysisReceivedTime);
            }
            if (summaryObj.has("CSD")) {
                StringBuilder sb1000 = new StringBuilder();
                cdsAry = summaryObj.getJSONArray("CSD");
                for (i = 0; i < cdsAry.length(); ++i) {
                    convObj = cdsAry.getJSONObject(i);
                    text = convObj.getString("Text");
                    if (!StringUtils.isNotBlank((CharSequence)text)) continue;
                    sb1000.append(text).append("\n");
                }
                if (sb1000.length() > 0) {
                    this.addMessage(UUID.randomUUID().toString(), SEPE + I18NUtil.getString("ai_chat_analysis") + SEPE, 2, null, null, true);
                    this.addMessage(UUID.randomUUID().toString(), sb1000.toString(), 2, time, thinkTime, true);
                }
            }
            if (summaryObj.has("KX")) {
                StringBuilder sb999 = new StringBuilder();
                cdsAry = summaryObj.getJSONArray("KX");
                for (i = 0; i < cdsAry.length(); ++i) {
                    convObj = cdsAry.getJSONObject(i);
                    text = convObj.getString("Text");
                    if (!StringUtils.isNotBlank((CharSequence)text)) continue;
                    sb999.append(text).append("\n");
                }
                if (sb999.length() > 0) {
                    this.addMessage(UUID.randomUUID().toString(), SEPE + I18NUtil.getString("ai_chat_analysis") + SEPE, 2, null, null, true);
                    this.addMessage(UUID.randomUUID().toString(), sb999.toString(), 2, time, thinkTime, true);
                }
            }
            if (summaryObj.has("SCS")) {
                StringBuilder sb1001 = new StringBuilder();
                JSONArray scsAry = summaryObj.getJSONArray("SCS");
                for (i = 0; i < scsAry.length(); ++i) {
                    convObj = scsAry.getJSONObject(i);
                    text = convObj.getString("Text");
                    if (!StringUtils.isNotBlank((CharSequence)text)) continue;
                    sb1001.append(text).append("\n");
                }
                if (sb1001.length() > 0) {
                    this.addMessage(UUID.randomUUID().toString(), SEPE + I18NUtil.getString("ai_chat_summary") + SEPE, 2, null, null, true);
                    this.addMessage(UUID.randomUUID().toString(), sb1001.toString(), 2, time, null, true);
                }
            }
            if (summaryObj.has("ACP")) {
                StringBuilder sb1002 = new StringBuilder();
                JSONArray acpAry = summaryObj.getJSONArray("ACP");
                for (i = 0; i < acpAry.length(); ++i) {
                    convObj = acpAry.getJSONObject(i);
                    text = convObj.getString("Text");
                    if (!StringUtils.isNotBlank((CharSequence)text)) continue;
                    sb1002.append(text).append("\n");
                }
                if (sb1002.length() > 0) {
                    this.addMessage(UUID.randomUUID().toString(), SEPE + I18NUtil.getString("ai_chat_msg_extraction") + SEPE, 2, null, null, true);
                    this.addMessage(UUID.randomUUID().toString(), sb1002.toString(), 2, time, null, true);
                }
            }
            if (summaryObj.has("ARC")) {
                StringBuilder sb1003 = new StringBuilder();
                JSONArray arcAry = summaryObj.getJSONArray("ARC");
                for (i = 0; i < arcAry.length(); ++i) {
                    convObj = arcAry.getJSONObject(i);
                    text = convObj.getString("Text");
                    if (!StringUtils.isNotBlank((CharSequence)text)) continue;
                    text = text.replaceAll("\\s+", "");
                    StringBuffer sb = new StringBuffer();
                    AIChatPanel.printJsonAsText(text, 0, sb);
                    sb1003.append(sb.toString()).append("\n");
                }
                if (sb1003.length() > 0) {
                    this.addMessage(UUID.randomUUID().toString(), SEPE + I18NUtil.getString("ai_chat_msg_src") + SEPE, 2, null, null, true);
                    this.addMessage(UUID.randomUUID().toString(), sb1003.toString(), 2, time, null, true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printJsonAsText(String json, int indent, StringBuffer sb) {
        int i = 0;
        while (i < json.length()) {
            if (json.charAt(i) == '\"') {
                String value;
                int valueEnd;
                int delimiter;
                int keyStart = i + 1;
                int keyEnd = json.indexOf(34, keyStart);
                String key = json.substring(keyStart, keyEnd);
                for (i = keyEnd + 1; i < json.length() && json.charAt(i) != ':'; ++i) {
                }
                if (json.charAt(++i) == '{') {
                    int valueStart;
                    int j;
                    AIChatPanel.appendIndent(indent, sb);
                    sb.append("\ud83d\udd39 ").append(key).append("\n");
                    int braceCount = 1;
                    for (j = valueStart = i + 1; j < json.length() && braceCount > 0; ++j) {
                        if (json.charAt(j) == '{') {
                            ++braceCount;
                            continue;
                        }
                        if (json.charAt(j) != '}') continue;
                        --braceCount;
                    }
                    String nested = json.substring(i, j);
                    AIChatPanel.printJsonAsText(nested, indent + 2, sb);
                    i = j;
                    continue;
                }
                int valueStart = i;
                int n = delimiter = json.charAt(i) == '\"' ? 34 : 44;
                if (delimiter == 34) {
                    valueEnd = json.indexOf(34, valueStart + 1);
                    value = json.substring(valueStart + 1, valueEnd);
                    AIChatPanel.appendIndent(indent, sb);
                    sb.append(key).append(": ").append(value).append("\n");
                    i = valueEnd + 1;
                    continue;
                }
                valueEnd = json.indexOf(44, valueStart);
                if (valueEnd == -1) {
                    valueEnd = json.indexOf(125, valueStart);
                }
                value = json.substring(valueStart, valueEnd);
                AIChatPanel.appendIndent(indent, sb);
                sb.append(key).append(": ").append(value).append("\n");
                i = valueEnd;
                continue;
            }
            ++i;
        }
    }

    private static void appendIndent(int indent, StringBuffer sb) {
        for (int j = 0; j < indent; ++j) {
            sb.append(" ");
        }
    }
}

