/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.customer;

import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.customer.RoundedPanel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class AIChatPanel3
extends JPanel {
    private static final Color COLOR_CUSTOMER_TEXT = new Color(30, 144, 255);
    private static final Color COLOR_AGENT_TEXT = new Color(0, 128, 0);
    private static final Color COLOR_CHAT_BACKGROUND = new Color(245, 245, 245);
    private static final Color COLOR_SUMMARY_DEFAULT_BG = new Color(255, 253, 230);
    private static final Color COLOR_SUMMARY_SCS_BG = new Color(253, 236, 234);
    private static final Color COLOR_SUMMARY_ARC_BG = new Color(220, 255, 220);
    private static final Color COLOR_SUMMARY_ACP_BG = new Color(230, 245, 255);
    private static final Color COLOR_SUMMARY_SCS_FG = new Color(229, 57, 53);
    private static final Color COLOR_SUMMARY_ARC_FG = new Color(0, 70, 100);
    private static final Color COLOR_SUMMARY_ACP_FG = new Color(0, 70, 100);
    private static final Color COLOR_SUGGESTION_FG = new Color(0, 70, 100);
    private static final Color COLOR_SUGGESTION_USER_BG = new Color(230, 245, 255);
    private static final Color COLOR_SUGGESTION_AGENT_BG = new Color(220, 255, 220);
    private static final Color COLOR_SUGGESTION_AI_BG = new Color(255, 240, 240);
    private final JPanel chatBodyPanel;
    private final JScrollPane scrollPane;
    private final List<MessageRecord> messages = new ArrayList<MessageRecord>();
    private int shift = 100;
    private final JPanel spacer = new JPanel();

    public AIChatPanel3() {
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new FlowLayout(2));
        JButton clearButton = new JButton(I18NUtil.getString("ai_chat_btn_clear"));
        clearButton.setFont(UIConstants.FONT_13_BOLD);
        clearButton.addActionListener(e -> this.clearChat());
        topPanel.add(clearButton);
        this.add((Component)topPanel, "North");
        this.chatBodyPanel = new JPanel();
        this.chatBodyPanel.setLayout(new BoxLayout(this.chatBodyPanel, 1));
        this.chatBodyPanel.setBackground(COLOR_CHAT_BACKGROUND);
        this.spacer.setOpaque(false);
        this.spacer.setMinimumSize(new Dimension(1, 100));
        this.spacer.setPreferredSize(new Dimension(1, 100));
        this.chatBodyPanel.add(this.spacer);
        JPanel topAlignedContainer = new JPanel(new BorderLayout());
        topAlignedContainer.setBackground(COLOR_CHAT_BACKGROUND);
        topAlignedContainer.add((Component)this.chatBodyPanel, "North");
        this.scrollPane = new JScrollPane(topAlignedContainer);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.scrollPane, "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AIChatPanel3.this.resizeAllMessages();
            }
        });
    }

    private void resizeAllMessages() {
        SwingUtilities.invokeLater(() -> {
            int maxWidth = this.chatBodyPanel.getWidth() - this.shift;
            for (MessageRecord rec : this.messages) {
                Component[] components;
                for (Component comp : components = rec.wrapper.getComponents()) {
                    if (!(comp instanceof JPanel)) continue;
                    JPanel panel = (JPanel)comp;
                    for (Component innerComp : panel.getComponents()) {
                        Dimension centerSize;
                        if (!(innerComp instanceof RoundedPanel)) continue;
                        RoundedPanel roundedPanel = (RoundedPanel)innerComp;
                        roundedPanel.setMaximumSize(new Dimension(maxWidth, Integer.MAX_VALUE));
                        Component northComp = ((BorderLayout)roundedPanel.getLayout()).getLayoutComponent("North");
                        Component centerComp = ((BorderLayout)roundedPanel.getLayout()).getLayoutComponent("Center");
                        int totalHeight = 0;
                        int maxWidthUsed = 0;
                        if (northComp != null) {
                            FontMetrics fm = northComp.getFontMetrics(northComp.getFont());
                            totalHeight += fm.getHeight();
                        }
                        if (centerComp != null && (centerSize = this.adjustTextAreaSize(centerComp, maxWidth)) != null) {
                            totalHeight += centerSize.height;
                            maxWidthUsed = Math.max(maxWidthUsed, centerSize.width);
                        }
                        roundedPanel.setPreferredSize(new Dimension(maxWidthUsed + 24, totalHeight + 24));
                    }
                }
            }
            for (Component wrapper : this.chatBodyPanel.getComponents()) {
                if (!(wrapper instanceof JPanel)) continue;
                for (Component inner : ((JPanel)wrapper).getComponents()) {
                    Dimension centerSize;
                    if (!(inner instanceof RoundedPanel)) continue;
                    RoundedPanel rounded = (RoundedPanel)inner;
                    rounded.setMaximumSize(new Dimension(maxWidth, Integer.MAX_VALUE));
                    Component northComp = ((BorderLayout)rounded.getLayout()).getLayoutComponent("North");
                    Component centerComp = ((BorderLayout)rounded.getLayout()).getLayoutComponent("Center");
                    int totalHeight = 0;
                    int maxWidthUsed = 0;
                    if (northComp != null) {
                        FontMetrics fm = northComp.getFontMetrics(northComp.getFont());
                        totalHeight += fm.getHeight();
                    }
                    if (centerComp != null && (centerSize = this.adjustTextAreaSize(centerComp, maxWidth)) != null) {
                        totalHeight += centerSize.height;
                        maxWidthUsed = Math.max(maxWidthUsed, centerSize.width);
                    }
                    rounded.setPreferredSize(new Dimension(maxWidthUsed + 24, totalHeight + 24));
                }
            }
            this.refreshPanel();
        });
    }

    private Dimension computeTextSize(JTextArea textArea, int maxWidth) {
        FontMetrics fm = textArea.getFontMetrics(textArea.getFont());
        String text = textArea.getText();
        int lineHeight = fm.getHeight();
        int maxLineWidth = 0;
        int totalHeight = 0;
        int lineWidth = 0;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\n' || ch == '\r') {
                totalHeight += lineHeight;
                maxLineWidth = Math.max(maxLineWidth, Math.min(lineWidth, maxWidth));
                lineWidth = 0;
                if (ch != '\r' || i + 1 >= text.length() || text.charAt(i + 1) != '\n') continue;
                ++i;
                continue;
            }
            int charWidth = fm.charWidth(ch);
            if (lineWidth + charWidth > maxWidth) {
                totalHeight += lineHeight;
                maxLineWidth = Math.max(maxLineWidth, maxWidth);
                lineWidth = 0;
            }
            lineWidth += charWidth;
        }
        maxLineWidth = Math.max(maxLineWidth, Math.min(lineWidth, maxWidth));
        return new Dimension(maxLineWidth + 10, totalHeight += lineHeight);
    }

    private Dimension adjustTextAreaSize(Component c, int maxWidth) {
        if (c instanceof JTextArea) {
            int actualWidth;
            JTextArea textArea = (JTextArea)c;
            textArea.setLineWrap(true);
            textArea.setWrapStyleWord(true);
            textArea.setSize(new Dimension(maxWidth, Short.MAX_VALUE));
            textArea.revalidate();
            textArea.repaint();
            Dimension preferred = this.computeTextSize(textArea, maxWidth);
            preferred.width = actualWidth = Math.min(maxWidth, preferred.width);
            textArea.setPreferredSize(preferred);
            textArea.setMaximumSize(new Dimension(maxWidth, Integer.MAX_VALUE));
            return preferred;
        }
        if (c instanceof JPanel) {
            JPanel panel = (JPanel)c;
            int totalHeight = 0;
            int maxWidthUsed = 0;
            for (Component child : panel.getComponents()) {
                Dimension childPref = this.adjustTextAreaSize(child, maxWidth);
                if (childPref == null) continue;
                totalHeight += childPref.height;
                maxWidthUsed = Math.max(maxWidthUsed, childPref.width);
            }
            c.setMaximumSize(new Dimension(maxWidthUsed, Integer.MAX_VALUE));
            c.setPreferredSize(new Dimension(maxWidthUsed, totalHeight));
            return new Dimension(maxWidthUsed, totalHeight);
        }
        return null;
    }

    public void updateOrAddMessage(String msgId, String text, int role, String time, boolean finish) {
        boolean updateDone = false;
        for (MessageRecord rec : this.messages) {
            if (!rec.msgId.equals(msgId)) continue;
            rec.label.setText(text);
            rec.timeLabel.setText("[" + time + "]");
            updateDone = true;
            break;
        }
        if (!updateDone) {
            this.addPlainMessage(msgId, text, role, time, finish);
        } else {
            this.resizeAllMessages();
        }
    }

    private void addPlainMessage(String msgId, String text, int role, String time, boolean finish) {
        JTextArea label = new JTextArea(text);
        label.setFont(UIConstants.FONT_13_BOLD);
        label.setForeground(role == 0 ? COLOR_CUSTOMER_TEXT : COLOR_AGENT_TEXT);
        label.setLineWrap(true);
        label.setWrapStyleWord(true);
        label.setEditable(false);
        label.setOpaque(false);
        label.setBorder(null);
        JPanel labelWrapper = new JPanel(new BorderLayout());
        labelWrapper.setOpaque(false);
        labelWrapper.add((Component)label, "Center");
        RoundedPanel bubblePanel = new RoundedPanel("MAIN=" + role, Color.WHITE, 12);
        bubblePanel.setLayout(new BorderLayout());
        bubblePanel.setBorder(BorderFactory.createEmptyBorder(8, 12, 8, 12));
        bubblePanel.add((Component)labelWrapper, "Center");
        JLabel timeLabel = new JLabel("[" + time + "]");
        timeLabel.setBorder(BorderFactory.createEmptyBorder(4, 6, 4, 6));
        timeLabel.setFont(UIConstants.FONT_13_BOLD);
        timeLabel.setForeground(role == 0 ? COLOR_CUSTOMER_TEXT : COLOR_AGENT_TEXT);
        JPanel timeWrapper = new JPanel(new BorderLayout());
        timeWrapper.setOpaque(false);
        timeWrapper.add((Component)timeLabel, "North");
        timeWrapper.setAlignmentY(0.0f);
        bubblePanel.setAlignmentY(0.0f);
        JPanel horizontal = new JPanel();
        horizontal.setLayout(new BoxLayout(horizontal, 0));
        horizontal.setOpaque(false);
        if (role == 0) {
            horizontal.add(Box.createHorizontalStrut(1));
            horizontal.add(timeWrapper);
            horizontal.add(Box.createHorizontalStrut(4));
            horizontal.add(bubblePanel);
            horizontal.add(Box.createHorizontalGlue());
        } else {
            horizontal.add(Box.createHorizontalGlue());
            horizontal.add(bubblePanel);
            horizontal.add(Box.createHorizontalStrut(4));
            horizontal.add(timeWrapper);
            horizontal.add(Box.createHorizontalStrut(1));
        }
        JPanel wrapper = new JPanel();
        wrapper.setLayout(new BoxLayout(wrapper, 1));
        wrapper.setOpaque(false);
        wrapper.add(Box.createVerticalStrut(8));
        wrapper.add(horizontal);
        int insertIndex = this.chatBodyPanel.getComponentCount() - 1;
        this.chatBodyPanel.add((Component)wrapper, insertIndex);
        this.messages.add(new MessageRecord(msgId, this.chatBodyPanel.getComponentCount() - 1, role, horizontal, wrapper, label, timeLabel));
        SwingUtilities.invokeLater(() -> {
            int maxWidth = this.chatBodyPanel.getWidth() - this.shift;
            label.setMinimumSize(new Dimension(0, 0));
            Dimension preferred = this.computeTextSize(label, maxWidth);
            int actualWidth = preferred.width;
            label.setPreferredSize(new Dimension(actualWidth, preferred.height));
            label.setMaximumSize(new Dimension(actualWidth, Integer.MAX_VALUE));
            labelWrapper.setPreferredSize(new Dimension(actualWidth, preferred.height));
            labelWrapper.setMaximumSize(new Dimension(actualWidth, Integer.MAX_VALUE));
            bubblePanel.setPreferredSize(new Dimension(actualWidth + 24, preferred.height + 24));
            bubblePanel.setMaximumSize(new Dimension(maxWidth + 24, Integer.MAX_VALUE));
            bubblePanel.revalidate();
            Dimension timePref = timeLabel.getPreferredSize();
            timeWrapper.setPreferredSize(new Dimension(timePref.width, timePref.height));
            timeWrapper.setMaximumSize(new Dimension(timePref.width, timePref.height));
        });
        this.refreshPanel();
    }

    private void addSubSuggestion(String parentMsgId, String suggestion, int role, String thinkTime) {
        for (MessageRecord rec : this.messages) {
            if (!rec.msgId.equals(parentMsgId)) continue;
            if (thinkTime != null) {
                suggestion = (String)suggestion + " (" + I18NUtil.getString("ai_chat_think_time") + thinkTime + ")";
            }
            JTextArea label = new JTextArea((String)suggestion);
            label.setWrapStyleWord(true);
            label.setLineWrap(true);
            label.setEditable(false);
            label.setFont(UIConstants.FONT_13_BOLD);
            label.setForeground(COLOR_SUGGESTION_FG);
            label.setOpaque(false);
            JPanel labelWrapper = new JPanel(new BorderLayout());
            labelWrapper.setOpaque(false);
            labelWrapper.add((Component)label, "Center");
            RoundedPanel bubblePanel = new RoundedPanel("SUGG=" + role, this.getSuggestionColor(role), 12);
            bubblePanel.setLayout(new BorderLayout());
            bubblePanel.setBorder(BorderFactory.createEmptyBorder(8, 12, 8, 12));
            bubblePanel.add((Component)labelWrapper, "Center");
            JPanel suggestionPanel = new JPanel();
            suggestionPanel.setLayout(new BoxLayout(suggestionPanel, 0));
            suggestionPanel.setOpaque(false);
            suggestionPanel.setBackground(Color.GREEN);
            int margin = 70;
            if (role == 0) {
                suggestionPanel.add(Box.createHorizontalStrut(margin));
                suggestionPanel.add(bubblePanel);
                suggestionPanel.add(Box.createHorizontalGlue());
            } else {
                suggestionPanel.add(Box.createHorizontalGlue());
                suggestionPanel.add(bubblePanel);
                suggestionPanel.add(Box.createHorizontalStrut(margin));
            }
            rec.wrapper.add(Box.createVerticalStrut(6));
            rec.wrapper.add(suggestionPanel);
            SwingUtilities.invokeLater(() -> {
                int maxWidth = this.chatBodyPanel.getWidth() - this.shift;
                label.setMinimumSize(new Dimension(0, 0));
                Dimension preferred = this.computeTextSize(label, maxWidth);
                int actualWidth = preferred.width;
                label.setPreferredSize(new Dimension(actualWidth, preferred.height));
                label.setMaximumSize(new Dimension(actualWidth, Integer.MAX_VALUE));
                labelWrapper.setPreferredSize(new Dimension(actualWidth, preferred.height));
                labelWrapper.setMaximumSize(new Dimension(actualWidth, Integer.MAX_VALUE));
                bubblePanel.setPreferredSize(new Dimension(actualWidth + 24, preferred.height + 24));
                bubblePanel.setMaximumSize(new Dimension(maxWidth + 24, Integer.MAX_VALUE));
                bubblePanel.revalidate();
            });
            this.refreshPanel();
            return;
        }
    }

    private String getTitleBySummaryType(String summaryType) {
        switch (summaryType) {
            case "SCS": {
                return I18NUtil.getString("ai_chat_title_scs");
            }
            case "ARC": {
                return I18NUtil.getString("ai_chat_title_arc");
            }
            case "ACP": {
                return I18NUtil.getString("ai_chat_title_acp");
            }
        }
        return "";
    }

    public void addSummaryBox(String content, String summaryType) {
        JTextArea mainTextArea = new JTextArea(content);
        mainTextArea.setFont(UIConstants.FONT_13_BOLD);
        switch (summaryType) {
            case "SCS": {
                mainTextArea.setForeground(COLOR_SUMMARY_SCS_FG);
                break;
            }
            case "ARC": {
                mainTextArea.setForeground(COLOR_SUMMARY_ARC_FG);
                break;
            }
            case "ACP": {
                mainTextArea.setForeground(COLOR_SUMMARY_ACP_FG);
                break;
            }
            default: {
                mainTextArea.setForeground(COLOR_SUMMARY_SCS_FG);
            }
        }
        mainTextArea.setLineWrap(true);
        mainTextArea.setWrapStyleWord(true);
        mainTextArea.setEditable(false);
        mainTextArea.setOpaque(false);
        mainTextArea.setBorder(null);
        JPanel labelWrapper = new JPanel(new BorderLayout());
        labelWrapper.setOpaque(false);
        labelWrapper.add((Component)mainTextArea, "Center");
        Color bgColor = COLOR_SUMMARY_DEFAULT_BG;
        switch (summaryType) {
            case "SCS": {
                bgColor = COLOR_SUMMARY_SCS_BG;
                break;
            }
            case "ARC": {
                bgColor = COLOR_SUMMARY_ARC_BG;
                break;
            }
            case "ACP": {
                bgColor = COLOR_SUMMARY_ACP_BG;
                break;
            }
            default: {
                bgColor = COLOR_SUMMARY_DEFAULT_BG;
            }
        }
        RoundedPanel summaryPanel = new RoundedPanel("SUMMARY", bgColor, 12);
        summaryPanel.setLayout(new BorderLayout());
        summaryPanel.setBorder(BorderFactory.createEmptyBorder(8, 12, 8, 12));
        summaryPanel.add((Component)labelWrapper, "Center");
        JLabel titleLabel = new JLabel(this.getTitleBySummaryType(summaryType), 0);
        titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        titleLabel.setFont(UIConstants.FONT_13_BOLD);
        switch (summaryType) {
            case "SCS": {
                titleLabel.setForeground(COLOR_SUMMARY_SCS_FG);
                break;
            }
            case "ARC": {
                titleLabel.setForeground(COLOR_SUMMARY_ARC_FG);
                break;
            }
            case "ACP": {
                titleLabel.setForeground(COLOR_SUMMARY_ACP_FG);
                break;
            }
            default: {
                titleLabel.setForeground(COLOR_SUMMARY_SCS_FG);
            }
        }
        summaryPanel.add((Component)titleLabel, "North");
        JPanel horizontal = new JPanel();
        horizontal.setLayout(new BoxLayout(horizontal, 0));
        horizontal.setOpaque(false);
        horizontal.add(Box.createHorizontalGlue());
        horizontal.add(summaryPanel);
        horizontal.add(Box.createHorizontalGlue());
        int insertIndex = this.chatBodyPanel.getComponentCount() - 1;
        this.chatBodyPanel.add(Box.createVerticalStrut(10), insertIndex);
        int insertIndex2 = this.chatBodyPanel.getComponentCount() - 1;
        this.chatBodyPanel.add((Component)horizontal, insertIndex2);
        SwingUtilities.invokeLater(() -> {
            int maxWidth = this.chatBodyPanel.getWidth() - this.shift;
            mainTextArea.setMinimumSize(new Dimension(0, 0));
            Dimension preferred = this.computeTextSize(mainTextArea, maxWidth);
            FontMetrics fm = titleLabel.getFontMetrics(titleLabel.getFont());
            int lineHeight = fm.getHeight();
            int actualWidth = preferred.width;
            mainTextArea.setPreferredSize(new Dimension(actualWidth, preferred.height));
            mainTextArea.setMaximumSize(new Dimension(actualWidth, Integer.MAX_VALUE));
            labelWrapper.setPreferredSize(new Dimension(actualWidth, preferred.height));
            labelWrapper.setMaximumSize(new Dimension(actualWidth, Integer.MAX_VALUE));
            summaryPanel.setPreferredSize(new Dimension(actualWidth + 24, preferred.height + 24 + lineHeight));
            summaryPanel.setMaximumSize(new Dimension(maxWidth + 24, Integer.MAX_VALUE));
            summaryPanel.revalidate();
        });
        this.refreshPanel();
    }

    private Color getSuggestionColor(int role) {
        if (role == 0) {
            return COLOR_SUGGESTION_USER_BG;
        }
        if (role == 1) {
            return COLOR_SUGGESTION_AGENT_BG;
        }
        return COLOR_SUGGESTION_AI_BG;
    }

    private void refreshPanel() {
        this.chatBodyPanel.revalidate();
        this.chatBodyPanel.repaint();
        this.scrollPane.revalidate();
        this.scrollPane.repaint();
        SwingUtilities.invokeLater(() -> this.scrollPane.getVerticalScrollBar().setValue(this.scrollPane.getVerticalScrollBar().getMaximum()));
    }

    public void clearChat() {
        this.chatBodyPanel.removeAll();
        this.spacer.setOpaque(false);
        this.spacer.setMinimumSize(new Dimension(1, 100));
        this.spacer.setPreferredSize(new Dimension(1, 100));
        this.chatBodyPanel.add(this.spacer);
        this.messages.clear();
        this.refreshPanel();
    }

    public void onAiSubtitleReceived(String msgId, String msg, int role, int usage, boolean finish, long callStartTime, long analysisReceivedTime) {
        String time = this.getDurationDisp(callStartTime, analysisReceivedTime);
        if (role == 0) {
            this.updateOrAddMessage(msgId, I18NUtil.getString("ai_chat_customer_prefix") + msg, role, time, finish);
        } else if (role == 1) {
            this.updateOrAddMessage(msgId, I18NUtil.getString("ai_chat_agent_prefix") + msg, role, time, finish);
        } else {
            this.updateOrAddMessage(msgId, I18NUtil.getString("ai_chat_ai_prefix") + msg, role, time, finish);
        }
    }

    public void onAiSummaryReceived(JSONObject summaryObj, long callStartTime, long analysisReceivedTime, long lastCustomerTime) {
        try {
            String text;
            JSONObject convObj;
            String text2;
            JSONObject convObj2;
            int i;
            JSONArray cdsAry;
            String dataId = UUID.randomUUID().toString();
            if (summaryObj.has("dataId")) {
                dataId = summaryObj.getString("dataId");
            }
            String time = this.getDurationDisp(callStartTime, analysisReceivedTime);
            String thinkTime = null;
            if (lastCustomerTime > 0L) {
                thinkTime = this.getDurationDisp2(lastCustomerTime, analysisReceivedTime);
            }
            if (summaryObj.has("CSD")) {
                cdsAry = summaryObj.getJSONArray("CSD");
                for (i = 0; i < cdsAry.length(); ++i) {
                    convObj2 = cdsAry.getJSONObject(i);
                    text2 = convObj2.getString("Text");
                    this.addSubSuggestion(dataId, text2, 1, thinkTime);
                }
            }
            if (summaryObj.has("KX")) {
                cdsAry = summaryObj.getJSONArray("KX");
                for (i = 0; i < cdsAry.length(); ++i) {
                    convObj2 = cdsAry.getJSONObject(i);
                    text2 = convObj2.getString("Text");
                    this.addSubSuggestion(dataId, text2, 0, thinkTime);
                }
            }
            if (summaryObj.has("SCS")) {
                StringBuilder sb1001 = new StringBuilder();
                JSONArray scsAry = summaryObj.getJSONArray("SCS");
                for (int i2 = 0; i2 < scsAry.length(); ++i2) {
                    convObj = scsAry.getJSONObject(i2);
                    text = convObj.getString("Text");
                    if (!StringUtils.isNotBlank((CharSequence)text)) continue;
                    sb1001.append(text).append("\n");
                }
                if (sb1001.length() > 0) {
                    this.addSummaryBox(sb1001.toString(), "SCS");
                }
            }
            if (summaryObj.has("ARC")) {
                StringBuilder sb1003 = new StringBuilder();
                JSONArray arcAry = summaryObj.getJSONArray("ARC");
                for (int i3 = 0; i3 < arcAry.length(); ++i3) {
                    convObj = arcAry.getJSONObject(i3);
                    text = convObj.getString("Text");
                    if (!StringUtils.isNotBlank((CharSequence)text)) continue;
                    text = text.replaceAll("\\s+", "");
                    StringBuffer sb = new StringBuffer();
                    AIChatPanel3.printJsonAsText(text, 0, sb);
                    sb1003.append(sb.toString()).append("\n");
                }
                if (sb1003.length() > 0) {
                    this.addSummaryBox(sb1003.toString(), "ARC");
                }
            }
            if (summaryObj.has("ACP")) {
                StringBuilder sb1002 = new StringBuilder();
                JSONArray acpAry = summaryObj.getJSONArray("ACP");
                for (int i4 = 0; i4 < acpAry.length(); ++i4) {
                    convObj = acpAry.getJSONObject(i4);
                    text = convObj.getString("Text");
                    if (!StringUtils.isNotBlank((CharSequence)text)) continue;
                    sb1002.append(text).append("\n");
                }
                if (sb1002.length() > 0) {
                    this.addSummaryBox(sb1002.toString(), "ACP");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getDurationDisp(long callStartTime, long analysisReceivedTime) {
        long diff = analysisReceivedTime - callStartTime;
        long hours = diff / 3600000L;
        long minutes = diff / 60000L % 60L;
        long seconds = diff / 1000L % 60L;
        String time = null;
        time = hours > 0L ? String.format("%02d:%02d:%02d", hours, minutes, seconds) : String.format("%02d:%02d", minutes, seconds);
        return time;
    }

    private String getDurationDisp2(long callStartTime, long analysisReceivedTime) {
        long diff = analysisReceivedTime - callStartTime;
        double seconds = (double)diff / 1000.0;
        return String.format(I18NUtil.getString("ai_chat_think_time_sec"), seconds);
    }

    public static void printJsonAsText(String json, int indent, StringBuffer sb) {
        int i = 0;
        while (i < json.length()) {
            if (json.charAt(i) == '\"') {
                String value;
                int valueEnd;
                int delimiter;
                int keyStart = i + 1;
                int keyEnd = json.indexOf(34, keyStart);
                String key = json.substring(keyStart, keyEnd);
                for (i = keyEnd + 1; i < json.length() && json.charAt(i) != ':'; ++i) {
                }
                if (json.charAt(++i) == '{') {
                    int valueStart;
                    int j;
                    AIChatPanel3.appendIndent(indent, sb);
                    sb.append("\ud83d\udd39 ").append(key).append("\n");
                    int braceCount = 1;
                    for (j = valueStart = i + 1; j < json.length() && braceCount > 0; ++j) {
                        if (json.charAt(j) == '{') {
                            ++braceCount;
                            continue;
                        }
                        if (json.charAt(j) != '}') continue;
                        --braceCount;
                    }
                    String nested = json.substring(i, j);
                    AIChatPanel3.printJsonAsText(nested, indent + 2, sb);
                    i = j;
                    continue;
                }
                int valueStart = i;
                int n = delimiter = json.charAt(i) == '\"' ? 34 : 44;
                if (delimiter == 34) {
                    valueEnd = json.indexOf(34, valueStart + 1);
                    value = json.substring(valueStart + 1, valueEnd);
                    AIChatPanel3.appendIndent(indent, sb);
                    sb.append(key).append(": ").append(value).append("\n");
                    i = valueEnd + 1;
                    continue;
                }
                valueEnd = json.indexOf(44, valueStart);
                if (valueEnd == -1) {
                    valueEnd = json.indexOf(125, valueStart);
                }
                value = json.substring(valueStart, valueEnd);
                AIChatPanel3.appendIndent(indent, sb);
                sb.append(key).append(": ").append(value).append("\n");
                i = valueEnd;
                continue;
            }
            ++i;
        }
    }

    private static void appendIndent(int indent, StringBuffer sb) {
        for (int j = 0; j < indent; ++j) {
            sb.append(" ");
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("\u804a\u5929\u9762\u677f");
        frame.setDefaultCloseOperation(3);
        frame.setSize(400, 1000);
        AIChatPanel3 panel = new AIChatPanel3();
        frame.add(panel);
        frame.setVisible(true);
        SwingUtilities.invokeLater(() -> {
            panel.updateOrAddMessage("1", "\u60a8\u597d\uff0c\u6211\u662f\u5ba2\u670d\u5c0f\u5e6b\u624b\u3002\u60a8\u597d\uff0c\u6211\u662f\u5ba2\u670d\u5c0f\u5e6b\u624b\u3002\u60a8\u597d\uff0c\u6211\u662f\u5ba2\u670d\u5c0f\u5e6b\u624b\u3002\u60a8\u597d\uff0c\u6211\u662f\u5ba2\u670d\u5c0f\u5e6b\u624b\u3002\u60a8\u597d\uff0c\u6211\u662f\u5ba2\u670d\u5c0f\u5e6b\u624b\u3002", 0, "09:00", true);
            panel.updateOrAddMessage("2", "\u9019\u908a\u662f\u5750\u5e2d\u3002\u8acb\u554f\u6709\u4ec0\u9ebc\u554f\u984c\u3002\u9019\u908a\u662f\u5750\u5e2d\u3002\u8acb\u554f\u6709\u4ec0\u9ebc\u554f\u984c\uff1f", 1, "09:01", true);
            Timer timer1 = new Timer(10000, e -> panel.updateOrAddMessage("2", "\u9019\u908a\u662f\u5750\u5e2d\u3002\u8acb\u554f\u6709\u4ec0\u9ebc\u554f\u984c\u3002\u9019\u908a\u662f\u5750\u5e2d\u3002\u8acb\u554f\u6709\u4ec0\u9ebc\u554f\u984c\uff1f\u9019\u908a\u662f\u5750\u5e2d\u3002\u8acb\u554f\u6709\u4ec0\u9ebc\u554f\u984c\uff1f\u9019\u908a\u662f\u5750\u5e2d\u3002\u8acb\u554f\u6709\u4ec0\u9ebc\u554f\u984c\uff1f\u9019\u908a\u662f\u5750\u5e2d\u3002\u8acb\u554f\u6709\u4ec0\u9ebc\u554f\u984c\u3002\u9019\u908a\u662f\u5750\u5e2d\u3002\u8acb\u554f\u6709\u4ec0\u9ebc\u554f\u984c\uff1f\u9019\u908a\u662f\u5750\u5e2d\u3002\u8acb\u554f\u6709\u4ec0\u9ebc\u554f\u984c\uff1f\u9019\u908a\u662f\u5750\u5e2d\u3002\u8acb\u554f\u6709\u4ec0\u9ebc\u554f\u984c\uff1f\u9019\u908a\u662f\u5750\u5e2d\u3002\u8acb\u554f\u6709\u4ec0\u9ebc\u554f\u984c\u3002\u9019\u908a\u662f\u5750\u5e2d\u3002\u8acb\u554f\u6709\u4ec0\u9ebc\u554f\u984c\uff1f\u9019\u908a\u662f\u5750\u5e2d\u3002\u8acb\u554f\u6709\u4ec0\u9ebc\u554f\u984c\uff1f\u9019\u908a\u662f\u5750\u5e2d\u3002\u8acb\u554f\u6709\u4ec0\u9ebc\u554f\u984c\uff1f\u9019\u908a\u662f\u5750\u5e2d\u3002\u8acb\u554f\u6709\u4ec0\u9ebc\u554f\u984c\u3002\u9019\u908a\u662f\u5750\u5e2d\u3002\u8acb\u554f\u6709\u4ec0\u9ebc\u554f\u984c\uff1f\u9019\u908a\u662f\u5750\u5e2d\u3002\u8acb\u554f\u6709\u4ec0\u9ebc\u554f\u984c\uff1f\u9019\u908a\u662f\u5750\u5e2d\u3002\u8acb\u554f\u6709\u4ec0\u9ebc\u554f\u984c\uff1f", 1, "09:01", true));
            timer1.setRepeats(false);
            timer1.start();
            Timer timer2 = new Timer(15000, e -> panel.updateOrAddMessage("2", "\u9019\u908a\u662f\u5750\u5e2d\u3002\u8acb\u554f\u6709\u4ec0\u9ebc\u554f\u984c\u3002\u9019\u908a\u662f\u5750\u5e2d\u3002\u8acb\u554f\u6709\u4ec0\u9ebc\u554f\u984c\uff1f\u9019\u908a\u662f\u5750\u5e2d\u3002\u8acb\u554f\u6709\u4ec0\u9ebc\u554f\u984c\uff1f", 1, "09:01", true));
            timer2.setRepeats(false);
            timer2.start();
            panel.updateOrAddMessage("3", "\u6211\u662f\u4e00\u500b", 1, "09:01", true);
            panel.updateOrAddMessage("4", "\u4f60\u662f\u4e00\u500b", 1, "09:01", true);
            panel.addSummaryBox("\u8a71\u8853\u5efa\u8b70\uff1a\u8acb\u554f\u60a8\u9700\u8981\u54ea\u65b9\u9762\u7684\u5354\u52a9\uff1f\u8a71\u8853\u5efa\u8b70\uff1a\u8acb\u554f\u60a8\u9700\u8981\u54ea\u65b9\u9762\u7684\u5354\u52a9\uff1f\u8a71\u8853\u5efa\u8b70\uff1a\u8acb\u554f\u60a8\u9700\u8981\u54ea\u65b9\u9762\u7684\u5354\u52a9\uff1f\u8a71\u8853\u5efa\u8b70\uff1a\u8acb\u554f\u60a8\u9700\u8981\u54ea\u65b9\u9762\u7684\u5354\u52a9\uff1f\u8a71\u8853\u5efa\u8b70\uff1a\u8acb\u554f\u60a8\u9700\u8981\u54ea\u65b9\u9762\u7684\u5354\u52a9\uff1f\u8a71\u8853\u5efa\u8b70\uff1a\u8acb\u554f\u60a8\u9700\u8981\u54ea\u65b9\u9762\u7684", "SCS");
            panel.addSummaryBox("\u8a71\u8853\u5efa\u8b70\uff1a\u8acb\u554f\u60a8\u9700\u8981\u54ea\u65b9\u9762\u7684\u5354\u52a9\uff1f\u8a71\u8853\u5efa\u8b70\uff1a\u8acb\u554f\u60a8\u9700\u8981\u54ea\u65b9\u9762\u7684\u5354\u52a9\uff1f\u8a71\u8853\u5efa\u8b70\uff1a\u8acb\u554f\u60a8\u9700\u8981\u54ea\u65b9\u9762\u7684\u5354\u52a9\uff1f\u8a71\u8853\u5efa\u8b70\uff1a\u8acb\u554f\u60a8\u9700\u8981\u54ea\u65b9\u9762\u7684\u5354\u52a9\uff1f\u8a71\u8853\u5efa\u8b70\uff1a\u8acb\u554f\u60a8\u9700\u8981\u54ea\u65b9\u9762\u7684\u5354\u52a9\uff1f\u8a71\u8853\u5efa\u8b70\uff1a\u8acb\u554f\u60a8\u9700\u8981\u54ea\u65b9\u9762\u7684\u5354\u52a9", "ARC");
            panel.resizeAllMessages();
        });
    }

    private static class MessageRecord {
        String msgId;
        int index;
        int role;
        JPanel panel;
        JPanel wrapper;
        JTextArea label;
        JLabel timeLabel;

        MessageRecord(String msgId, int index, int role, JPanel panel, JPanel wrapper, JTextArea label, JLabel timeLabel) {
            this.msgId = msgId;
            this.index = index;
            this.role = role;
            this.panel = panel;
            this.wrapper = wrapper;
            this.label = label;
            this.timeLabel = timeLabel;
        }
    }
}

