/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.customer;

import com.blisscloud.ezuc.client.cc.SummaryTreeCache;
import com.blisscloud.ezuc.client.customer.PhoneCustomerHistoryPanel;
import com.blisscloud.ezuc.client.outboundfilter.CallResultType;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class CallHistoryTableModel
extends AbstractTableModel {
    private SimpleDateFormat timeformatter = new SimpleDateFormat("HH:mm:ss");
    private SimpleDateFormat dateformatter = new SimpleDateFormat("yyyy-MM-dd");
    private String[] columns = new String[]{I18NUtil.getString("personalCustomer.history.direction"), I18NUtil.getString("personalCustomer.history.agent"), I18NUtil.getString("personalCustomer.history.phoneNum"), I18NUtil.getString("personalCustomer.history.startDate"), I18NUtil.getString("personalCustomer.history.startTime"), I18NUtil.getString("personalCustomer.history.answerTime"), I18NUtil.getString("personalCustomer.history.talkDuration"), I18NUtil.getString("personalCustomer.history.result"), I18NUtil.getString("personalCustomer.history.summary")};
    private JSONArray historyAry = new JSONArray();

    public void clear() {
        this.historyAry = new JSONArray();
        this.fireTableDataChanged();
    }

    public void setCustomerItems(JSONArray itemList) {
        this.historyAry = itemList;
        this.fireTableDataChanged();
    }

    public JSONObject getItem(int rowIndex) {
        try {
            return this.historyAry.getJSONObject(rowIndex);
        }
        catch (JSONException e) {
            Log.e(PhoneCustomerHistoryPanel.class.getSimpleName(), "ERROR:" + e.getMessage(), e);
            return null;
        }
    }

    @Override
    public int getRowCount() {
        return this.historyAry.length();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columns[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            JSONObject item = this.historyAry.getJSONObject(rowIndex);
            switch (columnIndex) {
                case 0: {
                    String srcType = item.getString("sType");
                    if ("TRUNK".equals(srcType)) {
                        return I18NUtil.getString("attachdata.direction.inbound");
                    }
                    String dstType = item.getString("dType");
                    if ("TRUNK".equals(dstType)) {
                        return I18NUtil.getString("attachdata.direction.outbound");
                    }
                    return "";
                }
                case 1: {
                    String dstType;
                    StringBuffer b = new StringBuffer();
                    String srcType = item.getString("sType");
                    if ("EMPLOYEE".equals(srcType)) {
                        if (item.has("sName")) {
                            b.append(item.getString("sName"));
                        }
                        if (item.has("sExt")) {
                            b.append(" (");
                            b.append(item.getString("sExt"));
                            b.append(")");
                        }
                    }
                    if ("EMPLOYEE".equals(dstType = item.getString("dType")) && item.has("dName")) {
                        b.append(item.getString("dName"));
                        if (item.has("dExt")) {
                            b.append(" (");
                            b.append(item.getString("dExt"));
                            b.append(")");
                        }
                    }
                    return b.toString();
                }
                case 2: {
                    String srcType = item.getString("sType");
                    if ("TRUNK".equals(srcType) && item.has("sExt")) {
                        return item.getString("sExt");
                    }
                    String dstType = item.getString("dType");
                    if ("TRUNK".equals(dstType) && item.has("dDialExt")) {
                        return item.getString("dDialExt");
                    }
                    return "";
                }
                case 3: {
                    if (item.has("sTime")) {
                        long t = item.getLong("sTime");
                        Date d = new Date();
                        d.setTime(t);
                        return this.dateformatter.format(d);
                    }
                    return "";
                }
                case 4: {
                    if (item.has("sTime")) {
                        long t = item.getLong("sTime");
                        Date d = new Date();
                        d.setTime(t);
                        return this.timeformatter.format(d);
                    }
                    return "";
                }
                case 5: {
                    if (item.has("aTime")) {
                        long t = item.getLong("aTime");
                        Date d = new Date();
                        d.setTime(t);
                        return this.timeformatter.format(d);
                    }
                    return "";
                }
                case 6: {
                    if (item.has("sTime") && item.has("eTime")) {
                        return CommonUtil.getDurationMilliSeconds(item.getLong("eTime") - item.getLong("sTime"));
                    }
                    return "";
                }
                case 7: {
                    if (item.has("result")) {
                        int dialResult = item.getInt("result");
                        CallResultType callType = CallResultType.getValue(dialResult);
                        return callType.getCallResult();
                    }
                    return "";
                }
                case 8: {
                    String[] idAry;
                    String ids;
                    String summaryNote = null;
                    if (item.has("suNote")) {
                        summaryNote = item.getString("suNote");
                    }
                    StringBuffer summCategoryInfo = new StringBuffer();
                    StringBuffer summOutcomeInfo = new StringBuffer();
                    if (item.has("suCategoryId")) {
                        summCategoryInfo.append(SummaryTreeCache.getSummaryItem(item.getLong("suCategoryId")));
                    }
                    if (item.has("suCategoryIds")) {
                        ids = item.getString("suCategoryIds");
                        for (String id : idAry = ids.split(",")) {
                            if (summCategoryInfo.length() != 0) {
                                summCategoryInfo.append(I18NUtil.getString("comma"));
                            }
                            summCategoryInfo.append(SummaryTreeCache.getSummaryItem(Long.parseLong(id)));
                        }
                    }
                    if (item.has("suOutcomeId")) {
                        summOutcomeInfo.append(SummaryTreeCache.getSummaryItem(item.getLong("suOutcomeId")));
                    }
                    if (item.has("suOutcomeIds")) {
                        ids = item.getString("suOutcomeIds");
                        for (String id : idAry = ids.split(",")) {
                            if (summOutcomeInfo.length() != 0) {
                                summOutcomeInfo.append(I18NUtil.getString("comma"));
                            }
                            summOutcomeInfo.append(SummaryTreeCache.getSummaryItem(Long.parseLong(id)));
                        }
                    }
                    StringBuffer summarybuffer = new StringBuffer();
                    if (summCategoryInfo.length() > 0) {
                        if (summarybuffer.length() > 0) {
                            summarybuffer.append(" / ");
                        }
                        summarybuffer.append(summCategoryInfo.toString());
                    }
                    if (summOutcomeInfo.length() > 0) {
                        if (summarybuffer.length() > 0) {
                            summarybuffer.append(" / ");
                        }
                        summarybuffer.append(summOutcomeInfo.toString());
                    }
                    if (StringUtils.isNotBlank((CharSequence)summaryNote)) {
                        if (summarybuffer.length() > 0) {
                            summarybuffer.append(" / ");
                        }
                        summarybuffer.append(summaryNote);
                    }
                    return summarybuffer.toString();
                }
            }
            return "";
        }
        catch (JSONException e) {
            Log.e(PhoneCustomerHistoryPanel.class.getSimpleName(), "ERROR:" + e.getMessage(), e);
            return "";
        }
    }
}

