/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.customer;

import com.blisscloud.ezuc.client.cc.ApplicationCache;
import com.blisscloud.ezuc.client.customer.ColumnType;
import com.blisscloud.ezuc.client.customer.CustomerField;
import com.blisscloud.ezuc.client.customer.CustomerFieldItem;
import com.blisscloud.ezuc.client.customer.CustomerItem;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class ChangeCustomerTableModel
extends AbstractTableModel {
    private String[] columns = new String[]{I18NUtil.getString("personalCustomer.fields.strId"), I18NUtil.getString("personalCustomer.fields.name"), I18NUtil.getString("personalCustomer.fields.gender"), I18NUtil.getString("personalCustomer.fields.level"), I18NUtil.getString("personalCustomer.fields.birthday"), I18NUtil.getString("personalCustomer.fields.identityNumber"), I18NUtil.getString("personalCustomer.fields.passportNumber"), I18NUtil.getString("personalCustomer.fields.phone")};
    private List<CustomerItem> customerList = new ArrayList<CustomerItem>();

    ChangeCustomerTableModel() {
    }

    public void clear() {
        this.customerList.clear();
        this.fireTableDataChanged();
    }

    public void setCustomerItems(List<CustomerItem> itemList) {
        this.customerList.clear();
        if (itemList != null) {
            this.customerList.addAll(itemList);
        }
        this.fireTableDataChanged();
    }

    public CustomerItem getItem(int rowIndex) {
        return this.customerList.get(rowIndex);
    }

    @Override
    public int getRowCount() {
        return this.customerList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columns[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        CustomerItem item = this.customerList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return item.getStrId();
            }
            case 1: {
                return item.getName();
            }
            case 2: {
                CustomerField field = ApplicationCache.getInstance().schameMap.get((Object)ColumnType.CUSTOMER_TITLE);
                CustomerFieldItem itemx = field.getEnumMap().get(item.getGender());
                if (itemx != null) {
                    return itemx.getName();
                }
                return "";
            }
            case 3: {
                CustomerField field = ApplicationCache.getInstance().schameMap.get((Object)ColumnType.CUSTOMER_LEVEL);
                CustomerFieldItem itemx = field.getEnumMap().get(item.getLevel());
                if (itemx != null) {
                    return itemx.getName();
                }
                return "";
            }
            case 4: {
                if (item.getBirthday() != null) {
                    CustomerField field = ApplicationCache.getInstance().schameMap.get((Object)ColumnType.CUSTOMER_BIRTHDAY);
                    SimpleDateFormat sdf = new SimpleDateFormat(field.getFormatDesc());
                    return sdf.format(item.getBirthday());
                }
                return "";
            }
            case 5: {
                if (item.getIdentityNumber() != null) {
                    return item.getIdentityNumber();
                }
                return "";
            }
            case 6: {
                if (item.getPassportNumber() != null) {
                    return item.getPassportNumber();
                }
                return "";
            }
            case 7: {
                StringBuffer pBuffer = new StringBuffer();
                if (item.getMobilePhone() != null) {
                    pBuffer.append(I18NUtil.getString("personalCustomer.field.phone.mobile"));
                    pBuffer.append(":");
                    pBuffer.append(item.getMobilePhone());
                    pBuffer.append(" ");
                }
                if (item.getOfficePhone() != null) {
                    pBuffer.append(I18NUtil.getString("personalCustomer.field.phone.office"));
                    pBuffer.append(":");
                    pBuffer.append(item.getOfficePhone());
                    pBuffer.append(" ");
                }
                if (item.getHomePhone() != null) {
                    pBuffer.append(I18NUtil.getString("personalCustomer.field.phone.home"));
                    pBuffer.append(":");
                    pBuffer.append(item.getHomePhone());
                    pBuffer.append(" ");
                }
                if (item.getOtherPhone() != null) {
                    pBuffer.append(I18NUtil.getString("personalCustomer.field.phone.other"));
                    pBuffer.append(":");
                    pBuffer.append(item.getOtherPhone());
                    pBuffer.append(" ");
                }
                if (item.getHomePhone() != null) {
                    pBuffer.append(I18NUtil.getString("personalCustomer.field.phone.assistant"));
                    pBuffer.append(":");
                    pBuffer.append(item.getAssistantPhone());
                    pBuffer.append(" ");
                }
                return pBuffer.toString();
            }
        }
        return "";
    }
}

