/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.customer;

import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.cc.SummaryTreeCache;
import com.blisscloud.ezuc.client.customer.PhoneCustomerHistoryPanel;
import com.blisscloud.ezuc.client.outboundfilter.CallResultType;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.json.JSONException;
import org.json.JSONObject;

public class CustomerHistoryDetailPanel
extends JPanel {
    private SimpleDateFormat timeformatter = new SimpleDateFormat("HH:mm:ss");
    private SimpleDateFormat dateformatter = new SimpleDateFormat("yyyy-MM-dd");
    private JLabel dateLabel;
    private JLabel startTimeLabel;
    private JLabel answerTimeLabel;
    private JLabel endTimeLabel;
    private JLabel durationLabel;
    private JLabel directionLabel;
    private JLabel phoneLabel;
    private JLabel resultLabel;
    private JLabel agentTitle;
    private JLabel agentLabel;
    private JLabel summaryCategoryLabel;
    private JLabel summaryOutcomeLabel;
    private JTextArea noteArea;

    public CustomerHistoryDetailPanel() {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(6, 0, 5, 0), BorderFactory.createLineBorder(Color.GRAY)));
        this.setLayout(new BorderLayout());
        JPanel x = new JPanel();
        x.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        x.setLayout(new GridBagLayout());
        this.add((Component)x, "Center");
        int y = 0;
        JLabel noteTitle = new JLabel();
        noteTitle.setFont(UIConstants.FONT_12_BOLD);
        x.add((Component)noteTitle, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
        noteTitle.setText(I18NUtil.getString("personalCustomer.history.startDate"));
        this.dateLabel = new JLabel();
        x.add((Component)this.dateLabel, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        noteTitle = new JLabel();
        noteTitle.setFont(UIConstants.FONT_12_BOLD);
        x.add((Component)noteTitle, new GridBagConstraints(2, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
        noteTitle.setText(I18NUtil.getString("personalCustomer.history.startTime"));
        this.startTimeLabel = new JLabel();
        x.add((Component)this.startTimeLabel, new GridBagConstraints(3, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        noteTitle = new JLabel();
        noteTitle.setFont(UIConstants.FONT_12_BOLD);
        x.add((Component)noteTitle, new GridBagConstraints(4, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
        noteTitle.setText(I18NUtil.getString("personalCustomer.history.answerTime"));
        this.answerTimeLabel = new JLabel();
        x.add((Component)this.answerTimeLabel, new GridBagConstraints(5, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        noteTitle = new JLabel();
        noteTitle.setFont(UIConstants.FONT_12_BOLD);
        x.add((Component)noteTitle, new GridBagConstraints(6, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
        noteTitle.setText(I18NUtil.getString("personalCustomer.history.endTime"));
        this.endTimeLabel = new JLabel();
        x.add((Component)this.endTimeLabel, new GridBagConstraints(7, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        noteTitle = new JLabel();
        noteTitle.setFont(UIConstants.FONT_12_BOLD);
        x.add((Component)noteTitle, new GridBagConstraints(8, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
        noteTitle.setText(I18NUtil.getString("personalCustomer.history.talkDuration"));
        this.durationLabel = new JLabel();
        x.add((Component)this.durationLabel, new GridBagConstraints(9, y++, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 5, 2, 5), 0, 0));
        noteTitle = new JLabel();
        noteTitle.setFont(UIConstants.FONT_12_BOLD);
        x.add((Component)noteTitle, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
        noteTitle.setText(I18NUtil.getString("personalCustomer.history.direction"));
        this.directionLabel = new JLabel();
        x.add((Component)this.directionLabel, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        noteTitle = new JLabel();
        noteTitle.setFont(UIConstants.FONT_12_BOLD);
        x.add((Component)noteTitle, new GridBagConstraints(2, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
        noteTitle.setText(I18NUtil.getString("personalCustomer.history.phoneNum"));
        this.phoneLabel = new JLabel();
        x.add((Component)this.phoneLabel, new GridBagConstraints(3, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        noteTitle = new JLabel();
        noteTitle.setFont(UIConstants.FONT_12_BOLD);
        x.add((Component)noteTitle, new GridBagConstraints(4, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
        noteTitle.setText(I18NUtil.getString("personalCustomer.history.result"));
        this.resultLabel = new JLabel();
        x.add((Component)this.resultLabel, new GridBagConstraints(5, y++, 5, 1, 1.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.agentTitle = new JLabel();
        this.agentTitle.setFont(UIConstants.FONT_12_BOLD);
        x.add((Component)this.agentTitle, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.agentTitle.setText(I18NUtil.getString("personalCustomer.history.agent"));
        this.agentLabel = new JLabel();
        x.add((Component)this.agentLabel, new GridBagConstraints(1, y++, 9, 1, 1.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        noteTitle = new JLabel();
        noteTitle.setFont(UIConstants.FONT_12_BOLD);
        x.add((Component)noteTitle, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
        noteTitle.setText(I18NUtil.getString("contact_record_dialog_category"));
        this.summaryCategoryLabel = new JLabel();
        x.add((Component)this.summaryCategoryLabel, new GridBagConstraints(1, y++, 9, 1, 1.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        noteTitle = new JLabel();
        noteTitle.setFont(UIConstants.FONT_12_BOLD);
        x.add((Component)noteTitle, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
        noteTitle.setText(I18NUtil.getString("contact_record_dialog_outcome"));
        this.summaryOutcomeLabel = new JLabel();
        x.add((Component)this.summaryOutcomeLabel, new GridBagConstraints(1, y++, 9, 1, 1.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        noteTitle = new JLabel();
        noteTitle.setFont(UIConstants.FONT_12_BOLD);
        x.add((Component)noteTitle, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 12, 0, new Insets(2, 5, 2, 5), 0, 0));
        noteTitle.setText(I18NUtil.getString("contact_record_dialog_note"));
        this.noteArea = new JTextArea(4, 20);
        this.noteArea.setLineWrap(true);
        this.noteArea.setWrapStyleWord(true);
        this.noteArea.setOpaque(false);
        this.noteArea.setEditable(false);
        JScrollPane scroll = new JScrollPane(this.noteArea);
        scroll.setHorizontalScrollBarPolicy(31);
        x.add((Component)scroll, new GridBagConstraints(1, y++, 9, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 2, 5), 0, 0));
    }

    public void setData(JSONObject item) {
        try {
            String[] idAry;
            String ids;
            String dstType;
            String srcType;
            Date d;
            long t;
            if (item.has("sTime")) {
                t = item.getLong("sTime");
                d = new Date();
                d.setTime(t);
                this.dateLabel.setText(this.dateformatter.format(d));
                this.startTimeLabel.setText(this.timeformatter.format(d));
            }
            if (item.has("aTime")) {
                t = item.getLong("aTime");
                d = new Date();
                d.setTime(t);
                this.answerTimeLabel.setText(this.timeformatter.format(d));
            }
            if (item.has("eTime")) {
                t = item.getLong("eTime");
                d = new Date();
                d.setTime(t);
                this.endTimeLabel.setText(this.timeformatter.format(d));
            }
            if (item.has("sTime") && item.has("eTime")) {
                this.durationLabel.setText(CommonUtil.getDurationMilliSeconds(item.getLong("eTime") - item.getLong("sTime")));
            }
            if ("TRUNK".equals(srcType = item.getString("sType")) && item.has("sExt")) {
                this.phoneLabel.setText(item.getString("sExt"));
            }
            if ("TRUNK".equals(dstType = item.getString("dType")) && item.has("dDialExt")) {
                this.phoneLabel.setText(item.getString("dDialExt"));
            }
            if ("TRUNK".equals(srcType)) {
                this.directionLabel.setText(I18NUtil.getString("attachdata.direction.inbound"));
            }
            if ("TRUNK".equals(dstType)) {
                this.directionLabel.setText(I18NUtil.getString("attachdata.direction.outbound"));
            }
            StringBuffer b = new StringBuffer();
            if ("EMPLOYEE".equals(srcType)) {
                if (item.has("sName")) {
                    b.append(item.getString("sName"));
                }
                if (item.has("sExt")) {
                    b.append(" (");
                    b.append(item.getString("sExt"));
                    b.append(")");
                }
                this.agentTitle.setText(I18NUtil.getString("personalCustomer.history.agentDialout"));
            }
            if ("EMPLOYEE".equals(dstType) && item.has("dName")) {
                b.append(item.getString("dName"));
                if (item.has("dExt")) {
                    b.append(" (");
                    b.append(item.getString("dExt"));
                    b.append(")");
                }
                this.agentTitle.setText(I18NUtil.getString("personalCustomer.history.agentAnswered"));
            }
            this.agentLabel.setText(b.toString());
            if (item.has("result")) {
                int dialResult = item.getInt("result");
                CallResultType callType = CallResultType.getValue(dialResult);
                this.resultLabel.setText(callType.getCallResult());
            }
            StringBuffer summCategoryInfo = new StringBuffer();
            StringBuffer summOutcomeInfo = new StringBuffer();
            if (item.has("suCategoryId")) {
                summCategoryInfo.append(SummaryTreeCache.getSummaryItem(item.getLong("suCategoryId")));
            }
            if (item.has("suCategoryIds")) {
                ids = item.getString("suCategoryIds");
                for (String id : idAry = ids.split(",")) {
                    if (summCategoryInfo.length() != 0) {
                        summCategoryInfo.append(I18NUtil.getString("comma"));
                    }
                    summCategoryInfo.append(SummaryTreeCache.getSummaryItem(Long.parseLong(id)));
                }
            }
            if (summCategoryInfo.length() > 0) {
                this.summaryCategoryLabel.setText(summCategoryInfo.toString());
            }
            if (item.has("suOutcomeId")) {
                summOutcomeInfo.append(SummaryTreeCache.getSummaryItem(item.getLong("suOutcomeId")));
            }
            if (item.has("suOutcomeIds")) {
                ids = item.getString("suOutcomeIds");
                for (String id : idAry = ids.split(",")) {
                    if (summOutcomeInfo.length() != 0) {
                        summOutcomeInfo.append(I18NUtil.getString("comma"));
                    }
                    summOutcomeInfo.append(SummaryTreeCache.getSummaryItem(Long.parseLong(id)));
                }
            }
            if (summOutcomeInfo.length() > 0) {
                this.summaryOutcomeLabel.setText(summOutcomeInfo.toString());
            }
            if (item.has("suNote")) {
                String note = item.getString("suNote");
                this.noteArea.setText(note);
            }
        }
        catch (JSONException e) {
            Log.e(PhoneCustomerHistoryPanel.class.getSimpleName(), "ERROR:" + e.getMessage(), e);
        }
    }

    public void clearData() {
    }
}

