/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.customer;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.cc.Application;
import com.blisscloud.ezuc.client.component.ChatBackgroundPanel;
import com.blisscloud.ezuc.client.component.CustomLineBorder;
import com.blisscloud.ezuc.client.component.GroupPanel;
import com.blisscloud.ezuc.client.customer.AIChatPanel3;
import com.blisscloud.ezuc.client.customer.HomeMenuPanel;
import com.blisscloud.ezuc.client.customer.HomeTabPanel;
import com.blisscloud.mobile.ezuc.agent.AttachDataBean;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.json.JSONObject;

public class HomeFramePanel
extends JPanel {
    private static final int CHAT_PANEL_WIDTH = 450;
    private JSplitPane middleSplitPane;
    private HomeMenuPanel menuPanel;
    private AIChatPanel3 chatPanel;
    private HomeTabPanel tabPanel;
    private ChatBackgroundPanel backgroundPanel;
    private boolean backgroundShow;
    private boolean showChatPanel;

    public HomeFramePanel() {
        this.setLayout(new BorderLayout());
        this.initView();
    }

    private void initView() {
        JSplitPane mainSplitPane = new JSplitPane(1);
        this.add((Component)mainSplitPane, "Center");
        mainSplitPane.setBorder(BorderFactory.createEmptyBorder());
        mainSplitPane.setContinuousLayout(true);
        this.middleSplitPane = new JSplitPane(1);
        this.middleSplitPane.setBorder(BorderFactory.createEmptyBorder());
        this.middleSplitPane.setContinuousLayout(true);
        this.menuPanel = new HomeMenuPanel(this);
        this.menuPanel.setMinimumSize(new Dimension(150, 300));
        this.menuPanel.setPreferredSize(new Dimension(200, 300));
        this.menuPanel.setBorder(new CustomLineBorder(GroupPanel.TITLE_BORDER_COLOR, 0, 0, 0, 1));
        this.backgroundPanel = new ChatBackgroundPanel();
        this.backgroundPanel.setMinimumSize(new Dimension(300, 300));
        this.chatPanel = new AIChatPanel3();
        this.chatPanel.setMinimumSize(new Dimension(150, 300));
        this.chatPanel.setMaximumSize(new Dimension(450, Integer.MAX_VALUE));
        this.chatPanel.setPreferredSize(new Dimension(450, 300));
        this.middleSplitPane.setLeftComponent(this.backgroundPanel);
        this.middleSplitPane.setRightComponent(null);
        this.backgroundShow = true;
        this.tabPanel = new HomeTabPanel(this);
        mainSplitPane.setLeftComponent(this.menuPanel);
        mainSplitPane.setRightComponent(this.middleSplitPane);
        SwingUtilities.invokeLater(() -> {
            int totalWidth = this.getWidth();
            if (totalWidth > 0) {
                int menuWidth = (int)((double)totalWidth * 0.15);
                mainSplitPane.setDividerLocation(menuWidth);
                this.middleSplitPane.setDividerLocation(this.getWidth() - menuWidth);
            }
        });
        mainSplitPane.setResizeWeight(0.0);
        this.middleSplitPane.setResizeWeight(1.0);
        this.checkChatPanel();
    }

    public void showChatPanel() {
        if (this.chatPanel.getParent() == null) {
            this.middleSplitPane.setRightComponent(this.chatPanel);
            this.middleSplitPane.revalidate();
            this.middleSplitPane.repaint();
            SwingUtilities.invokeLater(() -> {
                int chatWidth;
                int totalWidth = this.middleSplitPane.getWidth();
                int backgroundWidth = totalWidth - (chatWidth = 450);
                if (backgroundWidth > 0) {
                    this.middleSplitPane.setDividerLocation(backgroundWidth);
                } else {
                    this.middleSplitPane.setDividerLocation(totalWidth - chatWidth);
                }
            });
            this.showChatPanel = true;
        }
    }

    public void hideChatPanel() {
        if (this.chatPanel.getParent() != null) {
            this.chatPanel.clearChat();
            this.middleSplitPane.setRightComponent(null);
            this.middleSplitPane.setDividerLocation(this.getWidth());
            this.middleSplitPane.revalidate();
            this.middleSplitPane.repaint();
            this.showChatPanel = false;
        }
    }

    public void refreshData() {
        this.menuPanel.refreshApplicationList();
    }

    public void release() {
        if (this.menuPanel != null) {
            this.menuPanel.release();
        }
        if (this.tabPanel != null) {
            this.tabPanel.release();
        }
    }

    public void closeAllTab() {
        this.backgroundShow = true;
        this.middleSplitPane.remove(this.tabPanel);
        this.middleSplitPane.setLeftComponent(this.backgroundPanel);
        System.gc();
    }

    public boolean onAgentAttributeReceived(String matchSipCallId, String eventSipCallId) {
        if (this.menuPanel != null) {
            return this.menuPanel.onAgentAttributeReceived(matchSipCallId, eventSipCallId);
        }
        return false;
    }

    public void openUrlTab(Application app, String url) {
        boolean successOpen = this.tabPanel.openURLTab(app, url);
        if (successOpen && this.backgroundShow) {
            this.backgroundShow = false;
            this.middleSplitPane.remove(this.backgroundPanel);
            this.middleSplitPane.setLeftComponent(this.tabPanel);
        }
    }

    public void openSummaryTab(Application app, AttachDataBean callDataBean) {
        boolean successOpen = this.tabPanel.openSummaryTab(app, callDataBean);
        if (successOpen && this.backgroundShow) {
            this.backgroundShow = false;
            this.middleSplitPane.remove(this.backgroundPanel);
            this.middleSplitPane.setLeftComponent(this.tabPanel);
        }
    }

    public int getTabCount() {
        if (this.tabPanel != null) {
            return this.tabPanel.getTabCount();
        }
        return 0;
    }

    public void onPersonalInfoChanged() {
        this.checkChatPanel();
    }

    public void onPhoneStateChanged() {
    }

    private void checkChatPanel() {
        if (!PreferencesUtil.isAiAssistanceEnabled(UCChatClient.context)) {
            this.hideChatPanel();
        } else {
            this.showChatPanel();
        }
    }

    public void onAiSubtitleReceived(String msgId, String msg, int role, int usage, boolean finish, long callStartTime, long analysisReceivedTime) {
        this.showChatPanel();
        this.chatPanel.onAiSubtitleReceived(msgId, msg, role, usage, finish, callStartTime, analysisReceivedTime);
    }

    public void onAiSummaryReceived(JSONObject summaryObj, long callStartTime, long analysisReceivedTime, long lastCustomerTime) {
        this.showChatPanel();
        this.chatPanel.onAiSummaryReceived(summaryObj, callStartTime, analysisReceivedTime, lastCustomerTime);
    }

    public void onAiAssistanceOn() {
        this.chatPanel.clearChat();
    }

    public boolean isShowChatPanel() {
        return this.showChatPanel;
    }

    public void setShowChatPanel(boolean showChatPanel) {
        this.showChatPanel = showChatPanel;
    }
}

