/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.customer;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.cc.Application;
import com.blisscloud.ezuc.client.cc.ApplicationCache;
import com.blisscloud.ezuc.client.component.EntryPanel;
import com.blisscloud.ezuc.client.component.ExpandListener;
import com.blisscloud.ezuc.client.component.GroupPanel;
import com.blisscloud.ezuc.client.component.GroupPanelType;
import com.blisscloud.ezuc.client.component.UCScrollPane;
import com.blisscloud.ezuc.client.customer.AppCondOper;
import com.blisscloud.ezuc.client.customer.AppConditonOper;
import com.blisscloud.ezuc.client.customer.AppEntryPanel;
import com.blisscloud.ezuc.client.customer.AppParamType;
import com.blisscloud.ezuc.client.customer.HomeFramePanel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.AttachDataBean;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HomeMenuPanel
extends JPanel
implements ExpandListener {
    private static final String HOME_FUN_GROUP_WORKAREA = "HOME_FUN_GROUP_WORKAREA";
    private HomeFramePanel framePanel;
    private JScrollPane scrollPane;
    private JPanel menuPanel;
    private Map<String, GroupPanel> homeGroupMap = new Hashtable<String, GroupPanel>();
    private Map<EntryPanel, GroupPanel> entryPanelMap = new HashMap<EntryPanel, GroupPanel>();
    private final EntryPanelMouseListener enteryMouseListener = new EntryPanelMouseListener();

    public HomeMenuPanel(HomeFramePanel framePanel) {
        this.framePanel = framePanel;
        this.initView();
        this.initDefaultGroups();
    }

    public void release() {
        this.menuPanel.removeAll();
        this.menuPanel.revalidate();
        this.menuPanel.repaint();
        this.initDefaultGroups();
    }

    private void initView() {
        BorderLayout tabpanelMyAddressBookLayout = new BorderLayout();
        this.setLayout(tabpanelMyAddressBookLayout);
        this.setBackground(Color.WHITE);
        this.scrollPane = new UCScrollPane(60);
        this.add((Component)this.scrollPane, "Center");
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.menuPanel = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                int prefWidth = HomeMenuPanel.this.getWidth() - HomeMenuPanel.this.scrollPane.getVerticalScrollBar().getWidth();
                int prefHeight = super.getPreferredSize().height;
                return new Dimension(prefWidth, prefHeight);
            }
        };
        this.scrollPane.setViewportView(this.menuPanel);
        BoxLayout contentMyAddressBookLayout = new BoxLayout(this.menuPanel, 1);
        this.menuPanel.setLayout(contentMyAddressBookLayout);
        this.menuPanel.setBackground(Color.WHITE);
    }

    private void initDefaultGroups() {
        this.homeGroupMap.clear();
        this.menuPanel.removeAll();
        GroupPanel groupPanel = new GroupPanel(HOME_FUN_GROUP_WORKAREA, I18NUtil.getString("home_func_group_bizarea"), null, GroupPanelType.general, this);
        groupPanel.setEntryHeight(40);
        groupPanel.setShowCompCount(false);
        boolean collapse = PreferencesUtil.isGeneralBookGroupCollapsed(UCChatClient.context, groupPanel.getGroupId());
        groupPanel.setExpanded(!collapse);
        groupPanel.setBackground(Color.YELLOW);
        groupPanel.setVisible(true);
        groupPanel.setMode(true);
        this.homeGroupMap.put(HOME_FUN_GROUP_WORKAREA, groupPanel);
        this.menuPanel.add(groupPanel);
        this.menuPanel.revalidate();
        this.menuPanel.repaint();
    }

    @Override
    public void onChanged() {
    }

    public void refreshApplicationList() {
        RefreshApplicationListTask refreshTask = new RefreshApplicationListTask();
        refreshTask.start();
    }

    public boolean onAgentAttributeReceived(String matchSipCalId, String eventSipCallId) {
        try {
            AttachDataBean callDataMap = WebAgent.forceCallAttrbute(matchSipCalId, eventSipCallId);
            if (callDataMap != null) {
                List<Application> myApplicationList = ApplicationCache.getInstance().getApplicationList();
                for (Application app : myApplicationList) {
                    this.handleApp(app, callDataMap);
                }
            }
        }
        catch (Throwable t) {
            Log.e(HomeMenuPanel.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
        }
        return false;
    }

    private void handleApp(Application app, AttachDataBean attBean) {
        try {
            HashMap<String, String> attributes = attBean != null ? attBean.getAttachData() : new HashMap<String, String>();
            JSONObject obj = app.getObj();
            if (!this.checkAutoOpen(obj, attributes)) {
                return;
            }
            int appType = obj.getInt("appType");
            if (appType == 0) {
                this.framePanel.openSummaryTab(app, attBean);
            } else if (appType == 1) {
                int openStyle = obj.getInt("openStyle");
                String url = this.getAppUrl(obj, attributes);
                if (openStyle == 0) {
                    Desktop.getDesktop().browse(new URL(url).toURI());
                } else {
                    this.framePanel.openUrlTab(app, url);
                }
            } else if (appType == 2) {
                String filePath = obj.getString("filePath");
                if (StringUtils.isNotBlank((CharSequence)filePath)) {
                    if (filePath.contains("{ANI}") && StringUtils.isNotBlank((CharSequence)((CharSequence)attributes.get("ANI")))) {
                        filePath = filePath.replace("{ANI}", (CharSequence)attributes.get("ANI"));
                    }
                    if (filePath.contains("{DNIS}") && StringUtils.isNotBlank((CharSequence)((CharSequence)attributes.get("DNIS")))) {
                        filePath = filePath.replace("{DNIS}", (CharSequence)attributes.get("DNIS"));
                    }
                    Process p = Runtime.getRuntime().exec(filePath);
                    Log.i(HomeMenuPanel.class.getSimpleName(), p.toString());
                }
            } else if (appType == 3) {
                final int syncPort = obj.optInt("syncPort", 2223);
                String contentSync = obj.optString("syncContent", "{CAMP_TARGET_INFO}");
                if (StringUtils.isNotBlank((CharSequence)contentSync)) {
                    if (contentSync.contains("{CAMP_TARGET_INFO}") && attBean != null && StringUtils.isNotBlank((CharSequence)attBean.getCampReqInfo1())) {
                        contentSync = contentSync.replace("{CAMP_TARGET_INFO}", attBean.getCampReqInfo1());
                    }
                    if (contentSync.contains("{ANI}") && StringUtils.isNotBlank((CharSequence)((CharSequence)attributes.get("ANI")))) {
                        contentSync = contentSync.replace("{ANI}", (CharSequence)attributes.get("ANI"));
                    }
                    if (contentSync.contains("{DNIS}") && StringUtils.isNotBlank((CharSequence)((CharSequence)attributes.get("DNIS")))) {
                        contentSync = contentSync.replace("{DNIS}", (CharSequence)attributes.get("DNIS"));
                    }
                }
                final String syncData = contentSync;
                new Timer().schedule(new TimerTask(this){

                    @Override
                    public void run() {
                        try {
                            byte[] data = syncData.getBytes(StandardCharsets.UTF_8);
                            InetAddress addr = InetAddress.getByName("127.0.0.1");
                            try (DatagramSocket socket = new DatagramSocket();){
                                DatagramPacket packet = new DatagramPacket(data, data.length, addr, syncPort);
                                socket.send(packet);
                                Log.i(HomeMenuPanel.class.getSimpleName(), "Sent " + data.length + " bytes to 127.0.0.1:" + syncPort + " -> " + syncData);
                            }
                        }
                        catch (Exception e) {
                            Log.e(HomeMenuPanel.class.getSimpleName(), "Sent data failed:" + e.getMessage(), e);
                        }
                    }
                }, 100L);
            }
        }
        catch (Throwable t) {
            Log.e(HomeMenuPanel.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
        }
    }

    private boolean checkAutoOpen(JSONObject appObj, Map<String, String> attributes) throws JSONException {
        int conditionType = appObj.getInt("conditionType");
        int directionType = appObj.getInt("directionType");
        if (conditionType == 0) {
            return false;
        }
        if (conditionType == 1) {
            if (directionType == 0) {
                return true;
            }
            String direction = null;
            if (attributes != null && attributes.containsKey("DIRECTION")) {
                direction = attributes.get("DIRECTION");
            }
            if (direction == null) {
                return false;
            }
            if ("INBOUND".equals(direction) && directionType == 1) {
                return true;
            }
            return "OUTBOUND".equals(direction) && directionType == 2;
        }
        if (conditionType == 2) {
            String direction = null;
            if (attributes != null && attributes.containsKey("DIRECTION")) {
                direction = attributes.get("DIRECTION");
            }
            if (direction == null && directionType != 0) {
                return false;
            }
            if ("INBOUND".equals(direction) && directionType == 2) {
                return false;
            }
            if ("OUTBOUND".equals(direction) && directionType == 1) {
                return false;
            }
            int conditionOper = appObj.getInt("conditionOper");
            AppConditonOper condOper = AppConditonOper.getValue(conditionOper);
            JSONArray conditions = appObj.getJSONArray("conditions");
            if (conditions == null || conditions.length() == 0) {
                return false;
            }
            return this.verifyAttribute(condOper, attributes, conditions);
        }
        return false;
    }

    private String getAppUrl(JSONObject appObj, Map<String, String> attributes) throws JSONException {
        LiteContact mySelf = ContactManager.getContact((Context)UCChatClient.context, PreferencesUtil.getUserJid(UCChatClient.context));
        String url = appObj.getString("url");
        JSONArray parameters = appObj.getJSONArray("parameters");
        StringBuffer urlBuffer = new StringBuffer();
        urlBuffer.append(url);
        if (parameters != null && parameters.length() != 0) {
            if (!url.contains("?")) {
                urlBuffer.append("?");
            } else {
                urlBuffer.append("&");
            }
            int index = 0;
            for (int i = 0; i < parameters.length(); ++i) {
                JSONObject param = parameters.getJSONObject(i);
                String paramKey = param.getString("key");
                int paramTypeId = param.getInt("type");
                AppParamType paramType = AppParamType.getValue(paramTypeId);
                if (index != 0) {
                    urlBuffer.append("&");
                }
                urlBuffer.append(paramKey);
                urlBuffer.append("=");
                if (paramType == AppParamType.EMP_ID) {
                    if (mySelf.getId() != null) {
                        urlBuffer.append(mySelf.getId());
                    }
                } else if (paramType == AppParamType.EMP_STAFF_ID) {
                    String staffId = PreferencesUtil.getUserStaffId(UCChatClient.context);
                    if (StringUtils.isNotBlank((CharSequence)staffId)) {
                        urlBuffer.append(staffId);
                    }
                } else if (paramType == AppParamType.EMP_LOGIN_ACCOUNT) {
                    if (StringUtils.isNotBlank((CharSequence)mySelf.getAccount())) {
                        urlBuffer.append(mySelf.getAccount());
                    }
                } else if (paramType == AppParamType.EMP_EMAIL) {
                    if (StringUtils.isNotBlank((CharSequence)mySelf.getEmail())) {
                        urlBuffer.append(mySelf.getEmail());
                    }
                } else if (paramType == AppParamType.EMP_CNAME) {
                    if (StringUtils.isNotBlank((CharSequence)mySelf.getOtherName())) {
                        urlBuffer.append(mySelf.getOtherName());
                    }
                } else if (paramType == AppParamType.EMP_GIVEN_NAME) {
                    if (StringUtils.isNotBlank((CharSequence)mySelf.getGivenName())) {
                        urlBuffer.append(mySelf.getGivenName());
                    }
                } else if (paramType == AppParamType.EMP_SUR_NAME) {
                    if (StringUtils.isNotBlank((CharSequence)mySelf.getSurName())) {
                        urlBuffer.append(mySelf.getSurName());
                    }
                } else if (paramType == AppParamType.ANI) {
                    if (attributes.containsKey("ANI")) {
                        urlBuffer.append(attributes.get("ANI"));
                    }
                } else if (paramType == AppParamType.DNIS) {
                    if (attributes.containsKey("DNIS")) {
                        urlBuffer.append(attributes.get("DNIS"));
                    }
                } else if (paramType == AppParamType.CALL_ID) {
                    if (attributes.containsKey("CALL_ID")) {
                        urlBuffer.append(attributes.get("CALL_ID"));
                    }
                } else if (paramType == AppParamType.LINK_ID) {
                    if (attributes.containsKey("LINK_ID")) {
                        urlBuffer.append(attributes.get("LINK_ID"));
                    }
                } else if (paramType == AppParamType.INBOUND_RULE_INFO && attributes.containsKey("INBOUND_RULE_INFO")) {
                    urlBuffer.append(attributes.get("INBOUND_RULE_INFO"));
                }
                ++index;
            }
        }
        return urlBuffer.toString();
    }

    private boolean verifyAttribute(AppConditonOper condOper, Map<String, String> attributes, JSONArray conditions) throws JSONException {
        for (int i = 0; conditions != null && i < conditions.length(); ++i) {
            JSONObject cond = conditions.getJSONObject(i);
            String attName = cond.getString("name");
            String compareValue1 = attributes.get(attName);
            String compareValue2 = cond.getString("value");
            AppCondOper operType = AppCondOper.getValue(cond.getInt("oper"));
            boolean result = this.checkTwoValue(compareValue1, compareValue2, operType);
            Log.i(HomeMenuPanel.class.getSimpleName(), "(" + i + ") " + attName + " " + compareValue1 + " " + operType.toString() + " " + compareValue2);
            if (result) {
                if (condOper != AppConditonOper.OR) continue;
                Log.i(HomeMenuPanel.class.getSimpleName(), "result:true");
                return true;
            }
            if (condOper != AppConditonOper.AND) continue;
            Log.i(HomeMenuPanel.class.getSimpleName(), "result:false");
            return false;
        }
        if (condOper == AppConditonOper.OR) {
            Log.i(HomeMenuPanel.class.getSimpleName(), "result:false");
            return false;
        }
        if (condOper == AppConditonOper.AND) {
            Log.i(HomeMenuPanel.class.getSimpleName(), "result:true");
            return true;
        }
        Log.i(HomeMenuPanel.class.getSimpleName(), "result:false");
        return false;
    }

    private boolean checkTwoValue(String value1, String value2, AppCondOper condOper) {
        if (value1 == null || value2 == null) {
            return false;
        }
        if (NumberUtils.isNumber((String)value1) && NumberUtils.isNumber((String)value2)) {
            try {
                double d1 = Double.parseDouble(value1);
                double d2 = Double.parseDouble(value2);
                if (condOper == AppCondOper.LESS_THAN) {
                    return d1 < d2;
                }
                if (condOper == AppCondOper.LESS_EQUALS) {
                    return d1 <= d2;
                }
                if (condOper == AppCondOper.EQUALS) {
                    return d1 == d2;
                }
                if (condOper == AppCondOper.GREATER_EQUALS) {
                    return d1 >= d2;
                }
                if (condOper == AppCondOper.GREATER_THAN) {
                    return d1 > d2;
                }
                if (condOper == AppCondOper.NOT_EQUALS) {
                    return d1 != d2;
                }
                return false;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        int compareResult = value1.compareTo(value2);
        if (condOper == AppCondOper.LESS_THAN) {
            return compareResult < 0;
        }
        if (condOper == AppCondOper.LESS_EQUALS) {
            return compareResult <= 0;
        }
        if (condOper == AppCondOper.EQUALS) {
            return compareResult == 0;
        }
        if (condOper == AppCondOper.GREATER_EQUALS) {
            return compareResult >= 0;
        }
        if (condOper == AppCondOper.GREATER_THAN) {
            return compareResult > 0;
        }
        if (condOper == AppCondOper.NOT_EQUALS) {
            return compareResult != 0;
        }
        return false;
    }

    private void handleAppClicked(Application app) {
        try {
            AttachDataBean attBean = WebAgent.getCurrentCallAttrbuteForClicked();
            HashMap<String, String> attributes = attBean != null ? attBean.getAttachData() : new HashMap<String, String>();
            JSONObject obj = app.getObj();
            int appType = obj.getInt("appType");
            if (appType == 0) {
                this.framePanel.openSummaryTab(app, attBean);
            } else if (appType == 1) {
                int openStyle = obj.getInt("openStyle");
                String url = this.getAppUrl(obj, attributes);
                if (openStyle == 0) {
                    Desktop.getDesktop().browse(new URL(url).toURI());
                } else {
                    this.framePanel.openUrlTab(app, url);
                }
            } else if (appType == 2) {
                String filePath = obj.getString("filePath");
                if (StringUtils.isNotBlank((CharSequence)filePath)) {
                    if (filePath.contains("{ANI}") && StringUtils.isNotBlank((CharSequence)((CharSequence)attributes.get("ANI")))) {
                        filePath = filePath.replace("{ANI}", (CharSequence)attributes.get("ANI"));
                    }
                    if (filePath.contains("{DNIS}") && StringUtils.isNotBlank((CharSequence)((CharSequence)attributes.get("DNIS")))) {
                        filePath = filePath.replace("{DNIS}", (CharSequence)attributes.get("DNIS"));
                    }
                    Process p = Runtime.getRuntime().exec(filePath);
                    Log.i(HomeMenuPanel.class.getSimpleName(), p.toString());
                }
            } else if (appType == 3) {
                final int syncPort = obj.optInt("syncPort", 2223);
                String contentSync = obj.optString("syncContent", "{CAMP_TARGET_INFO}");
                if (StringUtils.isNotBlank((CharSequence)contentSync)) {
                    if (contentSync.contains("{CAMP_TARGET_INFO}") && attBean != null && StringUtils.isNotBlank((CharSequence)attBean.getCampReqInfo1())) {
                        contentSync = contentSync.replace("{CAMP_TARGET_INFO}", attBean.getCampReqInfo1());
                    }
                    if (contentSync.contains("{ANI}") && StringUtils.isNotBlank((CharSequence)((CharSequence)attributes.get("ANI")))) {
                        contentSync = contentSync.replace("{ANI}", (CharSequence)attributes.get("ANI"));
                    }
                    if (contentSync.contains("{DNIS}") && StringUtils.isNotBlank((CharSequence)((CharSequence)attributes.get("DNIS")))) {
                        contentSync = contentSync.replace("{DNIS}", (CharSequence)attributes.get("DNIS"));
                    }
                }
                final String syncData = contentSync;
                new Timer().schedule(new TimerTask(this){

                    @Override
                    public void run() {
                        try {
                            byte[] data = syncData.getBytes(StandardCharsets.UTF_8);
                            InetAddress addr = InetAddress.getByName("127.0.0.1");
                            try (DatagramSocket socket = new DatagramSocket();){
                                DatagramPacket packet = new DatagramPacket(data, data.length, addr, syncPort);
                                socket.send(packet);
                                Log.i(HomeMenuPanel.class.getSimpleName(), "Sent " + data.length + " bytes to 127.0.0.1:" + syncPort + " -> " + syncData);
                            }
                        }
                        catch (Exception e) {
                            Log.e(HomeMenuPanel.class.getSimpleName(), "Sent data failed:" + e.getMessage(), e);
                        }
                    }
                }, 100L);
            }
        }
        catch (Throwable t) {
            Log.e(HomeMenuPanel.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
        }
    }

    class EntryPanelMouseListener
    extends MouseAdapter {
        EntryPanelMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (evt.getButton() == 1) {
                AppEntryPanel entry = (AppEntryPanel)evt.getComponent();
                entry.setSelected(true);
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (evt.getButton() == 1) {
                AppEntryPanel entry = (AppEntryPanel)evt.getComponent();
                entry.setSelected(false);
                if (evt.getClickCount() == 1) {
                    HomeMenuPanel.this.handleAppClicked(entry.getApp());
                }
            }
        }
    }

    class RefreshApplicationListTask
    extends Thread {
        private String refreshApplicationListTask = "refreshApplicationListTask";

        public RefreshApplicationListTask() {
            this.setName("UC-RefreshApplicationListTasz");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String string = this.refreshApplicationListTask;
            synchronized (string) {
                Log.i(HomeMenuPanel.class.getSimpleName(), "run RefreshApplicationListTask");
                final List<Application> myApplicationList = ApplicationCache.getInstance().getApplicationList();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GroupPanel homeFuncGroupPane = HomeMenuPanel.this.homeGroupMap.get(HomeMenuPanel.HOME_FUN_GROUP_WORKAREA);
                        List<String> oldHomeFuncEntryIdList = RefreshApplicationListTask.this.getEntryPanelIds(homeFuncGroupPane);
                        ArrayList<String> unchangedHomeFuncIdList = new ArrayList<String>(oldHomeFuncEntryIdList);
                        List<String> newHomeFuncIdList = RefreshApplicationListTask.this.getHomeFuncEntryIdList(myApplicationList);
                        unchangedHomeFuncIdList.retainAll(newHomeFuncIdList);
                        newHomeFuncIdList.removeAll(unchangedHomeFuncIdList);
                        oldHomeFuncEntryIdList.removeAll(unchangedHomeFuncIdList);
                        if (myApplicationList == null) {
                            homeFuncGroupPane.clearContentComponent();
                        } else {
                            for (String oldHomeFuncEntryId : oldHomeFuncEntryIdList) {
                                RefreshApplicationListTask.this.removeEntryPanel(oldHomeFuncEntryId, homeFuncGroupPane);
                            }
                            int appCount = myApplicationList.size();
                            int appIndex = 0;
                            for (int i = 0; i < appCount; ++i) {
                                Object app = myApplicationList.get(i);
                                if (app instanceof Application) {
                                    Application application = (Application)app;
                                    String entryKey = application.getEntryKey();
                                    if (unchangedHomeFuncIdList.contains(entryKey)) {
                                        AppEntryPanel appPanel = (AppEntryPanel)RefreshApplicationListTask.this.moveEntryPanel(entryKey, appIndex, homeFuncGroupPane);
                                        appPanel.setApplication(application);
                                    } else if (newHomeFuncIdList.contains(entryKey)) {
                                        RefreshApplicationListTask.this.addAppEntryPanel(application, appIndex, homeFuncGroupPane);
                                    }
                                    ++appIndex;
                                    continue;
                                }
                                Log.w(HomeMenuPanel.class.getSimpleName(), "unexpected object type " + app.getClass().getName());
                            }
                        }
                        homeFuncGroupPane.revalidate();
                        homeFuncGroupPane.repaint();
                    }
                });
            }
        }

        private List<String> getHomeFuncEntryIdList(List<Application> myApplicationList) {
            ArrayList<String> ret = new ArrayList<String>();
            if (myApplicationList != null && myApplicationList.size() != 0) {
                for (Application app : myApplicationList) {
                    ret.add(app.getEntryKey());
                }
            }
            return ret;
        }

        private List<String> getEntryPanelIds(GroupPanel groupPanel) {
            Component[] comps;
            ArrayList<String> ret = new ArrayList<String>();
            for (Component comp : comps = groupPanel.getContentComponents()) {
                if (!(comp instanceof EntryPanel)) continue;
                EntryPanel ep = (EntryPanel)comp;
                ret.add(ep.getEntryId());
            }
            return ret;
        }

        private void addAppEntryPanel(Application application, int index, GroupPanel groupPanel) {
            AppEntryPanel applicationBiz = new AppEntryPanel(application);
            applicationBiz.addMouseListener(HomeMenuPanel.this.enteryMouseListener);
            applicationBiz.setCursor(Cursor.getPredefinedCursor(12));
            groupPanel.addContentComponent(applicationBiz, index);
            groupPanel.revalidate();
            groupPanel.repaint();
            HomeMenuPanel.this.entryPanelMap.put(applicationBiz, groupPanel);
        }

        private EntryPanel moveEntryPanel(String entryId, int index, GroupPanel fromGroupPane) {
            Log.d(HomeMenuPanel.class.getSimpleName(), "moveEntryPanel:" + entryId + " index:" + index + " fromGroupPane:" + String.valueOf(fromGroupPane));
            Collection<EntryPanel> eps = this.findEntryPanel(entryId);
            for (EntryPanel ep : eps) {
                GroupPanel groupPanel = HomeMenuPanel.this.entryPanelMap.get(ep);
                if (groupPanel != fromGroupPane) continue;
                boolean selected = ep.isSelected();
                groupPanel.moveContentComponent(ep, index);
                ep.setSelected(selected);
                return ep;
            }
            return null;
        }

        private void removeEntryPanel(String entryId, GroupPanel fromGroupPane) {
            Log.d(HomeMenuPanel.class.getSimpleName(), "remove entryId:" + entryId + " fromGroupPane:" + String.valueOf(fromGroupPane));
            Collection<EntryPanel> eps = this.findEntryPanel(entryId);
            for (EntryPanel ep : eps) {
                GroupPanel groupPanel = HomeMenuPanel.this.entryPanelMap.get(ep);
                if (groupPanel != fromGroupPane) continue;
                groupPanel.removeContentComponent(ep);
                groupPanel.revalidate();
                groupPanel.repaint();
                HomeMenuPanel.this.entryPanelMap.remove(ep);
                return;
            }
        }

        private Collection<EntryPanel> findEntryPanel(String entryId) {
            ArrayList<EntryPanel> ret = new ArrayList<EntryPanel>();
            HashSet<EntryPanel> eps = new HashSet<EntryPanel>(HomeMenuPanel.this.entryPanelMap.keySet());
            for (EntryPanel ep : eps) {
                String _entryId = ep.getEntryId();
                if (_entryId == null || !_entryId.equals(entryId)) continue;
                ret.add(ep);
            }
            return ret;
        }
    }
}

