/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.customer;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.cc.Application;
import com.blisscloud.ezuc.client.customer.BizPanel;
import com.blisscloud.ezuc.client.customer.HomeFramePanel;
import com.blisscloud.ezuc.client.customer.PhoneBizPanel;
import com.blisscloud.ezuc.client.customer.SpacedTabbedPaneUI;
import com.blisscloud.ezuc.client.customer.UrlBizPanel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.mobile.ezuc.agent.AttachDataBean;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import org.apache.commons.lang3.StringUtils;

public class HomeTabPanel
extends JPanel {
    private JTabbedPane jTabbedPane1;
    private HomeFramePanel framePanel;
    private JPopupMenu cleaupUpMenu;
    private CleanAllTabsAction cleanAllTabsAction;

    public HomeTabPanel(HomeFramePanel framePanel) {
        super(new BorderLayout());
        this.framePanel = framePanel;
        this.initGUI();
        this.cleaupUpMenu = new JPopupMenu();
        this.cleaupUpMenu.add(new CleanRightTabsAction());
        this.cleaupUpMenu.add(new CleanLeftTabsAction());
        this.cleaupUpMenu.add(new CleanOtherTabsAction());
        this.cleanAllTabsAction = new CleanAllTabsAction();
        this.cleaupUpMenu.add(this.cleanAllTabsAction);
    }

    public void release() {
        this.cleanAllTabsAction.actionPerformed(null);
    }

    private void removeTab(int index) {
        BizPanel comp = (BizPanel)((Object)this.jTabbedPane1.getComponentAt(index));
        if (comp != null) {
            comp.onClose();
        }
        this.jTabbedPane1.removeTabAt(index);
        if (this.jTabbedPane1.getTabCount() == 0) {
            this.framePanel.closeAllTab();
        }
        BroadcastUtil.sendCustomerServiceChangedEvent(UCChatClient.context);
    }

    public void removeComp(JPanel panel) {
        BizPanel comp;
        if (panel instanceof BizPanel && (comp = (BizPanel)((Object)panel)) != null) {
            comp.onClose();
        }
        this.jTabbedPane1.remove(panel);
        if (this.jTabbedPane1.getTabCount() == 0) {
            this.framePanel.closeAllTab();
        }
        BroadcastUtil.sendCustomerServiceChangedEvent(UCChatClient.context);
    }

    private void initGUI() {
        this.setBackground(new Color(80, 80, 80));
        this.jTabbedPane1 = new JTabbedPane();
        this.jTabbedPane1.setTabLayoutPolicy(1);
        this.jTabbedPane1.setUI(new SpacedTabbedPaneUI());
        this.jTabbedPane1.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        this.add((Component)this.jTabbedPane1, "Center");
        this.jTabbedPane1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                int index;
                if (evt.getButton() == 1 && evt.getClickCount() == 2) {
                    int index2 = HomeTabPanel.this.jTabbedPane1.indexAtLocation(evt.getX(), evt.getY());
                    if (index2 != -1) {
                        HomeTabPanel.this.removeTab(index2);
                    }
                } else if (evt.getButton() == 3 && evt.getClickCount() == 1 && (index = HomeTabPanel.this.jTabbedPane1.indexAtLocation(evt.getX(), evt.getY())) != -1) {
                    HomeTabPanel.this.cleaupUpMenu.show(HomeTabPanel.this.jTabbedPane1, evt.getX(), evt.getY());
                }
            }
        });
        this.jTabbedPane1.addMouseMotionListener(new MouseMotionAdapter(this){

            @Override
            public void mouseMoved(MouseEvent e) {
                JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
                if (HomeTabPanel.findTabPaneIndex(e.getPoint(), tabbedPane) > -1) {
                    tabbedPane.setCursor(new Cursor(12));
                } else {
                    tabbedPane.setCursor(new Cursor(0));
                }
            }
        });
    }

    private static int findTabPaneIndex(Point p, JTabbedPane tabbedPane) {
        for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
            if (!tabbedPane.getBoundsAt(i).contains(p.x, p.y)) continue;
            return i;
        }
        return -1;
    }

    private boolean isCallOpenAlready(String sipCallId) {
        int tabSize = this.jTabbedPane1.getTabCount();
        for (int i = 0; i < tabSize; ++i) {
            PhoneBizPanel bizPanel;
            Component comp = this.jTabbedPane1.getComponentAt(i);
            if (!(comp instanceof PhoneBizPanel) || !(bizPanel = (PhoneBizPanel)comp).checkSipCallId(sipCallId)) continue;
            return true;
        }
        return false;
    }

    private boolean isCallOpenAlready(Application app) {
        int tabSize = this.jTabbedPane1.getTabCount();
        for (int i = 0; i < tabSize; ++i) {
            PhoneBizPanel bizPanel;
            Component comp = this.jTabbedPane1.getComponentAt(i);
            if (!(comp instanceof PhoneBizPanel) || !(bizPanel = (PhoneBizPanel)comp).getApp().equals(app)) continue;
            return true;
        }
        return false;
    }

    public boolean openURLTab(Application app, String url) {
        String name = I18NUtil.getString("home_func_biz_url");
        if (StringUtils.isNotBlank((CharSequence)app.getName())) {
            name = app.getName();
        }
        UrlBizPanel p1 = new UrlBizPanel(app, url);
        this.jTabbedPane1.add((Component)((Object)p1));
        this.jTabbedPane1.setTabComponentAt(this.jTabbedPane1.indexOfComponent((Component)((Object)p1)), this.getTitlePanel(this.jTabbedPane1, (JComponent)((Object)p1), name));
        this.jTabbedPane1.setSelectedComponent((Component)((Object)p1));
        BroadcastUtil.sendCustomerServiceChangedEvent(UCChatClient.context);
        return true;
    }

    public boolean openSummaryTab(Application app, AttachDataBean callDataBean) {
        String name = I18NUtil.getString("home_func_biz_phone");
        if (StringUtils.isNotBlank((CharSequence)app.getName())) {
            name = app.getName();
        }
        if (callDataBean == null) {
            if (this.isCallOpenAlready(app)) {
                ToastUtil.showShort(I18NUtil.getString("home_biz_message_trial_already_open"));
                return false;
            }
            PhoneBizPanel p1 = new PhoneBizPanel(this, app, callDataBean);
            this.jTabbedPane1.add(p1);
            this.jTabbedPane1.setTabComponentAt(this.jTabbedPane1.indexOfComponent(p1), this.getTitlePanel(this.jTabbedPane1, p1, name));
            this.jTabbedPane1.setSelectedComponent(p1);
            BroadcastUtil.sendCustomerServiceChangedEvent(UCChatClient.context);
            return true;
        }
        Map<String, String> callData = callDataBean.getAttachData();
        if (callData == null || !callData.containsKey("SIP_CALL_ID")) {
            ToastUtil.showLong(I18NUtil.getString("home_biz_message_no_call_info"));
            return false;
        }
        String sipCallId = callData.get("SIP_CALL_ID");
        if (StringUtils.isBlank((CharSequence)sipCallId)) {
            ToastUtil.showLong(I18NUtil.getString("home_biz_message_no_call_info"));
            return false;
        }
        if (this.isCallOpenAlready(sipCallId)) {
            ToastUtil.showShort(I18NUtil.getString("home_biz_message_already_open"));
            return false;
        }
        PhoneBizPanel p1 = new PhoneBizPanel(this, app, callDataBean);
        this.jTabbedPane1.add(p1);
        this.jTabbedPane1.setTabComponentAt(this.jTabbedPane1.indexOfComponent(p1), this.getTitlePanel(this.jTabbedPane1, p1, name));
        this.jTabbedPane1.setSelectedComponent(p1);
        BroadcastUtil.sendCustomerServiceChangedEvent(UCChatClient.context);
        return true;
    }

    private JPanel getTitlePanel(JTabbedPane tabbedPane, final JComponent panel, String title) {
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setOpaque(false);
        JLabel titleLbl = new JLabel(title);
        titleLbl.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 5));
        titlePanel.add((Component)titleLbl, "Center");
        JButton closeButton = new JButton("x");
        closeButton.setFont(new Font("arial", 1, 14));
        closeButton.setForeground(Color.GRAY);
        closeButton.setOpaque(false);
        closeButton.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        closeButton.setContentAreaFilled(false);
        closeButton.setBorderPainted(false);
        closeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                HomeTabPanel.this.removeTab(HomeTabPanel.this.jTabbedPane1.indexOfComponent(panel));
            }
        });
        titlePanel.add((Component)closeButton, "East");
        return titlePanel;
    }

    public int getTabCount() {
        return this.jTabbedPane1.getTabCount();
    }

    class CleanRightTabsAction
    extends AbstractAction {
        public CleanRightTabsAction() {
            this.putValue("Name", I18NUtil.getString("home_tab_clean_right"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedIndex = HomeTabPanel.this.jTabbedPane1.getSelectedIndex();
            int tabSize = HomeTabPanel.this.jTabbedPane1.getTabCount();
            for (int i = tabSize - 1; i > selectedIndex; --i) {
                HomeTabPanel.this.removeTab(i);
            }
        }
    }

    class CleanLeftTabsAction
    extends AbstractAction {
        public CleanLeftTabsAction() {
            this.putValue("Name", I18NUtil.getString("home_tab_clean_left"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedIndex = HomeTabPanel.this.jTabbedPane1.getSelectedIndex();
            for (int i = selectedIndex - 1; i >= 0; --i) {
                HomeTabPanel.this.removeTab(i);
            }
        }
    }

    class CleanOtherTabsAction
    extends AbstractAction {
        public CleanOtherTabsAction() {
            this.putValue("Name", I18NUtil.getString("home_tab_clean_others"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedIndex = HomeTabPanel.this.jTabbedPane1.getSelectedIndex();
            int tabSize = HomeTabPanel.this.jTabbedPane1.getTabCount();
            for (int i = tabSize - 1; i >= 0; --i) {
                if (i == selectedIndex) continue;
                HomeTabPanel.this.removeTab(i);
            }
        }
    }

    class CleanAllTabsAction
    extends AbstractAction {
        public CleanAllTabsAction() {
            this.putValue("Name", I18NUtil.getString("home_tab_clean_all"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int tabSize = HomeTabPanel.this.jTabbedPane1.getTabCount();
            for (int i = tabSize - 1; i >= 0; --i) {
                HomeTabPanel.this.removeTab(i);
            }
        }
    }
}

