/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.customer;

import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.cc.ApplicationCache;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.component.HintTextField;
import com.blisscloud.ezuc.client.customer.ColumnType;
import com.blisscloud.ezuc.client.customer.CustomerField;
import com.blisscloud.ezuc.client.customer.CustomerFieldItem;
import com.blisscloud.ezuc.client.customer.FieldDataType;
import com.blisscloud.ezuc.client.customer.LabelType;
import com.blisscloud.ezuc.client.customer.LabelTypeSelectionRenderer;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.toedter.calendar.JCalendar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class ModifyCustomerDialog
extends GenericDialog
implements PropertyChangeListener {
    private JSONObject mCustomerDetail;
    private Color titleColor = new Color(213, 226, 243);
    private JPanel customerFormPanel;
    private ConcurrentHashMap<ColumnType, String> inputMap = new ConcurrentHashMap();
    private ConcurrentHashMap<ColumnType, JComponent> componentMap = new ConcurrentHashMap();
    private JCalendar jcalendar;
    private JPopupMenu popup;
    private JLabel lblBirthday;
    private JLabel lblBirthdayCancel;
    private boolean dateSelected;
    private ChangeListener changeListener;
    private Long mBirthday;
    private String mUuid;
    private Long customerId;

    public ModifyCustomerDialog(JFrame frame, String uuid, JSONObject customerDetail, boolean modal) {
        super(frame);
        this.mUuid = uuid;
        this.mCustomerDetail = customerDetail;
        try {
            this.customerId = this.mCustomerDetail.getLong("id");
            this.handleCustomerDetailToMap();
        }
        catch (JSONException e) {
            Log.e(ModifyCustomerDialog.class.getName(), "ERROR:" + e.getMessage(), e);
        }
        this.setTitle(I18NUtil.getString("personalCustomer_modify_form_title"));
        this.setModal(modal);
        this.setSize(900, 650);
        this.setMinimumSize(new Dimension(900, 650));
        this.initGUI();
    }

    private void handleCustomerDetailToMap() throws JSONException {
        for (ColumnType columnType : ColumnType.values()) {
            CustomerField f = ApplicationCache.getInstance().schameMap.get((Object)columnType);
            if (!f.isEnabled()) continue;
            if (f.getDataType() == FieldDataType.DATETIME) {
                if (!this.mCustomerDetail.has(columnType.getColumnName())) continue;
                long time = this.mCustomerDetail.getLong(columnType.getColumnName());
                this.inputMap.put(columnType, String.valueOf(time));
                continue;
            }
            if (f.getDataType() == FieldDataType.INT) {
                if (!this.mCustomerDetail.has(columnType.getColumnName())) continue;
                int value = this.mCustomerDetail.getInt(columnType.getColumnName());
                this.inputMap.put(columnType, String.valueOf(value));
                continue;
            }
            if (f.getDataType() == FieldDataType.LONG) {
                if (!this.mCustomerDetail.has(columnType.getColumnName())) continue;
                long value = this.mCustomerDetail.getLong(columnType.getColumnName());
                this.inputMap.put(columnType, String.valueOf(value));
                continue;
            }
            if (f.getDataType() != FieldDataType.STRING || !this.mCustomerDetail.has(columnType.getColumnName())) continue;
            String value = this.mCustomerDetail.getString(columnType.getColumnName());
            this.inputMap.put(columnType, value);
        }
    }

    public void refresh() {
        this.collectInputMap();
        this.componentMap.clear();
        this.customerFormPanel.removeAll();
        this.initForm();
        this.revalidate();
        this.repaint();
    }

    private void lblBirthdayCancel(MouseEvent evt) {
        this.setBirthday(null);
    }

    private void lblBirthdayMouseClicked(MouseEvent evt) {
        if (this.jcalendar == null) {
            this.initJCalendar();
        }
        int x = 0;
        int y = this.lblBirthday.getHeight();
        Calendar calendar = Calendar.getInstance();
        if (this.mBirthday != null) {
            calendar.setTime(new Date(this.mBirthday));
        }
        this.jcalendar.setCalendar(calendar);
        this.popup.show(this.lblBirthday, x, y);
        this.dateSelected = false;
    }

    private void initJCalendar() {
        this.jcalendar = new JCalendar();
        this.jcalendar.getDayChooser().addPropertyChangeListener("day", (PropertyChangeListener)this);
        this.jcalendar.getDayChooser().setAlwaysFireDayProperty(true);
        this.jcalendar.setMaxSelectableDate(new Date());
        this.popup = new JPopupMenu(){

            @Override
            public void setVisible(boolean b) {
                Boolean isCanceled = (Boolean)this.getClientProperty("JPopupMenu.firePopupMenuCanceled");
                if (b || !b && ModifyCustomerDialog.this.dateSelected || isCanceled != null && !b && isCanceled.booleanValue()) {
                    super.setVisible(b);
                }
            }
        };
        this.popup.setLightWeightPopupEnabled(true);
        this.popup.add((Component)this.jcalendar);
        this.changeListener = new ChangeListener(){
            boolean hasListened = false;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (this.hasListened) {
                    this.hasListened = false;
                    return;
                }
                if (ModifyCustomerDialog.this.popup.isVisible() && ModifyCustomerDialog.this.jcalendar.getMonthChooser().getComboBox().hasFocus()) {
                    MenuElement[] me = MenuSelectionManager.defaultManager().getSelectedPath();
                    MenuElement[] newMe = new MenuElement[me.length + 1];
                    newMe[0] = ModifyCustomerDialog.this.popup;
                    for (int i = 0; i < me.length; ++i) {
                        newMe[i + 1] = me[i];
                    }
                    this.hasListened = true;
                    MenuSelectionManager.defaultManager().setSelectedPath(newMe);
                }
            }
        };
        MenuSelectionManager.defaultManager().addChangeListener(this.changeListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("day") && this.popup.isVisible()) {
            this.dateSelected = true;
            this.popup.setVisible(false);
            if ((Integer)evt.getNewValue() > 0) {
                this.setBirthday("" + this.jcalendar.getCalendar().getTimeInMillis());
            } else {
                this.setBirthday(null);
            }
        }
    }

    private void setBirthday(String timeMills) {
        if (StringUtils.isBlank((CharSequence)timeMills)) {
            this.mBirthday = null;
            this.lblBirthday.setForeground(HintTextField.HINT_COLOR);
            this.lblBirthday.setText(I18NUtil.getString("common_not_yet_setting"));
            this.lblBirthdayCancel.setVisible(false);
        } else {
            this.mBirthday = Long.parseLong(timeMills);
            this.lblBirthday.setForeground(UIManager.getColor("Label.foreground"));
            CustomerField f1 = ApplicationCache.getInstance().schameMap.get((Object)ColumnType.CUSTOMER_BIRTHDAY);
            SimpleDateFormat sdf = new SimpleDateFormat(f1.getFormatDesc());
            Date d = new Date();
            d.setTime(this.mBirthday);
            this.lblBirthday.setText(sdf.format(d));
            this.lblBirthdayCancel.setVisible(true);
        }
    }

    private void collectInputMap() {
        this.inputMap.clear();
        for (ColumnType columnType : ColumnType.values()) {
            Object obj;
            JComponent f;
            if (columnType == ColumnType.CUSTOMER_BIRTHDAY) {
                if (this.mBirthday == null) continue;
                this.inputMap.put(columnType, String.valueOf(this.mBirthday));
                continue;
            }
            JComponent comp = this.componentMap.get((Object)columnType);
            if (comp instanceof JTextField) {
                f = (JTextField)comp;
                if (!StringUtils.isNotBlank((CharSequence)((JTextComponent)f).getText())) continue;
                this.inputMap.put(columnType, ((JTextComponent)f).getText());
                continue;
            }
            if (comp instanceof JTextArea) {
                f = (JTextArea)comp;
                if (!StringUtils.isNotBlank((CharSequence)((JTextComponent)f).getText())) continue;
                this.inputMap.put(columnType, ((JTextComponent)f).getText());
                continue;
            }
            if (!(comp instanceof JComboBox) || (obj = ((JComboBox)(f = (JComboBox)comp)).getSelectedItem()) == null || !(obj instanceof LabelType)) continue;
            LabelType t = (LabelType)obj;
            this.inputMap.put(columnType, String.valueOf(t.getType()));
        }
    }

    private void initGUI() {
        JPanel p = new JPanel();
        p.setBackground(UIConstants.COLOR_DIALOG_BACKGROUND);
        p.setBorder(BorderFactory.createEmptyBorder(15, 15, 0, 15));
        p.setLayout(new BorderLayout());
        this.getContentPane().add((Component)p, "Center");
        JScrollPane mainScrollPanel = new JScrollPane();
        Border b = BorderFactory.createLineBorder(Color.LIGHT_GRAY);
        mainScrollPanel.setBorder(b);
        mainScrollPanel.getVerticalScrollBar().setUnitIncrement(30);
        mainScrollPanel.setHorizontalScrollBarPolicy(31);
        p.add((Component)mainScrollPanel, "Center");
        this.customerFormPanel = new JPanel();
        this.customerFormPanel.setBackground(Color.WHITE);
        this.customerFormPanel.setLayout(new GridBagLayout());
        mainScrollPanel.setViewportView(this.customerFormPanel);
        this.initForm();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonPanel.setLayout(new FlowLayout(1, 5, 5));
        p.add((Component)buttonPanel, "South");
        JButton btnSubmit = new JButton();
        btnSubmit.setBackground(Color.GREEN);
        btnSubmit.setEnabled(true);
        btnSubmit.setCursor(Cursor.getPredefinedCursor(12));
        btnSubmit.setText(I18NUtil.getString("home_Btn_customer_save"));
        buttonPanel.add(btnSubmit);
        btnSubmit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifyCustomerDialog.this.handleSubmit();
            }
        });
        JButton btnClose = new JButton();
        btnClose.setCursor(Cursor.getPredefinedCursor(12));
        btnClose.setText(I18NUtil.getString("home_Btn_customer_close"));
        buttonPanel.add(btnClose);
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifyCustomerDialog.this.dispose();
            }
        });
    }

    private void initForm() {
        int y = 0;
        this.addTitle(y++, "personalCustomer.newForm.baseInfo");
        this.addTwoField(ColumnType.CUSTOMER_STRID, ColumnType.CUSTOMER_TITLE, y++, 20, 5);
        this.addTwoField(ColumnType.CUSTOMER_LASTNAME, ColumnType.CUSTOMER_GENDER, y++, 5, 5);
        this.addTwoField(ColumnType.CUSTOMER_OTHERTNAME, ColumnType.CUSTOMER_IDENTITY_NUMBER, y++, 5, 5);
        this.addTwoField(ColumnType.CUSTOMER_FIRSTNAME, ColumnType.CUSTOMER_PASSPORT_NUMBER, y++, 5, 5);
        this.addTwoField(ColumnType.CUSTOMER_BIRTHDAY, ColumnType.CUSTOMER_HOBBY, y++, 5, 5);
        this.addTwoField(ColumnType.CUSTOMER_CORPORATION, ColumnType.CUSTOMER_DEPT, y++, 5, 5);
        this.addTwoField(ColumnType.CUSTOMER_BIZ_TITLE, ColumnType.CUSTOMER_BIZ_DUTY, y++, 5, 20);
        this.addTitle(y++, "personalCustomer.newForm.customInfo");
        int cindex = 0;
        CustomerField f1 = null;
        ArrayList<CustomerField> list = ApplicationCache.getInstance().customEnableList;
        for (int cx = 0; cx < list.size(); ++cx) {
            CustomerField f = list.get(cx);
            if (f1 != null) {
                this.addTwoField(f1.getColumnType(), f.getColumnType(), y++, cindex == 0 ? 20 : 5, cx == list.size() - 1 ? 20 : 5);
                f1 = null;
                ++cindex;
                continue;
            }
            f1 = f;
        }
        if (f1 != null) {
            this.addTwoField(f1.getColumnType(), null, y++, 5, 20);
        }
        this.addTitle(y++, "personalCustomer.newForm.contactInfo");
        this.addTwoField(ColumnType.CUSTOMER_MOBILEPHONE, ColumnType.CUSTOMER_OFFICEPHONE, y++, 20, 5);
        this.addTwoField(ColumnType.CUSTOMER_HOMEPHONE, ColumnType.CUSTOMER_OTHERPHONE, y++, 5, 5);
        this.addTwoField(ColumnType.CUSTOMER_FAX, null, y++, 5, 5);
        this.addTwoField(ColumnType.CUSTOMER_EMAIL, ColumnType.CUSTOMER_OTHEREMAIL, y++, 5, 5);
        this.addTwoField(ColumnType.CUSTOMER_COMMUNICATION_TYPE_1, ColumnType.CUSTOMER_COMMUNICATION_NUMBER_1, y++, 5, 5);
        this.addTwoField(ColumnType.CUSTOMER_COMMUNICATION_TYPE_2, ColumnType.CUSTOMER_COMMUNICATION_NUMBER_2, y++, 5, 5);
        this.addTwoField(ColumnType.CUSTOMER_ASSISTANT_NAME, ColumnType.CUSTOMER_ASSISTANT_PHONE, y++, 5, 20);
        this.addTitle(y++, "personalCustomer.newForm.addressInfo");
        this.addOneField(ColumnType.CUSTOMER_ADDRESS_1, y++, 20, 5);
        this.addTwoField(ColumnType.CUSTOMER_CITY_1, ColumnType.CUSTOMER_PROVINCE_1, y++, 5, 5);
        this.addTwoField(ColumnType.CUSTOMER_COUNTRY_1, ColumnType.CUSTOMER_POST_CODE_1, y++, 5, 5);
        this.addOneField(ColumnType.CUSTOMER_ADDRESS_2, y++, 20, 5);
        this.addTwoField(ColumnType.CUSTOMER_CITY_2, ColumnType.CUSTOMER_PROVINCE_2, y++, 5, 5);
        this.addTwoField(ColumnType.CUSTOMER_COUNTRY_2, ColumnType.CUSTOMER_POST_CODE_2, y++, 5, 20);
        this.addTitle(y++, "personalCustomer.newForm.blockInfo");
        this.addTwoField(ColumnType.CUSTOMER_BLOCK_CALL, ColumnType.CUSTOMER_BLOCK_EMAIL, y++, 20, 5);
        this.addOneFieldArea(ColumnType.CUSTOMER_BLOCK_MEMO, y++, 5, 20);
        this.addTitle(y++, "personalCustomer.newForm.bizInfo");
        this.addTwoField(ColumnType.CUSTOMER_SOURCE, ColumnType.CUSTOMER_LEVEL, y++, 20, 5);
        this.addOneFieldArea(ColumnType.CUSTOMER_REMARK, y++, 5, 40);
        JPanel x2 = new JPanel();
        x2.setOpaque(false);
        this.customerFormPanel.add((Component)x2, new GridBagConstraints(0, y++, 5, 1, 1.0, 5.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void addTitle(int y, String key) {
        JPanel groupTitle = new JPanel();
        groupTitle.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        groupTitle.setLayout(new FlowLayout(0, 0, 0));
        JLabel x = new JLabel();
        x.setText(I18NUtil.getString(key));
        groupTitle.add(x);
        groupTitle.setBackground(this.titleColor);
        this.customerFormPanel.add((Component)groupTitle, new GridBagConstraints(0, y, 5, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void addTwoField(ColumnType c1, ColumnType c2, int y, int top, int bottom) {
        JPanel bLinePanel;
        LabelType type;
        DefaultComboBoxModel<LabelType> x1Model;
        LabelType target;
        JLabel title2;
        JLabel title1;
        JPanel linePanel;
        Border b = BorderFactory.createLineBorder(Color.LIGHT_GRAY);
        if (c1 != null) {
            CustomerField f1 = ApplicationCache.getInstance().schameMap.get((Object)c1);
            String v1 = this.getFieldValue(f1);
            linePanel = new JPanel();
            linePanel.setOpaque(false);
            linePanel.setLayout(new FlowLayout(2, 2, 0));
            if (f1.isMandatoryFlag()) {
                title1 = new JLabel("*");
                title1.setForeground(Color.RED);
                linePanel.add(title1);
            }
            title2 = new JLabel(f1.getName());
            linePanel.add(title2);
            this.customerFormPanel.add((Component)linePanel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(top, 50, bottom, 5), 0, 0));
            if (f1.isEnumData()) {
                target = null;
                JComboBox x1 = new JComboBox();
                x1Model = new DefaultComboBoxModel<LabelType>();
                for (CustomerFieldItem item : f1.getEnumItems()) {
                    type = new LabelType(item.getKey(), item.getName());
                    x1Model.addElement(type);
                    if (!StringUtils.isNotBlank((CharSequence)v1) || item.getKey() != Integer.parseInt(v1)) continue;
                    target = type;
                }
                x1.setModel(x1Model);
                if (target != null) {
                    x1.setSelectedItem(target);
                }
                x1.setRenderer(new LabelTypeSelectionRenderer());
                this.componentMap.put(c1, x1);
                this.customerFormPanel.add(x1, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 2, new Insets(top, 2, bottom, 25), 0, 0));
            } else if (c1 == ColumnType.CUSTOMER_BIRTHDAY) {
                bLinePanel = this.genBirthdayPanel();
                this.setBirthday(v1);
                this.customerFormPanel.add((Component)bLinePanel, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(top, 2, bottom, 25), 0, 0));
            } else {
                JTextField x1 = new JTextField(v1, 20);
                x1.setOpaque(false);
                x1.setBorder(b);
                x1.setEditable(true);
                this.componentMap.put(c1, x1);
                this.customerFormPanel.add((Component)x1, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 2, new Insets(top, 2, bottom, 25), 0, 0));
            }
        }
        if (c2 != null) {
            CustomerField f2 = ApplicationCache.getInstance().schameMap.get((Object)c2);
            String v2 = this.getFieldValue(f2);
            linePanel = new JPanel();
            linePanel.setOpaque(false);
            linePanel.setLayout(new FlowLayout(2, 2, 0));
            if (f2.isMandatoryFlag()) {
                title1 = new JLabel("*");
                title1.setForeground(Color.RED);
                linePanel.add(title1);
            }
            title2 = new JLabel(f2.getName());
            linePanel.add(title2);
            this.customerFormPanel.add((Component)linePanel, new GridBagConstraints(2, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(top, 25, bottom, 5), 0, 0));
            if (f2.isEnumData()) {
                target = null;
                JComboBox x3 = new JComboBox();
                x1Model = new DefaultComboBoxModel();
                for (CustomerFieldItem item : f2.getEnumItems()) {
                    type = new LabelType(item.getKey(), item.getName());
                    x1Model.addElement(type);
                    if (!StringUtils.isNotBlank((CharSequence)v2) || item.getKey() != Integer.parseInt(v2)) continue;
                    target = type;
                }
                x3.setModel(x1Model);
                if (target != null) {
                    x3.setSelectedItem(target);
                }
                x3.setRenderer(new LabelTypeSelectionRenderer());
                this.componentMap.put(c2, x3);
                this.customerFormPanel.add(x3, new GridBagConstraints(3, y, 1, 1, 0.0, 0.0, 17, 2, new Insets(top, 2, bottom, 25), 0, 0));
            } else if (c2 == ColumnType.CUSTOMER_BIRTHDAY) {
                bLinePanel = this.genBirthdayPanel();
                this.setBirthday(v2);
                this.customerFormPanel.add((Component)bLinePanel, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(top, 2, bottom, 25), 0, 0));
            } else {
                JTextField x3 = new JTextField(v2, 20);
                x3.setOpaque(false);
                x3.setBorder(b);
                x3.setEditable(true);
                this.componentMap.put(c2, x3);
                this.customerFormPanel.add((Component)x3, new GridBagConstraints(3, y, 1, 1, 0.0, 0.0, 17, 2, new Insets(top, 2, bottom, 25), 0, 0));
            }
        }
        JPanel x05 = new JPanel();
        x05.setOpaque(false);
        this.customerFormPanel.add((Component)x05, new GridBagConstraints(4, y, 1, 1, 1.0, 0.0, 10, 2, new Insets(top, 5, bottom, 5), 0, 0));
    }

    private JPanel genBirthdayPanel() {
        JPanel bLinePanel = new JPanel();
        bLinePanel.setOpaque(false);
        bLinePanel.setLayout(new FlowLayout(0, 5, 0));
        this.lblBirthday = new JLabel(I18NUtil.getString("common_not_yet_setting"));
        this.lblBirthday.setCursor(UIConstants.CURSOR_HAND);
        this.lblBirthday.setFont(UIConstants.FONT_12_PLAIN);
        this.lblBirthday.setForeground(HintTextField.HINT_COLOR);
        this.lblBirthday.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ModifyCustomerDialog.this.lblBirthdayMouseClicked(evt);
            }
        });
        bLinePanel.add(this.lblBirthday);
        this.lblBirthdayCancel = new JLabel(I18NUtil.getString("common_btn_delete"));
        this.lblBirthdayCancel.setVisible(false);
        this.lblBirthdayCancel.setForeground(HintTextField.HINT_COLOR);
        this.lblBirthdayCancel.setCursor(UIConstants.CURSOR_HAND);
        Font font = new Font("Microsoft YaHei", 0, 12);
        Map<TextAttribute, ?> attributes = font.getAttributes();
        attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        this.lblBirthdayCancel.setFont(font.deriveFont(attributes));
        this.lblBirthdayCancel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ModifyCustomerDialog.this.lblBirthdayCancel(evt);
            }
        });
        bLinePanel.add(this.lblBirthdayCancel);
        return bLinePanel;
    }

    private void addOneField(ColumnType c1, int y, int top, int bottom) {
        Border b = BorderFactory.createLineBorder(Color.LIGHT_GRAY);
        if (c1 != null) {
            CustomerField f1 = ApplicationCache.getInstance().schameMap.get((Object)c1);
            String v1 = this.getFieldValue(f1);
            JPanel linePanel = new JPanel();
            linePanel.setOpaque(false);
            linePanel.setLayout(new FlowLayout(2, 2, 0));
            if (f1.isMandatoryFlag()) {
                JLabel title1 = new JLabel("*");
                title1.setForeground(Color.RED);
                linePanel.add(title1);
            }
            JLabel title2 = new JLabel(f1.getName());
            linePanel.add(title2);
            this.customerFormPanel.add((Component)linePanel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(top, 50, bottom, 5), 0, 0));
            if (f1.isEnumData()) {
                LabelType target = null;
                JComboBox x1 = new JComboBox();
                DefaultComboBoxModel<LabelType> x1Model = new DefaultComboBoxModel<LabelType>();
                for (CustomerFieldItem item : f1.getEnumItems()) {
                    LabelType type = new LabelType(item.getKey(), item.getName());
                    x1Model.addElement(type);
                    if (!StringUtils.isNotBlank((CharSequence)v1) || item.getKey() != Integer.parseInt(v1)) continue;
                    target = type;
                }
                x1.setModel(x1Model);
                if (target != null) {
                    x1.setSelectedItem(target);
                }
                x1.setRenderer(new LabelTypeSelectionRenderer());
                this.componentMap.put(c1, x1);
                this.customerFormPanel.add(x1, new GridBagConstraints(1, y, 3, 1, 0.0, 0.0, 17, 2, new Insets(top, 2, bottom, 25), 0, 0));
            } else if (c1 == ColumnType.CUSTOMER_BIRTHDAY) {
                JPanel bLinePanel = this.genBirthdayPanel();
                this.setBirthday(v1);
                this.customerFormPanel.add((Component)bLinePanel, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(top, 2, bottom, 25), 0, 0));
            } else {
                JTextField x1 = new JTextField(v1, 20);
                x1.setOpaque(false);
                x1.setBorder(b);
                x1.setEditable(true);
                this.componentMap.put(c1, x1);
                this.customerFormPanel.add((Component)x1, new GridBagConstraints(1, y, 3, 1, 0.0, 0.0, 17, 2, new Insets(top, 2, bottom, 25), 0, 0));
            }
        }
        JPanel x05 = new JPanel();
        x05.setOpaque(false);
        this.customerFormPanel.add((Component)x05, new GridBagConstraints(4, y, 1, 1, 1.0, 0.0, 10, 2, new Insets(top, 5, bottom, 5), 0, 0));
    }

    private void addOneFieldArea(ColumnType c1, int y, int top, int bottom) {
        Border b = BorderFactory.createLineBorder(Color.LIGHT_GRAY);
        if (c1 != null) {
            CustomerField f1 = ApplicationCache.getInstance().schameMap.get((Object)c1);
            String v1 = this.getFieldValue(f1);
            JPanel linePanel = new JPanel();
            linePanel.setOpaque(false);
            linePanel.setLayout(new FlowLayout(2, 2, 0));
            if (f1.isMandatoryFlag()) {
                JLabel title1 = new JLabel("*");
                title1.setForeground(Color.RED);
                linePanel.add(title1);
            }
            JLabel title2 = new JLabel(f1.getName());
            linePanel.add(title2);
            this.customerFormPanel.add((Component)linePanel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(top, 50, bottom, 5), 0, 0));
            JTextArea x1 = new JTextArea(v1, 4, 50);
            x1.setBorder(b);
            x1.setOpaque(false);
            x1.setEditable(true);
            this.componentMap.put(c1, x1);
            this.customerFormPanel.add((Component)x1, new GridBagConstraints(1, y, 3, 1, 0.0, 0.0, 17, 2, new Insets(top, 2, bottom, 25), 0, 0));
        }
        JPanel x05 = new JPanel();
        x05.setOpaque(false);
        this.customerFormPanel.add((Component)x05, new GridBagConstraints(4, y, 1, 1, 1.0, 0.0, 10, 2, new Insets(top, 5, bottom, 5), 0, 0));
    }

    private String getFieldValue(CustomerField f) {
        if (!f.isEnabled()) {
            return "";
        }
        String inputData = this.inputMap.get((Object)f.getColumnType());
        if (inputData != null) {
            return inputData;
        }
        return "";
    }

    @Override
    protected void onESCPressed() {
        this.dispose();
    }

    public void handleSubmit() {
        ColumnType customType;
        int i;
        this.collectInputMap();
        String value = this.inputMap.get((Object)ColumnType.CUSTOMER_STRID);
        if (StringUtils.isBlank((CharSequence)value)) {
            String msg = String.format(I18NUtil.getString("validation.somthingEmptyNotAllowed"), "strId");
            CustomerField strIdField = ApplicationCache.getInstance().schameMap.get((Object)ColumnType.CUSTOMER_STRID);
            if (strIdField != null) {
                msg = String.format(I18NUtil.getString("validation.somthingEmptyNotAllowed"), strIdField.getName());
            }
            JOptionPane.showMessageDialog(this, msg, I18NUtil.getString("common_message"), 0);
            JComponent comp = this.componentMap.get((Object)ColumnType.CUSTOMER_STRID);
            if (comp != null) {
                comp.requestFocus();
            }
            return;
        }
        String lastNameValue = this.inputMap.get((Object)ColumnType.CUSTOMER_LASTNAME);
        if (StringUtils.isBlank((CharSequence)lastNameValue)) {
            String msg = String.format(I18NUtil.getString("validation.somthingEmptyNotAllowed"), "lastName");
            CustomerField lastNameField = ApplicationCache.getInstance().schameMap.get((Object)ColumnType.CUSTOMER_LASTNAME);
            if (lastNameField != null) {
                msg = String.format(I18NUtil.getString("validation.somthingEmptyNotAllowed"), lastNameField.getName());
            }
            JOptionPane.showMessageDialog(this, msg, I18NUtil.getString("common_message"), 0);
            JComponent comp = this.componentMap.get((Object)ColumnType.CUSTOMER_LASTNAME);
            if (comp != null) {
                comp.requestFocus();
            }
            return;
        }
        for (i = 101; i <= 130; ++i) {
            customType = ColumnType.getValue(i);
            String cValue = this.inputMap.get((Object)customType);
            CustomerField cField = ApplicationCache.getInstance().schameMap.get((Object)customType);
            if (cField == null || !cField.isEnabled() || !cField.isMandatoryFlag()) continue;
            boolean valdationOK = true;
            if (cField.isEnumData()) {
                if (StringUtils.isBlank((CharSequence)cValue) || cValue.equals("-1")) {
                    valdationOK = false;
                }
            } else if (StringUtils.isBlank((CharSequence)cValue)) {
                valdationOK = false;
            }
            if (valdationOK) continue;
            String msg = String.format(I18NUtil.getString("validation.somthingEmptyNotAllowed"), cField.getName());
            JOptionPane.showMessageDialog(this, msg, I18NUtil.getString("common_message"), 0);
            JComponent comp = this.componentMap.get((Object)customType);
            if (comp != null) {
                comp.requestFocus();
            }
            return;
        }
        for (i = 1; i <= 130; ++i) {
            String cValue;
            CustomerField cField;
            customType = ColumnType.getValue(i);
            if (customType == null || (cField = ApplicationCache.getInstance().schameMap.get((Object)customType)) == null || !cField.isEnabled() || cField.getDataType() != FieldDataType.INT || !StringUtils.isNotBlank((CharSequence)(cValue = this.inputMap.get((Object)customType)))) continue;
            if (!NumberUtils.isNumber((String)cValue)) {
                String msg = String.format(I18NUtil.getString("validation.somethingMustBeNumber"), cField.getName());
                JOptionPane.showMessageDialog(this, msg, I18NUtil.getString("common_message"), 0);
                JComponent comp = this.componentMap.get((Object)customType);
                if (comp != null) {
                    comp.requestFocus();
                }
                return;
            }
            try {
                Integer msg = Integer.parseInt(cValue);
                continue;
            }
            catch (Throwable t) {
                String msg = String.format(I18NUtil.getString("validation.somethingNotInIntRange"), cField.getName());
                JOptionPane.showMessageDialog(this, msg, I18NUtil.getString("common_message"), 0);
                JComponent comp = this.componentMap.get((Object)customType);
                if (comp != null) {
                    comp.requestFocus();
                }
                return;
            }
        }
        WebAgent.getInstance().modifyNewPersonalCustomer(this.customerId, this.inputMap, this.mUuid);
    }

    public void showDialog() {
        this.setVisible(true);
    }

    public void onModifyFailed(Intent intent) {
        String returnInfo = intent.getStringExtra("returnInfo");
        JOptionPane.showMessageDialog(this, returnInfo, I18NUtil.getString("common_message"), 0);
    }
}

