/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.customer;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.cc.Application;
import com.blisscloud.ezuc.client.cc.ApplicationCache;
import com.blisscloud.ezuc.client.component.RoundedCornerPanel;
import com.blisscloud.ezuc.client.customer.BizPanel;
import com.blisscloud.ezuc.client.customer.ColumnType;
import com.blisscloud.ezuc.client.customer.CustomerField;
import com.blisscloud.ezuc.client.customer.CustomerFieldItem;
import com.blisscloud.ezuc.client.customer.CustomerNameUtil;
import com.blisscloud.ezuc.client.customer.HomeTabPanel;
import com.blisscloud.ezuc.client.customer.ModifyCustomerDialog;
import com.blisscloud.ezuc.client.customer.NewCustomerDialog;
import com.blisscloud.ezuc.client.customer.PhoneAttPanel;
import com.blisscloud.ezuc.client.customer.PhoneBizSummaryPanel;
import com.blisscloud.ezuc.client.customer.PhoneCustomerHistoryPanel;
import com.blisscloud.ezuc.client.customer.PhoneCustomerPanel;
import com.blisscloud.ezuc.client.customer.SearchCustomerDialog;
import com.blisscloud.ezuc.client.customer.SpacedTabbedPaneUI;
import com.blisscloud.ezuc.client.main.MainPanel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Bundle;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.AttachDataBean;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class PhoneBizPanel
extends JPanel
implements BizPanel {
    private String dialoutUuid = UUID.randomUUID().toString();
    private Application mApp;
    private AttachDataBean mCallDataBean;
    private HomeTabPanel mTabPanel;
    private PhoneBizSummaryPanel summaryPanel;
    private PhoneCustomerPanel customerPanel;
    private PhoneCustomerHistoryPanel customerHistoryPanel;
    private PhoneAttPanel attPanel;
    private BroadcastReceiver receiver;
    private SimpleDateFormat timeformatter = new SimpleDateFormat("HH:mm:ss");
    private JPanel data0Panel;
    private JLabel noteLabel;
    private JPanel spacePanel;
    private JPanel dataPanel;
    private JLabel editAction;
    private JLabel searchAction;
    private JLabel createNewAction;
    private JLabel cleanCustomerAction;
    private SearchCustomerDialog searchCustomerDialog;
    private NewCustomerDialog newCustomerDialog;
    private ModifyCustomerDialog modifyCustomerDialog;
    private Timer autoLoginTimer = new Timer("PhoneBizPanelAutoLoginTimer");

    public PhoneBizPanel(HomeTabPanel tabPanel, Application app, AttachDataBean callDataBean) {
        super(new BorderLayout());
        this.mTabPanel = tabPanel;
        this.mApp = app;
        this.mCallDataBean = callDataBean;
        this.initGUI();
        this.receiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                try {
                    String action = intent.getAction();
                    Bundle bundle = intent.getExtras();
                    if ("ezuc.intent.action.event.CALL_SUMMARY_UPDATE".equals(action)) {
                        String[] submitCallList;
                        if (PhoneBizPanel.this.mCallDataBean == null) {
                            return;
                        }
                        for (String submitCallId : submitCallList = bundle.getStringArray("callList")) {
                            String callId = PhoneBizPanel.this.mCallDataBean.getCallId();
                            if (callId == null || !callId.equals(submitCallId)) continue;
                            PhoneBizPanel.this.mCallDataBean.addSubmitCount();
                            PhoneBizPanel.this.handleSubmitAfterwork();
                        }
                    } else if ("ezuc.intent.action.event.CUSTOMER_STR_ID_FETCHED".equals(action)) {
                        if (PhoneBizPanel.this.mCallDataBean == null) {
                            return;
                        }
                        String uuid = intent.getStringExtra("uuid");
                        if (PhoneBizPanel.this.dialoutUuid != null && PhoneBizPanel.this.dialoutUuid.equals(uuid)) {
                            String strId = intent.getStringExtra("strId");
                            PhoneBizPanel.this.openNewFormDialog(strId);
                        }
                    } else if ("ezuc.intent.action.event.CUSTOMER_SCHEMA_LIST_UPDATE".equals(action)) {
                        if (PhoneBizPanel.this.newCustomerDialog != null) {
                            PhoneBizPanel.this.newCustomerDialog.refresh();
                        }
                        if (PhoneBizPanel.this.modifyCustomerDialog != null) {
                            PhoneBizPanel.this.modifyCustomerDialog.refresh();
                        }
                        PhoneBizPanel.this.fetchData();
                    } else if ("ezuc.intent.action.event.SAVE_CUSTOMER_DONE".equals(action)) {
                        JSONObject customer;
                        boolean fill;
                        String uuidIdTemp = intent.getStringExtra("uuid");
                        if (!PhoneBizPanel.this.dialoutUuid.equals(uuidIdTemp)) {
                            return;
                        }
                        if (PhoneBizPanel.this.newCustomerDialog != null) {
                            PhoneBizPanel.this.newCustomerDialog.dispose();
                        }
                        if (!(fill = intent.getBooleanExtra("fill", true))) {
                            return;
                        }
                        if (PhoneBizPanel.this.mCallDataBean != null && (customer = intent.getJSONObjectExtra("customer")) != null) {
                            PhoneBizPanel.this.mCallDataBean.updateCustomer(customer);
                            PhoneBizPanel.this.handleCustomerDetail(PhoneBizPanel.this.mCallDataBean.getCustomerId());
                        }
                        PhoneBizPanel.this.fetchData();
                        PhoneBizPanel.this.determineCustomer();
                    } else if ("ezuc.intent.action.event.SAVE_CUSTOMER_FAILED".equals(action)) {
                        String uuidIdTemp = intent.getStringExtra("uuid");
                        if (!PhoneBizPanel.this.dialoutUuid.equals(uuidIdTemp)) {
                            return;
                        }
                        if (PhoneBizPanel.this.newCustomerDialog != null) {
                            PhoneBizPanel.this.newCustomerDialog.onSaveFailed(intent);
                        }
                    } else if ("ezuc.intent.action.event.MODIFY_CUSTOMER_DONE".equals(action)) {
                        JSONObject customer;
                        String uuidIdTemp = intent.getStringExtra("uuid");
                        if (!PhoneBizPanel.this.dialoutUuid.equals(uuidIdTemp)) {
                            return;
                        }
                        if (PhoneBizPanel.this.mCallDataBean != null && (customer = intent.getJSONObjectExtra("customer")) != null) {
                            PhoneBizPanel.this.mCallDataBean.updateCustomer(customer);
                            PhoneBizPanel.this.handleCustomerDetail(PhoneBizPanel.this.mCallDataBean.getCustomerId());
                        }
                        if (PhoneBizPanel.this.modifyCustomerDialog != null) {
                            PhoneBizPanel.this.modifyCustomerDialog.dispose();
                        }
                        PhoneBizPanel.this.fetchData();
                        PhoneBizPanel.this.determineCustomer();
                    } else if ("ezuc.intent.action.event.MODIFY_CUSTOMER_FAILED".equals(action)) {
                        String uuidIdTemp = intent.getStringExtra("uuid");
                        if (!PhoneBizPanel.this.dialoutUuid.equals(uuidIdTemp)) {
                            return;
                        }
                        if (PhoneBizPanel.this.modifyCustomerDialog != null) {
                            PhoneBizPanel.this.modifyCustomerDialog.onModifyFailed(intent);
                        }
                    } else if ("ezuc.intent.action.event.SEARCH_CUSTOMER_RESULT".equals(action)) {
                        String uuidIdTemp = intent.getStringExtra("uuid");
                        if (!PhoneBizPanel.this.dialoutUuid.equals(uuidIdTemp)) {
                            return;
                        }
                        if (PhoneBizPanel.this.searchCustomerDialog == null || !PhoneBizPanel.this.searchCustomerDialog.isVisible()) {
                            return;
                        }
                        JSONObject resultObj = intent.getJSONObjectExtra("result");
                        if (resultObj != null) {
                            JSONArray customerAry = resultObj.getJSONArray("customerList");
                            PhoneBizPanel.this.searchCustomerDialog.updateCustomerList(customerAry);
                        }
                    } else if ("ezuc.intent.action.event.DETERMINE_CUSTOMER".equals(action)) {
                        JSONObject customer;
                        String uuidIdTemp = intent.getStringExtra("uuid");
                        if (!PhoneBizPanel.this.dialoutUuid.equals(uuidIdTemp)) {
                            return;
                        }
                        if (PhoneBizPanel.this.mCallDataBean != null && (customer = intent.getJSONObjectExtra("customer")) != null) {
                            PhoneBizPanel.this.mCallDataBean.determineCustomer(customer);
                        }
                        PhoneBizPanel.this.fetchData(false);
                        PhoneBizPanel.this.determineCustomer();
                    } else if ("ezuc.intent.action.event.FIND_CUSTOMER_CONTACT_HISTORY_RESULT".equals(action)) {
                        String uuidIdTemp = intent.getStringExtra("uuid");
                        if (!PhoneBizPanel.this.dialoutUuid.equals(uuidIdTemp)) {
                            return;
                        }
                        JSONObject resultObj = intent.getJSONObjectExtra("result");
                        if (resultObj != null) {
                            JSONArray customerAry = resultObj.getJSONArray("contactRecords");
                            PhoneBizPanel.this.customerHistoryPanel.updateContactHistoryList(customerAry);
                        }
                    } else if ("ezuc.intent.action.event.CUSTOMER_INFO_CHANGED".equals(action)) {
                        JSONObject resultObj = intent.getJSONObjectExtra("customer");
                        if (PhoneBizPanel.this.mCallDataBean != null && PhoneBizPanel.this.mCallDataBean.getCustomerId() != null && resultObj.has("id") && PhoneBizPanel.this.mCallDataBean.getCustomerId().longValue() == resultObj.getLong("id")) {
                            String agentName = intent.getStringExtra("agentName");
                            JSONObject customer = intent.getJSONObjectExtra("customer");
                            PhoneBizPanel.this.mCallDataBean.updateCustomerInfo(agentName, customer);
                            PhoneBizPanel.this.fetchData();
                        }
                    } else if ("ezuc.intent.action.event.CONTACT_RECORD_CHANGED".equals(action)) {
                        Long customerIdTemp;
                        JSONObject contactRecordObj = intent.getJSONObjectExtra("contactRecord");
                        String callId = contactRecordObj.getString("uniqueId");
                        if (PhoneBizPanel.this.mCallDataBean == null || !PhoneBizPanel.this.mCallDataBean.isCallId(callId)) {
                            return;
                        }
                        Long customerId = null;
                        if (contactRecordObj.has("customerId") && (customerIdTemp = Long.valueOf(contactRecordObj.getLong("customerId"))) > 0L) {
                            customerId = customerIdTemp;
                        }
                        if (customerId == null && PhoneBizPanel.this.mCallDataBean.getCustomerId() != null) {
                            if (PhoneBizPanel.this.mCallDataBean != null) {
                                PhoneBizPanel.this.mCallDataBean.cleanCustomer();
                            }
                            if (PhoneBizPanel.this.customerHistoryPanel != null) {
                                PhoneBizPanel.this.customerHistoryPanel.updateContactHistoryList(new JSONArray());
                            }
                            PhoneBizPanel.this.fetchData();
                        } else if (customerId != null) {
                            boolean doUpdate = false;
                            if (PhoneBizPanel.this.mCallDataBean.getCustomerId() == null) {
                                doUpdate = true;
                            } else if (customerId.longValue() != PhoneBizPanel.this.mCallDataBean.getCustomerId().longValue()) {
                                doUpdate = true;
                            }
                            if (doUpdate) {
                                WebAgent.getInstance().targetPersonalCustomer(customerId, PhoneBizPanel.this.dialoutUuid);
                            }
                        }
                    } else if ("ezuc.intent.action.event.TARGET_CUSTOMER_DONE".equals(action)) {
                        JSONObject customer;
                        String uuidIdTemp = intent.getStringExtra("uuid");
                        if (!PhoneBizPanel.this.dialoutUuid.equals(uuidIdTemp)) {
                            return;
                        }
                        if (PhoneBizPanel.this.mCallDataBean != null && (customer = intent.getJSONObjectExtra("customer")) != null) {
                            PhoneBizPanel.this.mCallDataBean.updateCustomer(customer);
                            PhoneBizPanel.this.handleCustomerDetail(PhoneBizPanel.this.mCallDataBean.getCustomerId());
                        }
                        PhoneBizPanel.this.fetchData();
                    }
                }
                catch (Throwable t) {
                    Log.e(MainPanel.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
                }
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction("ezuc.intent.action.event.CALL_SUMMARY_UPDATE");
        filter.addAction("ezuc.intent.action.event.CUSTOMER_STR_ID_FETCHED");
        filter.addAction("ezuc.intent.action.event.CUSTOMER_SCHEMA_LIST_UPDATE");
        filter.addAction("ezuc.intent.action.event.SAVE_CUSTOMER_DONE");
        filter.addAction("ezuc.intent.action.event.SAVE_CUSTOMER_FAILED");
        filter.addAction("ezuc.intent.action.event.MODIFY_CUSTOMER_DONE");
        filter.addAction("ezuc.intent.action.event.MODIFY_CUSTOMER_FAILED");
        filter.addAction("ezuc.intent.action.event.SEARCH_CUSTOMER_RESULT");
        filter.addAction("ezuc.intent.action.event.DETERMINE_CUSTOMER");
        filter.addAction("ezuc.intent.action.event.FIND_CUSTOMER_CONTACT_HISTORY_RESULT");
        filter.addAction("ezuc.intent.action.event.CUSTOMER_INFO_CHANGED");
        filter.addAction("ezuc.intent.action.event.CONTACT_RECORD_CHANGED");
        filter.addAction("ezuc.intent.action.event.TARGET_CUSTOMER_DONE");
        UCChatClient.context.registerReceiver(this.receiver, filter);
        this.fetchData(true);
    }

    private void openCustomerSearchDialog() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PhoneBizPanel.this.searchCustomerDialog != null && PhoneBizPanel.this.searchCustomerDialog.isVisible()) {
                    PhoneBizPanel.this.searchCustomerDialog.dispose();
                }
                PhoneBizPanel.this.searchCustomerDialog = new SearchCustomerDialog(UCChatClient.getInstance(), PhoneBizPanel.this.mCallDataBean, PhoneBizPanel.this.dialoutUuid);
                PhoneBizPanel.this.searchCustomerDialog.setLocationRelativeTo(PhoneBizPanel.this);
                PhoneBizPanel.this.searchCustomerDialog.showDialog();
            }
        });
    }

    private void doNewFormDialog() {
        if (ApplicationCache.getInstance().codeAutoEnabled) {
            WebAgent.getInstance().fetchNewCustomerStrId(this.dialoutUuid);
        } else {
            this.openNewFormDialog(null);
        }
    }

    private void openNewFormDialog(final String strId) {
        String phoneNumber = null;
        String direction = this.mCallDataBean.getDirection();
        if (StringUtils.isNotBlank((CharSequence)direction)) {
            phoneNumber = "INBOUND".equals(direction) ? this.mCallDataBean.getAni() : this.mCallDataBean.getDnis();
        }
        final String customerNumber = phoneNumber;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PhoneBizPanel.this.newCustomerDialog = new NewCustomerDialog(UCChatClient.getInstance(), strId, customerNumber, PhoneBizPanel.this.dialoutUuid, false);
                PhoneBizPanel.this.newCustomerDialog.setLocationRelativeTo(PhoneBizPanel.this);
                PhoneBizPanel.this.newCustomerDialog.showDialog();
            }
        });
    }

    private void openModifyFormDialog() {
        if (this.mCallDataBean == null) {
            return;
        }
        if (this.mCallDataBean.getCustomerDetail() == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PhoneBizPanel.this.modifyCustomerDialog = new ModifyCustomerDialog(UCChatClient.getInstance(), PhoneBizPanel.this.dialoutUuid, PhoneBizPanel.this.mCallDataBean.getCustomerDetail(), false);
                PhoneBizPanel.this.modifyCustomerDialog.setLocationRelativeTo(PhoneBizPanel.this);
                PhoneBizPanel.this.modifyCustomerDialog.showDialog();
            }
        });
    }

    private void handleSubmitAfterwork() {
        JOptionPane.showMessageDialog(this, I18NUtil.getString("save_summary_contact_done"), I18NUtil.getString("common_message"), 1);
        if (PreferencesUtil.getAutoReadyOption() == 2) {
            MainPanel mainPanel = UCChatClient.getInstance().getMainPanel();
            mainPanel.startAutoLoginTimer(1L);
        }
        this.mTabPanel.removeComp(this);
    }

    private void fetchData() {
        this.fetchData(false);
    }

    private void fetchData(boolean autoOpenMatched) {
        if (this.customerPanel != null) {
            this.customerPanel.refreash();
        }
        if (this.attPanel != null) {
            this.attPanel.refresh();
        }
        try {
            JSONObject customerDetail = this.mCallDataBean != null ? this.mCallDataBean.getCustomerDetail() : null;
            Object customerName = "";
            String customerNo = "";
            if (customerDetail != null) {
                Integer title = null;
                String lastName = null;
                String otherName = null;
                String firstName = null;
                if (customerDetail.has("title")) {
                    title = customerDetail.getInt("title");
                }
                if (customerDetail.has("lastName")) {
                    lastName = customerDetail.getString("lastName");
                }
                if (customerDetail.has("otherName")) {
                    otherName = customerDetail.getString("otherName");
                }
                if (customerDetail.has("firstName")) {
                    firstName = customerDetail.getString("firstName");
                }
                customerName = CustomerNameUtil.getCustomerName(title, lastName, otherName, firstName, true);
                if (customerDetail.has("level")) {
                    CustomerField field = ApplicationCache.getInstance().schameMap.get((Object)ColumnType.CUSTOMER_LEVEL);
                    int level = customerDetail.getInt("level");
                    CustomerFieldItem itemx = field.getEnumMap().get(level);
                    if (itemx != null) {
                        customerName = (String)customerName + " [" + itemx.getName() + "]";
                    }
                }
                if (customerDetail.has("strId")) {
                    customerNo = customerDetail.getString("strId");
                }
            } else if (this.mCallDataBean != null && StringUtils.isNotBlank((CharSequence)this.mCallDataBean.getCampReqName())) {
                customerName = this.buildCampaignCustomerName(this.mCallDataBean, 100);
            }
            this.data0Panel.removeAll();
            this.data0Panel.setVisible(true);
            this.spacePanel.setVisible(false);
            this.dataPanel.removeAll();
            this.dataPanel.setVisible(false);
            this.noteLabel.setVisible(false);
            this.cleanCustomerAction.setVisible(false);
            this.editAction.setVisible(false);
            this.createNewAction.setVisible(false);
            this.searchAction.setVisible(false);
            if (this.mCallDataBean == null) {
                clabel = new JLabel();
                clabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
                clabel.setText(I18NUtil.getString("home_biz_customer_label"));
                this.data0Panel.add(clabel);
            } else {
                this.handleCustomerDetail(this.mCallDataBean.getCustomerId());
                if (this.mCallDataBean.getCustomerDetail() != null) {
                    this.editAction.setVisible(true);
                    this.cleanCustomerAction.setVisible(true);
                } else {
                    this.editAction.setVisible(false);
                    this.cleanCustomerAction.setVisible(false);
                }
                this.searchAction.setVisible(true);
                this.createNewAction.setVisible(true);
                if (this.mCallDataBean.getCsize() > 1) {
                    if ("ANI".equals(this.mCallDataBean.getMatchType())) {
                        this.noteLabel.setText(" [" + String.format(I18NUtil.getString("home_biz_message_match_multple_ani"), this.mCallDataBean.getCsize()) + "]");
                    } else if ("DNIS".equals(this.mCallDataBean.getMatchType())) {
                        this.noteLabel.setText(" [" + String.format(I18NUtil.getString("home_biz_message_match_multple_dnis"), this.mCallDataBean.getCsize()) + "]");
                    } else if ("IDENTITY".equals(this.mCallDataBean.getMatchType())) {
                        this.noteLabel.setText(" [" + String.format(I18NUtil.getString("home_biz_message_match_multple_identity"), this.mCallDataBean.getCsize()) + "]");
                    } else if ("CNO".equals(this.mCallDataBean.getMatchType())) {
                        this.noteLabel.setText(" [" + String.format(I18NUtil.getString("home_biz_message_match_multple_cno"), this.mCallDataBean.getCsize()) + "]");
                    }
                    this.noteLabel.setVisible(true);
                    if (autoOpenMatched) {
                        new Timer().schedule(new TimerTask(){

                            @Override
                            public void run() {
                                SwingUtilities.invokeLater(() -> PhoneBizPanel.this.openCustomerSearchDialog());
                            }
                        }, 800L);
                    }
                }
                clabel = new JLabel();
                clabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
                clabel.setText(I18NUtil.getString("home_biz_customer_label") + (String)customerName);
                this.data0Panel.add(clabel);
                if (StringUtils.isNotBlank((CharSequence)customerNo)) {
                    JLabel c1label = new JLabel();
                    c1label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
                    c1label.setText(I18NUtil.getString("home_biz_no_label") + customerNo);
                    this.data0Panel.add(c1label);
                }
                if (this.mCallDataBean.isHasAttData()) {
                    String menuRuleInfo;
                    String inboundRuleInfo;
                    String dnis;
                    String ani;
                    String direction;
                    this.spacePanel.setVisible(true);
                    this.dataPanel.setVisible(true);
                    Long startTime = this.mCallDataBean.getStartTime();
                    if (startTime != null) {
                        JLabel label = new JLabel();
                        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
                        Date d = new Date();
                        d.setTime(startTime);
                        label.setText(I18NUtil.getString("attachdata.startTime") + this.timeformatter.format(d));
                        this.dataPanel.add(label);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(direction = this.mCallDataBean.getDirection()))) {
                        JLabel label = new JLabel();
                        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
                        if ("INBOUND".equals(direction)) {
                            label.setText(I18NUtil.getString("attachdata.direction") + I18NUtil.getString("attachdata.direction.inbound"));
                        } else {
                            label.setText(I18NUtil.getString("attachdata.direction") + I18NUtil.getString("attachdata.direction.outbound"));
                        }
                        this.dataPanel.add(label);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(ani = this.mCallDataBean.getAni()))) {
                        JLabel label = new JLabel();
                        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
                        label.setText(I18NUtil.getString("attachdata.ani") + ani);
                        this.dataPanel.add(label);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(dnis = this.mCallDataBean.getDnis()))) {
                        JLabel label = new JLabel();
                        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
                        label.setText(I18NUtil.getString("attachdata.dnis") + dnis);
                        this.dataPanel.add(label);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(inboundRuleInfo = this.mCallDataBean.getInboundRuleInfo()))) {
                        JLabel label = new JLabel();
                        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
                        label.setText(I18NUtil.getString("attachdata.inbound_rule_info") + inboundRuleInfo);
                        this.dataPanel.add(label);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(menuRuleInfo = this.mCallDataBean.getMenuRuleInfo()))) {
                        JLabel label = new JLabel();
                        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
                        label.setText(I18NUtil.getString("attachdata.menu_rule_info") + menuRuleInfo);
                        this.dataPanel.add(label);
                    }
                }
            }
        }
        catch (Throwable t) {
            Log.e(PhoneBizPanel.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
        }
    }

    private String buildCampaignCustomerName(AttachDataBean bean, int maxDisplayLen) {
        if (bean == null) {
            return "";
        }
        String base = StringUtils.defaultString((String)StringUtils.trimToEmpty((String)bean.getCampReqName()));
        List<String> extras = Stream.of(bean.getCampReqInfo1()).filter(StringUtils::isNotBlank).map(StringUtils::trim).map(s -> s.replace("[", "").replace("]", "")).toList();
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)base)) {
            sb.append(base);
            if (!extras.isEmpty()) {
                sb.append("  ");
            }
        }
        for (String ex : extras) {
            sb.append('[').append(ex).append(']');
        }
        String full = sb.toString();
        if (maxDisplayLen > 0 && full.length() > maxDisplayLen) {
            return full.substring(0, Math.max(0, maxDisplayLen - 1)) + "\u2026";
        }
        return full;
    }

    private void handleCustomerDetail(Long customerId) {
        if (customerId == null || customerId == 0L) {
            return;
        }
        WebAgent.getInstance().findCustomerContactHistory(customerId, this.dialoutUuid);
    }

    public static boolean containsHanScript(String s) {
        int codepoint;
        for (int i = 0; i < s.length(); i += Character.charCount(codepoint)) {
            codepoint = s.codePointAt(i);
            if (Character.UnicodeScript.of(codepoint) != Character.UnicodeScript.HAN) continue;
            return true;
        }
        return false;
    }

    private void initGUI() {
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        int y = 0;
        RoundedCornerPanel upperPanel = new RoundedCornerPanel(6);
        upperPanel.setLayout(new GridBagLayout());
        this.add((Component)upperPanel, "North");
        this.data0Panel = new JPanel();
        this.data0Panel.setVisible(false);
        this.data0Panel.setLayout(new FlowLayout(0, 0, 0));
        upperPanel.add((Component)this.data0Panel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 2), 0, 0));
        this.noteLabel = new JLabel();
        this.noteLabel.setForeground(Color.red);
        this.noteLabel.setVisible(false);
        upperPanel.add((Component)this.noteLabel, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 2), 0, 0));
        this.noteLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.noteLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PhoneBizPanel.this.mCallDataBean == null) {
                    return;
                }
                if (PhoneBizPanel.this.searchCustomerDialog != null && PhoneBizPanel.this.searchCustomerDialog.isVisible()) {
                    return;
                }
                PhoneBizPanel.this.openCustomerSearchDialog();
            }
        });
        this.spacePanel = new JPanel();
        this.spacePanel.setVisible(false);
        upperPanel.add((Component)this.spacePanel, new GridBagConstraints(0, y++, 2, 1, 1.0, 0.0, 13, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.dataPanel = new JPanel();
        this.dataPanel.setVisible(false);
        this.dataPanel.setLayout(new FlowLayout(0, 0, 0));
        upperPanel.add((Component)this.dataPanel, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 2), 0, 0));
        JPanel actionPanel = new JPanel();
        actionPanel.setLayout(new FlowLayout(2, 0, 0));
        upperPanel.add((Component)actionPanel, new GridBagConstraints(1, 0, 2, y + 1, 1.0, 0.0, 13, 1, new Insets(5, 2, 5, 5), 0, 0));
        this.cleanCustomerAction = new JLabel();
        this.cleanCustomerAction.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 2));
        this.cleanCustomerAction.setIcon(UIConstants.USER_CLEAN);
        this.cleanCustomerAction.setText(I18NUtil.getString("home_btn_customer_clean"));
        this.cleanCustomerAction.setCursor(Cursor.getPredefinedCursor(12));
        this.cleanCustomerAction.setIconTextGap(1);
        this.cleanCustomerAction.setVisible(false);
        actionPanel.add(this.cleanCustomerAction);
        this.cleanCustomerAction.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PhoneBizPanel.this.mCallDataBean == null) {
                    return;
                }
                int result = JOptionPane.showConfirmDialog(PhoneBizPanel.this, I18NUtil.getString("home_biz_message_clean_assiciation_confirm"), I18NUtil.getString("common_title_warning"), 2, 2);
                if (result == 0) {
                    PhoneBizPanel.this.disassociateCustomer();
                    if (PhoneBizPanel.this.mCallDataBean != null) {
                        PhoneBizPanel.this.mCallDataBean.cleanCustomer();
                    }
                    if (PhoneBizPanel.this.customerHistoryPanel != null) {
                        PhoneBizPanel.this.customerHistoryPanel.updateContactHistoryList(new JSONArray());
                    }
                    PhoneBizPanel.this.fetchData();
                }
            }
        });
        this.searchAction = new JLabel();
        this.searchAction.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 2));
        this.searchAction.setIcon(UIConstants.USER_SEARCH);
        this.searchAction.setText(I18NUtil.getString("home_btn_customer_search"));
        this.searchAction.setCursor(Cursor.getPredefinedCursor(12));
        this.searchAction.setIconTextGap(1);
        this.searchAction.setVisible(false);
        actionPanel.add(this.searchAction);
        this.searchAction.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PhoneBizPanel.this.mCallDataBean == null) {
                    return;
                }
                if (PhoneBizPanel.this.searchCustomerDialog != null && PhoneBizPanel.this.searchCustomerDialog.isVisible()) {
                    return;
                }
                PhoneBizPanel.this.openCustomerSearchDialog();
            }
        });
        this.editAction = new JLabel();
        this.editAction.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 2));
        this.editAction.setIcon(UIConstants.USER_EDIT);
        this.editAction.setText(I18NUtil.getString("home_btn_customer_edit"));
        this.editAction.setCursor(Cursor.getPredefinedCursor(12));
        this.editAction.setIconTextGap(1);
        this.editAction.setVisible(false);
        actionPanel.add(this.editAction);
        this.editAction.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PhoneBizPanel.this.mCallDataBean == null) {
                    return;
                }
                if (PhoneBizPanel.this.modifyCustomerDialog != null && PhoneBizPanel.this.modifyCustomerDialog.isVisible()) {
                    return;
                }
                PhoneBizPanel.this.openModifyFormDialog();
            }
        });
        this.createNewAction = new JLabel();
        this.createNewAction.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 2));
        this.createNewAction.setIcon(UIConstants.USER_ADD);
        this.createNewAction.setText(I18NUtil.getString("home_btn_customer_add"));
        this.createNewAction.setCursor(Cursor.getPredefinedCursor(12));
        this.createNewAction.setIconTextGap(1);
        this.createNewAction.setVisible(false);
        actionPanel.add(this.createNewAction);
        this.createNewAction.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PhoneBizPanel.this.mCallDataBean == null) {
                    return;
                }
                if (PhoneBizPanel.this.newCustomerDialog != null && PhoneBizPanel.this.newCustomerDialog.isVisible()) {
                    return;
                }
                PhoneBizPanel.this.doNewFormDialog();
            }
        });
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setTabLayoutPolicy(1);
        jTabbedPane.setUI(new SpacedTabbedPaneUI());
        jTabbedPane.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        this.add((Component)jTabbedPane, "Center");
        this.summaryPanel = new PhoneBizSummaryPanel(this, this.mApp, this.mCallDataBean);
        jTabbedPane.addTab(I18NUtil.getString("home_biz_phone_tab_summary"), null, this.summaryPanel, null);
        this.customerPanel = new PhoneCustomerPanel(this.mCallDataBean);
        jTabbedPane.addTab(I18NUtil.getString("home_biz_phone_tab_customer_detail"), null, this.customerPanel, null);
        this.customerHistoryPanel = new PhoneCustomerHistoryPanel();
        jTabbedPane.addTab(I18NUtil.getString("home_biz_phone_tab_contact_history"), null, this.customerHistoryPanel, null);
        this.attPanel = new PhoneAttPanel(this.mCallDataBean);
        jTabbedPane.addTab(I18NUtil.getString("home_biz_phone_tab_attachdata"), null, this.attPanel, null);
        jTabbedPane.addMouseMotionListener(new MouseMotionAdapter(this){

            @Override
            public void mouseMoved(MouseEvent e) {
                JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
                if (PhoneBizPanel.findTabPaneIndex(e.getPoint(), tabbedPane) > -1) {
                    tabbedPane.setCursor(new Cursor(12));
                } else {
                    tabbedPane.setCursor(new Cursor(0));
                }
            }
        });
    }

    protected void btnSaveActionPerformed(ActionEvent evt) {
        if (this.mCallDataBean == null) {
            return;
        }
        String callId = this.mCallDataBean.getCallId();
        if (StringUtils.isBlank((CharSequence)callId)) {
            JOptionPane.showMessageDialog(this, I18NUtil.getString("home_biz_message_no_call_info_to_save"), I18NUtil.getString("common_title_error"), 0);
            return;
        }
        List<Object> catogeryList = new ArrayList();
        List<Object> outcomeList = new ArrayList();
        if (this.summaryPanel.isCategoryTreeEnabled() && (catogeryList = this.summaryPanel.getCategoryIdSelected()).size() == 0) {
            JOptionPane.showMessageDialog(this, I18NUtil.getString("contact_record_dialog_category_missing"), I18NUtil.getString("common_title_error"), 0);
            return;
        }
        if (this.summaryPanel.isOutcomeTreeEnabled() && (outcomeList = this.summaryPanel.getOutcomeIdSelected()).size() == 0) {
            JOptionPane.showMessageDialog(this, I18NUtil.getString("contact_record_dialog_outcome_missing"), I18NUtil.getString("common_title_error"), 0);
            return;
        }
        String note = this.summaryPanel.noteArea.getText();
        WebAgent.getInstance().saveCallSummary(this.mCallDataBean.getCallIdSet(), this.mCallDataBean.getCustomerId(), StringUtils.join(catogeryList, (String)","), StringUtils.join(outcomeList, (String)","), note, this.mApp != null ? Long.valueOf(this.mApp.getId()) : null);
        this.mCallDataBean.setSummaryCategoryIds(catogeryList);
        this.mCallDataBean.setSummaryOutcomeIds(outcomeList);
        this.mCallDataBean.setSummaryNote(note);
    }

    private void determineCustomer() {
        if (this.mCallDataBean == null) {
            return;
        }
        String callId = this.mCallDataBean.getCallId();
        if (StringUtils.isBlank((CharSequence)callId)) {
            JOptionPane.showMessageDialog(this, I18NUtil.getString("home_biz_message_no_call_info_to_save"), I18NUtil.getString("common_title_error"), 0);
            return;
        }
        WebAgent.getInstance().determineCustomer(this.mCallDataBean.getCallIdSet(), this.mCallDataBean.getCustomerId());
    }

    private void disassociateCustomer() {
        if (this.mCallDataBean == null) {
            return;
        }
        String callId = this.mCallDataBean.getCallId();
        if (StringUtils.isBlank((CharSequence)callId)) {
            JOptionPane.showMessageDialog(this, I18NUtil.getString("home_biz_message_no_call_info_to_save"), I18NUtil.getString("common_title_error"), 0);
            return;
        }
        WebAgent.getInstance().disassociateCustomer(this.mCallDataBean.getCallIdSet());
    }

    private static int findTabPaneIndex(Point p, JTabbedPane tabbedPane) {
        for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
            if (!tabbedPane.getBoundsAt(i).contains(p.x, p.y)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void onClose() {
        UCChatClient.context.unregisterReceiver(this.receiver);
        if (this.autoLoginTimer != null) {
            this.autoLoginTimer.cancel();
        }
    }

    public Application getApp() {
        return this.mApp;
    }

    public void setApp(Application mApp) {
        this.mApp = mApp;
    }

    public void removeSelf() {
        this.mTabPanel.removeComp(this);
    }

    public boolean checkSipCallId(String sipCallId) {
        if (this.mCallDataBean == null) {
            return false;
        }
        return this.mCallDataBean != null && this.mCallDataBean.getSipCallId().equals(sipCallId);
    }
}

