/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.customer;

import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.cc.Application;
import com.blisscloud.ezuc.client.cc.SummaryTreeCache;
import com.blisscloud.ezuc.client.component.HintTextField;
import com.blisscloud.ezuc.client.customer.PhoneBizPanel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.summary.CheckBoxNodeEditor;
import com.blisscloud.ezuc.client.summary.CheckBoxNodeRenderer;
import com.blisscloud.ezuc.client.summary.RadioBtnNodeEditor;
import com.blisscloud.ezuc.client.summary.RadioBtnNodeRenderer;
import com.blisscloud.ezuc.client.summary.SummaryTreeModel;
import com.blisscloud.ezuc.client.summary.SummaryTreeModelListener;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.AttachDataBean;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.json.JSONException;
import org.json.JSONObject;

public class PhoneBizSummaryPanel
extends JPanel {
    protected JTree categoryTree;
    protected JTree outcomeTree;
    protected JTextArea noteArea;
    boolean categoryTreeEnabled = false;
    boolean outcomeTreeEnabled = false;
    private JPanel treePanel;
    private Application mApp;
    private AttachDataBean mCallDataBean;
    private PhoneBizPanel parent;

    public PhoneBizSummaryPanel(PhoneBizPanel parent, Application app, AttachDataBean callDataBean) {
        this.mApp = app;
        this.mCallDataBean = callDataBean;
        this.parent = parent;
        this.initGUI();
        this.initData();
    }

    private void initGUI() {
        try {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            this.add((Component)mainPanel, "Center");
            GridLayout layout = new GridLayout(0, 2);
            layout.setHgap(10);
            this.treePanel = new JPanel(layout);
            this.treePanel.setBorder(BorderFactory.createEmptyBorder());
            mainPanel.add((Component)this.treePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 2.0, 10, 1, new Insets(6, 8, 6, 8), 0, 0));
            JPanel leftPanel = new JPanel();
            leftPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setHgap(2);
            borderLayout.setVgap(2);
            leftPanel.setLayout(borderLayout);
            leftPanel.setBackground(Color.WHITE);
            final HintTextField txtSearch = new HintTextField(I18NUtil.getString("common_placeholder_search"), UIConstants.FONT_12_PLAIN);
            leftPanel.add((Component)txtSearch, "North");
            txtSearch.setFont(UIConstants.FONT_12_PLAIN);
            txtSearch.setForeground(Color.DARK_GRAY);
            txtSearch.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            txtSearch.setOpaque(false);
            txtSearch.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    PhoneBizSummaryPanel.this.filterTree(PhoneBizSummaryPanel.this.categoryTree, txtSearch.getText());
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    PhoneBizSummaryPanel.this.filterTree(PhoneBizSummaryPanel.this.categoryTree, txtSearch.getText());
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    PhoneBizSummaryPanel.this.filterTree(PhoneBizSummaryPanel.this.categoryTree, txtSearch.getText());
                }
            });
            this.categoryTree = new JTree();
            this.categoryTree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.categoryTree.getSelectionModel().setSelectionMode(1);
            JScrollPane xx = new JScrollPane(this.categoryTree);
            xx.setBackground(Color.WHITE);
            xx.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            leftPanel.add((Component)xx, "Center");
            this.treePanel.add(leftPanel);
            JPanel rightPanel = new JPanel();
            rightPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            borderLayout = new BorderLayout();
            borderLayout.setHgap(2);
            borderLayout.setVgap(2);
            rightPanel.setLayout(borderLayout);
            rightPanel.setBackground(Color.WHITE);
            txtSearch = new HintTextField(I18NUtil.getString("common_placeholder_search"), UIConstants.FONT_12_PLAIN);
            rightPanel.add((Component)txtSearch, "North");
            txtSearch.setFont(UIConstants.FONT_12_PLAIN);
            txtSearch.setForeground(Color.DARK_GRAY);
            txtSearch.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            txtSearch.setOpaque(false);
            txtSearch.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    PhoneBizSummaryPanel.this.filterTree(PhoneBizSummaryPanel.this.outcomeTree, txtSearch.getText());
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    PhoneBizSummaryPanel.this.filterTree(PhoneBizSummaryPanel.this.outcomeTree, txtSearch.getText());
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    PhoneBizSummaryPanel.this.filterTree(PhoneBizSummaryPanel.this.outcomeTree, txtSearch.getText());
                }
            });
            this.outcomeTree = new JTree();
            this.outcomeTree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.outcomeTree.getSelectionModel().setSelectionMode(1);
            xx = new JScrollPane(this.outcomeTree);
            xx.setBackground(Color.WHITE);
            xx.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            rightPanel.add((Component)xx, "Center");
            this.treePanel.add(rightPanel);
            JLabel noteTitle = new JLabel();
            mainPanel.add((Component)noteTitle, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            noteTitle.setText(I18NUtil.getString("contact_record_dialog_note"));
            noteTitle.setFont(UIConstants.FONT_14_BOLD);
            this.noteArea = new JTextArea(5, 20);
            this.noteArea.setLineWrap(true);
            this.noteArea.setWrapStyleWord(true);
            JScrollPane scroll = new JScrollPane(this.noteArea);
            scroll.setHorizontalScrollBarPolicy(31);
            mainPanel.add((Component)scroll, new GridBagConstraints(0, 7, 2, 1, 1.0, 1.0, 10, 1, new Insets(6, 8, 6, 8), 0, 0));
            this.noteArea.setFont(UIConstants.FONT_14_BOLD);
            this.noteArea.getInputMap().put(KeyStroke.getKeyStroke(10, 64), "Shift+Enter");
            this.noteArea.getActionMap().put("Shift+Enter", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        PhoneBizSummaryPanel.this.noteArea.getDocument().insertString(PhoneBizSummaryPanel.this.noteArea.getCaretPosition(), "\n", null);
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                }
            });
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(1, 5, 5));
            this.add((Component)buttonPanel, "South");
            JButton btnSubmit = new JButton();
            if (this.mCallDataBean != null) {
                btnSubmit.setBackground(Color.GREEN);
                btnSubmit.setEnabled(true);
            } else {
                btnSubmit.setEnabled(false);
            }
            btnSubmit.setCursor(Cursor.getPredefinedCursor(12));
            btnSubmit.setText(I18NUtil.getString("home_Btn_customer_submit"));
            buttonPanel.add(btnSubmit);
            btnSubmit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PhoneBizSummaryPanel.this.parent.btnSaveActionPerformed(e);
                }
            });
            JButton btnClose = new JButton();
            btnClose.setCursor(Cursor.getPredefinedCursor(12));
            btnClose.setText(I18NUtil.getString("home_Btn_customer_close"));
            buttonPanel.add(btnClose);
            btnClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PhoneBizSummaryPanel.this.parent.removeSelf();
                }
            });
            if (this.mCallDataBean != null && this.mCallDataBean.getSubmitCount() > 0) {
                JLabel label = new JLabel();
                label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
                String msg = String.format(I18NUtil.getString("home_biz_message_submit_count"), this.mCallDataBean.getSubmitCount());
                label.setText("(" + msg + ")");
                buttonPanel.add(label);
            }
        }
        catch (Exception e) {
            Log.e(PhoneBizSummaryPanel.class.getName(), "ERROR:" + e.getMessage(), e);
        }
    }

    private void initData() {
        try {
            ArrayList<Long> categorySelectList = new ArrayList<Long>();
            ArrayList<Long> outcomeSelectList = new ArrayList<Long>();
            if (this.mCallDataBean != null) {
                if (this.mCallDataBean.getSummaryCategoryIds() != null) {
                    for (Long id : this.mCallDataBean.getSummaryCategoryIds()) {
                        categorySelectList.add(id);
                    }
                }
                if (this.mCallDataBean.getSummaryOutcomeIds() != null) {
                    for (Long id : this.mCallDataBean.getSummaryOutcomeIds()) {
                        outcomeSelectList.add(id);
                    }
                }
                if (this.mCallDataBean.getSummaryNote() != null) {
                    this.noteArea.setText(this.mCallDataBean.getSummaryNote());
                }
            }
            int summaryType = 0;
            if (this.mApp.getObj().has("summaryType")) {
                summaryType = this.mApp.getObj().getInt("summaryType");
            }
            if (summaryType == 0) {
                Map<Object, Object> callData;
                int directionType = 0;
                if (this.mApp.getObj().has("directionType")) {
                    directionType = this.mApp.getObj().getInt("directionType");
                }
                String direction = null;
                direction = directionType == 1 ? "INBOUND" : (directionType == 2 ? "OUTBOUND" : "OUTBOUND");
                Map<Object, Object> map = callData = this.mCallDataBean != null ? this.mCallDataBean.getAttachData() : new HashMap();
                if (callData != null && callData.containsKey("DIRECTION")) {
                    direction = (String)callData.get("DIRECTION");
                }
                if ("OUTBOUND".equals(direction)) {
                    SummaryTreeModel model;
                    boolean multiEnabled;
                    if (SummaryTreeCache.iOutboundCategoryId != null) {
                        multiEnabled = false;
                        if (SummaryTreeCache.outboundCategoryMultiChooseEnabed) {
                            this.categoryTree.setCellEditor(new CheckBoxNodeEditor());
                            this.categoryTree.setCellRenderer(new CheckBoxNodeRenderer());
                            multiEnabled = true;
                        } else {
                            this.categoryTree.setCellEditor(new RadioBtnNodeEditor());
                            this.categoryTree.setCellRenderer(new RadioBtnNodeRenderer());
                        }
                        this.categoryTree.setEditable(true);
                        model = new SummaryTreeModel(SummaryTreeCache.iOutboundCategoryId, categorySelectList, multiEnabled);
                        model.addTreeModelListener(new SummaryTreeModelListener(this.categoryTree));
                        this.categoryTree.setModel(model);
                        this.expandAllNodes(this.categoryTree, 0, this.categoryTree.getRowCount());
                        this.categoryTree.setVisible(true);
                        this.categoryTreeEnabled = true;
                    } else {
                        this.categoryTree.setVisible(false);
                    }
                    if (SummaryTreeCache.iOutboundOutcomeId != null) {
                        multiEnabled = false;
                        if (SummaryTreeCache.outboundOutcomeMultiChooseEnabed) {
                            this.outcomeTree.setCellEditor(new CheckBoxNodeEditor());
                            this.outcomeTree.setCellRenderer(new CheckBoxNodeRenderer());
                            multiEnabled = true;
                        } else {
                            this.outcomeTree.setCellEditor(new RadioBtnNodeEditor());
                            this.outcomeTree.setCellRenderer(new RadioBtnNodeRenderer());
                        }
                        this.outcomeTree.setEditable(true);
                        model = new SummaryTreeModel(SummaryTreeCache.iOutboundOutcomeId, outcomeSelectList, multiEnabled);
                        model.addTreeModelListener(new SummaryTreeModelListener(this.outcomeTree));
                        this.outcomeTree.setModel(model);
                        this.expandAllNodes(this.outcomeTree, 0, this.outcomeTree.getRowCount());
                        this.outcomeTree.setVisible(true);
                        this.outcomeTreeEnabled = true;
                    } else {
                        this.outcomeTree.setVisible(false);
                    }
                } else if ("INBOUND".equals(direction)) {
                    SummaryTreeModel model;
                    boolean multiEnabled;
                    if (SummaryTreeCache.iInboundCategoryId != null) {
                        multiEnabled = false;
                        if (SummaryTreeCache.inboundCategoryMultiChooseEnabed) {
                            this.categoryTree.setCellEditor(new CheckBoxNodeEditor());
                            this.categoryTree.setCellRenderer(new CheckBoxNodeRenderer());
                            multiEnabled = true;
                        } else {
                            this.categoryTree.setCellEditor(new RadioBtnNodeEditor());
                            this.categoryTree.setCellRenderer(new RadioBtnNodeRenderer());
                        }
                        this.categoryTree.setEditable(true);
                        model = new SummaryTreeModel(SummaryTreeCache.iInboundCategoryId, categorySelectList, multiEnabled);
                        model.addTreeModelListener(new SummaryTreeModelListener(this.categoryTree));
                        this.categoryTree.setModel(model);
                        this.expandAllNodes(this.categoryTree, 0, this.categoryTree.getRowCount());
                        this.categoryTree.setVisible(true);
                        this.categoryTreeEnabled = true;
                    } else {
                        this.categoryTree.setVisible(false);
                    }
                    if (SummaryTreeCache.iInboundOutcomeId != null) {
                        multiEnabled = false;
                        if (SummaryTreeCache.inboundOutcomeMultiChooseEnabed) {
                            this.outcomeTree.setCellEditor(new CheckBoxNodeEditor());
                            this.outcomeTree.setCellRenderer(new CheckBoxNodeRenderer());
                            multiEnabled = true;
                        } else {
                            this.outcomeTree.setCellEditor(new RadioBtnNodeEditor());
                            this.outcomeTree.setCellRenderer(new RadioBtnNodeRenderer());
                        }
                        this.outcomeTree.setEditable(true);
                        model = new SummaryTreeModel(SummaryTreeCache.iInboundOutcomeId, outcomeSelectList, multiEnabled);
                        model.addTreeModelListener(new SummaryTreeModelListener(this.outcomeTree));
                        this.outcomeTree.setModel(model);
                        this.expandAllNodes(this.outcomeTree, 0, this.outcomeTree.getRowCount());
                        this.outcomeTree.setVisible(true);
                        this.outcomeTreeEnabled = true;
                    } else {
                        this.outcomeTree.setVisible(false);
                    }
                }
            } else if (summaryType == 1) {
                SummaryTreeModel model;
                boolean multiEnabled;
                JSONObject attObj = this.mApp.getObj();
                Long summaryCategoryId = null;
                if (attObj.has("summaryCategoryId")) {
                    summaryCategoryId = attObj.getLong("summaryCategoryId");
                }
                Long summaryOutcomeId = null;
                if (attObj.has("summaryOutcomeId")) {
                    summaryOutcomeId = this.mApp.getObj().getLong("summaryOutcomeId");
                }
                if (summaryCategoryId != null) {
                    multiEnabled = false;
                    if (attObj.has("categoryMultiChooseEnabed") && attObj.getBoolean("categoryMultiChooseEnabed")) {
                        this.categoryTree.setCellEditor(new CheckBoxNodeEditor());
                        this.categoryTree.setCellRenderer(new CheckBoxNodeRenderer());
                        multiEnabled = true;
                    } else {
                        this.categoryTree.setCellEditor(new RadioBtnNodeEditor());
                        this.categoryTree.setCellRenderer(new RadioBtnNodeRenderer());
                    }
                    this.categoryTree.setEditable(true);
                    model = new SummaryTreeModel(summaryCategoryId, categorySelectList, multiEnabled);
                    model.addTreeModelListener(new SummaryTreeModelListener(this.categoryTree));
                    this.categoryTree.setModel(model);
                    this.expandAllNodes(this.categoryTree, 0, this.categoryTree.getRowCount());
                    this.categoryTree.setVisible(true);
                    this.categoryTreeEnabled = true;
                } else {
                    this.categoryTree.setVisible(false);
                }
                if (summaryOutcomeId != null) {
                    multiEnabled = false;
                    if (attObj.has("outcomeMultiChooseEnabed") && attObj.getBoolean("outcomeMultiChooseEnabed")) {
                        this.outcomeTree.setCellEditor(new CheckBoxNodeEditor());
                        this.outcomeTree.setCellRenderer(new CheckBoxNodeRenderer());
                        multiEnabled = true;
                    } else {
                        this.outcomeTree.setCellEditor(new RadioBtnNodeEditor());
                        this.outcomeTree.setCellRenderer(new RadioBtnNodeRenderer());
                    }
                    this.outcomeTree.setEditable(true);
                    model = new SummaryTreeModel(summaryOutcomeId, outcomeSelectList, multiEnabled);
                    model.addTreeModelListener(new SummaryTreeModelListener(this.outcomeTree));
                    this.outcomeTree.setModel(model);
                    this.expandAllNodes(this.outcomeTree, 0, this.outcomeTree.getRowCount());
                    this.outcomeTree.setVisible(true);
                    this.outcomeTreeEnabled = true;
                } else {
                    this.outcomeTree.setVisible(false);
                }
            }
        }
        catch (JSONException e) {
            Log.e(PhoneBizSummaryPanel.class.getName(), "ERROR:" + e.getMessage(), e);
        }
    }

    private void filterTree(final JTree tree, String filterKey) {
        ((SummaryTreeModel)tree.getModel()).filterKey(filterKey);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                tree.updateUI();
            }
        });
    }

    private void expandAllNodes(JTree tree, int startingIndex, int rowCount) {
        for (int i = startingIndex; i < rowCount; ++i) {
            tree.expandRow(i);
        }
        if (tree.getRowCount() != rowCount) {
            this.expandAllNodes(tree, rowCount, tree.getRowCount());
        }
    }

    public List<Long> getCategoryIdSelected() {
        return ((SummaryTreeModel)this.categoryTree.getModel()).getSelectedIdList();
    }

    public List<Long> getOutcomeIdSelected() {
        return ((SummaryTreeModel)this.outcomeTree.getModel()).getSelectedIdList();
    }

    public boolean isCategoryTreeEnabled() {
        return this.categoryTreeEnabled;
    }

    public boolean isOutcomeTreeEnabled() {
        return this.outcomeTreeEnabled;
    }

    public void setCategoryTreeEnabled(boolean categoryTreeEnabled) {
        this.categoryTreeEnabled = categoryTreeEnabled;
    }

    public void setOutcomeTreeEnabled(boolean outcomeTreeEnabled) {
        this.outcomeTreeEnabled = outcomeTreeEnabled;
    }
}

