/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.customer;

import com.blisscloud.ezuc.client.customer.CallHistoryTableModel;
import com.blisscloud.ezuc.client.customer.CustomerHistoryDetailPanel;
import com.blisscloud.ezuc.client.customer.HeaderRenderer;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.json.JSONArray;
import org.json.JSONObject;

public class PhoneCustomerHistoryPanel
extends JPanel {
    private CallHistoryTableModel callHistoryTableModel = new CallHistoryTableModel();
    private JTable callHistoryTable;
    private CustomerHistoryDetailPanel detailPanel;

    public PhoneCustomerHistoryPanel() {
        this.initView();
    }

    public void updateContactHistoryList(JSONArray historyAry) {
        this.callHistoryTableModel.setCustomerItems(historyAry);
    }

    public void initView() {
        this.setBorder(BorderFactory.createEmptyBorder(6, 8, 6, 8));
        this.setLayout(new BorderLayout());
        JPanel x = new JPanel();
        x.setLayout(new BorderLayout());
        this.add((Component)x, "Center");
        JPanel group = new JPanel();
        group.setLayout(new GridBagLayout());
        x.add((Component)group, "South");
        this.detailPanel = new CustomerHistoryDetailPanel();
        this.detailPanel.setVisible(false);
        group.add((Component)this.detailPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JLabel maxLabel = new JLabel();
        maxLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        maxLabel.setText(I18NUtil.getString("home_biz_message_max_history_items"));
        group.add((Component)maxLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.callHistoryTable = new JTable();
        this.callHistoryTable.setRowHeight(28);
        ListSelectionModel selectionModel = this.callHistoryTable.getSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int[] selectedRow = PhoneCustomerHistoryPanel.this.callHistoryTable.getSelectedRows();
                if (selectedRow.length > 0) {
                    int selectedRowIndex = PhoneCustomerHistoryPanel.this.callHistoryTable.getSelectedRow();
                    JSONObject obj = PhoneCustomerHistoryPanel.this.callHistoryTableModel.getItem(selectedRowIndex);
                    PhoneCustomerHistoryPanel.this.detailPanel.setData(obj);
                    PhoneCustomerHistoryPanel.this.detailPanel.setVisible(true);
                } else {
                    PhoneCustomerHistoryPanel.this.detailPanel.clearData();
                    PhoneCustomerHistoryPanel.this.detailPanel.setVisible(false);
                }
            }
        });
        this.callHistoryTable.setModel(this.callHistoryTableModel);
        this.callHistoryTable.setSelectionMode(0);
        JTableHeader header = this.callHistoryTable.getTableHeader();
        header.setDefaultRenderer(new HeaderRenderer(this.callHistoryTable));
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        TableColumn dirColumn = this.callHistoryTable.getColumnModel().getColumn(0);
        TableColumn agentColumn = this.callHistoryTable.getColumnModel().getColumn(1);
        TableColumn phoneNumColumn = this.callHistoryTable.getColumnModel().getColumn(2);
        TableColumn startDateColumn = this.callHistoryTable.getColumnModel().getColumn(3);
        TableColumn startTimeColumn = this.callHistoryTable.getColumnModel().getColumn(4);
        TableColumn answerTimeColumn = this.callHistoryTable.getColumnModel().getColumn(5);
        TableColumn durationColumn = this.callHistoryTable.getColumnModel().getColumn(6);
        TableColumn resultColumn = this.callHistoryTable.getColumnModel().getColumn(7);
        dirColumn.setCellRenderer(centerRenderer);
        agentColumn.setCellRenderer(centerRenderer);
        phoneNumColumn.setCellRenderer(centerRenderer);
        startDateColumn.setCellRenderer(centerRenderer);
        startTimeColumn.setCellRenderer(centerRenderer);
        answerTimeColumn.setCellRenderer(centerRenderer);
        durationColumn.setCellRenderer(centerRenderer);
        resultColumn.setCellRenderer(centerRenderer);
        dirColumn.setPreferredWidth(80);
        dirColumn.setMaxWidth(80);
        agentColumn.setPreferredWidth(180);
        agentColumn.setMaxWidth(180);
        phoneNumColumn.setPreferredWidth(120);
        phoneNumColumn.setMaxWidth(120);
        startDateColumn.setPreferredWidth(80);
        startDateColumn.setMaxWidth(80);
        startTimeColumn.setPreferredWidth(80);
        startTimeColumn.setMaxWidth(80);
        answerTimeColumn.setPreferredWidth(80);
        answerTimeColumn.setMaxWidth(80);
        durationColumn.setPreferredWidth(80);
        durationColumn.setMaxWidth(80);
        resultColumn.setPreferredWidth(150);
        resultColumn.setMaxWidth(150);
        JTableHeader th = this.callHistoryTable.getTableHeader();
        th.setPreferredSize(new Dimension(0, 28));
        x.add((Component)new JScrollPane(this.callHistoryTable), "Center");
    }
}

