/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.customer;

import com.blisscloud.ezuc.client.cc.ApplicationCache;
import com.blisscloud.ezuc.client.customer.ColumnType;
import com.blisscloud.ezuc.client.customer.CustomerField;
import com.blisscloud.ezuc.client.customer.CustomerFieldItem;
import com.blisscloud.ezuc.client.customer.FieldDataType;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.AttachDataBean;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.json.JSONException;
import org.json.JSONObject;

public class PhoneCustomerPanel
extends JPanel {
    private Color titleColor = new Color(213, 226, 243);
    private AttachDataBean mCallDataBean;
    private JPanel contentPanel;
    private JSONObject customerObj = new JSONObject();
    private String agentName;

    public PhoneCustomerPanel(AttachDataBean callDataBean) {
        this.mCallDataBean = callDataBean;
        this.initView();
    }

    public void refreash() {
        this.removeAll();
        this.initView();
    }

    public void initView() {
        this.setBorder(BorderFactory.createEmptyBorder(6, 8, 6, 8));
        if (this.mCallDataBean != null) {
            this.customerObj = this.mCallDataBean.getCustomerDetail() != null ? this.mCallDataBean.getCustomerDetail() : new JSONObject();
            this.agentName = this.mCallDataBean.getAgentName() != null ? this.mCallDataBean.getAgentName() : "";
        }
        this.setLayout(new BorderLayout());
        JScrollPane mainScrollPanel = new JScrollPane();
        mainScrollPanel.getVerticalScrollBar().setUnitIncrement(30);
        this.add((Component)mainScrollPanel, "Center");
        mainScrollPanel.setHorizontalScrollBarPolicy(31);
        this.contentPanel = new JPanel();
        this.contentPanel.setBackground(Color.WHITE);
        this.contentPanel.setLayout(new GridBagLayout());
        mainScrollPanel.setViewportView(this.contentPanel);
        int y = 0;
        this.addTitle(y++, "personalCustomer.newForm.baseInfo");
        this.addTwoField(ColumnType.CUSTOMER_STRID, ColumnType.CUSTOMER_TITLE, y++, 20, 5);
        this.addTwoField(ColumnType.CUSTOMER_LASTNAME, ColumnType.CUSTOMER_GENDER, y++, 5, 5);
        this.addTwoField(ColumnType.CUSTOMER_OTHERTNAME, ColumnType.CUSTOMER_IDENTITY_NUMBER, y++, 5, 5);
        this.addTwoField(ColumnType.CUSTOMER_FIRSTNAME, ColumnType.CUSTOMER_PASSPORT_NUMBER, y++, 5, 5);
        this.addTwoField(ColumnType.CUSTOMER_BIRTHDAY, ColumnType.CUSTOMER_HOBBY, y++, 5, 5);
        this.addTwoField(ColumnType.CUSTOMER_CORPORATION, ColumnType.CUSTOMER_DEPT, y++, 5, 5);
        this.addTwoField(ColumnType.CUSTOMER_BIZ_TITLE, ColumnType.CUSTOMER_BIZ_DUTY, y++, 5, 20);
        this.addTitle(y++, "personalCustomer.newForm.customInfo");
        int cindex = 0;
        CustomerField f1 = null;
        ArrayList<CustomerField> list = ApplicationCache.getInstance().customEnableList;
        for (int cx = 0; cx < list.size(); ++cx) {
            CustomerField f = list.get(cx);
            if (f1 != null) {
                this.addTwoField(f1.getColumnType(), f.getColumnType(), y++, cindex == 0 ? 20 : 5, cx == list.size() - 1 ? 20 : 5);
                f1 = null;
                ++cindex;
                continue;
            }
            f1 = f;
        }
        if (f1 != null) {
            this.addTwoField(f1.getColumnType(), null, y++, 5, 20);
        }
        this.addTitle(y++, "personalCustomer.newForm.contactInfo");
        this.addTwoField(ColumnType.CUSTOMER_MOBILEPHONE, ColumnType.CUSTOMER_OFFICEPHONE, y++, 20, 5);
        this.addTwoField(ColumnType.CUSTOMER_HOMEPHONE, ColumnType.CUSTOMER_OTHERPHONE, y++, 5, 5);
        this.addTwoField(ColumnType.CUSTOMER_FAX, null, y++, 5, 5);
        this.addTwoField(ColumnType.CUSTOMER_EMAIL, ColumnType.CUSTOMER_OTHEREMAIL, y++, 5, 5);
        this.addTwoField(ColumnType.CUSTOMER_COMMUNICATION_TYPE_1, ColumnType.CUSTOMER_COMMUNICATION_NUMBER_1, y++, 5, 5);
        this.addTwoField(ColumnType.CUSTOMER_COMMUNICATION_TYPE_2, ColumnType.CUSTOMER_COMMUNICATION_NUMBER_2, y++, 5, 5);
        this.addTwoField(ColumnType.CUSTOMER_ASSISTANT_NAME, ColumnType.CUSTOMER_ASSISTANT_PHONE, y++, 5, 20);
        this.addTitle(y++, "personalCustomer.newForm.addressInfo");
        this.addOneField(ColumnType.CUSTOMER_ADDRESS_1, y++, 20, 5);
        this.addTwoField(ColumnType.CUSTOMER_CITY_1, ColumnType.CUSTOMER_PROVINCE_1, y++, 5, 5);
        this.addTwoField(ColumnType.CUSTOMER_COUNTRY_1, ColumnType.CUSTOMER_POST_CODE_1, y++, 5, 5);
        this.addOneField(ColumnType.CUSTOMER_ADDRESS_2, y++, 20, 5);
        this.addTwoField(ColumnType.CUSTOMER_CITY_2, ColumnType.CUSTOMER_PROVINCE_2, y++, 5, 5);
        this.addTwoField(ColumnType.CUSTOMER_COUNTRY_2, ColumnType.CUSTOMER_POST_CODE_2, y++, 5, 20);
        this.addTitle(y++, "personalCustomer.newForm.blockInfo");
        this.addTwoField(ColumnType.CUSTOMER_BLOCK_CALL, ColumnType.CUSTOMER_BLOCK_EMAIL, y++, 20, 5);
        this.addOneFieldArea(ColumnType.CUSTOMER_BLOCK_MEMO, y++, 5, 20);
        this.addTitle(y++, "personalCustomer.newForm.bizInfo");
        this.addTwoField(ColumnType.CUSTOMER_SOURCE, ColumnType.CUSTOMER_LEVEL, y++, 20, 5);
        this.addTwoField(ColumnType.CUSTOMER_AGENT, null, y++, 5, 5);
        this.addOneFieldArea(ColumnType.CUSTOMER_REMARK, y++, 5, 40);
        JPanel x2 = new JPanel();
        x2.setOpaque(false);
        this.contentPanel.add((Component)x2, new GridBagConstraints(0, y++, 5, 1, 1.0, 5.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void addTwoField(ColumnType c1, ColumnType c2, int y, int top, int bottom) {
        Border b = BorderFactory.createLineBorder(Color.LIGHT_GRAY);
        if (c1 != null) {
            CustomerField f1 = ApplicationCache.getInstance().schameMap.get((Object)c1);
            String v1 = this.getFieldValue(f1);
            JLabel x0 = new JLabel(f1.getName());
            this.contentPanel.add((Component)x0, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(top, 50, bottom, 5), 0, 0));
            JTextField x1 = new JTextField(v1, 20);
            x1.setOpaque(false);
            x1.setBorder(b);
            x1.setEditable(false);
            this.contentPanel.add((Component)x1, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 2, new Insets(top, 2, bottom, 25), 0, 0));
        }
        if (c2 != null) {
            CustomerField f2 = ApplicationCache.getInstance().schameMap.get((Object)c2);
            String v2 = this.getFieldValue(f2);
            JLabel x2 = new JLabel(f2.getName());
            this.contentPanel.add((Component)x2, new GridBagConstraints(2, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(top, 25, bottom, 5), 0, 0));
            JTextField x3 = new JTextField(v2, 20);
            x3.setOpaque(false);
            x3.setBorder(b);
            x3.setEditable(false);
            this.contentPanel.add((Component)x3, new GridBagConstraints(3, y, 1, 1, 0.0, 0.0, 17, 2, new Insets(top, 2, bottom, 25), 0, 0));
        }
        JPanel x05 = new JPanel();
        x05.setOpaque(false);
        this.contentPanel.add((Component)x05, new GridBagConstraints(4, y, 1, 1, 1.0, 0.0, 10, 2, new Insets(top, 5, bottom, 5), 0, 0));
    }

    private void addOneField(ColumnType c1, int y, int top, int bottom) {
        Border b = BorderFactory.createLineBorder(Color.LIGHT_GRAY);
        if (c1 != null) {
            CustomerField f1 = ApplicationCache.getInstance().schameMap.get((Object)c1);
            String v1 = this.getFieldValue(f1);
            JLabel x0 = new JLabel(f1.getName());
            this.contentPanel.add((Component)x0, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(top, 50, bottom, 5), 0, 0));
            JTextField x1 = new JTextField(v1, 51);
            x1.setOpaque(false);
            x1.setBorder(b);
            x1.setEditable(false);
            this.contentPanel.add((Component)x1, new GridBagConstraints(1, y, 3, 1, 0.0, 0.0, 17, 2, new Insets(top, 2, bottom, 25), 0, 0));
        }
        JPanel x05 = new JPanel();
        x05.setOpaque(false);
        this.contentPanel.add((Component)x05, new GridBagConstraints(4, y, 1, 1, 1.0, 0.0, 10, 2, new Insets(top, 5, bottom, 5), 0, 0));
    }

    private void addOneFieldArea(ColumnType c1, int y, int top, int bottom) {
        Border b = BorderFactory.createLineBorder(Color.LIGHT_GRAY);
        if (c1 != null) {
            CustomerField f1 = ApplicationCache.getInstance().schameMap.get((Object)c1);
            String v1 = this.getFieldValue(f1);
            JLabel x0 = new JLabel(f1.getName());
            this.contentPanel.add((Component)x0, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(top, 50, bottom, 5), 0, 0));
            JTextArea x1 = new JTextArea(v1, 4, 50);
            x1.setBorder(b);
            x1.setOpaque(false);
            x1.setEditable(false);
            this.contentPanel.add((Component)x1, new GridBagConstraints(1, y, 3, 1, 0.0, 0.0, 17, 2, new Insets(top, 2, bottom, 25), 0, 0));
        }
        JPanel x05 = new JPanel();
        x05.setOpaque(false);
        this.contentPanel.add((Component)x05, new GridBagConstraints(4, y, 1, 1, 1.0, 0.0, 10, 2, new Insets(top, 5, bottom, 5), 0, 0));
    }

    private String getFieldValue(CustomerField f) {
        if (!this.customerObj.has(f.getColumnType().getColumnName())) {
            return "";
        }
        try {
            if (f.getDataType() == FieldDataType.STRING) {
                return this.customerObj.getString(f.getColumnType().getColumnName());
            }
            if (f.getDataType() == FieldDataType.INT) {
                int v = this.customerObj.getInt(f.getColumnType().getColumnName());
                if (f.isEnumData()) {
                    CustomerFieldItem item = f.getEnumMap().get(v);
                    if (item == null) {
                        return String.valueOf(v);
                    }
                    return item.getName();
                }
                return String.valueOf(v);
            }
            if (f.getDataType() == FieldDataType.LONG) {
                long v = this.customerObj.getLong(f.getColumnType().getColumnName());
                if (f.getColumnType() == ColumnType.CUSTOMER_AGENT) {
                    return this.agentName;
                }
                return String.valueOf(v);
            }
            if (f.getDataType() == FieldDataType.DATETIME) {
                long timestamp = this.customerObj.getLong(f.getColumnType().getColumnName());
                Date d = new Date();
                d.setTime(timestamp);
                SimpleDateFormat sdf = new SimpleDateFormat(f.getFormatDesc());
                return sdf.format(d);
            }
        }
        catch (JSONException e) {
            Log.e(PhoneCustomerPanel.class.getSimpleName(), "ERROR:" + e.getMessage(), e);
        }
        return "";
    }

    private void addTitle(int y, String key) {
        JPanel groupTitle = new JPanel();
        groupTitle.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        groupTitle.setLayout(new FlowLayout(0, 0, 0));
        JLabel x = new JLabel();
        x.setText(I18NUtil.getString(key));
        groupTitle.add(x);
        groupTitle.setBackground(this.titleColor);
        this.contentPanel.add((Component)groupTitle, new GridBagConstraints(0, y, 5, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }
}

