/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.customer;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.customer.CustomerItem;
import com.blisscloud.ezuc.client.customer.CustomerTableModel;
import com.blisscloud.ezuc.client.customer.HeaderRenderer;
import com.blisscloud.ezuc.client.customer.LabelType;
import com.blisscloud.ezuc.client.customer.LabelTypeSelectionRenderer;
import com.blisscloud.ezuc.client.customer.ModifyCustomerDialog;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.AttachDataBean;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SearchCustomerDialog
extends GenericDialog {
    private static final int ITEM_PID_INDEX = 7;
    private static final int ITEM_CNO_INDEX = 1;
    private static final int ITEM_ID_INDEX = 2;
    private static final int ITEM_PHONE_INDEX = 0;
    private String mUuid;
    private AttachDataBean mCallDataBean;
    private CustomerTableModel customerTableModel = new CustomerTableModel();
    private JComboBox<LabelType> searchType;
    private JTextField searchContent;
    private JButton btnSubmit;
    private JTable customerTable;

    public SearchCustomerDialog(JFrame frame, AttachDataBean callDataBean, String uuid) {
        super(frame);
        String number;
        this.mCallDataBean = callDataBean;
        this.mUuid = uuid;
        this.setTitle(I18NUtil.getString("personalCustomer_search_form_title"));
        this.setModal(false);
        this.setMinimumSize(new Dimension(1100, 650));
        this.initGUI();
        if (StringUtils.isNotBlank((CharSequence)this.mCallDataBean.getPids())) {
            this.searchType.setSelectedIndex(7);
            this.doSearch();
        } else if ("CNO".equals(this.mCallDataBean.getMatchType())) {
            String strId = this.mCallDataBean.getCustomerStrId();
            if (StringUtils.isNotBlank((CharSequence)strId)) {
                this.searchType.setSelectedIndex(1);
                this.searchContent.setText(strId);
                this.doSearch();
            }
        } else if ("IDENTITY".equals(this.mCallDataBean.getMatchType())) {
            String identity = this.mCallDataBean.getIdentity();
            if (StringUtils.isNotBlank((CharSequence)identity)) {
                this.searchType.setSelectedIndex(2);
                this.searchContent.setText(identity);
                this.doSearch();
            }
        } else if ("ANI".equals(this.mCallDataBean.getMatchType())) {
            String orgNumber = this.mCallDataBean.getOrgInboundNum();
            HashSet<String> numberSet = new HashSet<String>();
            String number2 = this.mCallDataBean.getAni();
            if (StringUtils.isNotBlank((CharSequence)orgNumber)) {
                numberSet.add(orgNumber);
            }
            if (StringUtils.isNotBlank((CharSequence)number2)) {
                numberSet.add(number2);
            }
            if (numberSet.size() > 0) {
                this.searchType.setSelectedIndex(0);
                this.searchContent.setText(String.join((CharSequence)",", numberSet));
                this.doSearch();
            }
        } else if ("DNIS".equals(this.mCallDataBean.getMatchType())) {
            String number3 = this.mCallDataBean.getDnis();
            if (StringUtils.isNotBlank((CharSequence)number3)) {
                this.searchType.setSelectedIndex(0);
                this.searchContent.setText(number3);
                this.doSearch();
            }
        } else if ("INBOUND".equals(this.mCallDataBean.getDirection())) {
            String number4 = this.mCallDataBean.getAni();
            if (StringUtils.isNotBlank((CharSequence)number4)) {
                this.searchType.setSelectedIndex(0);
                this.searchContent.setText(number4);
                this.doSearch();
            }
        } else if ("OUTBOUND".equals(this.mCallDataBean.getDirection()) && StringUtils.isNotBlank((CharSequence)(number = this.mCallDataBean.getDnis()))) {
            this.searchType.setSelectedIndex(0);
            this.searchContent.setText(number);
            this.doSearch();
        }
    }

    public void updateCustomerList(JSONArray customerAry) {
        Log.i(SearchCustomerDialog.class.getName(), "customerAry: " + customerAry.length());
        ArrayList<CustomerItem> list = new ArrayList<CustomerItem>();
        try {
            for (int i = 0; i < customerAry.length(); ++i) {
                JSONObject obj = customerAry.getJSONObject(i);
                CustomerItem item = new CustomerItem();
                item.setDetail(obj);
                list.add(item);
            }
        }
        catch (JSONException e) {
            Log.e(ModifyCustomerDialog.class.getName(), "ERROR:" + e.getMessage(), e);
        }
        this.customerTableModel.setCustomerItems(list);
    }

    private void doSearch() {
        LabelType item = (LabelType)this.searchType.getSelectedItem();
        int type = item.getType();
        if (type != 13) {
            String searchText = this.searchContent.getText();
            if (StringUtils.isBlank((CharSequence)searchText)) {
                JOptionPane.showMessageDialog(this, I18NUtil.getString("home_biz_message_search_content_empty"), I18NUtil.getString("common_title_error"), 0);
                this.searchContent.requestFocus();
                return;
            }
            WebAgent.getInstance().searchCustomer(type, searchText.trim(), this.mUuid);
        } else {
            WebAgent.getInstance().searchCustomer(type, this.mCallDataBean.getPids(), this.mUuid);
        }
    }

    private void initGUI() {
        try {
            JPanel centerPanel = new JPanel();
            centerPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 0, 15));
            centerPanel.setLayout(new BorderLayout());
            centerPanel.setBackground(UIConstants.COLOR_DIALOG_BACKGROUND);
            this.getContentPane().add((Component)centerPanel, "Center");
            JPanel searchPanel = new JPanel();
            searchPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            searchPanel.setOpaque(false);
            searchPanel.setLayout(new FlowLayout(0, 5, 0));
            centerPanel.add((Component)searchPanel, "North");
            this.searchType = new JComboBox();
            DefaultComboBoxModel<LabelType> x1Model = new DefaultComboBoxModel<LabelType>();
            x1Model.addElement(new LabelType(2, I18NUtil.getString("personalCustomer.message.search.item.phone")));
            x1Model.addElement(new LabelType(10, I18NUtil.getString("personalCustomer.message.search.item.strId")));
            x1Model.addElement(new LabelType(11, I18NUtil.getString("personalCustomer.message.search.item.identity")));
            x1Model.addElement(new LabelType(12, I18NUtil.getString("personalCustomer.message.search.item.passport")));
            x1Model.addElement(new LabelType(1, I18NUtil.getString("personalCustomer.message.search.item.name")));
            x1Model.addElement(new LabelType(4, I18NUtil.getString("personalCustomer.message.search.item.corporation")));
            x1Model.addElement(new LabelType(8, I18NUtil.getString("personalCustomer.message.search.item.remark")));
            x1Model.addElement(new LabelType(13, I18NUtil.getString("personalCustomer.message.search.item.serverMatch")));
            this.searchType.setModel(x1Model);
            this.searchType.setRenderer(new LabelTypeSelectionRenderer());
            this.searchType.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    LabelType selected = (LabelType)this.searchType.getSelectedItem();
                    if (selected != null && selected.getType() == 13) {
                        this.searchContent.setVisible(false);
                    } else {
                        this.searchContent.setVisible(true);
                    }
                    this.searchContent.getParent().revalidate();
                    this.searchContent.getParent().repaint();
                }
            });
            searchPanel.add(this.searchType);
            this.searchContent = new JTextField(20);
            searchPanel.add(this.searchContent);
            this.searchContent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchCustomerDialog.this.doSearch();
                }
            });
            JButton btnSearch = new JButton();
            btnSearch.setEnabled(true);
            btnSearch.setCursor(Cursor.getPredefinedCursor(12));
            btnSearch.setText(I18NUtil.getString("home_Btn_customer_search"));
            searchPanel.add(btnSearch);
            btnSearch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchCustomerDialog.this.doSearch();
                }
            });
            JPanel x = new JPanel();
            x.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            x.setLayout(new BorderLayout());
            centerPanel.add((Component)x, "Center");
            JLabel maxLabel = new JLabel();
            maxLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            maxLabel.setText(I18NUtil.getString("home_biz_message_max_items"));
            x.add((Component)maxLabel, "South");
            this.customerTable = new JTable();
            this.customerTable.setRowHeight(28);
            ListSelectionModel selectionModel = this.customerTable.getSelectionModel();
            selectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int[] selectedRow = SearchCustomerDialog.this.customerTable.getSelectedRows();
                    if (selectedRow.length > 0) {
                        SearchCustomerDialog.this.btnSubmit.setEnabled(true);
                        SearchCustomerDialog.this.btnSubmit.setBackground(Color.GREEN);
                    } else {
                        SearchCustomerDialog.this.btnSubmit.setEnabled(false);
                        SearchCustomerDialog.this.btnSubmit.setBackground(new Color(240, 240, 240));
                    }
                }
            });
            this.customerTable.setModel(this.customerTableModel);
            this.customerTable.setSelectionMode(0);
            this.customerTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    if (me.getClickCount() == 2) {
                        SearchCustomerDialog.this.handleSubmit();
                    }
                }
            });
            JTableHeader header = this.customerTable.getTableHeader();
            header.setDefaultRenderer(new HeaderRenderer(this.customerTable));
            DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
            centerRenderer.setHorizontalAlignment(0);
            TableColumn strIdColumn = this.customerTable.getColumnModel().getColumn(0);
            TableColumn nameColumn = this.customerTable.getColumnModel().getColumn(1);
            TableColumn genderColumn = this.customerTable.getColumnModel().getColumn(2);
            TableColumn levelColumn = this.customerTable.getColumnModel().getColumn(3);
            TableColumn birthdayColumn = this.customerTable.getColumnModel().getColumn(4);
            TableColumn idNumColumn = this.customerTable.getColumnModel().getColumn(5);
            TableColumn passNumColumn = this.customerTable.getColumnModel().getColumn(6);
            TableColumn phoneColumn = this.customerTable.getColumnModel().getColumn(7);
            strIdColumn.setCellRenderer(centerRenderer);
            genderColumn.setCellRenderer(centerRenderer);
            levelColumn.setCellRenderer(centerRenderer);
            birthdayColumn.setCellRenderer(centerRenderer);
            idNumColumn.setCellRenderer(centerRenderer);
            passNumColumn.setCellRenderer(centerRenderer);
            genderColumn.setPreferredWidth(50);
            nameColumn.setPreferredWidth(150);
            phoneColumn.setPreferredWidth(300);
            JTableHeader th = this.customerTable.getTableHeader();
            th.setPreferredSize(new Dimension(0, 28));
            x.add((Component)new JScrollPane(this.customerTable), "Center");
            JPanel buttonPanel = new JPanel();
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            buttonPanel.setLayout(new FlowLayout(1, 5, 5));
            centerPanel.add((Component)buttonPanel, "South");
            this.btnSubmit = new JButton();
            this.btnSubmit.setEnabled(false);
            this.btnSubmit.setCursor(Cursor.getPredefinedCursor(12));
            this.btnSubmit.setText(I18NUtil.getString("home_Btn_customer_select"));
            buttonPanel.add(this.btnSubmit);
            this.btnSubmit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchCustomerDialog.this.handleSubmit();
                }
            });
            JButton btnClose = new JButton();
            btnClose.setCursor(Cursor.getPredefinedCursor(12));
            btnClose.setText(I18NUtil.getString("home_Btn_customer_close"));
            buttonPanel.add(btnClose);
            btnClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchCustomerDialog.this.dispose();
                }
            });
        }
        catch (Exception e2) {
            Log.e(ModifyCustomerDialog.class.getName(), "ERROR:" + e2.getMessage(), e2);
        }
    }

    public void handleSubmit() {
        int selectedRow = this.customerTable.getSelectedRow();
        CustomerItem item = this.customerTableModel.getItem(selectedRow);
        BroadcastUtil.sendDetermineCustomerEvent(UCChatClient.context, this.mUuid, item.getDetail());
        this.dispose();
    }

    public void showDialog() {
        this.setVisible(true);
    }
}

