/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.customer;

import com.blisscloud.ezuc.client.cc.Application;
import com.blisscloud.ezuc.client.chat.MessageArea;
import com.blisscloud.ezuc.client.customer.BizPanel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Log;
import java.net.CookieHandler;
import java.net.CookieManager;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;

public class UrlBizPanel
extends JFXPanel
implements BizPanel {
    private Application mApp;
    private String mUrl;
    private BorderPane borderPane;
    private WebView webView;
    private WebEngine webEngine;
    private static int xx = 0;
    private int x = -1;

    public UrlBizPanel(Application app, String url) {
        this.mApp = app;
        this.mUrl = url;
        this.x = xx++;
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                UrlBizPanel.this.initJavaFXComponent();
            }
        });
    }

    protected void initJavaFXComponent() {
        this.webView = new WebView();
        this.borderPane = new BorderPane();
        this.borderPane.setCenter((Node)this.webView);
        StackPane s = new StackPane();
        s.getChildren().add(this.borderPane);
        Scene scene = new Scene((Parent)s);
        this.setScene(scene);
        this.webEngine = this.webView.getEngine();
        this.webEngine.getLoadWorker().stateProperty().addListener((obs, oldState, newState) -> {
            if (newState != Worker.State.SUCCEEDED) {
                if (newState == Worker.State.FAILED) {
                    String currentUrl = this.webEngine.getLocation();
                    Throwable exception = this.webEngine.getLoadWorker().getException();
                    ToastUtil.showErrorLong(String.format(I18NUtil.getString("home_biz_phone_url_failed"), exception != null ? exception.getMessage() : "NA"));
                    Log.e(UrlBizPanel.class.getSimpleName(), "Page load failed! url:" + currentUrl + ", reason:" + String.valueOf(exception) != null ? exception.getMessage() : "NA");
                } else if (newState == Worker.State.CANCELLED) {
                    Log.e(UrlBizPanel.class.getSimpleName(), "Page load cancelled!");
                }
            }
        });
        this.webEngine.load(this.mUrl);
    }

    @Override
    public void onClose() {
        try {
            if (this.webEngine != null) {
                final WebEngine xEngine = this.webEngine;
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        xEngine.load("about:blank");
                        CookieHandler.setDefault(new CookieManager());
                    }
                });
            }
            this.borderPane = null;
            this.webView = null;
            this.webEngine = null;
        }
        catch (Throwable t) {
            Log.i(MessageArea.class.getSimpleName(), t.getMessage(), t);
        }
    }
}

