/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.fax;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.component.UCUploadFileChooser;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.FileUploadException;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.ChatActionUtil;
import com.blisscloud.mobile.ezuc.bean.FaxTransferInfo;
import com.blisscloud.mobile.ezuc.callback.FaxSubmitListener;
import com.blisscloud.mobile.ezuc.connection.file.FaxTransferConnection;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import java.awt.Component;
import java.io.File;
import javax.swing.JOptionPane;

public class FaxActionUtil
extends ChatActionUtil {
    public static final int UPLOAD_FAX_MAX_SIZE = 0x1400000;

    public static void uploadFax(FaxTransferInfo faxTransferInfo, Component comp) {
        File file = faxTransferInfo.getFile();
        if (!file.exists()) {
            Log.e(FileUtil.class.getSimpleName(), "file " + file.getAbsolutePath() + " does not exist!");
            JOptionPane.showMessageDialog(comp, I18NUtil.getString("media_upload_failed_not_found"), I18NUtil.getString("common_title_error"), 0);
            return;
        }
        String fileExt = FileUtil.getFileExtension(file);
        if (!UCUploadFileChooser.FAX_TYPES.contains(fileExt)) {
            JOptionPane.showMessageDialog(comp, I18NUtil.getString("media_upload_failed_type_unsupported"), I18NUtil.getString("common_title_error"), 0);
            return;
        }
        long fileSize = file.length();
        if (fileSize > 0x1400000L) {
            JOptionPane.showMessageDialog(comp, String.format(I18NUtil.getString("chat_validation_doc_maxsize"), FileUtil.convertFileSizeDisplay(0x1400000L)), I18NUtil.getString("common_title_error"), 0);
            return;
        }
        if (FaxActionUtil.uploadFaxInternal(faxTransferInfo, comp)) {
            ToastUtil.showLong(I18NUtil.getString("fax_msg_submitting"));
        } else {
            JOptionPane.showMessageDialog(comp, I18NUtil.getString("media_upload_failed_general"), I18NUtil.getString("common_title_error"), 0);
        }
    }

    private static boolean uploadFaxInternal(FaxTransferInfo faxTransferInfo, Component comp) throws FileUploadException {
        try {
            Activity context = UCChatClient.context;
            FaxSubmitListener faxListener = new FaxSubmitListener(comp);
            FaxTransferConnection ftConn = new FaxTransferConnection(context);
            ftConn.setCallBack(faxListener);
            ftConn.uploadFile(faxTransferInfo);
            return true;
        }
        catch (Exception e) {
            Log.e(FileUtil.class.getSimpleName(), e.getLocalizedMessage(), e);
            return false;
        }
    }
}

