/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.fax;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.chat.SelectFileHandler;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.mobile.ezuc.util.FaxSelectionCallback;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class FaxDropper
extends DropTargetAdapter {
    private FaxSelectionCallback callback = null;
    private Component comp = null;

    public FaxDropper(FaxSelectionCallback callback, Component comp) {
        this.callback = callback;
        this.comp = comp;
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            if (PreferencesUtil.isSyncDataNow(UCChatClient.context)) {
                dtde.dropComplete(false);
                return;
            }
            dtde.acceptDrop(3);
            Transferable trans = dtde.getTransferable();
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List files = (List)trans.getTransferData(DataFlavor.javaFileListFlavor);
                final ArrayList<File> targetFileList = new ArrayList<File>();
                for (File file : files) {
                    long fileSize = file.length();
                    if (fileSize > 0x1400000L) {
                        JOptionPane.showMessageDialog(this.comp, String.format(I18NUtil.getString("chat_validation_doc_maxsize"), FileUtil.convertFileSizeDisplay(0x1400000L)), I18NUtil.getString("common_title_error"), 0);
                        return;
                    }
                    targetFileList.add(file);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SelectFileHandler.handleSelectedFileForFax(targetFileList, null, FaxDropper.this.callback);
                    }
                });
            } else if (dtde.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                Image image = (Image)trans.getTransferData(DataFlavor.imageFlavor);
                SelectFileHandler.handleSelectedFileForFax(image, null, this.callback);
            }
            dtde.dropComplete(true);
        }
        catch (Exception e1) {
            dtde.dropComplete(false);
            e1.printStackTrace();
        }
    }
}

