/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.fax;

import com.blisscloud.ezuc.bean.web.LiteFaxDoc;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.chat.DownloadFileTask;
import com.blisscloud.ezuc.client.chat.DownloadFileTaskCallBack;
import com.blisscloud.ezuc.client.component.EntryPanel;
import com.blisscloud.ezuc.client.fax.FaxEntryParameter;
import com.blisscloud.ezuc.client.main.SelectChatroomDialog;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.tool.PhoneListBorder;
import com.blisscloud.ezuc.client.util.DateTimeUtil;
import com.blisscloud.ezuc.client.util.FaxUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.ChatActionUtil;
import com.blisscloud.mobile.ezuc.agent.ChatReceiver;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.manager.task.MarkFaxRemoteReadTask;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.MediaFileUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.commons.lang3.StringUtils;

public class FaxHistoryEntryPanel
extends JPanel {
    private static final long serialVersionUID = -8073511014432646353L;
    public static final int ENTRY_HEIGHT = 50;
    private JLabel lblNew;
    private JLabel lblDirection;
    private JLabel lblTime;
    private JLabel lblStatus;
    private JLabel lblNumber;
    private JLabel lblTiff;
    private JLabel lblOriginal;
    private JLabel lblError;
    private JLabel lblSuffix;
    private JProgressBar pbDownload;
    private JLabel lblCancelDownload;
    private boolean selected;
    private LiteFaxDoc mFaxDoc;
    private DownloadFileTask downloadTask = null;
    private MouseListener mouseListener = null;
    private FaxEntryParameter faxEntryParameter;

    public FaxHistoryEntryPanel(LiteFaxDoc faxDoc, FaxEntryParameter faxEntryParameter) {
        this.mFaxDoc = faxDoc;
        this.faxEntryParameter = faxEntryParameter;
        this.initGui();
        this.initData();
    }

    public LiteFaxDoc getDoc() {
        return this.mFaxDoc;
    }

    public long getId() {
        return this.mFaxDoc.getId();
    }

    public String getNumberToDial() {
        return this.lblNumber.getText();
    }

    private void initGui() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new PhoneListBorder());
        this.setBackground(EntryPanel.ENTRY_BACKGROUND);
        this.setPreferredSize(new Dimension(1200, 50));
        this.setMinimumSize(new Dimension(1200, 50));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 60));
        this.setOpaque(false);
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (SwingUtilities.isLeftMouseButton(evt)) {
                    try {
                        FaxHistoryEntryPanel.this.displayTiff();
                    }
                    catch (Exception ex) {
                        Log.e(FaxHistoryEntryPanel.class.getSimpleName(), "ERROR:" + ex.getMessage());
                    }
                }
            }
        };
        int x = 0;
        this.lblNew = new JLabel();
        this.add((Component)this.lblNew, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.lblNew.setPreferredSize(new Dimension(30, 30));
        this.lblNew.setMaximumSize(new Dimension(30, 30));
        this.lblNew.setMinimumSize(new Dimension(30, 30));
        this.lblDirection = new JLabel();
        this.add((Component)this.lblDirection, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.lblDirection.setPreferredSize(new Dimension(30, 30));
        this.lblDirection.setMaximumSize(new Dimension(30, 30));
        this.lblDirection.setMinimumSize(new Dimension(30, 30));
        this.lblStatus = new JLabel();
        this.add((Component)this.lblStatus, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        this.lblStatus.setFont(UIConstants.FONT_14_PLAIN);
        this.lblStatus.setPreferredSize(new Dimension(90, 50));
        this.lblStatus.setMaximumSize(new Dimension(90, 50));
        this.lblStatus.setMinimumSize(new Dimension(90, 50));
        this.lblNumber = new JLabel();
        this.add((Component)this.lblNumber, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        this.lblNumber.setFont(UIConstants.FONT_14_PLAIN);
        this.lblNumber.setPreferredSize(new Dimension(120, 50));
        this.lblNumber.setMaximumSize(new Dimension(120, 50));
        this.lblNumber.setMinimumSize(new Dimension(120, 50));
        this.lblTiff = new JLabel();
        this.add((Component)this.lblTiff, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        this.lblTiff.setFont(UIConstants.FONT_14_PLAIN);
        this.lblTiff.setPreferredSize(new Dimension(100, 50));
        this.lblTiff.setMaximumSize(new Dimension(100, 50));
        this.lblTiff.setMinimumSize(new Dimension(100, 50));
        this.lblOriginal = new JLabel();
        this.add((Component)this.lblOriginal, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        this.lblOriginal.setFont(UIConstants.FONT_14_PLAIN);
        this.lblOriginal.setPreferredSize(new Dimension(100, 50));
        this.lblOriginal.setMaximumSize(new Dimension(100, 50));
        this.lblOriginal.setMinimumSize(new Dimension(100, 50));
        this.lblOriginal.setCursor(UIConstants.CURSOR_HAND);
        this.lblOriginal.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (SwingUtilities.isLeftMouseButton(evt)) {
                    try {
                        FaxHistoryEntryPanel.this.displayOriginal();
                    }
                    catch (Exception e) {
                        Log.e(FaxHistoryEntryPanel.class.getSimpleName(), "ERROR:" + e.getMessage());
                    }
                }
            }
        });
        this.lblTime = new JLabel();
        this.add((Component)this.lblTime, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        this.lblTime.setFont(UIConstants.FONT_14_PLAIN);
        this.lblTime.setPreferredSize(new Dimension(110, 50));
        this.lblTime.setMaximumSize(new Dimension(110, 50));
        this.lblTime.setMinimumSize(new Dimension(110, 50));
        this.lblTime.setHorizontalAlignment(4);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setOpaque(false);
        this.add((Component)panel, new GridBagConstraints(x++, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        this.pbDownload = new JProgressBar();
        panel.add((Component)this.pbDownload, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.pbDownload.setMinimum(0);
        this.pbDownload.setMaximum(100);
        this.pbDownload.setValue(0);
        this.pbDownload.setStringPainted(true);
        this.pbDownload.setPreferredSize(new Dimension(100, 25));
        this.pbDownload.setMinimumSize(new Dimension(100, 25));
        this.pbDownload.setVisible(false);
        this.lblCancelDownload = new JLabel();
        panel.add((Component)this.lblCancelDownload, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        this.lblCancelDownload.setFont(UIConstants.FONT_14_PLAIN);
        this.lblCancelDownload.setPreferredSize(new Dimension(16, 16));
        this.lblCancelDownload.setMaximumSize(new Dimension(16, 16));
        this.lblCancelDownload.setMinimumSize(new Dimension(16, 16));
        this.lblCancelDownload.setIcon(GraphicUtil.getScaledIcon("images/message/cancelDownload.png", 16, 16));
        this.lblCancelDownload.setVisible(false);
        this.lblCancelDownload.setCursor(UIConstants.CURSOR_HAND);
        this.lblCancelDownload.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                try {
                    if (FaxHistoryEntryPanel.this.downloadTask != null) {
                        FaxHistoryEntryPanel.this.downloadTask.cancel();
                        FaxHistoryEntryPanel.this.downloadTask = null;
                    }
                }
                catch (Exception e) {
                    Log.e(FaxHistoryEntryPanel.class.getSimpleName(), "ERROR:" + e.getMessage());
                }
            }
        });
        this.lblError = new JLabel();
        panel.add((Component)this.lblError, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        this.lblError.setFont(UIConstants.FONT_14_PLAIN);
        this.lblError.setPreferredSize(new Dimension(400, 50));
        this.lblError.setMaximumSize(new Dimension(400, 50));
        this.lblError.setMinimumSize(new Dimension(400, 50));
        this.lblError.setForeground(Color.RED);
        this.lblSuffix = new JLabel();
        this.add((Component)this.lblSuffix, new GridBagConstraints(x++, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        this.lblSuffix.setFont(UIConstants.FONT_14_PLAIN);
    }

    public boolean canResend() {
        return this.mFaxDoc.getDirection() == 1 && (this.mFaxDoc.getStatus() == 5 || this.mFaxDoc.getStatus() == 6 || this.mFaxDoc.getStatus() == 8);
    }

    public boolean canCancel() {
        return this.mFaxDoc.getDirection() == 1 && this.mFaxDoc.getStatus() != 3 && this.mFaxDoc.getStatus() != 5 && this.mFaxDoc.getStatus() != 6 && this.mFaxDoc.getStatus() != 8;
    }

    public boolean canDelete() {
        return this.mFaxDoc.getDirection() == 0 || this.mFaxDoc.getStatus() == 3 || this.mFaxDoc.getStatus() == 5 || this.mFaxDoc.getStatus() == 6 || this.mFaxDoc.getStatus() == 8;
    }

    private void displayOriginal() throws Exception {
        if (this.mFaxDoc.getDirection() == 0) {
            String fileName;
            File faxDir;
            File cacheFile;
            if (this.mFaxDoc.getPdfFileSize() == 0L || StringUtils.isBlank((CharSequence)this.mFaxDoc.getPdfFilePath())) {
                Log.w(FaxHistoryEntryPanel.class.getSimpleName(), "pdf file is not ready!");
                return;
            }
            if (!this.mFaxDoc.isReadFlag()) {
                MarkFaxRemoteReadTask t = new MarkFaxRemoteReadTask((Context)UCChatClient.context, this.mFaxDoc.getId());
                TaskController.getInstance().addTask(t);
                t.start();
            }
            if ((cacheFile = new File(faxDir = MediaFileUtil.getFaxRoot(UCChatClient.context), fileName = this.getFaxPdfFileName(this.mFaxDoc))).exists()) {
                Desktop.getDesktop().open(cacheFile);
            } else {
                this.downloadAndOpenPdfFile(cacheFile, this.mFaxDoc);
            }
        } else {
            if (this.mFaxDoc.getOriginalFileSize() == 0L || StringUtils.isBlank((CharSequence)this.mFaxDoc.getOriginalDownloadPath())) {
                Log.w(FaxHistoryEntryPanel.class.getSimpleName(), "original file is not ready!");
                return;
            }
            File cacheFile = this.getOriginalCacheFile(this.mFaxDoc);
            if (cacheFile.exists() && cacheFile.length() == this.mFaxDoc.getOriginalFileSize()) {
                Desktop.getDesktop().open(cacheFile);
            } else {
                this.downloadAndOpenOriginalFile(cacheFile, this.mFaxDoc);
            }
        }
    }

    private void downloadAndOpenOriginalFile(File cacheFile, LiteFaxDoc faxDoc) {
        String fileDownloadURL = faxDoc.getOriginalDownloadPath();
        String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + fileDownloadURL.substring(fileDownloadURL.indexOf("/ucrm"));
        newURL = PreferencesUtil.isInOffice(UCChatClient.context) ? newURL + "&inOffice=true" : newURL + "&inOffice=false";
        if (this.pbDownload != null) {
            this.pbDownload.setValue(0);
            this.pbDownload.setVisible(true);
        }
        if (this.lblCancelDownload != null) {
            this.lblCancelDownload.setVisible(true);
        }
        this.downloadTask = new DownloadFileTask(UCChatClient.context, newURL, cacheFile, faxDoc.getOriginalFileSize(), new DownloadOpenTaskCallBack(cacheFile));
        this.downloadTask.start();
    }

    private void displayTiff() throws Exception {
        String fileName;
        File faxDir;
        File cacheFile;
        if (this.mFaxDoc.getFileSize() == 0L || StringUtils.isBlank((CharSequence)this.mFaxDoc.getFilePath())) {
            Log.w(FaxHistoryEntryPanel.class.getSimpleName(), "tiff file is not ready!");
            return;
        }
        if (!this.mFaxDoc.isReadFlag()) {
            MarkFaxRemoteReadTask t = new MarkFaxRemoteReadTask((Context)UCChatClient.context, this.mFaxDoc.getId());
            TaskController.getInstance().addTask(t);
            t.start();
        }
        if ((cacheFile = new File(faxDir = MediaFileUtil.getFaxRoot(UCChatClient.context), fileName = this.getFaxFileName(this.mFaxDoc))).exists()) {
            Desktop.getDesktop().open(cacheFile);
        } else {
            this.downloadAndOpenFile(cacheFile, this.mFaxDoc);
        }
    }

    private String getFaxFileName(LiteFaxDoc faxDoc) {
        SimpleDateFormat timeformatter = new SimpleDateFormat("yyyyMMddHHmm");
        return "Fax-" + faxDoc.getId() + "-" + timeformatter.format(new Date(this.mFaxDoc.getCreateTime())) + ".tiff";
    }

    private String getFaxPdfFileName(LiteFaxDoc faxDoc) {
        SimpleDateFormat timeformatter = new SimpleDateFormat("yyyyMMddHHmm");
        return "Fax-" + faxDoc.getId() + "-" + timeformatter.format(new Date(this.mFaxDoc.getCreateTime())) + ".pdf";
    }

    private void downloadAndOpenFile(File cacheFile, LiteFaxDoc faxDoc) {
        String fileDownloadURL = faxDoc.getFilePath();
        String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + fileDownloadURL.substring(fileDownloadURL.indexOf("/ucrm"));
        newURL = PreferencesUtil.isInOffice(UCChatClient.context) ? newURL + "&inOffice=true" : newURL + "&inOffice=false";
        if (this.pbDownload != null) {
            this.pbDownload.setValue(0);
            this.pbDownload.setVisible(true);
        }
        if (this.lblCancelDownload != null) {
            this.lblCancelDownload.setVisible(true);
        }
        this.downloadTask = new DownloadFileTask(UCChatClient.context, newURL, cacheFile, faxDoc.getFileSize(), new DownloadOpenTaskCallBack(cacheFile));
        this.downloadTask.start();
    }

    private void downloadAndOpenPdfFile(File cacheFile, LiteFaxDoc faxDoc) {
        String fileDownloadURL = faxDoc.getPdfFilePath();
        String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + fileDownloadURL.substring(fileDownloadURL.indexOf("/ucrm"));
        newURL = PreferencesUtil.isInOffice(UCChatClient.context) ? newURL + "&inOffice=true" : newURL + "&inOffice=false";
        if (this.pbDownload != null) {
            this.pbDownload.setValue(0);
            this.pbDownload.setVisible(true);
        }
        if (this.lblCancelDownload != null) {
            this.lblCancelDownload.setVisible(true);
        }
        this.downloadTask = new DownloadFileTask(UCChatClient.context, newURL, cacheFile, faxDoc.getPdfFileSize(), new DownloadOpenTaskCallBack(cacheFile));
        this.downloadTask.start();
    }

    private void downloadAndForwardFaxTiff(File cacheFile, LiteFaxDoc faxDoc, List<String> selectedJids) {
        String fileDownloadURL = faxDoc.getFilePath();
        String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + fileDownloadURL.substring(fileDownloadURL.indexOf("/ucrm"));
        newURL = PreferencesUtil.isInOffice(UCChatClient.context) ? newURL + "&inOffice=true" : newURL + "&inOffice=false";
        if (this.pbDownload != null) {
            this.pbDownload.setValue(0);
            this.pbDownload.setVisible(true);
        }
        if (this.lblCancelDownload != null) {
            this.lblCancelDownload.setVisible(true);
        }
        this.downloadTask = new DownloadFileTask(UCChatClient.context, newURL, cacheFile, faxDoc.getFileSize(), new DownloadForwardTaskCallBack(cacheFile, selectedJids));
        this.downloadTask.start();
    }

    private void downloadAndForwardFaxPdf(File cacheFile, LiteFaxDoc faxDoc, List<String> selectedJids) {
        String fileDownloadURL = faxDoc.getPdfFilePath();
        String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + fileDownloadURL.substring(fileDownloadURL.indexOf("/ucrm"));
        newURL = PreferencesUtil.isInOffice(UCChatClient.context) ? newURL + "&inOffice=true" : newURL + "&inOffice=false";
        if (this.pbDownload != null) {
            this.pbDownload.setValue(0);
            this.pbDownload.setVisible(true);
        }
        if (this.lblCancelDownload != null) {
            this.lblCancelDownload.setVisible(true);
        }
        this.downloadTask = new DownloadFileTask(UCChatClient.context, newURL, cacheFile, faxDoc.getPdfFileSize(), new DownloadForwardTaskCallBack(cacheFile, selectedJids));
        this.downloadTask.start();
    }

    private void downloadAndForwardFaxOrg(File cacheFile, LiteFaxDoc faxDoc, List<String> selectedJids) {
        String fileDownloadURL = faxDoc.getOriginalDownloadPath();
        String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + fileDownloadURL.substring(fileDownloadURL.indexOf("/ucrm"));
        newURL = PreferencesUtil.isInOffice(UCChatClient.context) ? newURL + "&inOffice=true" : newURL + "&inOffice=false";
        if (this.pbDownload != null) {
            this.pbDownload.setValue(0);
            this.pbDownload.setVisible(true);
        }
        if (this.lblCancelDownload != null) {
            this.lblCancelDownload.setVisible(true);
        }
        this.downloadTask = new DownloadFileTask(UCChatClient.context, newURL, cacheFile, faxDoc.getOriginalFileSize(), new DownloadForwardTaskCallBack(cacheFile, selectedJids));
        this.downloadTask.start();
    }

    private void downloadAndSaveAsFaxTiff(File cacheFile, File saveAsFile, LiteFaxDoc item) {
        String fileDownloadURL = item.getFilePath();
        String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + fileDownloadURL.substring(fileDownloadURL.indexOf("/ucrm"));
        newURL = PreferencesUtil.isInOffice(UCChatClient.context) ? newURL + "&inOffice=true" : newURL + "&inOffice=false";
        if (this.pbDownload != null) {
            this.pbDownload.setValue(0);
            this.pbDownload.setVisible(true);
        }
        if (this.lblCancelDownload != null) {
            this.lblCancelDownload.setVisible(true);
        }
        this.downloadTask = new DownloadFileTask(UCChatClient.context, newURL, cacheFile, item.getFileSize(), new DownloadSaveAsTaskCallBack(cacheFile, saveAsFile));
        this.downloadTask.start();
    }

    private void downloadAndSaveAsFaxPdf(File cacheFile, File saveAsFile, LiteFaxDoc item) {
        String fileDownloadURL = item.getPdfFilePath();
        String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + fileDownloadURL.substring(fileDownloadURL.indexOf("/ucrm"));
        newURL = PreferencesUtil.isInOffice(UCChatClient.context) ? newURL + "&inOffice=true" : newURL + "&inOffice=false";
        if (this.pbDownload != null) {
            this.pbDownload.setValue(0);
            this.pbDownload.setVisible(true);
        }
        if (this.lblCancelDownload != null) {
            this.lblCancelDownload.setVisible(true);
        }
        this.downloadTask = new DownloadFileTask(UCChatClient.context, newURL, cacheFile, item.getPdfFileSize(), new DownloadSaveAsTaskCallBack(cacheFile, saveAsFile));
        this.downloadTask.start();
    }

    private void downloadAndSaveAsFaxOrg(File cacheFile, File saveAsFile, LiteFaxDoc item) {
        String fileDownloadURL = item.getOriginalDownloadPath();
        String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + fileDownloadURL.substring(fileDownloadURL.indexOf("/ucrm"));
        newURL = PreferencesUtil.isInOffice(UCChatClient.context) ? newURL + "&inOffice=true" : newURL + "&inOffice=false";
        if (this.pbDownload != null) {
            this.pbDownload.setValue(0);
            this.pbDownload.setVisible(true);
        }
        if (this.lblCancelDownload != null) {
            this.lblCancelDownload.setVisible(true);
        }
        this.downloadTask = new DownloadFileTask(UCChatClient.context, newURL, cacheFile, item.getOriginalFileSize(), new DownloadSaveAsTaskCallBack(cacheFile, saveAsFile));
        this.downloadTask.start();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean b) {
        this.selected = b;
        this.setBackground(EntryPanel.ENTRY_BACKGROUND);
        this.setOpaque(this.selected);
        this.revalidate();
        this.repaint();
    }

    public void setMenuDisplayed(boolean b) {
        if (!this.selected) {
            this.setBackground(EntryPanel.ENTRY_MENU_DISPLAYED_BACKGROUND);
            this.setOpaque(b);
        }
        this.revalidate();
        this.repaint();
    }

    public void updateFaxHistory(LiteFaxDoc faxDoc, FaxEntryParameter faxEntryParameter) {
        this.mFaxDoc = faxDoc;
        this.faxEntryParameter = faxEntryParameter;
        this.initData();
    }

    private void initData() {
        this.lblTiff.removeMouseListener(this.mouseListener);
        this.lblTime.setText(DateTimeUtil.getTimeStr(this.mFaxDoc.getCreateTime(), true));
        int wwidth = this.faxEntryParameter.getMaxTimeLength() + 2;
        this.lblTime.setPreferredSize(new Dimension(wwidth, 50));
        this.lblTime.setMaximumSize(new Dimension(wwidth, 50));
        this.lblTime.setMinimumSize(new Dimension(wwidth, 50));
        int origLength = this.faxEntryParameter.getMaxOrigSizeLength() + 36 + this.lblOriginal.getIconTextGap() + 2;
        this.lblOriginal.setPreferredSize(new Dimension(origLength, 50));
        this.lblOriginal.setMaximumSize(new Dimension(origLength, 50));
        this.lblOriginal.setMinimumSize(new Dimension(origLength, 50));
        int tiffLength = this.faxEntryParameter.getMaxTiffSizeLength() + 36 + this.lblOriginal.getIconTextGap() + 2;
        this.lblTiff.setPreferredSize(new Dimension(tiffLength, 50));
        this.lblTiff.setMaximumSize(new Dimension(tiffLength, 50));
        this.lblTiff.setMinimumSize(new Dimension(tiffLength, 50));
        int statusLength = 36 + this.faxEntryParameter.getMaxStatusLength() + 2;
        this.lblStatus.setPreferredSize(new Dimension(statusLength, 50));
        this.lblStatus.setMaximumSize(new Dimension(statusLength, 50));
        this.lblStatus.setMinimumSize(new Dimension(statusLength, 50));
        int PhoneNumberLength = this.faxEntryParameter.getMaxPhoneNumberLength() + 2;
        this.lblNumber.setPreferredSize(new Dimension(PhoneNumberLength, 50));
        this.lblNumber.setMaximumSize(new Dimension(PhoneNumberLength, 50));
        this.lblNumber.setMinimumSize(new Dimension(PhoneNumberLength, 50));
        int errorLength = this.faxEntryParameter.getMaxErrorLength() + 2;
        this.lblError.setPreferredSize(new Dimension(errorLength, 50));
        this.lblError.setMaximumSize(new Dimension(errorLength, 50));
        this.lblError.setMinimumSize(new Dimension(errorLength, 50));
        int maxLength = 200 + this.faxEntryParameter.getTotalMax() + (36 + this.lblOriginal.getIconTextGap() + 2) * 2 + 6 + 100;
        this.setPreferredSize(new Dimension(maxLength, 50));
        this.setMinimumSize(new Dimension(maxLength, 50));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 60));
        if (this.mFaxDoc.getDirection() == 0) {
            this.lblDirection.setIcon(UIConstants.ICON_FAX_IN);
        } else {
            this.lblDirection.setIcon(UIConstants.ICON_FAX_OUT);
        }
        if (this.mFaxDoc.getDirection() == 0) {
            if (!this.mFaxDoc.isReadFlag()) {
                this.lblNew.setIcon(UIConstants.ICON_HISTORY_LIST_UNREAD);
            } else {
                this.lblNew.setIcon(null);
            }
            String statusText = I18NUtil.getString("fax_status_received_success");
            String phoneNum = this.mFaxDoc.getPhoneNumber() == null ? "" : this.mFaxDoc.getPhoneNumber();
            this.lblStatus.setText(statusText);
            this.lblNumber.setText(phoneNum);
            this.lblTiff.setText(FileUtil.convertFileSizeDisplay(this.mFaxDoc.getFileSize()));
            this.lblTiff.setCursor(UIConstants.CURSOR_HAND);
            this.lblTiff.setIcon(UIConstants.ICON_TIFF);
            this.lblTiff.addMouseListener(this.mouseListener);
            if (this.mFaxDoc.getPdfFileSize() != 0L) {
                this.lblOriginal.setText(FileUtil.convertFileSizeDisplay(this.mFaxDoc.getPdfFileSize()));
                URL url = UIConstants.getFaxIconURI("*.pdf");
                if (url != null) {
                    this.lblOriginal.setIcon(new ImageIcon(url));
                    this.lblOriginal.setCursor(UIConstants.CURSOR_HAND);
                }
            } else {
                this.lblOriginal.setIcon(null);
            }
        } else {
            boolean failedToSend = false;
            if (this.mFaxDoc.getStatus() == 3 || this.mFaxDoc.getStatus() == 5) {
                failedToSend = true;
            }
            String statusText = FaxUtil.getFaxOutMsg(this.mFaxDoc.getStatus());
            String phoneNum = this.mFaxDoc.getPhoneNumber() == null ? "" : this.mFaxDoc.getPhoneNumber();
            this.lblStatus.setText(statusText);
            this.lblNumber.setText(phoneNum);
            if (failedToSend) {
                this.lblStatus.setForeground(Color.RED);
            } else {
                this.lblStatus.setForeground(Color.BLACK);
            }
            if (this.mFaxDoc.getFileSize() != 0L) {
                this.lblTiff.setText(FileUtil.convertFileSizeDisplay(this.mFaxDoc.getFileSize()));
                this.lblTiff.setIcon(UIConstants.ICON_TIFF);
                this.lblTiff.setCursor(UIConstants.CURSOR_HAND);
                this.lblTiff.addMouseListener(this.mouseListener);
            } else {
                this.lblTiff.setIcon(null);
                this.lblTiff.setCursor(null);
            }
            if (this.mFaxDoc.getOriginalFileSize() != 0L) {
                this.lblOriginal.setText(FileUtil.convertFileSizeDisplay(this.mFaxDoc.getOriginalFileSize()));
                URL url = this.getFaxIconURI(this.mFaxDoc.getOriginalFileName());
                if (url != null) {
                    this.lblOriginal.setIcon(new ImageIcon(url));
                }
                this.lblOriginal.setToolTipText(this.mFaxDoc.getOriginalFileName());
            } else {
                this.lblOriginal.setIcon(null);
            }
            if (this.mFaxDoc.getStatus() == 6) {
                int page = this.mFaxDoc.getFaxPages();
                long timestent = this.mFaxDoc.getFaxTimeSpent() / 1000L;
                this.lblError.setForeground(Color.BLACK);
                this.lblError.setText(String.format(I18NUtil.getString("fax_success_timespent"), page != 0 ? String.valueOf(page) : "n", timestent));
            } else {
                int retryCount = this.mFaxDoc.getFaxRetryCount();
                int errorCode = this.mFaxDoc.getErrorCode();
                if (errorCode != 0) {
                    String errorDescr = "(" + errorCode + ") " + String.format(I18NUtil.getString("fax_error_code_" + errorCode), new Object[0]);
                    String fullErrorText = null;
                    fullErrorText = retryCount > 0 ? (retryCount == 1 ? String.format(I18NUtil.getString("fax_error_disp_single"), retryCount, errorDescr) : String.format(I18NUtil.getString("fax_error_disp"), retryCount, errorDescr)) : String.format(I18NUtil.getString("fax_error_disp_single"), 1, errorDescr);
                    this.lblError.setForeground(Color.RED);
                    this.lblError.setText(fullErrorText);
                } else {
                    this.lblError.setText("");
                }
            }
        }
    }

    private URL getFaxIconURI(String fileName) {
        URL uri = UIConstants.getFaxIconURI(fileName);
        if (uri != null) {
            return uri;
        }
        return UIConstants.getDefaultFaxIconURI();
    }

    public void handleFowardTiff() {
        SelectChatroomDialog scd = new SelectChatroomDialog(UCChatClient.getInstance());
        scd.setLocationRelativeTo(UCChatClient.getInstance().getMainPanel());
        SelectChatroomDialog.SelectChatroomResult result = scd.showDialog();
        if (result == null) {
            return;
        }
        List<String> selectedJids = result.getChatroomJids();
        if (selectedJids == null || selectedJids.size() == 0) {
            return;
        }
        Log.i(FaxHistoryEntryPanel.class.getSimpleName(), "handleFoward : id " + this.mFaxDoc.getId());
        File faxDir = MediaFileUtil.getFaxRoot(UCChatClient.context);
        String fileName = this.getFaxFileName(this.mFaxDoc);
        File cacheFile = new File(faxDir, fileName);
        if (cacheFile.exists()) {
            ArrayList<ChatReceiver> chatReceiverList = new ArrayList<ChatReceiver>();
            for (String receiverJid : selectedJids) {
                chatReceiverList.add(new ChatReceiver(receiverJid));
            }
            ChatActionUtil.uploadFile(chatReceiverList, cacheFile, true, null, this);
        } else {
            this.downloadAndForwardFaxTiff(cacheFile, this.mFaxDoc, selectedJids);
        }
    }

    public void handleFowardPdf() {
        SelectChatroomDialog scd = new SelectChatroomDialog(UCChatClient.getInstance());
        scd.setLocationRelativeTo(UCChatClient.getInstance().getMainPanel());
        SelectChatroomDialog.SelectChatroomResult result = scd.showDialog();
        if (result == null) {
            return;
        }
        List<String> selectedJids = result.getChatroomJids();
        if (selectedJids == null || selectedJids.size() == 0) {
            return;
        }
        Log.i(FaxHistoryEntryPanel.class.getSimpleName(), "handleFoward : id " + this.mFaxDoc.getId());
        File faxDir = MediaFileUtil.getFaxRoot(UCChatClient.context);
        String fileName = this.getFaxPdfFileName(this.mFaxDoc);
        File cacheFile = new File(faxDir, fileName);
        if (cacheFile.exists()) {
            ArrayList<ChatReceiver> chatReceiverList = new ArrayList<ChatReceiver>();
            for (String receiverJid : selectedJids) {
                chatReceiverList.add(new ChatReceiver(receiverJid));
            }
            ChatActionUtil.uploadFile(chatReceiverList, cacheFile, true, null, this);
        } else {
            this.downloadAndForwardFaxPdf(cacheFile, this.mFaxDoc, selectedJids);
        }
    }

    public void handleFowardOrg() {
        SelectChatroomDialog scd = new SelectChatroomDialog(UCChatClient.getInstance());
        scd.setLocationRelativeTo(UCChatClient.getInstance().getMainPanel());
        SelectChatroomDialog.SelectChatroomResult result = scd.showDialog();
        if (result == null) {
            return;
        }
        List<String> selectedJids = result.getChatroomJids();
        if (selectedJids == null || selectedJids.size() == 0) {
            return;
        }
        Log.i(FaxHistoryEntryPanel.class.getSimpleName(), "handleFoward : id " + this.mFaxDoc.getId());
        File cacheFile = this.getOriginalCacheFile(this.mFaxDoc);
        if (cacheFile.exists()) {
            ArrayList<ChatReceiver> chatReceiverList = new ArrayList<ChatReceiver>();
            for (String receiverJid : selectedJids) {
                chatReceiverList.add(new ChatReceiver(receiverJid));
            }
            ChatActionUtil.uploadFile(chatReceiverList, cacheFile, true, null, this);
        } else {
            this.downloadAndForwardFaxOrg(cacheFile, this.mFaxDoc, selectedJids);
        }
    }

    private File getOriginalCacheFile(LiteFaxDoc faxDoc) {
        File faxDir = MediaFileUtil.getFaxRoot(UCChatClient.context);
        String fileName = faxDoc.getOriginalFileName();
        File cacheFile = new File(faxDir, fileName);
        int count = 1;
        while (cacheFile.exists() && cacheFile.length() != this.mFaxDoc.getOriginalFileSize()) {
            int index = fileName.lastIndexOf(".");
            String newFileName = fileName.substring(0, index) + "(" + count++ + ")" + fileName.substring(index);
            cacheFile = new File(faxDir, newFileName);
        }
        return cacheFile;
    }

    public void handleSaveTiffToFile() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                File selectedFile;
                String fileName = FaxHistoryEntryPanel.this.getFaxFileName(FaxHistoryEntryPanel.this.mFaxDoc);
                FileChooser fc = new FileChooser();
                fc.setInitialFileName(fileName);
                String exten = "tiff";
                if (StringUtils.isNotBlank((CharSequence)exten)) {
                    fc.getExtensionFilters().addAll(new FileChooser.ExtensionFilter(exten.toUpperCase(), new String[]{"*." + exten.toLowerCase()}));
                }
                if ((selectedFile = fc.showSaveDialog(null)) != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                FaxHistoryEntryPanel.this.doSaveTiff(selectedFile);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            PreferencesUtil.setChatLastSaveDir(UCChatClient.context, selectedFile.getParentFile().getAbsolutePath());
                        }
                    });
                }
            }
        });
    }

    public void handleSavePdfToFile() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                File selectedFile;
                String fileName = FaxHistoryEntryPanel.this.getFaxPdfFileName(FaxHistoryEntryPanel.this.mFaxDoc);
                FileChooser fc = new FileChooser();
                fc.setInitialFileName(fileName);
                String exten = "pdf";
                if (StringUtils.isNotBlank((CharSequence)exten)) {
                    fc.getExtensionFilters().addAll(new FileChooser.ExtensionFilter(exten.toUpperCase(), new String[]{"*." + exten.toLowerCase()}));
                }
                if ((selectedFile = fc.showSaveDialog(null)) != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                FaxHistoryEntryPanel.this.doSavePdf(selectedFile);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            PreferencesUtil.setChatLastSaveDir(UCChatClient.context, selectedFile.getParentFile().getAbsolutePath());
                        }
                    });
                }
            }
        });
    }

    public void handleSaveOrgToFile() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                File selectedFile;
                String fileName = FaxHistoryEntryPanel.this.mFaxDoc.getOriginalFileName();
                FileChooser fc = new FileChooser();
                fc.setInitialFileName(fileName);
                String exten = null;
                if (fileName.contains(".")) {
                    String[] xx = fileName.split("\\.");
                    exten = xx[1];
                }
                fc.getExtensionFilters().clear();
                if (StringUtils.isNotBlank(exten)) {
                    fc.getExtensionFilters().addAll(new FileChooser.ExtensionFilter(exten.toUpperCase(), new String[]{"*." + exten.toLowerCase()}));
                }
                if ((selectedFile = fc.showSaveDialog(null)) != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                FaxHistoryEntryPanel.this.doSaveOrg(selectedFile);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            PreferencesUtil.setChatLastSaveDir(UCChatClient.context, selectedFile.getParentFile().getAbsolutePath());
                        }
                    });
                }
            }
        });
    }

    private void doSaveTiff(File saveAsFile) throws IOException {
        if (saveAsFile == null) {
            return;
        }
        Log.i(FaxHistoryEntryPanel.class.getSimpleName(), "doSaveTiff : id " + this.mFaxDoc.getId());
        File faxDir = MediaFileUtil.getFaxRoot(UCChatClient.context);
        String fileName = this.getFaxFileName(this.mFaxDoc);
        File cacheFile = new File(faxDir, fileName);
        if (cacheFile.exists()) {
            Files.copy(cacheFile.toPath(), saveAsFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            ToastUtil.showShort(I18NUtil.getString("media_save_to_local_success"));
        } else {
            this.downloadAndSaveAsFaxTiff(cacheFile, saveAsFile, this.mFaxDoc);
        }
    }

    private void doSavePdf(File saveAsFile) throws IOException {
        if (saveAsFile == null) {
            return;
        }
        Log.i(FaxHistoryEntryPanel.class.getSimpleName(), "doSavePdf : id " + this.mFaxDoc.getId());
        File faxDir = MediaFileUtil.getFaxRoot(UCChatClient.context);
        String fileName = this.getFaxPdfFileName(this.mFaxDoc);
        File cacheFile = new File(faxDir, fileName);
        if (cacheFile.exists()) {
            Files.copy(cacheFile.toPath(), saveAsFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            ToastUtil.showShort(I18NUtil.getString("media_save_to_local_success"));
        } else {
            this.downloadAndSaveAsFaxPdf(cacheFile, saveAsFile, this.mFaxDoc);
        }
    }

    private void doSaveOrg(File saveAsFile) throws IOException {
        if (saveAsFile == null) {
            return;
        }
        Log.i(FaxHistoryEntryPanel.class.getSimpleName(), "doSaveOrg : id " + this.mFaxDoc.getId());
        File cacheFile = this.getOriginalCacheFile(this.mFaxDoc);
        if (cacheFile.exists()) {
            Files.copy(cacheFile.toPath(), saveAsFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            ToastUtil.showShort(I18NUtil.getString("media_save_to_local_success"));
        } else {
            this.downloadAndSaveAsFaxOrg(cacheFile, saveAsFile, this.mFaxDoc);
        }
    }

    public void resend() {
        WebAgent.getInstance().resendFaxDoc(this.mFaxDoc.getId());
    }

    public void cancel() {
        WebAgent.getInstance().cancelFaxDoc(this.mFaxDoc.getId());
    }

    class DownloadOpenTaskCallBack
    implements DownloadFileTaskCallBack {
        File mFile;

        public DownloadOpenTaskCallBack(File toFile) {
            this.mFile = toFile;
        }

        @Override
        public void onFileLengthGot(int size) {
        }

        @Override
        public void onProgressUpdated(int progress) {
            if (FaxHistoryEntryPanel.this.pbDownload != null) {
                FaxHistoryEntryPanel.this.pbDownload.setValue(progress);
            }
        }

        @Override
        public void onDownloadFileStarted() {
        }

        @Override
        public void onDownloadFileCompleted() {
            if (FaxHistoryEntryPanel.this.pbDownload != null) {
                FaxHistoryEntryPanel.this.pbDownload.setValue(100);
            }
            Timer timer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ld2) {
                    try {
                        if (FaxHistoryEntryPanel.this.pbDownload != null) {
                            FaxHistoryEntryPanel.this.pbDownload.setVisible(false);
                        }
                        if (FaxHistoryEntryPanel.this.lblCancelDownload != null) {
                            FaxHistoryEntryPanel.this.lblCancelDownload.setVisible(false);
                        }
                        Desktop.getDesktop().open(DownloadOpenTaskCallBack.this.mFile);
                    }
                    catch (Exception e) {
                        Log.e(FaxHistoryEntryPanel.class.getSimpleName(), "ERROR:" + e.getMessage(), e);
                    }
                }
            });
            timer.setRepeats(false);
            timer.start();
        }

        @Override
        public void onDownloadFileCancelled() {
            if (FaxHistoryEntryPanel.this.pbDownload != null) {
                FaxHistoryEntryPanel.this.pbDownload.setValue(0);
                FaxHistoryEntryPanel.this.pbDownload.setVisible(false);
            }
            if (FaxHistoryEntryPanel.this.lblCancelDownload != null) {
                FaxHistoryEntryPanel.this.lblCancelDownload.setVisible(false);
            }
        }

        @Override
        public void onDownloadFileFailed() {
            if (FaxHistoryEntryPanel.this.pbDownload != null) {
                FaxHistoryEntryPanel.this.pbDownload.setValue(0);
                FaxHistoryEntryPanel.this.pbDownload.setVisible(false);
            }
            if (FaxHistoryEntryPanel.this.lblCancelDownload != null) {
                FaxHistoryEntryPanel.this.lblCancelDownload.setVisible(false);
            }
            ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
        }

        @Override
        public void onDownloadFileNotFound() {
            ToastUtil.showErrorLong(I18NUtil.getString("media_file_download_not_found"));
        }
    }

    class DownloadForwardTaskCallBack
    implements DownloadFileTaskCallBack {
        File mFile;
        List<String> mSelectedJids;

        public DownloadForwardTaskCallBack(File toFile, List<String> selectedJids) {
            this.mFile = toFile;
            this.mSelectedJids = selectedJids;
        }

        @Override
        public void onFileLengthGot(int size) {
        }

        @Override
        public void onProgressUpdated(int progress) {
            if (FaxHistoryEntryPanel.this.pbDownload != null) {
                FaxHistoryEntryPanel.this.pbDownload.setValue(progress);
            }
        }

        @Override
        public void onDownloadFileStarted() {
        }

        @Override
        public void onDownloadFileCompleted() {
            if (FaxHistoryEntryPanel.this.pbDownload != null) {
                FaxHistoryEntryPanel.this.pbDownload.setValue(100);
            }
            Timer timer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ld2) {
                    try {
                        if (FaxHistoryEntryPanel.this.pbDownload != null) {
                            FaxHistoryEntryPanel.this.pbDownload.setVisible(false);
                        }
                        if (FaxHistoryEntryPanel.this.lblCancelDownload != null) {
                            FaxHistoryEntryPanel.this.lblCancelDownload.setVisible(false);
                        }
                        ArrayList<ChatReceiver> chatReceiverList = new ArrayList<ChatReceiver>();
                        for (String receiverJid : DownloadForwardTaskCallBack.this.mSelectedJids) {
                            chatReceiverList.add(new ChatReceiver(receiverJid));
                        }
                        ChatActionUtil.uploadFile(chatReceiverList, DownloadForwardTaskCallBack.this.mFile, true, null, FaxHistoryEntryPanel.this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            timer.setRepeats(false);
            timer.start();
        }

        @Override
        public void onDownloadFileCancelled() {
            if (FaxHistoryEntryPanel.this.pbDownload != null) {
                FaxHistoryEntryPanel.this.pbDownload.setValue(0);
                FaxHistoryEntryPanel.this.pbDownload.setVisible(false);
            }
            if (FaxHistoryEntryPanel.this.lblCancelDownload != null) {
                FaxHistoryEntryPanel.this.lblCancelDownload.setVisible(false);
            }
        }

        @Override
        public void onDownloadFileFailed() {
            if (FaxHistoryEntryPanel.this.pbDownload != null) {
                FaxHistoryEntryPanel.this.pbDownload.setValue(0);
                FaxHistoryEntryPanel.this.pbDownload.setVisible(false);
            }
            if (FaxHistoryEntryPanel.this.lblCancelDownload != null) {
                FaxHistoryEntryPanel.this.lblCancelDownload.setVisible(false);
            }
            ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
        }

        @Override
        public void onDownloadFileNotFound() {
            ToastUtil.showErrorLong(I18NUtil.getString("media_file_download_not_found"));
        }
    }

    class DownloadSaveAsTaskCallBack
    implements DownloadFileTaskCallBack {
        File mFile;
        File mSaveAsFile;

        public DownloadSaveAsTaskCallBack(File toFile, File saveAsFile) {
            this.mFile = toFile;
            this.mSaveAsFile = saveAsFile;
        }

        @Override
        public void onFileLengthGot(int size) {
        }

        @Override
        public void onProgressUpdated(int progress) {
            if (FaxHistoryEntryPanel.this.pbDownload != null) {
                FaxHistoryEntryPanel.this.pbDownload.setValue(progress);
            }
        }

        @Override
        public void onDownloadFileStarted() {
        }

        @Override
        public void onDownloadFileCompleted() {
            if (FaxHistoryEntryPanel.this.pbDownload != null) {
                FaxHistoryEntryPanel.this.pbDownload.setValue(100);
            }
            Timer timer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ld2) {
                    try {
                        if (FaxHistoryEntryPanel.this.pbDownload != null) {
                            FaxHistoryEntryPanel.this.pbDownload.setVisible(false);
                        }
                        if (FaxHistoryEntryPanel.this.lblCancelDownload != null) {
                            FaxHistoryEntryPanel.this.lblCancelDownload.setVisible(false);
                        }
                        Files.copy(DownloadSaveAsTaskCallBack.this.mFile.toPath(), DownloadSaveAsTaskCallBack.this.mSaveAsFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        ToastUtil.showShort(I18NUtil.getString("media_save_to_local_success"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            timer.setRepeats(false);
            timer.start();
        }

        @Override
        public void onDownloadFileCancelled() {
            if (FaxHistoryEntryPanel.this.pbDownload != null) {
                FaxHistoryEntryPanel.this.pbDownload.setValue(0);
                FaxHistoryEntryPanel.this.pbDownload.setVisible(false);
            }
            if (FaxHistoryEntryPanel.this.lblCancelDownload != null) {
                FaxHistoryEntryPanel.this.lblCancelDownload.setVisible(false);
            }
        }

        @Override
        public void onDownloadFileFailed() {
            if (FaxHistoryEntryPanel.this.pbDownload != null) {
                FaxHistoryEntryPanel.this.pbDownload.setValue(0);
                FaxHistoryEntryPanel.this.pbDownload.setVisible(false);
            }
            if (FaxHistoryEntryPanel.this.lblCancelDownload != null) {
                FaxHistoryEntryPanel.this.lblCancelDownload.setVisible(false);
            }
            ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
        }

        @Override
        public void onDownloadFileNotFound() {
            ToastUtil.showErrorLong(I18NUtil.getString("media_file_download_not_found"));
        }
    }
}

