/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.fax;

import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.StringUtils;

public class FaxTiffUploadConfirmDialog
extends GenericDialog {
    private JPanel panelContent;
    private JLabel lblNumberTitle;
    private JTextField phoneNumberField;
    private JLabel lblTitleError;
    private JLabel lblPhotoTitle;
    private JLabel mSelectedPhoto;
    private JLabel lFileSize;
    private JLabel lFileName;
    private JButton btnConfirm;
    private JButton btnCancel;
    private boolean mOK = false;
    private File mFile = null;
    private String mPhoneNumber = null;

    public FaxTiffUploadConfirmDialog(JFrame frame, File file, String phoneNumber) {
        super(frame);
        this.mFile = file;
        this.mPhoneNumber = phoneNumber;
        this.initGUI();
        if (StringUtils.isNotBlank((CharSequence)this.mPhoneNumber)) {
            this.phoneNumberField.setText(this.mPhoneNumber);
        }
    }

    private void initGUI() {
        try {
            this.setTitle(I18NUtil.getString("fax_upload_title"));
            this.setModal(true);
            this.setLocationRelativeTo(null);
            this.panelContent = new JPanel();
            GridBagLayout panelContentLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.panelContent, "North");
            this.panelContent.setLayout(panelContentLayout);
            int y = 0;
            JPanel numberPanel = new JPanel();
            GridBagLayout numberLayout = new GridBagLayout();
            numberPanel.setLayout(numberLayout);
            numberPanel.setOpaque(false);
            this.lblNumberTitle = new JLabel();
            this.lblNumberTitle.setText(I18NUtil.getString("fax_upload_phoneNumber"));
            this.lblNumberTitle.setFont(UIConstants.FONT_14_PLAIN);
            numberPanel.add((Component)this.lblNumberTitle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.phoneNumberField = new JTextField(15);
            this.phoneNumberField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    FaxTiffUploadConfirmDialog.this.verifyNumber();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    FaxTiffUploadConfirmDialog.this.verifyNumber();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
            this.phoneNumberField.setPreferredSize(new Dimension(200, 20));
            this.phoneNumberField.setMinimumSize(new Dimension(200, 20));
            this.phoneNumberField.enableInputMethods(false);
            this.phoneNumberField.addKeyListener(new KeyListener(this){

                @Override
                public void keyTyped(KeyEvent e) {
                    char c = e.getKeyChar();
                    if ((c < '0' || c > '9') && c != '\b' && c != '+' && c != ',') {
                        e.consume();
                    }
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }
            });
            numberPanel.add((Component)this.phoneNumberField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.lblTitleError = new JLabel();
            this.lblTitleError.setFont(UIConstants.FONT_12_PLAIN);
            this.lblTitleError.setVisible(false);
            this.lblTitleError.setForeground(Color.RED);
            numberPanel.add((Component)this.lblTitleError, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.panelContent.add((Component)numberPanel, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 20, 10, 30), 0, 0));
            this.lblPhotoTitle = new JLabel();
            this.lblPhotoTitle.setText(I18NUtil.getString("fax_upload_fax"));
            this.lblPhotoTitle.setFont(UIConstants.FONT_14_PLAIN);
            this.panelContent.add((Component)this.lblPhotoTitle, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 10, 30), 0, 0));
            BufferedImage image = FileUtil.readFileHandleExif(this.mFile);
            double ratio = 1.0;
            ratio = image.getWidth(null) > image.getHeight(null) ? 400.0 / (double)image.getWidth(null) : 400.0 / (double)image.getHeight(null);
            int scaledWidth = (int)((double)image.getWidth() * ratio);
            int scaledHeight = (int)((double)image.getHeight() * ratio);
            this.mSelectedPhoto = new JLabel(GraphicUtil.getScaledIcon(image, scaledWidth, scaledHeight));
            this.panelContent.add((Component)this.mSelectedPhoto, new GridBagConstraints(0, y++, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 50, 5, 50), 0, 0));
            JPanel p = new JPanel();
            GridLayout mgr = new GridLayout(0, 1);
            p.setLayout(mgr);
            this.lFileName = new JLabel(this.mFile.getName());
            p.add(this.lFileName);
            this.lFileSize = new JLabel(FileUtil.getFileSizeText(this.mFile.length()));
            p.add(this.lFileSize);
            this.panelContent.add((Component)p, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 50, 5, 50), 0, 0));
            JPanel buttonPanel = new JPanel();
            FlowLayout jPanel1Layout = new FlowLayout();
            jPanel1Layout.setAlignment(1);
            jPanel1Layout.setHgap(10);
            buttonPanel.setLayout(jPanel1Layout);
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(8, 15, 8, 15));
            this.getContentPane().add((Component)buttonPanel, "South");
            buttonPanel.setOpaque(false);
            this.btnConfirm = new JButton();
            buttonPanel.add(this.btnConfirm);
            this.btnConfirm.setText(I18NUtil.getString("common_btn_ok"));
            this.btnConfirm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FaxTiffUploadConfirmDialog.this.btnConfirmActionPerformed(evt);
                }
            });
            this.btnConfirm.setEnabled(false);
            this.btnCancel = new JButton();
            buttonPanel.add(this.btnCancel);
            this.btnCancel.setText(I18NUtil.getString("common_btn_cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FaxTiffUploadConfirmDialog.this.btnCancelActionPerformed(evt);
                }
            });
            this.setSize(520, 800);
            this.setMinimumSize(new Dimension(320, 320));
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void verifyNumber() {
        String number = this.phoneNumberField.getText();
        if (TextUtils.isBlank((CharSequence)number)) {
            this.lblTitleError.setVisible(true);
            this.lblTitleError.setText(I18NUtil.getString("setting_label_number_not_exist"));
            this.phoneNumberField.requestFocus();
            this.btnConfirm.setEnabled(false);
            this.pack();
            return;
        }
        Pattern pattern = Pattern.compile("^\\+?[0-9,]+");
        Matcher matcher = pattern.matcher(number);
        if (!matcher.matches()) {
            this.lblTitleError.setVisible(true);
            this.lblTitleError.setText(I18NUtil.getString("setting_validation_digit_only_plus"));
            this.phoneNumberField.requestFocus();
            this.btnConfirm.setEnabled(false);
            this.pack();
            return;
        }
        this.lblTitleError.setVisible(false);
        this.lblTitleError.setText("");
        this.btnConfirm.setEnabled(true);
        this.pack();
    }

    private void btnConfirmActionPerformed(ActionEvent evt) {
        this.mOK = true;
        this.dispose();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.mOK = false;
        this.dispose();
    }

    @Override
    protected void onESCPressed() {
        this.mOK = false;
        this.dispose();
    }

    public boolean showDialog() {
        this.mOK = false;
        this.setVisible(true);
        return this.mOK;
    }

    public String getPhoneNumber() {
        return this.phoneNumberField.getText();
    }
}

