/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.login;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.component.GreenButton;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.mobile.ezuc.manager.task.ForgotPasswordTask;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class ForgotPasswordDialog
extends GenericDialog
implements ForgotPasswordTask.PasswordCompleteListener {
    private JLabel lblTitle;
    private JTextField txtAccount;
    private JLabel lblDescr;
    private JPanel panelContent;
    private JButton btnCancel;
    private JButton btnConfirm;
    private JLabel lblMessage;
    private String loginId;
    private ForgotPasswordTask mQueryTask;
    private boolean checkCompleted = false;

    public ForgotPasswordDialog(JFrame frame, String loginId) {
        super(frame);
        this.loginId = loginId;
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.panelContent = new JPanel();
            GridBagLayout panelContentLayout = new GridBagLayout();
            this.panelContent.setLayout(panelContentLayout);
            this.getContentPane().add((Component)this.panelContent, "Center");
            this.panelContent.setBorder(BorderFactory.createEmptyBorder(35, 30, 35, 30));
            this.panelContent.setBackground(UIConstants.BACKGROUND_LOGIN);
            this.lblTitle = new JLabel();
            this.panelContent.add((Component)this.lblTitle, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.lblTitle.setText(I18NUtil.getString("login_label_fill_account"));
            this.lblTitle.setFont(UIConstants.FONT_14_PLAIN);
            this.lblTitle.setForeground(Color.DARK_GRAY);
            this.txtAccount = new JTextField();
            this.panelContent.add((Component)this.txtAccount, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
            this.txtAccount.setText(this.loginId);
            this.txtAccount.setFont(UIConstants.FONT_12_PLAIN);
            this.txtAccount.setPreferredSize(new Dimension(200, 28));
            this.txtAccount.setMinimumSize(new Dimension(200, 28));
            ((AbstractDocument)this.txtAccount.getDocument()).setDocumentFilter(new LowercaseDocumentFilter(this));
            this.txtAccount.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ForgotPasswordDialog.this.txtForgotPasswordActionPerformed(evt);
                }
            });
            this.lblDescr = new JLabel();
            this.panelContent.add((Component)this.lblDescr, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.lblDescr.setText("<html><body style='width: 250px'>" + I18NUtil.getString("login_reset_pwd_hint_email"));
            this.lblDescr.setFont(UIConstants.FONT_12_PLAIN);
            this.lblDescr.setForeground(Color.DARK_GRAY);
            this.lblMessage = new JLabel();
            this.panelContent.add((Component)this.lblMessage, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.lblMessage.setFont(UIConstants.FONT_14_PLAIN);
            this.lblMessage.setPreferredSize(new Dimension(200, 28));
            this.lblMessage.setMinimumSize(new Dimension(200, 28));
            this.lblMessage.setVisible(false);
            JPanel x = new JPanel();
            x.setLayout(new GridBagLayout());
            x.setBackground(UIConstants.BACKGROUND_LOGIN);
            this.panelContent.add((Component)x, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 0, new Insets(30, 10, 10, 10), 0, 0));
            this.btnConfirm = new GreenButton();
            x.add((Component)this.btnConfirm, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnConfirm.setText(I18NUtil.getString("common_btn_ok"));
            this.btnConfirm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ForgotPasswordDialog.this.btnConfirmActionPerformed(evt);
                }
            });
            this.btnCancel = new GreenButton();
            x.add((Component)this.btnCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnCancel.setText(I18NUtil.getString("common_btn_cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ForgotPasswordDialog.this.btnCancelActionPerformed(evt);
                }
            });
            this.setDialogSize();
            this.setModal(true);
            this.setResizable(false);
            this.setTitle(I18NUtil.getString("login_label_forgot_password"));
            this.setIconImages(UIConstants.APP_ICONS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setDialogSize() {
        if (this.lblMessage.isVisible()) {
            this.setSize(380, 260);
        } else if (!this.lblMessage.isVisible()) {
            this.setSize(380, 230);
        }
        this.invalidate();
    }

    public boolean isCheckCompleted() {
        return this.checkCompleted;
    }

    private void txtForgotPasswordActionPerformed(ActionEvent evt) {
        this.submitForgotPasswordRequest();
    }

    private void btnConfirmActionPerformed(ActionEvent evt) {
        this.submitForgotPasswordRequest();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.checkCancelled();
    }

    @Override
    protected void onESCPressed() {
        this.checkCancelled();
    }

    private void checkCompleted() {
        this.checkCompleted = true;
        this.setVisible(false);
    }

    private void checkCancelled() {
        this.lblMessage.setVisible(false);
        this.setDialogSize();
        this.setVisible(false);
    }

    private void submitForgotPasswordRequest() {
        String loginAccountText = this.txtAccount.getText();
        if (loginAccountText != null) {
            loginAccountText = loginAccountText.replace(" ", "");
            loginAccountText = loginAccountText.trim();
            this.txtAccount.setText(loginAccountText);
        }
        if (TextUtils.isBlank((CharSequence)loginAccountText)) {
            this.updateState(true, true, I18NUtil.getString("login_validation_enterprise_no_empty"), null);
            this.txtAccount.requestFocus();
        }
        if (this.mQueryTask != null) {
            this.mQueryTask.terminate();
            this.mQueryTask = null;
        }
        this.updateState(false, false, I18NUtil.getString("login_enterprise_fetch_processing"), UIConstants.ICON_LOADING24);
        this.mQueryTask = new ForgotPasswordTask(UCChatClient.context, loginAccountText, this);
    }

    private void updateState(boolean buttonEnabled, boolean error, String text, Icon icon) {
        this.txtAccount.setEnabled(buttonEnabled);
        this.btnConfirm.setEnabled(buttonEnabled);
        this.btnCancel.setEnabled(buttonEnabled);
        this.lblMessage.setForeground(error ? Color.RED : Color.BLACK);
        this.lblMessage.setText(text);
        this.lblMessage.setIcon(icon);
        this.lblMessage.setVisible(true);
        this.setDialogSize();
    }

    @Override
    public void onCheckCompleted(int type, final String info) {
        switch (type) {
            case 0: {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ForgotPasswordDialog.this.checkCompleted();
                    }
                });
                break;
            }
            case -1: {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ForgotPasswordDialog.this.updateState(true, true, info, null);
                    }
                });
                break;
            }
            case 1: {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ForgotPasswordDialog.this.updateState(true, true, String.format(I18NUtil.getString("network_server_connect_fail_try_later"), I18NUtil.getAppName()), null);
                    }
                });
            }
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                ForgotPasswordDialog inst = new ForgotPasswordDialog(frame, "127.0.0.1");
                inst.setVisible(true);
            }
        });
    }

    class LowercaseDocumentFilter
    extends DocumentFilter {
        LowercaseDocumentFilter(ForgotPasswordDialog this$0) {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) throws BadLocationException {
            if (fb != null && text != null) {
                fb.insertString(offset, text.toLowerCase(), attr);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (fb != null && text != null) {
                fb.replace(offset, length, text.toLowerCase(), attrs);
            }
        }
    }
}

