/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.main;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.bulletin.BulletinPanel;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.AgentStatusType;
import com.blisscloud.mobile.ezuc.bean.MediaType;
import com.blisscloud.mobile.ezuc.util.ApiVersion;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AgentStateDialog
extends GenericDialog {
    private static final long serialVersionUID = 2005755156175398787L;
    private JRadioButton phoneLoginRadioBtn;
    private JRadioButton phoneLogoutRadioBtn;
    private JRadioButton chatLoginRadioBtn;
    private JRadioButton chatLogoutRadioBtn;
    private JCheckBox autoLoginCheckBtn;
    private JCheckBox autoLogoutCheckBtn;
    private JLabel lblPadding0;
    private JLabel lblPadding1;
    private JLabel lblPadding2;
    private JLabel lblPadding3;
    private JButton btnConfirm;
    private JScrollPane jScrollPane;
    private JPanel mainPanel;
    ButtonGroup phoneLoginButtonGroup = new ButtonGroup();
    ButtonGroup chatLoginButtonGroup = new ButtonGroup();
    ButtonGroup autoReadyButtonGroup = new ButtonGroup();
    private JRadioButton autoReadyRadioBox1;
    private JRadioButton autoReadyRadioBox2;
    private JRadioButton autoReadyRadioBox3;
    private JPanel autoReadyNotePanel;
    private JLabel autoNoteLabel;
    private JComboBox<Integer> autoPeriod;
    private JLabel autoNoteUilt;
    private Integer[] periodAry = new Integer[]{3, 4, 5, 6, 7, 8, 9, 10, 15, 20, 30, 40, 50, 60, 90, 120, 150, 180};
    private ArrayList<JCheckBox> queueCheckBoxList = new ArrayList();
    private JComboBox<JSONObject> aiAgentComboBox;
    private DefaultComboBoxModel<JSONObject> aiAgentComboBoxModel;
    private ArrayList<JSONObject> aiAgentList = new ArrayList();
    private BroadcastReceiver receiver = null;
    private IntentFilter filter = null;

    public AgentStateDialog(JFrame frame) {
        super(frame);
        this.initGUI();
        this.loadAgentState();
        this.reloadAiList();
        this.initReceiver();
    }

    private void initReceiver() {
        this.receiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                try {
                    String action = intent.getAction();
                    Log.d(BulletinPanel.class.getSimpleName(), " \u6536\u5230\u5ee3\u64ad:" + action);
                    if ("ezuc.intent.action.event.AI_AGENT_LIST_UPDATE".equals(action)) {
                        AgentStateDialog.this.reloadAiList();
                    } else if ("ezuc.intent.action.event.AGENT_ROLE_CHANGED".equals(action) || "ezuc.intent.action.event.AGENT_STATE_CHANGED".equals(action)) {
                        AgentStateDialog.this.reloadGUI();
                    } else if ("ezuc.intent.action.event.PERSONAL_INFO_CHANGED".equals(action)) {
                        AgentStateDialog.this.reloadGUI();
                    }
                }
                catch (Throwable t) {
                    Log.e(BulletinPanel.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
                }
            }
        };
        this.filter = new IntentFilter();
        this.filter.addAction("ezuc.intent.action.event.AI_AGENT_LIST_UPDATE");
        this.filter.addAction("ezuc.intent.action.event.AGENT_ROLE_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.AGENT_STATE_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.PERSONAL_INFO_CHANGED");
        UCChatClient.context.registerReceiver(this.receiver, this.filter);
    }

    private void initGUI() {
        try {
            this.setTitle(I18NUtil.getString("agent_state_dialog_label"));
            this.setModal(true);
            this.setLocationRelativeTo(null);
            BorderLayout thisLayout = new BorderLayout();
            this.setLayout(thisLayout);
            this.loadMain();
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new GridBagLayout());
            buttonPanel.setBackground(UIConstants.COLOR_DIALOG_BACKGROUND);
            this.add((Component)buttonPanel, "South");
            this.btnConfirm = new JButton();
            buttonPanel.add((Component)this.btnConfirm, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
            this.btnConfirm.setText(I18NUtil.getString("common_btn_ok"));
            this.btnConfirm.setMinimumSize(new Dimension(75, 30));
            this.btnConfirm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (ApiVersion.isApi27Later()) {
                        AgentStateDialog.this.btnConfirmActionPerformed(evt);
                    } else {
                        AgentStateDialog.this.btnConfirmActionPerformedOld(evt);
                    }
                }
            });
            this.configDialogSize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void configDialogSize() {
        int width = 550;
        if (PreferencesUtil.isPhoneAgent() && PreferencesUtil.isChatAgent()) {
            width = 500;
        }
        if (PreferencesUtil.isAiAssistanceEnabled(UCChatClient.context)) {
            width += 100;
        }
        this.setSize(620, width);
        this.setMinimumSize(new Dimension(520, 350));
    }

    private void reloadGUI() {
        try {
            this.remove(this.jScrollPane);
            this.loadMain();
            this.loadAgentState();
            this.reloadAiList();
            this.configDialogSize();
            this.revalidate();
            this.repaint();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void reloadAiList() {
        if (PreferencesUtil.isAiAssistanceEnabled(UCChatClient.context)) {
            this.loadAiAgentOptions();
            this.setupAiAgentComboBoxRenderer();
        }
    }

    private void loadMain() throws Exception {
        JLabel phoneMediaLabel;
        this.jScrollPane = new JScrollPane();
        this.jScrollPane.setVerticalScrollBarPolicy(20);
        this.jScrollPane.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.jScrollPane, "Center");
        this.jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.mainPanel = new JPanel();
        this.jScrollPane.setViewportView(this.mainPanel);
        GridBagLayout mainLayout = new GridBagLayout();
        this.mainPanel.setLayout(mainLayout);
        this.mainPanel.setBackground(UIConstants.COLOR_DIALOG_BACKGROUND);
        int y = 0;
        JLabel queueInfoLabel = new JLabel();
        this.mainPanel.add((Component)queueInfoLabel, new GridBagConstraints(0, y++, 3, 1, 0.0, 0.0, 17, 0, new Insets(20, 40, 0, 40), 0, 0));
        queueInfoLabel.setText(I18NUtil.getString("agent_state_dialog_queue_info"));
        queueInfoLabel.setFont(UIConstants.FONT_16_BOLD);
        if (ApiVersion.isApi27Later()) {
            boolean queueInfoSet = false;
            Set<Long> selectedSet = PreferencesUtil.getAgentQueueSelectedSet();
            String queueInfoStr = PreferencesUtil.getAgentQueueInfo();
            if (StringUtils.isNotBlank((CharSequence)queueInfoStr)) {
                JSONArray ary = new JSONArray(queueInfoStr);
                for (int k = 0; k < ary.length(); ++k) {
                    JSONObject obj = ary.getJSONObject(k);
                    long skillId = obj.getLong("skillId");
                    String skillName = obj.getString("skillName");
                    int level = obj.getInt("level");
                    String levelInfo = "";
                    levelInfo = level == -1 ? I18NUtil.getString("agent_skill_level_low") : (level == 0 ? I18NUtil.getString("agent_skill_level_medium") : (level == 1 ? I18NUtil.getString("agent_skill_level_high") : (level == 2 ? I18NUtil.getString("agent_skill_level_top") : I18NUtil.getString("agent_skill_level_unknown"))));
                    JCheckBox queueEnabledBtn = new JCheckBox();
                    queueEnabledBtn.setName("" + skillId);
                    this.mainPanel.add((Component)queueEnabledBtn, new GridBagConstraints(0, y++, 3, 1, 0.0, 0.0, 17, 0, new Insets(10, 55, 0, 20), 0, 0));
                    queueEnabledBtn.setText(skillName + " (" + levelInfo + ")");
                    queueEnabledBtn.setOpaque(false);
                    queueEnabledBtn.setFont(UIConstants.FONT_12_PLAIN);
                    queueEnabledBtn.setSelected(selectedSet.contains(skillId));
                    this.queueCheckBoxList.add(queueEnabledBtn);
                    queueInfoSet = true;
                }
            }
            if (!queueInfoSet) {
                JLabel queueInfo = new JLabel();
                this.mainPanel.add((Component)queueInfo, new GridBagConstraints(0, y++, 3, 1, 0.0, 0.0, 17, 0, new Insets(10, 55, 0, 20), 0, 0));
                queueInfo.setText(I18NUtil.getString("agent_state_dialog_skill_zero"));
                queueInfo.setFont(UIConstants.FONT_12_PLAIN);
            }
        } else {
            JLabel queueInfo = new JLabel();
            this.mainPanel.add((Component)queueInfo, new GridBagConstraints(0, y++, 3, 1, 0.0, 0.0, 17, 0, new Insets(10, 55, 0, 20), 0, 0));
            String queueInfoStr = PreferencesUtil.getAgentQueueInfo();
            StringBuffer buffer = new StringBuffer();
            if (StringUtils.isNotBlank((CharSequence)queueInfoStr)) {
                JSONArray ary = new JSONArray(queueInfoStr);
                for (int k = 0; k < ary.length(); ++k) {
                    if (k != 0) {
                        buffer.append(I18NUtil.getString("comma"));
                    }
                    JSONObject obj = ary.getJSONObject(k);
                    String skillName = obj.getString("skillName");
                    int level = obj.getInt("level");
                    String levelInfo = "";
                    levelInfo = level == -1 ? I18NUtil.getString("agent_skill_level_low") : (level == 0 ? I18NUtil.getString("agent_skill_level_medium") : (level == 1 ? I18NUtil.getString("agent_skill_level_high") : (level == 2 ? I18NUtil.getString("agent_skill_level_top") : I18NUtil.getString("agent_skill_level_unknown"))));
                    buffer.append(skillName);
                    buffer.append(" (");
                    buffer.append(levelInfo);
                    buffer.append(")");
                }
            }
            if (buffer.length() != 0) {
                queueInfo.setText("<html><body style='width: 280px;'>" + buffer.toString() + "</body></html>");
            } else {
                queueInfo.setText(I18NUtil.getString("agent_state_dialog_skill_zero"));
            }
            queueInfo.setFont(UIConstants.FONT_12_PLAIN);
        }
        JLabel mediaTypesLabel = new JLabel();
        this.mainPanel.add((Component)mediaTypesLabel, new GridBagConstraints(0, y++, 3, 1, 0.0, 0.0, 17, 0, new Insets(20, 40, 0, 40), 0, 0));
        mediaTypesLabel.setText(I18NUtil.getString("agent_state_dialog_mediatypes_label"));
        mediaTypesLabel.setFont(UIConstants.FONT_16_BOLD);
        JLabel lblPadding10 = new JLabel();
        this.mainPanel.add((Component)lblPadding10, new GridBagConstraints(0, y++, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 10), 0, 0));
        if (PreferencesUtil.isPhoneAgent()) {
            phoneMediaLabel = new JLabel();
            this.mainPanel.add((Component)phoneMediaLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 55, 0, 20), 0, 0));
            phoneMediaLabel.setText(I18NUtil.getString("agent_media_phone"));
            phoneMediaLabel.setFont(UIConstants.FONT_12_PLAIN);
            this.phoneLoginRadioBtn = new JRadioButton();
            this.mainPanel.add((Component)this.phoneLoginRadioBtn, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
            this.phoneLoginRadioBtn.setText(I18NUtil.getString("agent_state_dialog_option_login"));
            this.phoneLoginRadioBtn.setSelected(false);
            this.phoneLoginRadioBtn.setOpaque(false);
            this.phoneLoginRadioBtn.setFont(UIConstants.FONT_12_PLAIN);
            this.phoneLoginButtonGroup.add(this.phoneLoginRadioBtn);
            this.phoneLogoutRadioBtn = new JRadioButton();
            this.mainPanel.add((Component)this.phoneLogoutRadioBtn, new GridBagConstraints(2, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
            this.phoneLogoutRadioBtn.setText(I18NUtil.getString("agent_state_dialog_option_logout"));
            this.phoneLogoutRadioBtn.setSelected(false);
            this.phoneLoginRadioBtn.setOpaque(false);
            this.phoneLogoutRadioBtn.setFont(UIConstants.FONT_12_PLAIN);
            this.phoneLoginButtonGroup.add(this.phoneLogoutRadioBtn);
        }
        if (PreferencesUtil.isChatAgent()) {
            phoneMediaLabel = new JLabel();
            this.mainPanel.add((Component)phoneMediaLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 55, 0, 20), 0, 0));
            phoneMediaLabel.setText(I18NUtil.getString("agent_media_chat"));
            phoneMediaLabel.setFont(UIConstants.FONT_12_PLAIN);
            this.chatLoginRadioBtn = new JRadioButton();
            this.mainPanel.add((Component)this.chatLoginRadioBtn, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
            this.chatLoginRadioBtn.setText(I18NUtil.getString("agent_state_dialog_option_login"));
            this.chatLoginRadioBtn.setSelected(false);
            this.chatLoginRadioBtn.setOpaque(false);
            this.chatLoginRadioBtn.setFont(UIConstants.FONT_12_PLAIN);
            this.chatLoginButtonGroup.add(this.chatLoginRadioBtn);
            this.chatLogoutRadioBtn = new JRadioButton();
            this.mainPanel.add((Component)this.chatLogoutRadioBtn, new GridBagConstraints(2, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
            this.chatLogoutRadioBtn.setText(I18NUtil.getString("agent_state_dialog_option_logout"));
            this.chatLogoutRadioBtn.setSelected(false);
            this.chatLogoutRadioBtn.setOpaque(false);
            this.chatLogoutRadioBtn.setFont(UIConstants.FONT_12_PLAIN);
            this.chatLoginButtonGroup.add(this.chatLogoutRadioBtn);
        }
        this.lblPadding0 = new JLabel();
        this.mainPanel.add((Component)this.lblPadding0, new GridBagConstraints(0, y++, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.autoLoginCheckBtn = new JCheckBox();
        this.mainPanel.add((Component)this.autoLoginCheckBtn, new GridBagConstraints(0, y++, 3, 1, 0.0, 0.0, 17, 0, new Insets(10, 55, 0, 20), 0, 0));
        this.autoLoginCheckBtn.setText(I18NUtil.getString("agent_state_dialog_option_auto_login"));
        this.autoLoginCheckBtn.setSelected(false);
        this.autoLoginCheckBtn.setOpaque(false);
        this.autoLoginCheckBtn.setFont(UIConstants.FONT_12_PLAIN);
        this.autoLogoutCheckBtn = new JCheckBox();
        this.mainPanel.add((Component)this.autoLogoutCheckBtn, new GridBagConstraints(0, y++, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 55, 0, 20), 0, 0));
        this.autoLogoutCheckBtn.setText(I18NUtil.getString("agent_state_dialog_option_auto_logout"));
        this.autoLogoutCheckBtn.setSelected(false);
        this.autoLogoutCheckBtn.setOpaque(false);
        this.autoLogoutCheckBtn.setFont(UIConstants.FONT_12_PLAIN);
        this.lblPadding1 = new JLabel();
        this.mainPanel.add((Component)this.lblPadding1, new GridBagConstraints(0, y++, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 20), 0, 0));
        JLabel agentStatusLabel = new JLabel();
        this.mainPanel.add((Component)agentStatusLabel, new GridBagConstraints(0, y++, 3, 1, 0.0, 0.0, 17, 0, new Insets(20, 40, 0, 20), 0, 0));
        agentStatusLabel.setText(I18NUtil.getString("agent_state_dialog_state_label"));
        agentStatusLabel.setFont(UIConstants.FONT_16_BOLD);
        this.autoReadyRadioBox1 = new JRadioButton();
        this.mainPanel.add((Component)this.autoReadyRadioBox1, new GridBagConstraints(0, y++, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 55, 0, 20), 0, 0));
        this.autoReadyRadioBox1.setText(I18NUtil.getString("agent_state_dialog_auto_ready_not_enabled"));
        this.autoReadyRadioBox1.setSelected(false);
        this.autoReadyRadioBox1.setOpaque(false);
        this.autoReadyRadioBox1.setFont(UIConstants.FONT_12_PLAIN);
        this.autoReadyButtonGroup.add(this.autoReadyRadioBox1);
        this.autoReadyRadioBox2 = new JRadioButton();
        this.mainPanel.add((Component)this.autoReadyRadioBox2, new GridBagConstraints(0, y++, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 55, 0, 20), 0, 0));
        this.autoReadyRadioBox2.setText(I18NUtil.getString("agent_state_dialog_auto_ready_enabled"));
        this.autoReadyRadioBox2.setSelected(false);
        this.autoReadyRadioBox2.setOpaque(false);
        this.autoReadyRadioBox2.setFont(UIConstants.FONT_12_PLAIN);
        this.autoReadyButtonGroup.add(this.autoReadyRadioBox2);
        this.autoReadyNotePanel = new JPanel();
        this.autoReadyNotePanel.setOpaque(false);
        this.autoReadyNotePanel.setLayout(new FlowLayout());
        this.mainPanel.add((Component)this.autoReadyNotePanel, new GridBagConstraints(0, y++, 3, 1, 0.0, 0.0, 17, 0, new Insets(10, 70, 0, 20), 0, 0));
        this.autoNoteLabel = new JLabel();
        this.autoReadyNotePanel.add(this.autoNoteLabel);
        this.autoNoteLabel.setText(I18NUtil.getString("agent_state_dialog_auto_ready_note"));
        this.autoPeriod = new JComboBox<Integer>(this.periodAry);
        this.autoReadyNotePanel.add(this.autoPeriod);
        this.autoPeriod.setSelectedIndex(10);
        this.autoNoteUilt = new JLabel();
        this.autoReadyNotePanel.add(this.autoNoteUilt);
        this.autoNoteUilt.setText(I18NUtil.getString("agent_state_dialog_auto_ready_unit"));
        this.autoReadyRadioBox3 = new JRadioButton();
        this.mainPanel.add((Component)this.autoReadyRadioBox3, new GridBagConstraints(0, y++, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 55, 0, 20), 0, 0));
        this.autoReadyRadioBox3.setText(I18NUtil.getString("agent_state_dialog_auto_ready_enabled_summarydone"));
        this.autoReadyRadioBox3.setSelected(false);
        this.autoReadyRadioBox3.setOpaque(false);
        this.autoReadyRadioBox3.setFont(UIConstants.FONT_12_PLAIN);
        this.autoReadyButtonGroup.add(this.autoReadyRadioBox3);
        this.lblPadding2 = new JLabel();
        this.mainPanel.add((Component)this.lblPadding2, new GridBagConstraints(0, y++, 3, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 20), 0, 0));
        if (PreferencesUtil.isAiAssistanceEnabled(UCChatClient.context)) {
            agentStatusLabel = new JLabel();
            this.mainPanel.add((Component)agentStatusLabel, new GridBagConstraints(0, y++, 3, 1, 0.0, 0.0, 17, 0, new Insets(20, 40, 0, 20), 0, 0));
            agentStatusLabel.setText(I18NUtil.getString("agent_state_dialog_ai_assistance"));
            agentStatusLabel.setFont(UIConstants.FONT_16_BOLD);
            JPanel panel = new JPanel(new FlowLayout(0));
            panel.setOpaque(false);
            JLabel aiAgentLabel = new JLabel(I18NUtil.getString("agent_state_dialog_ai_agent_select"));
            this.aiAgentComboBoxModel = new DefaultComboBoxModel();
            this.aiAgentComboBox = new JComboBox<JSONObject>(this.aiAgentComboBoxModel);
            this.aiAgentComboBox.setPreferredSize(new Dimension(200, 25));
            panel.add(aiAgentLabel);
            panel.add(this.aiAgentComboBox);
            this.mainPanel.add((Component)panel, new GridBagConstraints(0, y++, 3, 1, 0.0, 0.0, 17, 1, new Insets(5, 55, 0, 20), 0, 0));
        }
        this.lblPadding3 = new JLabel();
        this.mainPanel.add((Component)this.lblPadding3, new GridBagConstraints(0, y++, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 20), 0, 0));
    }

    private void loadAiAgentOptions() {
        block5: {
            try {
                this.aiAgentComboBoxModel.removeAllElements();
                this.aiAgentList.clear();
                String data = PreferencesUtil.getAiAgentList(UCChatClient.context);
                if (StringUtils.isBlank((CharSequence)data)) {
                    return;
                }
                this.aiAgentComboBoxModel.addElement(null);
                JSONArray jsonArray = new JSONArray(data);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject agent = jsonArray.getJSONObject(i);
                    this.aiAgentList.add(agent);
                    this.aiAgentComboBoxModel.addElement(agent);
                }
                String savedAgent = PreferencesUtil.getAiAgentSelected(UCChatClient.context);
                if (!StringUtils.isNotBlank((CharSequence)savedAgent)) break block5;
                JSONObject savedAgentJson = new JSONObject(savedAgent);
                long savedId = savedAgentJson.getLong("id");
                for (int i = 0; i < this.aiAgentList.size(); ++i) {
                    if (this.aiAgentList.get(i).getLong("id") != savedId) continue;
                    this.aiAgentComboBox.setSelectedIndex(i + 1);
                    break;
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private void setupAiAgentComboBoxRenderer() {
        this.aiAgentComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof JSONObject) {
                    JSONObject agent = (JSONObject)value;
                    String name = agent.optString("name", "Unknown");
                    this.setText(name);
                }
                return this;
            }
        });
    }

    private void loadAgentState() {
        if (PreferencesUtil.isAgentQueueEmpty()) {
            this.phoneLoginRadioBtn.setEnabled(false);
            this.phoneLogoutRadioBtn.setEnabled(false);
        } else {
            this.phoneLoginRadioBtn.setEnabled(true);
            this.phoneLogoutRadioBtn.setEnabled(true);
        }
        if (PreferencesUtil.isPhoneAgent()) {
            if (WebAgent.agentLoginMediaTypes.contains((Object)MediaType.PHONE)) {
                this.phoneLoginRadioBtn.setSelected(true);
                this.phoneLogoutRadioBtn.setSelected(false);
            } else {
                this.phoneLoginRadioBtn.setSelected(false);
                this.phoneLogoutRadioBtn.setSelected(true);
            }
        }
        if (PreferencesUtil.isChatAgent()) {
            if (WebAgent.agentLoginMediaTypes.contains((Object)MediaType.CHAT)) {
                this.chatLoginRadioBtn.setSelected(true);
                this.chatLogoutRadioBtn.setSelected(false);
            } else {
                this.chatLoginRadioBtn.setSelected(false);
                this.chatLogoutRadioBtn.setSelected(true);
            }
        }
        this.autoLoginCheckBtn.setSelected(PreferencesUtil.isAutoLogin());
        this.autoLogoutCheckBtn.setSelected(PreferencesUtil.isAutoLogout());
        int autoLoginOption = PreferencesUtil.getAutoReadyOption();
        if (autoLoginOption == 0) {
            this.autoReadyRadioBox1.setSelected(true);
        } else if (autoLoginOption == 1) {
            this.autoReadyRadioBox2.setSelected(true);
        } else {
            this.autoReadyRadioBox3.setSelected(true);
        }
        int selectedIndex = 10;
        for (int i = 0; i < this.periodAry.length; ++i) {
            if (this.periodAry[i] != PreferencesUtil.getAutoReadySeconds()) continue;
            selectedIndex = i;
        }
        this.autoPeriod.setSelectedIndex(selectedIndex);
    }

    private void btnConfirmActionPerformed(ActionEvent evt) {
        if (!PreferencesUtil.isAgent()) {
            this.setVisible(false);
            return;
        }
        HashSet<Long> oldQueueSelectedSet = new HashSet<Long>(PreferencesUtil.getAgentQueueSelectedSet());
        StringBuffer b = new StringBuffer();
        for (JCheckBox box : this.queueCheckBoxList) {
            if (b.length() > 0) {
                b.append(",");
            }
            if (!box.isSelected()) continue;
            b.append(box.getName());
        }
        if (this.queueCheckBoxList.size() > 0 && b.length() == 0) {
            JCheckBox box0 = this.queueCheckBoxList.get(0);
            box0.requestFocus();
            JOptionPane.showMessageDialog(this, I18NUtil.getString("agent_state_dialog_validation_skill_not_selected"), I18NUtil.getString("common_title_error"), 0);
            return;
        }
        PreferencesUtil.setAgentQueueSelectedInfo(b.toString());
        Set<Long> newQueueSelectedSet = PreferencesUtil.getAgentQueueSelectedSet();
        boolean diffQueueSet = !oldQueueSelectedSet.equals(newQueueSelectedSet);
        HashSet<MediaType> newLoginTypes = new HashSet<MediaType>();
        if (PreferencesUtil.isPhoneAgent() && this.phoneLoginRadioBtn.isSelected()) {
            newLoginTypes.add(MediaType.PHONE);
        }
        if (PreferencesUtil.isChatAgent() && this.chatLoginRadioBtn.isSelected()) {
            newLoginTypes.add(MediaType.CHAT);
        }
        AgentStatusType origState = WebAgent.getAgentState();
        if (newLoginTypes.size() == 0) {
            if (origState != AgentStatusType.LOGOUT) {
                WebAgent.getInstance().agentLogout();
            }
        } else {
            boolean same = AgentStateDialog.checkSetEquals(WebAgent.agentLoginMediaTypes, newLoginTypes);
            if (!same || diffQueueSet) {
                if (PreferencesUtil.isAgentQueueEmpty()) {
                    Log.e(AgentStateDialog.class.getSimpleName(), "No queue configured, cannot login ...");
                } else {
                    Set<Long> selectedSkillSize = PreferencesUtil.getAgentQueueSelectedSet();
                    WebAgent.getInstance().agentLogin(newLoginTypes, selectedSkillSize);
                }
            }
        }
        PreferencesUtil.setAutoLogin(this.autoLoginCheckBtn.isSelected());
        PreferencesUtil.setAutoLogout(this.autoLogoutCheckBtn.isSelected());
        if (this.autoReadyRadioBox1.isSelected()) {
            PreferencesUtil.setAutoReadyOption(0);
        } else if (this.autoReadyRadioBox2.isSelected()) {
            PreferencesUtil.setAutoReadyOption(1);
        } else if (this.autoReadyRadioBox3.isSelected()) {
            PreferencesUtil.setAutoReadyOption(2);
        }
        int selectedIndex = this.autoPeriod.getSelectedIndex();
        int selectedSeconds = this.periodAry[selectedIndex];
        PreferencesUtil.setAutoReadySeconds(selectedSeconds);
        if (PreferencesUtil.isAiAssistanceEnabled(UCChatClient.context)) {
            JSONObject selected = (JSONObject)this.aiAgentComboBox.getSelectedItem();
            if (selected != null) {
                PreferencesUtil.setAiAgentSelected(UCChatClient.context, selected.toString());
            } else {
                PreferencesUtil.setAiAgentSelected(UCChatClient.context, null);
            }
        }
        this.setVisible(false);
    }

    private void btnConfirmActionPerformedOld(ActionEvent evt) {
        if (!PreferencesUtil.isAgent()) {
            this.setVisible(false);
            return;
        }
        HashSet<MediaType> newLoginTypes = new HashSet<MediaType>();
        if (PreferencesUtil.isPhoneAgent() && this.phoneLoginRadioBtn.isSelected()) {
            newLoginTypes.add(MediaType.PHONE);
        }
        if (PreferencesUtil.isChatAgent() && this.chatLoginRadioBtn.isSelected()) {
            newLoginTypes.add(MediaType.CHAT);
        }
        AgentStatusType origState = WebAgent.getAgentState();
        if (newLoginTypes.size() == 0) {
            if (origState != AgentStatusType.LOGOUT) {
                WebAgent.getInstance().agentLogout();
            }
        } else {
            boolean same = AgentStateDialog.checkSetEquals(WebAgent.agentLoginMediaTypes, newLoginTypes);
            if (!same) {
                if (PreferencesUtil.isAgentQueueEmpty()) {
                    Log.e(AgentStateDialog.class.getSimpleName(), "No queue configured, cannot login ...");
                } else {
                    WebAgent.getInstance().agentLogin(newLoginTypes);
                }
            }
        }
        PreferencesUtil.setAutoLogin(this.autoLoginCheckBtn.isSelected());
        PreferencesUtil.setAutoLogout(this.autoLogoutCheckBtn.isSelected());
        if (this.autoReadyRadioBox1.isSelected()) {
            PreferencesUtil.setAutoReadyOption(0);
        } else if (this.autoReadyRadioBox2.isSelected()) {
            PreferencesUtil.setAutoReadyOption(1);
        } else if (this.autoReadyRadioBox3.isSelected()) {
            PreferencesUtil.setAutoReadyOption(2);
        }
        int selectedIndex = this.autoPeriod.getSelectedIndex();
        int selectedSeconds = this.periodAry[selectedIndex];
        PreferencesUtil.setAutoReadySeconds(selectedSeconds);
        if (PreferencesUtil.isAiAssistanceEnabled(UCChatClient.context)) {
            JSONObject selected = (JSONObject)this.aiAgentComboBox.getSelectedItem();
            if (selected != null) {
                PreferencesUtil.setAiAgentSelected(UCChatClient.context, selected.toString());
            } else {
                PreferencesUtil.setAiAgentSelected(UCChatClient.context, null);
            }
        }
        this.setVisible(false);
    }

    public static boolean checkSetEquals(Set<?> set1, Set<?> set2) {
        if (set1 == null || set2 == null) {
            return false;
        }
        if (set1.size() != set2.size()) {
            return false;
        }
        return set1.containsAll(set2);
    }
}

