/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.main;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.main.SelectChatroomDialog;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ChatRoomUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.Utils;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.bean.ChatRoomInfo;
import com.blisscloud.mobile.ezuc.bean.MessageChannel;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.db.UCDBGroup;
import com.blisscloud.mobile.ezuc.db.UCDBMessageChannel;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.MeetmeManager;
import com.blisscloud.mobile.ezuc.manager.MessageChannelManager;
import com.blisscloud.mobile.ezuc.manager.OutboundPrefixManager;
import java.awt.Component;
import java.awt.Image;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;

class ChatroomCellRenderer
extends DefaultListCellRenderer {
    int photoSize = 48;

    public ChatroomCellRenderer(int photoSize) {
        this.photoSize = photoSize;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        try {
            Activity ctx = UCChatClient.context;
            if (value instanceof ChatRoomInfo) {
                ChatRoomInfo chatRoomInfo = (ChatRoomInfo)value;
                int chatType = chatRoomInfo.getType();
                String chatId = chatRoomInfo.getChatRoomId();
                if (chatType == 0) {
                    LiteContact contact = ContactManager.getContact((Context)ctx, chatId);
                    Image contactImage = ContactManager.getContactImage(contact, this.photoSize, false, true);
                    String contactName = ContactManager.getContactFullName((Context)ctx, contact, chatId);
                    this.setText(contactName);
                    this.setIcon(new ImageIcon(contactImage));
                } else if (chatType == 7) {
                    MessageChannel channel = UCDBMessageChannel.getMessageChannelByJid(ctx, chatId);
                    Image contactImage = MessageChannelManager.getMessageChannelImage(channel, this.photoSize, false, true);
                    String contactName = MessageChannelManager.getFullName(ctx, channel, chatId);
                    this.setText(contactName);
                    this.setIcon(new ImageIcon(contactImage));
                } else if (chatType == 2) {
                    LiteConferenceRoom confRoom = MeetmeManager.getStaticMeetme(ctx, chatId);
                    String confRoomTitle = ChatRoomUtil.getConfRoomTitle(ctx, chatRoomInfo, confRoom, false, true);
                    Object roomNo = "";
                    if (confRoom != null) {
                        roomNo = " (" + OutboundPrefixManager.getMeetmePrefix(ctx) + confRoom.getRoomNo() + ")";
                    }
                    this.setText(confRoomTitle + (String)roomNo);
                    ArrayList<String> participants = UCDBChatRoom.findChatRoomParticipants((Context)ctx, chatId);
                    if (participants == null || participants.size() == 0 || confRoom == null || Utils.getConferenceRoomCount(ctx, confRoom.getRoomId(), chatId) == 0) {
                        this.setIcon(UIConstants.ICON_CONFERENCEROOM_IDLE_48);
                    } else {
                        this.setIcon(UIConstants.ICON_CONFERENCEROOM_USING_48);
                    }
                } else if (chatType == 1) {
                    ArrayList<String> participants = UCDBChatRoom.findChatRoomParticipants((Context)ctx, chatId);
                    LiteConferenceRoom confRoom = MeetmeManager.getMeetme((Context)ctx, chatId);
                    String chatRoomTitle = ChatRoomUtil.getChatRoomTitleForList(ctx, chatRoomInfo, participants, new HashMap<String, LiteContact>());
                    Object roomNo = "";
                    if (confRoom != null) {
                        roomNo = " (" + OutboundPrefixManager.getMeetmePrefix(ctx) + confRoom.getRoomNo() + ")";
                    }
                    this.setText(chatRoomTitle + (String)roomNo);
                    if (participants == null || participants.size() <= 0) {
                        this.setIcon(UIConstants.ICON_CONFERENCEROOM_IDLE_48);
                    } else {
                        this.setIcon(new ImageIcon(GraphicUtil.getChatRoomImage48(ctx, participants, null, true)));
                    }
                }
            } else if (value instanceof LiteContact) {
                LiteContact contact = (LiteContact)value;
                Image contactImage = ContactManager.getContactImage(contact, this.photoSize, false, true);
                this.setText(ContactManager.getContactFullName(contact));
                this.setIcon(new ImageIcon(contactImage));
            } else if (value instanceof LiteMyContact) {
                LiteMyContact contact = (LiteMyContact)value;
                String contactJID = contact.getId() + "@externalcontact";
                String contactName = contact.getName();
                Image contactImage = ContactManager.getExternalContactImage(contact, this.photoSize, false, true);
                this.setIcon(new ImageIcon(contactImage));
                this.setText((String)(contactName == null ? contactJID : contactName));
            } else if (value instanceof LiteConferenceRoom) {
                LiteConferenceRoom confRoom = (LiteConferenceRoom)value;
                this.setIcon(UIConstants.ICON_CONFERENCEROOM_USING_48);
                this.setText(ChatRoomUtil.getConfRoomTitle(ctx, null, confRoom, true, true));
            } else if (value instanceof String) {
                String groupName = (String)value;
                List<String> participants = UCDBGroup.findGroupParticipants(UCChatClient.context, groupName);
                ArrayList<Image> participantImages = new ArrayList<Image>();
                int participantCount = participants.size();
                for (int i = 0; i < participantCount; ++i) {
                    LiteContact contact = ContactManager.getContact((Context)UCChatClient.context, participants.get(i));
                    Image bi = ContactManager.getContactImage(contact, this.photoSize, true, false);
                    if (bi == null) {
                        participantImages.add(UIConstants.ICON_PERSON48.getImage());
                        continue;
                    }
                    participantImages.add(0, bi);
                }
                Image compoundedImage = GraphicUtil.getCompoundRoundedCornerImage(participantImages, 48, 48, true, true);
                int count = participantImages == null ? 0 : participantImages.size();
                this.setIcon(new ImageIcon(compoundedImage));
                this.setText(groupName + " (" + String.format(I18NUtil.getString("conference_member_count"), count) + ")");
            } else {
                this.setText("!!" + value.toString());
            }
            this.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        }
        catch (Throwable t) {
            Log.e(SelectChatroomDialog.class.getSimpleName(), t.getLocalizedMessage(), t);
        }
        return this;
    }
}

