/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.main;

import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.RoundedCornerPanel;
import com.blisscloud.ezuc.client.main.ChooseDataImportOptionCallback;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import org.apache.commons.lang3.StringUtils;

public class ChooseDataImportDayPanel
extends RoundedCornerPanel {
    private JPanel jPanel;
    private JPanel jPanel1;
    private JLabel lblTitle;
    private JButton btnConfirm;
    private JButton btnCancel;
    ButtonGroup buttonGroup1 = new ButtonGroup();
    ChooseDataImportOptionCallback callback;
    long maxDaysCount;
    private JTextField inputDayTextField;

    public ChooseDataImportDayPanel(long maxDaysCount, ChooseDataImportOptionCallback callback) {
        this.callback = callback;
        this.maxDaysCount = maxDaysCount;
        this.initGUI();
    }

    private void initGUI() {
        try {
            GridBagLayout panelContentLayout = new GridBagLayout();
            this.setLayout(panelContentLayout);
            this.setBackground(Color.WHITE);
            this.lblTitle = new JLabel();
            this.add((Component)this.lblTitle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 10, 10, 10), 0, 0));
            this.lblTitle.setText(String.format(I18NUtil.getString("init_data_option_days_specific_info"), this.maxDaysCount));
            this.lblTitle.setFont(UIConstants.FONT_16_PLAIN);
            this.lblTitle.setPreferredSize(new Dimension(300, 20));
            this.jPanel = new JPanel();
            FlowLayout panelFunctionLayout = new FlowLayout();
            panelFunctionLayout.setHgap(4);
            panelFunctionLayout.setVgap(0);
            this.jPanel.setLayout(panelFunctionLayout);
            this.jPanel.setOpaque(false);
            this.add((Component)this.jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 10, 0, 10), 0, 0));
            JLabel x1 = new JLabel();
            x1.setText(I18NUtil.getString("init_data_option_days_prefix"));
            x1.setFont(UIConstants.FONT_14_PLAIN);
            this.jPanel.add(x1);
            this.inputDayTextField = new JTextField();
            this.inputDayTextField.setFont(UIConstants.FONT_14_PLAIN);
            this.inputDayTextField.setPreferredSize(new Dimension(50, 28));
            this.inputDayTextField.setMinimumSize(new Dimension(50, 28));
            this.inputDayTextField.setText("14");
            this.inputDayTextField.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (StringUtils.isNotBlank((CharSequence)ChooseDataImportDayPanel.this.inputDayTextField.getText()) && Long.parseLong(ChooseDataImportDayPanel.this.inputDayTextField.getText()) > ChooseDataImportDayPanel.this.maxDaysCount) {
                        ChooseDataImportDayPanel.this.inputDayTextField.setText(String.valueOf(ChooseDataImportDayPanel.this.maxDaysCount));
                    }
                }
            });
            ((AbstractDocument)this.inputDayTextField.getDocument()).setDocumentFilter(new NumericAndLengthFilter(this, 4));
            this.jPanel.add(this.inputDayTextField);
            JLabel x2 = new JLabel();
            x2.setText(I18NUtil.getString("init_data_option_days_suffix"));
            x2.setFont(UIConstants.FONT_14_PLAIN);
            this.jPanel.add(x2);
            this.jPanel1 = new JPanel();
            FlowLayout jPanel1Layout = new FlowLayout();
            jPanel1Layout.setAlignment(1);
            jPanel1Layout.setHgap(10);
            this.jPanel1.setLayout(jPanel1Layout);
            this.add((Component)this.jPanel1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 0, 10, 0), 0, 0));
            this.jPanel1.setOpaque(false);
            this.btnConfirm = new JButton();
            this.jPanel1.add(this.btnConfirm);
            this.btnConfirm.setText(I18NUtil.getString("common_btn_ok"));
            this.btnConfirm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ChooseDataImportDayPanel.this.btnConfirmActionPerformed(evt);
                }
            });
            this.btnCancel = new JButton();
            this.jPanel1.add(this.btnCancel);
            this.btnCancel.setText(I18NUtil.getString("common_btn_cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ChooseDataImportDayPanel.this.btnCancelActionPerformed(evt);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void btnConfirmActionPerformed(ActionEvent evt) {
        if (this.callback != null) {
            long daysAgo = -1L;
            if (StringUtils.isNotBlank((CharSequence)this.inputDayTextField.getText())) {
                daysAgo = Long.parseLong(this.inputDayTextField.getText());
            }
            if (daysAgo > this.maxDaysCount) {
                daysAgo = this.maxDaysCount;
            }
            this.callback.optionConfirmed(daysAgo);
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        if (this.callback != null) {
            this.callback.optionCancelBack();
        }
    }

    private class NumericAndLengthFilter
    extends DocumentFilter {
        private int maxLength = 0;

        public NumericAndLengthFilter(ChooseDataImportDayPanel chooseDataImportDayPanel, int maxLength) {
            this.maxLength = maxLength;
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (this.isNumeric(text)) {
                if (this.maxLength > 0 && fb.getDocument().getLength() - length + text.length() > this.maxLength) {
                    return;
                }
                super.replace(fb, offset, length, text, attrs);
            }
        }

        private boolean isNumeric(String text) {
            if (text == null || text.trim().equals("")) {
                return false;
            }
            for (int iCount = 0; iCount < text.length(); ++iCount) {
                if (Character.isDigit(text.charAt(iCount))) continue;
                return false;
            }
            return true;
        }
    }
}

