/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.main;

import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.bean.DataImportBean;
import com.blisscloud.ezuc.client.component.DataImportCellRenderer;
import com.blisscloud.ezuc.client.component.RoundedCornerPanel;
import com.blisscloud.ezuc.client.main.ChooseDataImportOptionCallback;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ChooseDataImportPanel
extends RoundedCornerPanel
implements ListSelectionListener {
    private JScrollPane jScrollPane1;
    private JList<DataImportBean> listContact;
    private JPanel jPanel1;
    private JLabel lblTitle;
    private JButton btnConfirm;
    ButtonGroup buttonGroup1 = new ButtonGroup();
    private DefaultComboBoxModel<DataImportBean> listModelContact = new DefaultComboBoxModel();
    ChooseDataImportOptionCallback callback;

    public ChooseDataImportPanel(long maxDaysCount, ChooseDataImportOptionCallback callback) {
        this.callback = callback;
        this.initGUI();
        this.parepareData(maxDaysCount);
    }

    private void initGUI() {
        try {
            GridBagLayout panelContentLayout = new GridBagLayout();
            this.setLayout(panelContentLayout);
            this.setBackground(Color.WHITE);
            this.lblTitle = new JLabel();
            this.add((Component)this.lblTitle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 10, 10, 10), 0, 0));
            this.lblTitle.setText(I18NUtil.getString("init_data_option_title"));
            this.lblTitle.setFont(UIConstants.FONT_16_PLAIN);
            this.lblTitle.setPreferredSize(new Dimension(300, 20));
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(60);
            this.add((Component)this.jScrollPane1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 10, 0, 10), 0, 0));
            this.listContact = new JList();
            this.jScrollPane1.setViewportView(this.listContact);
            this.listContact.setCellRenderer(new DataImportCellRenderer());
            this.listContact.setModel(this.listModelContact);
            this.listContact.setSelectionMode(0);
            this.listContact.addListSelectionListener(this);
            this.jPanel1 = new JPanel();
            FlowLayout jPanel1Layout = new FlowLayout();
            jPanel1Layout.setAlignment(1);
            jPanel1Layout.setHgap(10);
            this.jPanel1.setLayout(jPanel1Layout);
            this.add((Component)this.jPanel1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 0, 10, 0), 0, 0));
            this.jPanel1.setOpaque(false);
            this.btnConfirm = new JButton();
            this.btnConfirm.setEnabled(false);
            this.jPanel1.add(this.btnConfirm);
            this.btnConfirm.setText(I18NUtil.getString("common_btn_ok"));
            this.btnConfirm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ChooseDataImportPanel.this.btnConfirmActionPerformed(evt);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parepareData(long daysCount) {
        this.listModelContact.removeAllElements();
        this.listModelContact.addElement(new DataImportBean(-1L, daysCount));
        if (daysCount > 0L) {
            this.listModelContact.addElement(new DataImportBean(-2L, daysCount));
        }
        if (daysCount > 14L) {
            this.listModelContact.addElement(new DataImportBean(14L, daysCount));
        }
        if (daysCount > 30L) {
            this.listModelContact.addElement(new DataImportBean(30L, daysCount));
        }
        if (daysCount > 90L) {
            this.listModelContact.addElement(new DataImportBean(90L, daysCount));
            this.listModelContact.addElement(new DataImportBean(365L, daysCount));
        }
        this.listModelContact.addElement(new DataImportBean(daysCount, daysCount));
        this.listContact.setSelectedIndex(2);
    }

    private void btnConfirmActionPerformed(ActionEvent evt) {
        if (this.callback != null) {
            long daysAgo = -1L;
            DataImportBean d = this.listContact.getSelectedValue();
            if (d != null) {
                daysAgo = d.getDays();
            }
            this.callback.optionConfirmed(daysAgo);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        DataImportBean node = this.listContact.getSelectedValue();
        if (node != null) {
            this.btnConfirm.setEnabled(true);
        } else {
            this.btnConfirm.setEnabled(false);
        }
    }
}

