/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.main;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.main.ChoosePBXSitePanel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;

public class ChoosePBXSiteUtils {
    String[] siteIds;
    String[] siteNames;
    int oldPosition = -1;
    int newPosition = -1;
    boolean isRingOnChoosePbxSite = false;
    boolean isSelect = true;
    ChoosePBXSitePanel choosePBXSitePanel;

    public ChoosePBXSiteUtils() {
        String sip_my_pbx_site_list = PreferencesUtil.getSipMyPbxSiteList(UCChatClient.context);
        this.siteIds = CommonUtil.getJsonDataArray(sip_my_pbx_site_list, "id");
        this.siteNames = CommonUtil.getJsonDataArray(sip_my_pbx_site_list, "name");
        long useSiteId = PreferencesUtil.getSipUsePbxSite(UCChatClient.context);
        if (useSiteId == -1L && this.siteIds.length < 2) {
            return;
        }
        for (int i = 0; i < this.siteIds.length; ++i) {
            if (useSiteId != Long.parseLong(this.siteIds[i])) continue;
            this.oldPosition = i;
            break;
        }
        this.isRingOnChoosePbxSite = false;
        this.choosePBXSitePanel = new ChoosePBXSitePanel(this.siteIds, this.siteNames, this.oldPosition, this.isRingOnChoosePbxSite, new ChoosePBXSitePanel.ChoosePBXSiteCallback(){

            @Override
            public void pbxSiteConfirmed(int siteIndex, boolean ringOnChoosePbxSite) {
                ChoosePBXSiteUtils.this.pbxSiteSelected(siteIndex, ringOnChoosePbxSite);
            }
        });
        UCChatClient.getInstance().showGlassPanel(this.choosePBXSitePanel, false);
    }

    private void pbxSiteSelected(int newPosition, boolean isRingOnChoosePbxSite) {
        UCChatClient.getInstance().hideGlassPanel();
        Activity ctx = UCChatClient.context;
        Log.d(ChoosePBXSiteUtils.class.getSimpleName(), "newPosition:" + newPosition);
        if (newPosition == -1) {
            newPosition = this.oldPosition;
        }
        this.isSelect = true;
        String newId = this.siteIds[newPosition];
        Log.d(ChoosePBXSiteUtils.class.getSimpleName(), "site oldId:" + PreferencesUtil.getSipUsePbxSite(ctx) + " newId:" + newId + " isRing:false");
        long useSiteId = PreferencesUtil.getSipUsePbxSite(ctx);
        if (useSiteId != Long.parseLong(newId)) {
            PreferencesUtil.setSipUsePbxSite(ctx, newId);
            PreferencesUtil.cleanSipPhoneInfo(ctx);
            WebAgent.getInstance().updateLoginSite();
            BroadcastUtil.sendCurrentSiteChanged(ctx);
            ToastUtil.showLong(I18NUtil.getString("network_notice_connect_now"));
            BroadcastUtil.sendStopPhoneServiceRequestEvent(UCChatClient.context, "doChangeSite");
            WebAgent.getInstance().startSipRequestProcess("ChoosePBXSiteUtils onClick MainAct");
            this.refreshListSinceMeetmePrefixMayChanged();
        } else if (PhoneAgent.isRegistered != PhoneAgent.STAT_REGISTERED) {
            BroadcastUtil.sendStartPhoneAfterWebLoginRequestEvent(ctx, "ChoosePBXSiteUtils onTouch OUTSIDE");
        }
    }

    private void refreshListSinceMeetmePrefixMayChanged() {
        Activity ctx = UCChatClient.context;
        if (this.siteIds.length > 1) {
            BroadcastUtil.sendContactHistoryChangedEvent(ctx);
            BroadcastUtil.sendMeetmePrefixChangedEvent(ctx);
        }
    }
}

