/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.main;

import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.main.QueryTableModel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.mobile.ezuc.db.UCDBHelper;
import com.blisscloud.mobile.ezuc.db.UserDatabase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DatabaseFrame
extends JFrame {
    Connection conn;
    Statement statement;
    private JPanel contentPanel;
    private JLabel lblTables;
    private JComboBox cmbTables;
    private JLabel lblSQL;
    private JRadioButton rbUser;
    private JRadioButton rbUC;
    private JPanel jPanel1;
    private JLabel lblStatus;
    private JLabel lblDatabase;
    private JTextField txtSQL;
    private JScrollPane spResult;
    private JTable tableResult;
    private JButton btnQuery;
    String databaseURL = UCDBHelper.DATABASE_URL;
    DefaultComboBoxModel cmbTablesModel = new DefaultComboBoxModel();
    QueryTableModel qtm = new QueryTableModel();
    ButtonGroup buttonGroup1 = new ButtonGroup();

    public DatabaseFrame() {
        this.initGUI();
        this.initDB();
        this.buttonGroup1.add(this.rbUC);
        this.buttonGroup1.add(this.rbUser);
    }

    private void initGUI() {
        try {
            this.setDefaultCloseOperation(2);
            this.contentPanel = new JPanel();
            GridBagLayout contentPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.contentPanel, "Center");
            this.contentPanel.setLayout(contentPanelLayout);
            this.contentPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.lblDatabase = new JLabel();
            this.contentPanel.add((Component)this.lblDatabase, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblDatabase.setText("\u8cc7\u6599\u5eab : ");
            this.jPanel1 = new JPanel();
            FlowLayout jPanel1Layout = new FlowLayout();
            jPanel1Layout.setAlignment(0);
            jPanel1Layout.setVgap(0);
            this.jPanel1.setLayout(jPanel1Layout);
            this.contentPanel.add((Component)this.jPanel1, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.rbUC = new JRadioButton();
            this.jPanel1.add(this.rbUC);
            this.rbUC.setText("UC");
            this.rbUC.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.rbUC.setSelected(true);
            this.rbUC.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    DatabaseFrame.this.rbUCItemStateChanged(evt);
                }
            });
            this.rbUser = new JRadioButton();
            this.jPanel1.add(this.rbUser);
            this.rbUser.setText("User");
            this.rbUser.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            this.rbUser.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    DatabaseFrame.this.rbUserItemStateChanged(evt);
                }
            });
            this.lblTables = new JLabel();
            this.contentPanel.add((Component)this.lblTables, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.lblTables.setText("\u8868\u683c : ");
            this.cmbTables = new JComboBox();
            this.contentPanel.add((Component)this.cmbTables, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.cmbTables.setModel(this.cmbTablesModel);
            this.cmbTables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DatabaseFrame.this.cmbTablesActionPerformed(evt);
                }
            });
            this.lblSQL = new JLabel();
            this.contentPanel.add((Component)this.lblSQL, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.lblSQL.setText("SQL : ");
            this.txtSQL = new JTextField();
            this.contentPanel.add((Component)this.txtSQL, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.txtSQL.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DatabaseFrame.this.txtSQLActionPerformed(evt);
                }
            });
            this.btnQuery = new JButton();
            this.contentPanel.add((Component)this.btnQuery, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.btnQuery.setText("\u57f7\u884c\u67e5\u8a62");
            this.btnQuery.setPreferredSize(new Dimension(100, 36));
            this.btnQuery.setMinimumSize(new Dimension(100, 36));
            this.btnQuery.setFont(new Font("\u5fae\u8edf\u6b63\u9ed1\u9ad4", 1, 14));
            this.btnQuery.setForeground(Color.RED);
            this.btnQuery.setFocusPainted(false);
            this.btnQuery.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DatabaseFrame.this.btnQueryActionPerformed(evt);
                }
            });
            this.spResult = new JScrollPane();
            this.contentPanel.add((Component)this.spResult, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.tableResult = new JTable();
            this.spResult.setViewportView(this.tableResult);
            this.tableResult.setModel(this.qtm);
            this.lblStatus = new JLabel();
            this.contentPanel.add((Component)this.lblStatus, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.lblStatus.setText(" ");
            this.setTitle(I18NUtil.getAppName() + " Check Database - " + this.databaseURL);
            this.setIconImages(Arrays.asList(UIConstants.ICON_LOGO16.getImage(), UIConstants.ICON_LOGO32.getImage(), UIConstants.ICON_LOGO64.getImage()));
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    DatabaseFrame.this.thisWindowClosing(evt);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void rbUCItemStateChanged(ItemEvent evt) {
        if (this.rbUC.isSelected()) {
            this.switchDB(UCDBHelper.DATABASE_URL);
        }
    }

    private void rbUserItemStateChanged(ItemEvent evt) {
        if (this.rbUser.isSelected()) {
            this.switchDB(UserDatabase.DATABASE_URL);
        }
    }

    private void cmbTablesActionPerformed(ActionEvent evt) {
        if (this.cmbTables.getSelectedItem() != null) {
            String tableName = this.cmbTables.getSelectedItem().toString();
            this.txtSQL.setText("select * from " + tableName);
            this.txtSQL.requestFocus();
        }
    }

    private void txtSQLActionPerformed(ActionEvent evt) {
        this.executeSQL();
    }

    private void btnQueryActionPerformed(ActionEvent evt) {
        this.executeSQL();
    }

    private void thisWindowClosing(WindowEvent evt) {
        this.closeDB();
    }

    private void switchDB(String databaseURL) {
        this.databaseURL = databaseURL;
        this.closeDB();
        this.initDB();
    }

    private void executeSQL() {
        this.btnQuery.setIcon(UIConstants.ICON_LOADING24);
        final String sql = this.txtSQL.getText();
        Thread queryTask = new Thread("DatabaseFrameExecuteSQL"){

            @Override
            public void run() {
                try {
                    ResultSet rs = DatabaseFrame.this.statement.executeQuery(sql);
                    DatabaseFrame.this.qtm.setQuery(rs);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DatabaseFrame.this.qtm.fireTableChanged(null);
                            DatabaseFrame.this.btnQuery.setIcon(null);
                            DatabaseFrame.this.lblStatus.setText("\u67e5\u8a62\u7d50\u679c : \u5171 " + DatabaseFrame.this.qtm.getRowCount() + " \u7b46\u8cc7\u6599");
                        }
                    });
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    final String errorMsg = e.getLocalizedMessage();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DatabaseFrame.this.btnQuery.setIcon(null);
                            JOptionPane.showMessageDialog(DatabaseFrame.this, "\u539f\u56e0:\n" + errorMsg, "\u67e5\u8a62\u5931\u6557!", 0);
                        }
                    });
                }
            }
        };
        queryTask.start();
    }

    private void initDB() {
        this.btnQuery.setEnabled(false);
        Thread connectTask = new Thread("DatabaseFrameInitDB"){

            @Override
            public void run() {
                try {
                    Properties prop = new Properties();
                    prop.setProperty("readonly", "true");
                    DatabaseFrame.this.conn = DriverManager.getConnection("jdbc:hsqldb:file:" + DatabaseFrame.this.databaseURL, prop);
                    DatabaseFrame.this.statement = DatabaseFrame.this.conn.createStatement();
                    String TABLE_NAME = "TABLE_NAME";
                    String[] TABLE_TYPES = new String[]{"TABLE"};
                    DatabaseMetaData dbmd = DatabaseFrame.this.conn.getMetaData();
                    final ArrayList<String> tableNames = new ArrayList<String>();
                    ResultSet tables = dbmd.getTables(null, null, null, TABLE_TYPES);
                    while (tables.next()) {
                        String tableName = tables.getString(TABLE_NAME);
                        tableNames.add(tableName);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DatabaseFrame.this.lblStatus.setText("\u5df2\u9023\u7dda\u8cc7\u6599\u5eab " + DatabaseFrame.this.databaseURL);
                            DatabaseFrame.this.btnQuery.setEnabled(true);
                            DatabaseFrame.this.cmbTablesModel.removeAllElements();
                            for (String tableName : tableNames) {
                                DatabaseFrame.this.cmbTablesModel.addElement(tableName);
                            }
                            DatabaseFrame.this.txtSQL.setText("select * from " + String.valueOf(DatabaseFrame.this.cmbTablesModel.getElementAt(0)));
                        }
                    });
                }
                catch (Exception e) {
                    System.out.println("Could not initialize the database.");
                    e.printStackTrace();
                    final String errorMsg = e.getLocalizedMessage();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DatabaseFrame.this.lblStatus.setText("\u7121\u6cd5\u9023\u7dda\u8cc7\u6599\u5eab! \u8a0a\u606f:" + errorMsg);
                        }
                    });
                }
            }
        };
        connectTask.start();
    }

    private void closeDB() {
        try {
            if (this.statement != null) {
                this.statement.close();
            }
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (Exception e) {
            System.out.println("Could not close the current connection.");
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                    UIManager.put("PopupMenu.consumeEventOnClose", Boolean.FALSE);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                DatabaseFrame inst = new DatabaseFrame();
                Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                inst.setSize((int)((double)screen.width * 0.7), (int)((double)screen.height * 0.8));
                inst.setLocationRelativeTo(null);
                inst.setVisible(true);
            }
        });
    }

    static {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

