/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.main;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.RoundedCornerPanel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class EnterpriseInfoPanel
extends RoundedCornerPanel {
    private static final String EMPTY_VALUE = "--";
    private JLabel lblTitle;
    private JLabel lblUCRMStatus;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel lblSIPStatus;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel lblUCRMAddress;
    private JLabel jLabel9;
    private JLabel lblUCRMPort;
    private JLabel jLabel11;
    private JLabel lblUCRMAccount;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel lblSIPAddress;
    private JLabel jLabel16;
    private JLabel lblSIPPort;
    private JLabel jLabel18;
    private JLabel lblSIPAccount;
    private JLabel jLabel20;
    private JLabel lblEnterpriseNo;
    private JLabel jLabel22;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private JPanel jPanel5;
    private JPanel jPanel4;
    private JPanel jPanel3;
    private JPanel jPanel2;
    private JPanel jPanel1;
    private JPanel panelContent;
    private JSeparator jSeparator1;
    private JButton btnConfirm;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new EnterpriseInfoPanel());
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public EnterpriseInfoPanel() {
        this.initGUI();
        this.loadEnterpriseInfo();
    }

    private void initGUI() {
        try {
            GridBagLayout thisLayout = new GridBagLayout();
            this.setLayout(thisLayout);
            this.setBackground(UIConstants.COLOR_DIALOG_BACKGROUND);
            this.lblTitle = new JLabel();
            this.add((Component)this.lblTitle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 10, 20), 0, 0));
            this.lblTitle.setText(I18NUtil.getString("fun_title_server_info"));
            this.lblTitle.setFont(UIConstants.FONT_16_BOLD);
            this.lblTitle.setForeground(UIConstants.COLOR_DIALOG_TITLE);
            this.jSeparator1 = new JSeparator();
            this.add((Component)this.jSeparator1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panelContent = new JPanel();
            BorderLayout panelContentLayout = new BorderLayout();
            panelContentLayout.setVgap(8);
            this.panelContent.setLayout(panelContentLayout);
            this.add((Component)this.panelContent, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelContent.setOpaque(false);
            this.panelContent.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
            this.jPanel1 = new JPanel();
            FlowLayout jPanel1Layout = new FlowLayout();
            jPanel1Layout.setAlignment(0);
            jPanel1Layout.setHgap(8);
            this.jPanel1.setLayout(jPanel1Layout);
            this.panelContent.add((Component)this.jPanel1, "North");
            this.jPanel1.setBackground(Color.WHITE);
            this.jLabel20 = new JLabel();
            this.jPanel1.add(this.jLabel20);
            this.jLabel20.setText(I18NUtil.getString("login_enterprise_no"));
            this.jLabel20.setFont(UIConstants.FONT_16_PLAIN);
            this.lblEnterpriseNo = new JLabel();
            this.jPanel1.add(this.lblEnterpriseNo);
            this.lblEnterpriseNo.setText("blisscloud");
            this.lblEnterpriseNo.setFont(UIConstants.FONT_16_PLAIN);
            this.lblEnterpriseNo.setForeground(Color.GRAY);
            this.jPanel2 = new JPanel();
            BoxLayout jPanel2Layout = new BoxLayout(this.jPanel2, 0);
            this.jPanel2.setLayout(jPanel2Layout);
            this.panelContent.add((Component)this.jPanel2, "Center");
            this.jPanel2.setOpaque(false);
            this.jPanel3 = new JPanel();
            this.jPanel2.add(this.jPanel3);
            GridBagLayout jPanel3Layout = new GridBagLayout();
            this.jPanel3.setLayout(jPanel3Layout);
            this.jPanel3.setBackground(Color.WHITE);
            this.jPanel3.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            this.jLabel1 = new JLabel();
            this.jPanel3.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel1.setText(I18NUtil.getString("conn_label_server_status"));
            this.jLabel1.setFont(UIConstants.FONT_16_PLAIN);
            this.jLabel2 = new JLabel();
            this.jPanel3.add((Component)this.jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 16, 0, 0), 0, 0));
            this.jLabel2.setText(I18NUtil.getString("conn_label_ucrm_server_status"));
            this.jLabel2.setFont(UIConstants.FONT_14_PLAIN);
            this.lblUCRMStatus = new JLabel();
            this.jPanel3.add((Component)this.lblUCRMStatus, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 16, 0, 0), 0, 0));
            this.lblUCRMStatus.setText("\u5df2\u9023\u7dda");
            this.lblUCRMStatus.setForeground(Color.GRAY);
            this.jLabel4 = new JLabel();
            this.jPanel3.add((Component)this.jLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 16, 0, 0), 0, 0));
            this.jLabel4.setText(I18NUtil.getString("conn_label_phone_server_status"));
            this.jLabel4.setFont(UIConstants.FONT_14_PLAIN);
            this.lblSIPStatus = new JLabel();
            this.jPanel3.add((Component)this.lblSIPStatus, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 16, 0, 0), 0, 0));
            this.lblSIPStatus.setText("\u5df2\u9023\u7dda");
            this.lblSIPStatus.setForeground(Color.GRAY);
            this.jLabel22 = new JLabel();
            this.jPanel3.add((Component)this.jLabel22, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel22.setText(" ");
            this.jPanel2.add(Box.createHorizontalStrut(8));
            this.jPanel4 = new JPanel();
            this.jPanel2.add(this.jPanel4);
            GridBagLayout jPanel4Layout = new GridBagLayout();
            this.jPanel4.setLayout(jPanel4Layout);
            this.jPanel4.setBackground(Color.WHITE);
            this.jPanel4.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            this.jLabel6 = new JLabel();
            this.jPanel4.add((Component)this.jLabel6, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel6.setText(I18NUtil.getString("conn_label_ucrm_server_conf"));
            this.jLabel6.setFont(UIConstants.FONT_16_PLAIN);
            this.jLabel7 = new JLabel();
            this.jPanel4.add((Component)this.jLabel7, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 16, 0, 0), 0, 0));
            this.jLabel7.setText(I18NUtil.getString("conn_label_server_address"));
            this.jLabel7.setFont(UIConstants.FONT_14_PLAIN);
            this.lblUCRMAddress = new JLabel();
            this.jPanel4.add((Component)this.lblUCRMAddress, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 16, 0, 0), 0, 0));
            this.lblUCRMAddress.setText("101.251.110.134");
            this.lblUCRMAddress.setForeground(Color.GRAY);
            this.jLabel9 = new JLabel();
            this.jPanel4.add((Component)this.jLabel9, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 16, 0, 0), 0, 0));
            this.jLabel9.setText(I18NUtil.getString("conn_label_server_port"));
            this.jLabel9.setFont(UIConstants.FONT_14_PLAIN);
            this.lblUCRMPort = new JLabel();
            this.jPanel4.add((Component)this.lblUCRMPort, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 16, 0, 0), 0, 0));
            this.lblUCRMPort.setText("10443");
            this.lblUCRMPort.setForeground(Color.GRAY);
            this.jLabel11 = new JLabel();
            this.jPanel4.add((Component)this.jLabel11, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 16, 0, 0), 0, 0));
            this.jLabel11.setText(I18NUtil.getString("conn_label_server_account"));
            this.jLabel11.setFont(UIConstants.FONT_14_PLAIN);
            this.lblUCRMAccount = new JLabel();
            this.jPanel4.add((Component)this.lblUCRMAccount, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 16, 0, 0), 0, 0));
            this.lblUCRMAccount.setText("albert.chiou");
            this.lblUCRMAccount.setForeground(Color.GRAY);
            this.jLabel3 = new JLabel();
            this.jPanel4.add((Component)this.jLabel3, new GridBagConstraints(0, 7, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel3.setText(" ");
            this.jPanel2.add(Box.createHorizontalStrut(8));
            this.jPanel5 = new JPanel();
            GridBagLayout jPanel5Layout = new GridBagLayout();
            this.jPanel2.add(this.jPanel5);
            this.jPanel5.setLayout(jPanel5Layout);
            this.jPanel5.setBackground(Color.WHITE);
            this.jPanel5.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            this.jLabel13 = new JLabel();
            this.jPanel5.add((Component)this.jLabel13, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel13.setText(I18NUtil.getString("conn_label_phone_server_conf"));
            this.jLabel13.setFont(UIConstants.FONT_16_PLAIN);
            this.jLabel14 = new JLabel();
            this.jPanel5.add((Component)this.jLabel14, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 16, 0, 0), 0, 0));
            this.jLabel14.setText(I18NUtil.getString("conn_label_server_address"));
            this.jLabel14.setFont(UIConstants.FONT_14_PLAIN);
            this.lblSIPAddress = new JLabel();
            this.jPanel5.add((Component)this.lblSIPAddress, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 16, 0, 0), 0, 0));
            this.lblSIPAddress.setText("101.251.110.134");
            this.lblSIPAddress.setForeground(Color.GRAY);
            this.jLabel16 = new JLabel();
            this.jPanel5.add((Component)this.jLabel16, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 16, 0, 0), 0, 0));
            this.jLabel16.setText(I18NUtil.getString("conn_label_server_port"));
            this.jLabel16.setFont(UIConstants.FONT_14_PLAIN);
            this.lblSIPPort = new JLabel();
            this.jPanel5.add((Component)this.lblSIPPort, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 16, 0, 0), 0, 0));
            this.lblSIPPort.setText("10461");
            this.lblSIPPort.setForeground(Color.GRAY);
            this.jLabel18 = new JLabel();
            this.jPanel5.add((Component)this.jLabel18, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 16, 0, 0), 0, 0));
            this.jLabel18.setText(I18NUtil.getString("conn_label_server_account"));
            this.jLabel18.setFont(UIConstants.FONT_14_PLAIN);
            this.lblSIPAccount = new JLabel();
            this.jPanel5.add((Component)this.lblSIPAccount, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 16, 0, 0), 0, 0));
            this.lblSIPAccount.setText("albert.chiou.mobile");
            this.lblSIPAccount.setForeground(Color.GRAY);
            this.jLabel5 = new JLabel();
            this.jPanel5.add((Component)this.jLabel5, new GridBagConstraints(0, 7, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel5.setText(" ");
            this.btnConfirm = new JButton();
            this.add((Component)this.btnConfirm, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
            this.btnConfirm.setText(I18NUtil.getString("common_btn_ok"));
            this.btnConfirm.setMinimumSize(new Dimension(75, 30));
            this.btnConfirm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EnterpriseInfoPanel.this.btnConfirmActionPerformed(evt);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadEnterpriseInfo() {
        Activity context = UCChatClient.context;
        String enterpriseNo = PreferencesUtil.getEnterpriseNo(context);
        if (TextUtils.isNotBlank((CharSequence)enterpriseNo)) {
            this.lblEnterpriseNo.setText(enterpriseNo.trim());
        } else {
            this.lblEnterpriseNo.setText(EMPTY_VALUE);
        }
        this.lblUCRMStatus.setText(this.getUcrmStatusSummary());
        this.lblSIPStatus.setText(this.getSipStatusSummary());
        boolean inoffice = PreferencesUtil.isInOffice(UCChatClient.context);
        this.lblUCRMAddress.setText(inoffice ? PreferencesUtil.getHost(context) : PreferencesUtil.getExternalHost(context));
        this.lblUCRMPort.setText(inoffice ? String.valueOf(8443) : String.valueOf(PreferencesUtil.getExternalPort(context)));
        this.lblUCRMAccount.setText(PreferencesUtil.getString(context, "WEB_LOGIN_ID", EMPTY_VALUE));
        boolean sipInOffice = PreferencesUtil.isSipInternal(UCChatClient.context);
        this.lblSIPAddress.setText(sipInOffice ? PreferencesUtil.getSipRealm(context) : PreferencesUtil.getSipRealmExternal(context));
        this.lblSIPPort.setText(sipInOffice ? String.valueOf(PreferencesUtil.getSipTlsPort(context)) : String.valueOf(PreferencesUtil.getSipExternalPort(context)));
        this.lblSIPAccount.setText(PreferencesUtil.getString(context, "SIP_USER_NAME", EMPTY_VALUE));
    }

    private void btnConfirmActionPerformed(ActionEvent evt) {
        UCChatClient.getInstance().hideGlassPanel();
    }

    private String getUcrmStatusSummary() {
        Object ucrmSummary = "";
        if (WebAgent.isLogin) {
            ucrmSummary = I18NUtil.getString("conn_label_stat_connected");
        } else {
            ucrmSummary = I18NUtil.getString("conn_label_stat_disconnected");
            String msg = WebAgent.getInstance().getLogingFailMsg();
            if (msg != null && !"".equals(msg.trim())) {
                ucrmSummary = (String)ucrmSummary + "(" + msg + ")";
            }
        }
        return ucrmSummary;
    }

    private String getSipStatusSummary() {
        String sipSummary = "";
        sipSummary = PreferencesUtil.hasPhoneCallLicense(UCChatClient.context) ? (PhoneAgent.isRegistered == PhoneAgent.STAT_REGISTERED ? I18NUtil.getString("conn_label_stat_connected") : I18NUtil.getString("conn_label_stat_disconnected")) : I18NUtil.getString("permission_no_voice_license");
        return sipSummary;
    }
}

