/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.main;

import com.blisscloud.ezuc.client.util.simulate.Log;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.Port;

public class MixVolume {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setVolume(float percentage) {
        Mixer.Info[] mixers;
        for (Mixer.Info mixerInfo : mixers = AudioSystem.getMixerInfo()) {
            Line.Info[] targetLines;
            Line.Info[] sourceLines;
            Log.i(MixVolume.class.getSimpleName(), "mixer name: " + mixerInfo.getName());
            Log.i(MixVolume.class.getSimpleName(), "-source----------------------------------------");
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            boolean hasSource = false;
            boolean hasPort = false;
            for (Line.Info li : sourceLines = mixer.getSourceLineInfo()) {
                Log.i(MixVolume.class.getSimpleName(), "Found source line: " + String.valueOf(li) + " " + String.valueOf(li.getClass()));
                if (!(li instanceof Port.Info)) continue;
                hasPort = true;
                Port.Info portInfo = (Port.Info)li;
                Log.i(MixVolume.class.getSimpleName(), "port found " + portInfo.getName() + " is source " + portInfo.isSource());
                if (!portInfo.isSource()) continue;
                hasSource = true;
            }
            Log.i(MixVolume.class.getSimpleName(), "-target----------------------------------------");
            for (Line.Info li : targetLines = mixer.getTargetLineInfo()) {
                Log.i(MixVolume.class.getSimpleName(), "Found target line: " + String.valueOf(li) + " " + String.valueOf(li.getClass()));
                if (!(li instanceof Port.Info)) continue;
                hasPort = true;
                Port.Info portInfo = (Port.Info)li;
                Log.i(MixVolume.class.getSimpleName(), "port found " + portInfo.getName() + " is source " + portInfo.isSource());
                if (!portInfo.isSource()) continue;
                hasSource = true;
            }
            if (!hasSource && hasPort) {
                Line.Info[] lineInfos;
                for (Line.Info lineInfo : lineInfos = mixer.getTargetLineInfo()) {
                    Log.i(MixVolume.class.getSimpleName(), "prepare to setVolume Line.Info: " + String.valueOf(lineInfo));
                    Line line = null;
                    boolean opened = true;
                    try {
                        line = mixer.getLine(lineInfo);
                        opened = line.isOpen();
                        if (!opened) {
                            line.open();
                        }
                        FloatControl volCtrl = (FloatControl)line.getControl(FloatControl.Type.VOLUME);
                        Log.i(MixVolume.class.getSimpleName(), "original: " + volCtrl.getValue());
                        volCtrl.setValue(volCtrl.getMaximum() * percentage);
                        Log.i(MixVolume.class.getSimpleName(), "after changed: " + volCtrl.getValue());
                    }
                    catch (LineUnavailableException e) {
                        Log.e(MixVolume.class.getSimpleName(), "ERROR:" + e.getMessage());
                    }
                    catch (IllegalArgumentException iaEx) {
                        Log.e(MixVolume.class.getSimpleName(), "ERROR:" + iaEx.getMessage());
                    }
                    finally {
                        if (line != null && !opened) {
                            line.close();
                        }
                    }
                }
            } else {
                if (hasSource) {
                    Log.i(MixVolume.class.getSimpleName(), "hasSource is true, skip!");
                }
                if (!hasPort) {
                    Log.i(MixVolume.class.getSimpleName(), "hasPort is false, skip!");
                }
            }
            Log.i(MixVolume.class.getSimpleName(), "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
            Log.i(MixVolume.class.getSimpleName(), "");
        }
    }
}

