/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.main;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteCustomer;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.component.PersonalPhoto;
import com.blisscloud.ezuc.client.component.RoundedCornerPanel;
import com.blisscloud.ezuc.client.emoticons.EmoticonUtils;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.text.HistoryTextWriter;
import com.blisscloud.ezuc.client.text.MsgTextConverter;
import com.blisscloud.ezuc.client.util.ChatRoomUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.ChatRoomInfo;
import com.blisscloud.mobile.ezuc.bean.MessageChannel;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.db.UCDBMessageChannel;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.CustomerManager;
import com.blisscloud.mobile.ezuc.manager.MeetmeManager;
import com.blisscloud.mobile.ezuc.manager.MessageChannelManager;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class PopupNotificationWindow
extends JFrame {
    private static final int TIMEOUT = 5000;
    private static final int ALPHA_MAX = 255;
    private static final int ALPHA_MIN = 100;
    private static final int ALPHA_DIFF = 4;
    private static final int ALPHA_DURATION = 20;
    private RoundedCornerPanel contentPane;
    private JLabel lblLogo;
    private JSeparator jSeparator1;
    private JLabel lblClose;
    private PersonalPhoto lblHeadIcon;
    private JLabel lblName;
    private JTextPane lblLastMsg;
    private Point pressedPoint;
    private Point pressedLocation;
    private BroadcastReceiver receiver = null;
    private IntentFilter filter = null;
    private int alpha = 255;
    private int increment = -4;
    private Timer fadeoutTimer;
    private Timer showTimeoutTimer;
    private int state = 0;

    public PopupNotificationWindow() {
        this.setTitle(I18NUtil.getAppName());
        this.setIconImages(UIConstants.APP_ICONS);
        this.setFocusableWindowState(false);
        this.initGUI();
        this.initReceiver();
        this.fadeoutTimer = new Timer(20, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ld2) {
                PopupNotificationWindow.this.alpha += PopupNotificationWindow.this.increment;
                if (PopupNotificationWindow.this.alpha < 100) {
                    PopupNotificationWindow.this.fadeoutTimer.stop();
                    PopupNotificationWindow.this.timeout();
                } else {
                    PopupNotificationWindow.this.draw();
                }
            }
        });
        this.showTimeoutTimer = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ld2) {
                PopupNotificationWindow.this.showTimeoutTimer.stop();
                PopupNotificationWindow.this.hideWin();
            }
        });
    }

    private void draw() {
        this.contentPane.setFromColor(new Color(128, 128, 128, this.alpha));
        this.contentPane.setToColor(new Color(32, 32, 32, this.alpha));
        this.contentPane.repaint();
    }

    private void initGUI() {
        try {
            this.setDefaultCloseOperation(2);
            this.setUndecorated(true);
            String osName = System.getProperties().getProperty("os.name").toLowerCase();
            this.contentPane = new RoundedCornerPanel(8, 1.0f, new Color(0x606060), 1, new Color(128, 128, 128, 100), new Color(32, 32, 32, 255));
            GridBagLayout contentPaneLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.contentPane, "Center");
            this.contentPane.setLayout(contentPaneLayout);
            this.contentPane.setPreferredSize(new Dimension(473, 143));
            this.contentPane.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent evt) {
                    PopupNotificationWindow.this.lblLogoMouseDragged(evt);
                }
            });
            this.contentPane.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    PopupNotificationWindow.this.lblLogoMousePressed(evt);
                }

                @Override
                public void mouseClicked(MouseEvent evt) {
                    PopupNotificationWindow.this.hideWin();
                    UCChatClient.getInstance().handleMoveToFront();
                }
            });
            this.lblLogo = new JLabel();
            this.contentPane.add((Component)this.lblLogo, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(4, 8, 4, 0), 0, 0));
            this.lblLogo.setIcon(UIConstants.ICON_LOGO20);
            this.lblLogo.setText(I18NUtil.getAppName());
            this.lblLogo.setFont(UIConstants.FONT_12_PLAIN);
            this.lblLogo.setForeground(Color.LIGHT_GRAY);
            this.lblLogo.setPreferredSize(new Dimension(20, 20));
            this.lblClose = new JLabel();
            this.contentPane.add((Component)this.lblClose, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(4, 0, 4, 8), 0, 0));
            this.lblClose.setIcon(UIConstants.ICON_CLOSE);
            this.lblClose.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    PopupNotificationWindow.this.dispose();
                    PreferencesUtil.setPopupNotification(UCChatClient.context, "-1,-1");
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    PopupNotificationWindow.this.lblClose.setIcon(UIConstants.ICON_CLOSE_OVER);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    PopupNotificationWindow.this.lblClose.setIcon(UIConstants.ICON_CLOSE);
                }
            });
            this.jSeparator1 = new JSeparator();
            this.contentPane.add((Component)this.jSeparator1, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator1.setForeground(new Color(0x808080));
            this.jSeparator1.setBackground(new Color(0x707070));
            this.lblHeadIcon = new PersonalPhoto();
            if (osName.indexOf("mac") >= 0) {
                this.contentPane.add((Component)this.lblHeadIcon, new GridBagConstraints(0, 2, 1, 2, 0.0, 0.0, 18, 0, new Insets(5, 10, 5, 0), 0, 0));
            } else {
                this.contentPane.add((Component)this.lblHeadIcon, new GridBagConstraints(0, 2, 1, 2, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 0), 0, 0));
            }
            this.lblHeadIcon.setPreferredSize(new Dimension(48, 48));
            this.lblHeadIcon.setMinimumSize(new Dimension(48, 48));
            this.lblName = new JLabel();
            this.lblName.setForeground(Color.WHITE);
            this.contentPane.add((Component)this.lblName, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 12, 0, 10), 0, 0));
            this.lblName.setFont(UIConstants.FONT_14_PLAIN);
            JPanel jPanel1 = new JPanel();
            FlowLayout jPanel1Layout = new FlowLayout();
            jPanel1Layout.setHgap(0);
            jPanel1Layout.setVgap(0);
            jPanel1Layout.setAlignment(0);
            jPanel1.setLayout(jPanel1Layout);
            jPanel1.setOpaque(false);
            this.lblLastMsg = new JTextPane();
            jPanel1.add(this.lblLastMsg);
            this.lblLastMsg.setFont(UIConstants.FONT_14_PLAIN);
            this.lblLastMsg.setForeground(Color.WHITE);
            this.lblLastMsg.setOpaque(false);
            this.lblLastMsg.setEnabled(true);
            this.lblLastMsg.setEditable(false);
            this.lblLastMsg.setCaret(new MyCaret());
            this.contentPane.add((Component)jPanel1, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 10, 0, 10), 0, 0));
            this.setBackground(new Color(0, 0, 0, 0));
            this.setAlwaysOnTop(true);
            this.setResizable(false);
            this.setSize(400, 100);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void lblLogoMousePressed(MouseEvent evt) {
        this.pressedPoint = evt.getLocationOnScreen();
        this.pressedLocation = this.getLocation();
    }

    private void lblLogoMouseDragged(MouseEvent evt) {
        Point currentPoint = evt.getLocationOnScreen();
        int diffX = currentPoint.x - this.pressedPoint.x;
        int diffY = currentPoint.y - this.pressedPoint.y;
        int x = this.pressedLocation.x + diffX;
        int y = this.pressedLocation.y + diffY;
        this.setLocation(x, y);
        PreferencesUtil.setPopupNotification(UCChatClient.context, x + "," + y);
    }

    private void initReceiver() {
        this.receiver = new BroadcastReceiver(this){

            @Override
            public void onReceive(Context context, Intent intent) {
            }
        };
        this.filter = new IntentFilter();
        UCChatClient.context.registerReceiver(this.receiver, this.filter);
    }

    public synchronized void hideWin() {
        if (this.state == 0) {
            return;
        }
        this.fadeoutTimer.start();
        this.state = 0;
    }

    public synchronized void showWin(String targetJid, String msgTitle, String msgContent, int hasMeCount) {
        try {
            this.setPhoto(targetJid);
            this.setMsgContent(msgTitle, msgContent, hasMeCount);
            this.state = 1;
            this.fadeoutTimer.stop();
            this.alpha = 255;
            this.draw();
            this.setVisible(true);
            this.toFront();
            this.showTimeoutTimer.stop();
            this.showTimeoutTimer.start();
        }
        catch (Throwable t) {
            Log.e(PopupNotificationWindow.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
        }
    }

    private void setPhoto(String chatJid) {
        Activity ctx = UCChatClient.context;
        if (chatJid == null) {
            this.setImage(UIConstants.ICON_GENERAL_NOTICE.getImage());
        } else if (JidUtil.isCustomerJid(chatJid)) {
            LiteCustomer liteCustomer = CustomerManager.getCustomerInfo(ctx, JidUtil.convertKey(chatJid));
            if (liteCustomer != null) {
                this.lblName.setText(liteCustomer.getNickname());
                if (liteCustomer.getType() == 0) {
                    this.lblName.setIcon(UIConstants.ICON_WECHAT_GREEN);
                } else if (liteCustomer.getType() == 1) {
                    this.lblName.setIcon(UIConstants.ICON_LINE_GREEN);
                } else if (liteCustomer.getType() == 2) {
                    this.lblName.setIcon(UIConstants.ICON_WEBCHAT_BLUE);
                }
                this.lblName.setHorizontalTextPosition(2);
                this.setImage(CustomerManager.getContactImage(liteCustomer, 48, false));
            } else {
                WebAgent.getInstance().getCustomerInfo(JidUtil.convertKey(chatJid));
                this.lblName.setText(chatJid);
            }
        } else if (JidUtil.isFakeExternalCallJid(chatJid)) {
            this.lblName.setText(I18NUtil.getString("phone_history_label_external"));
            this.setImage(UIConstants.ICON_EXTERNAL_CALL.getImage());
        } else if (JidUtil.isFakeFaxDocJid(chatJid)) {
            this.lblName.setText(I18NUtil.getString("fax_doc_label_external"));
            this.setImage(UIConstants.ICON_FAX_DOC.getImage());
        } else if (JidUtil.isBcAnnouncerJid(chatJid)) {
            this.lblName.setText(I18NUtil.getAppName());
            this.setImage(UIConstants.ICON_LOGO48.getImage());
        } else if (JidUtil.isMyContactJid(chatJid)) {
            ChatRoomInfo chatRoomInfo = ChatRoomManager.getChatRoom(ctx, chatJid);
            LiteMyContact contact = ContactManager.getExternalContact((Context)ctx, chatJid);
            this.lblName.setText(ChatRoomUtil.getMyContactRoomTitle(ctx, chatRoomInfo, contact));
            this.setImage(ContactManager.getExternalContactImage(contact, 48, false, true));
        } else if (JidUtil.isAPIUserJid(chatJid)) {
            ChatRoomInfo chatRoomInfo = ChatRoomManager.getChatRoom(ctx, chatJid);
            MessageChannel msgChannel = UCDBMessageChannel.getMessageChannelByJid(ctx, chatJid);
            this.lblName.setText(ChatRoomUtil.getMessageChannelRoomTitle(ctx, chatRoomInfo, msgChannel, chatJid));
            this.setImage(MessageChannelManager.getMessageChannelImage(msgChannel, 48, false, true));
        } else if (JidUtil.isChatJid(chatJid)) {
            ChatRoomInfo chatRoomInfo = ChatRoomManager.getChatRoom(ctx, chatJid);
            ArrayList<String> participants = UCDBChatRoom.findChatRoomParticipants((Context)ctx, chatRoomInfo.getChatRoomId());
            this.lblName.setText(ChatRoomUtil.getChatRoomTitleForList(ctx, chatRoomInfo, participants, null));
            if (participants == null || participants.size() <= 0) {
                this.setImage(UIConstants.ICON_CONFERENCEROOM_IDLE_48.getImage());
            } else {
                HashMap<String, LiteContact> userCacheMap = new HashMap<String, LiteContact>();
                this.setImage(GraphicUtil.getChatRoomImage(ctx, participants, userCacheMap, false, true));
            }
        } else if (JidUtil.isConfJid(chatJid)) {
            ChatRoomInfo chatRoomInfo = ChatRoomManager.getChatRoom(ctx, chatJid);
            LiteConferenceRoom room = MeetmeManager.getStaticMeetme(ctx, chatRoomInfo.getChatRoomId());
            this.lblName.setText(ChatRoomUtil.getConfRoomTitle(ctx, chatRoomInfo, room));
            this.setImage(UIConstants.ICON_CONFERENCEROOM_USING_48.getImage());
        } else if (JidUtil.isEmployeeJid(chatJid) || JidUtil.isLocationJid(chatJid)) {
            ChatRoomInfo roomInfo = ChatRoomManager.getChatRoom(ctx, chatJid);
            LiteContact liteContact = ContactManager.getContact((Context)ctx, chatJid);
            String contactName = ChatRoomUtil.getEmpRoomTitle(ctx, roomInfo, liteContact, chatJid);
            this.lblName.setText(contactName);
            Image image = ContactManager.getContactImage(liteContact, 48, false, true);
            this.setImage(image);
        } else {
            this.setImage(UIConstants.ICON_GENERAL_NOTICE.getImage());
        }
    }

    public void setImage(Image image) {
        if (image == null || image.getWidth(this) <= 0 || image.getHeight(this) <= 0) {
            this.lblHeadIcon.setImage(UIConstants.ICON_PERSON48.getImage());
        } else {
            this.lblHeadIcon.setImage(image);
        }
    }

    public synchronized void timeout() {
        if (this.state == 0) {
            this.dispose();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.fadeoutTimer.stop();
        this.showTimeoutTimer.stop();
    }

    private void setMsgContent(String msgTitle, String lastMsg, int hasMeCount) throws BadLocationException {
        this.lblName.setText(msgTitle);
        StyledDocument doc = (StyledDocument)this.lblLastMsg.getDocument();
        Style style = doc.addStyle("StyleName", null);
        StyleConstants.setForeground(style, new Color(173, 0, 0));
        this.lblLastMsg.setText("");
        if (lastMsg.startsWith("[PHONE_TALKING]") || lastMsg.startsWith("[PHONE_CANCEL]") || lastMsg.startsWith("[PHONE_CANCEL_IN]") || lastMsg.startsWith("[PHONE_CANCEL_OUT]")) {
            this.lblLastMsg.getDocument().insertString(this.lblLastMsg.getCaretPosition(), (String)(hasMeCount > 0 ? "[" + I18NUtil.getString("chat_label_at_by_others") + "] " : ""), style);
            String[] terms = lastMsg.split(" ");
            String phoneKey = terms[0];
            String phoneIconPath = ChatRoomManager.getPhoneIconPath(phoneKey);
            ImageIcon phoneIcon = GraphicUtil.getScaledIcon(phoneIconPath, 16, 16);
            String remainText = lastMsg.substring(phoneKey.length());
            try {
                this.lblLastMsg.insertIcon(phoneIcon);
                this.lblLastMsg.getDocument().insertString(this.lblLastMsg.getCaretPosition(), remainText, null);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        } else if (EmoticonUtils.isStickerContent(lastMsg)) {
            this.lblLastMsg.getDocument().insertString(this.lblLastMsg.getCaretPosition(), (String)(hasMeCount > 0 ? "[" + I18NUtil.getString("chat_label_at_by_others") + "] " : ""), style);
            String content = "[" + I18NUtil.getString("chat_msg_type_sticker") + "]";
            this.lblLastMsg.getDocument().insertString(this.lblLastMsg.getCaretPosition(), content, null);
        } else {
            this.lblLastMsg.getDocument().insertString(this.lblLastMsg.getCaretPosition(), (String)(hasMeCount > 0 ? "[" + I18NUtil.getString("chat_label_at_by_others") + "] " : ""), style);
            this.setMessage(lastMsg);
        }
    }

    private void setMessage(String content) throws BadLocationException {
        String msgContent = content.replace("\n", " ");
        HistoryTextWriter writer = new HistoryTextWriter(this.lblLastMsg, 14, -1);
        try {
            MsgTextConverter.convertAndAppendText(msgContent, writer);
        }
        catch (UCThreadException uCThreadException) {
            // empty catch block
        }
    }

    class MyCaret
    extends DefaultCaret {
        MyCaret() {
        }

        @Override
        protected void adjustVisibility(Rectangle nloc) {
        }
    }
}

