/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.main;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.component.ImageLabel;
import com.blisscloud.ezuc.client.main.MixVolume;
import com.blisscloud.ezuc.client.media.Archive;
import com.blisscloud.ezuc.client.media.AudioClipPlayer;
import com.blisscloud.ezuc.client.media.AudioClipPlayerListener;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.setting.LanguageItem;
import com.blisscloud.ezuc.client.setting.LanguageSelectionRenderer;
import com.blisscloud.ezuc.client.util.SystemUtils;
import com.blisscloud.mobile.ezuc.db.UserDatabase;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.MediaFileUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.blisscloud.sip.SipPhoneService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PreferencePanel
extends GenericDialog
implements AudioClipPlayerListener {
    private static final int MAX_GAIN = 200;
    private static final int LABEL_GAP = 25;
    private static final int SPACE = 25;
    private JPanel ringPanel;
    private JLabel lblRingConfig;
    private JComboBox<LanguageItem> ringBox;
    private DefaultComboBoxModel<LanguageItem> ringBoxModel = new DefaultComboBoxModel();
    private JSlider ringVolumeSlider;
    private JSlider appVolumeSlider;
    private JSlider txGainSlider;
    private JSlider rxGainSlider;
    private JLabel lblTalkConfig;
    private JCheckBox cbConfAutoMute;
    private JCheckBox cbKeybordSound;
    private JCheckBox cbNoPopupTransfer;
    private JLabel lblCloseEZDesktop;
    private JRadioButton rbCloseEZDesktop;
    private JRadioButton rbMinimizeEZDesktop;
    private JLabel lblSensMsgBtn;
    private JRadioButton rbEnterOnly;
    private JRadioButton rbCtrlEnter;
    private JLabel lblPopMapBtn;
    private JRadioButton rbGoogleMap;
    private JRadioButton rbQQMap;
    private JLabel lblScreenCaptureBtn;
    private JCheckBox cbHideSelf;
    private JCheckBox cbLastBounds;
    private JCheckBox cbNotificationEnableBtn;
    private JCheckBox cbDisplayNotificationContentBtn;
    private JLabel lblPadding2;
    private JButton btnConfirm;
    private JScrollPane jScrollPane;
    private JPanel mainPanel;
    private ButtonGroup buttonGroup1 = new ButtonGroup();
    private ButtonGroup buttonGroup2 = new ButtonGroup();
    private ButtonGroup buttonGroup3 = new ButtonGroup();
    private JPanel noticeRingPanel;
    private JLabel lblNoticeConfig;
    private JPanel noticeVolumePanel;
    private AudioClipPlayer clip_ringin;
    private ImageLabel btnTest;
    private JComboBox<LanguageItem> noticeBox;
    private DefaultComboBoxModel<LanguageItem> noticeBoxModel = new DefaultComboBoxModel();
    private JSlider noticeVolumeSlider;
    private AudioClipPlayer clip_notice;
    private ImageLabel btnNoticeTest;
    private ButtonGroup buttonGroup4 = new ButtonGroup();
    private JRadioButton rbDefaultNotice;
    private JRadioButton rbSystemNotice;
    private boolean confirmClicked = false;

    public boolean isWindows() {
        return SystemUtils.isWindows();
    }

    public PreferencePanel(JFrame frame) {
        super(frame);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
                PreferencePanel.this.stopRingTest();
                if (PreferencePanel.this.isWindows() && !PreferencePanel.this.confirmClicked) {
                    float appVolume = PreferencesUtil.getFloat(UCChatClient.context, "APP_SETTING_VOLUME", Float.valueOf(1.0f)).floatValue();
                    MixVolume.setVolume(appVolume);
                }
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        this.initGUI();
        this.loadData();
        this.loadPreference();
    }

    private void stopRingTest() {
        if (this.clip_ringin != null && this.clip_ringin.isRunning()) {
            this.clip_ringin.stop();
        }
    }

    private void startRingTest() {
        try {
            float volume = (float)this.ringVolumeSlider.getValue() * 1.0f / 100.0f;
            if (volume > 1.0f) {
                volume = 1.0f;
            }
            LanguageItem item = (LanguageItem)this.ringBoxModel.getSelectedItem();
            String ringinSource = "media/phone/" + MediaFileUtil.getWavFileNameForRing(item.getId());
            this.clip_ringin = new AudioClipPlayer(Archive.getAudioInputStream(SipPhoneService.class.getClassLoader().getResource(ringinSource)), (AudioClipPlayerListener)this);
            this.clip_ringin.adjustVolume(volume);
            this.clip_ringin.loop(2);
            this.btnTest.setIcon(UIConstants.ICON_RING_TONE_STOP);
            this.btnTest.setToolTipText(I18NUtil.getString("btn_ring_tone_test_stop"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void startNoticeTest() {
        try {
            LanguageItem item;
            float volume = (float)this.noticeVolumeSlider.getValue() * 1.0f / 100.0f;
            if (volume > 1.0f) {
                volume = 1.0f;
            }
            if ((item = (LanguageItem)this.noticeBoxModel.getSelectedItem()).getId() == 0) {
                return;
            }
            String ringinSource = "media/notice/" + MediaFileUtil.getWavFileNameForNotice(item.getId());
            this.clip_notice = new AudioClipPlayer(Archive.getAudioInputStream(PreferencePanel.class.getClassLoader().getResource(ringinSource)), (AudioClipPlayerListener)this);
            this.clip_notice.adjustVolume(volume);
            this.clip_notice.play();
            this.btnNoticeTest.setIcon(UIConstants.ICON_RING_TONE_STOP);
            this.btnNoticeTest.setToolTipText(I18NUtil.getString("btn_ring_tone_test_stop"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void stopNoticeTest() {
        if (this.clip_notice != null && this.clip_notice.isRunning()) {
            this.clip_notice.stop();
        }
    }

    private void loadData() {
        this.ringBoxModel.removeAllElements();
        int ringSetting = PreferencesUtil.getInt(UCChatClient.context, "RING_SETTING", 0);
        this.ringBoxModel.addElement(new LanguageItem(0, I18NUtil.getString("setting_label_prompt_lang_default")));
        this.ringBoxModel.addElement(new LanguageItem(1, "Best Tone"));
        this.ringBoxModel.addElement(new LanguageItem(2, "Classic"));
        this.ringBoxModel.addElement(new LanguageItem(3, "Despacito"));
        this.ringBoxModel.addElement(new LanguageItem(4, "Morning"));
        this.ringBoxModel.addElement(new LanguageItem(5, "Nice"));
        this.ringBoxModel.addElement(new LanguageItem(6, "Phone"));
        this.ringBoxModel.addElement(new LanguageItem(7, "Popular"));
        this.ringBoxModel.addElement(new LanguageItem(8, "Electronics"));
        this.ringBoxModel.setSelectedItem(this.ringBoxModel.getElementAt(ringSetting));
        this.noticeBoxModel.removeAllElements();
        int noticeSetting = PreferencesUtil.getInt(UCChatClient.context, "NOTICE_SETTING", 0);
        this.noticeBoxModel.addElement(new LanguageItem(0, I18NUtil.getString("setting_label_notice_sound_off")));
        this.noticeBoxModel.addElement(new LanguageItem(1, "Far"));
        this.noticeBoxModel.addElement(new LanguageItem(2, "On"));
        this.noticeBoxModel.addElement(new LanguageItem(3, "Off"));
        this.noticeBoxModel.addElement(new LanguageItem(4, "Gling"));
        this.noticeBoxModel.addElement(new LanguageItem(5, "Dingdong"));
        this.noticeBoxModel.addElement(new LanguageItem(6, "Door Bell"));
        this.noticeBoxModel.addElement(new LanguageItem(7, "Echo Bell"));
        this.noticeBoxModel.addElement(new LanguageItem(8, "Diamond"));
        this.noticeBoxModel.addElement(new LanguageItem(9, "Nice Ding"));
        this.noticeBoxModel.addElement(new LanguageItem(10, "Big Ben"));
        this.noticeBoxModel.setSelectedItem(this.noticeBoxModel.getElementAt(noticeSetting));
        LanguageItem item = (LanguageItem)this.noticeBoxModel.getSelectedItem();
        if (item.getId() == 0) {
            this.btnNoticeTest.setEnabled(false);
        } else {
            this.btnNoticeTest.setEnabled(true);
        }
    }

    private void initGUI() {
        try {
            int i;
            this.setTitle(I18NUtil.getString("setting_label_perference_descr"));
            this.setModal(true);
            this.setLocationRelativeTo(null);
            BorderLayout thisLayout = new BorderLayout();
            this.setLayout(thisLayout);
            JPanel sPanel = new JPanel();
            sPanel.setLayout(new GridBagLayout());
            sPanel.setBackground(UIConstants.COLOR_DIALOG_BACKGROUND);
            this.btnConfirm = new JButton();
            this.btnConfirm.setText(I18NUtil.getString("common_btn_ok"));
            this.btnConfirm.setMinimumSize(new Dimension(75, 30));
            this.btnConfirm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PreferencePanel.this.btnConfirmActionPerformed(evt);
                }
            });
            sPanel.add((Component)this.btnConfirm, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
            this.add((Component)sPanel, "South");
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setVerticalScrollBarPolicy(20);
            this.jScrollPane.setHorizontalScrollBarPolicy(30);
            this.add((Component)this.jScrollPane, "Center");
            this.jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            this.mainPanel = new JPanel();
            this.jScrollPane.setViewportView(this.mainPanel);
            GridBagLayout mainLayout = new GridBagLayout();
            this.mainPanel.setLayout(mainLayout);
            this.mainPanel.setBackground(UIConstants.COLOR_DIALOG_BACKGROUND);
            int y = 0;
            this.lblTalkConfig = new JLabel();
            this.mainPanel.add((Component)this.lblTalkConfig, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 17, 0, new Insets(15, 20, 0, 20), 0, 0));
            this.lblTalkConfig.setText(I18NUtil.getString("setting_label_call"));
            this.lblTalkConfig.setFont(UIConstants.FONT_14_PLAIN);
            this.ringPanel = new JPanel();
            FlowLayout panelFunctionLayout = new FlowLayout();
            panelFunctionLayout.setHgap(8);
            panelFunctionLayout.setVgap(0);
            this.ringPanel.setLayout(panelFunctionLayout);
            this.ringPanel.setOpaque(false);
            this.mainPanel.add((Component)this.ringPanel, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 17, 0, new Insets(6, 35, 0, 20), 0, 0));
            this.lblRingConfig = new JLabel();
            this.lblRingConfig.setText(I18NUtil.getString("setting_label_ring"));
            this.lblRingConfig.setFont(UIConstants.FONT_12_PLAIN);
            this.ringPanel.add(this.lblRingConfig);
            this.ringBox = new JComboBox();
            this.ringBox.setFont(UIConstants.FONT_12_PLAIN);
            this.ringBox.setModel(this.ringBoxModel);
            this.ringBox.setRenderer(new LanguageSelectionRenderer());
            this.ringBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PreferencePanel.this.clip_ringin != null && PreferencePanel.this.clip_ringin.isRunning()) {
                        PreferencePanel.this.stopRingTest();
                        PreferencePanel.this.startRingTest();
                    }
                }
            });
            this.ringPanel.add(this.ringBox);
            this.btnTest = new ImageLabel(UIConstants.ICON_RING_TONE);
            this.btnTest.setToolTipText(I18NUtil.getString("btn_ring_tone_test"));
            this.btnTest.setPreferredSize(new Dimension(24, 24));
            this.btnTest.setMinimumSize(new Dimension(24, 24));
            this.btnTest.setMaximumSize(new Dimension(24, 24));
            this.btnTest.setHorizontalAlignment(0);
            this.btnTest.setBorder(UIConstants.BORDER_CONFIG_BUTTON);
            this.btnTest.setCursor(UIConstants.CURSOR_HAND);
            this.btnTest.setArc(12);
            this.btnTest.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (PreferencePanel.this.clip_ringin != null && PreferencePanel.this.clip_ringin.isRunning()) {
                        PreferencePanel.this.stopRingTest();
                    } else {
                        PreferencePanel.this.startRingTest();
                    }
                }
            });
            this.ringPanel.add(this.btnTest);
            JPanel volumePanel = new JPanel();
            FlowLayout panelFunctionLayout2 = new FlowLayout();
            panelFunctionLayout2.setHgap(8);
            panelFunctionLayout2.setVgap(0);
            volumePanel.setLayout(panelFunctionLayout2);
            volumePanel.setOpaque(false);
            this.mainPanel.add((Component)volumePanel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 35, 0, 10), 0, 0));
            JLabel lblVolumeConfig = new JLabel();
            lblVolumeConfig.setText(I18NUtil.getString("setting_label_ring_volume"));
            lblVolumeConfig.setFont(UIConstants.FONT_12_PLAIN);
            volumePanel.add(lblVolumeConfig);
            float volume = PreferencesUtil.getFloat(UCChatClient.context, "RING_SETTING_VOLUME", Float.valueOf(0.5f)).floatValue();
            this.ringVolumeSlider = new JSlider(0, 0, 100, (int)(volume * 100.0f));
            this.ringVolumeSlider.setFont(UIConstants.FONT_12_PLAIN);
            this.ringVolumeSlider.setMajorTickSpacing(25);
            this.ringVolumeSlider.setPaintTicks(true);
            this.ringVolumeSlider.setPaintLabels(true);
            this.ringVolumeSlider.setBackground(UIConstants.COLOR_DIALOG_BACKGROUND);
            this.ringVolumeSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (PreferencePanel.this.clip_ringin != null && PreferencePanel.this.clip_ringin.isRunning()) {
                        float volume = (float)PreferencePanel.this.ringVolumeSlider.getValue() * 1.0f / 100.0f;
                        if (volume > 1.0f) {
                            volume = 1.0f;
                        }
                        PreferencePanel.this.clip_ringin.adjustVolume(volume);
                    }
                }
            });
            volumePanel.add(this.ringVolumeSlider);
            if (this.isWindows()) {
                JPanel appVolumePanel = new JPanel();
                panelFunctionLayout2 = new FlowLayout();
                panelFunctionLayout2.setHgap(8);
                panelFunctionLayout2.setVgap(0);
                appVolumePanel.setLayout(panelFunctionLayout2);
                appVolumePanel.setOpaque(false);
                this.mainPanel.add((Component)appVolumePanel, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 10, 0, 35), 0, 0));
                lblVolumeConfig = new JLabel();
                lblVolumeConfig.setText(I18NUtil.getString("setting_label_app_volume"));
                lblVolumeConfig.setFont(UIConstants.FONT_12_PLAIN);
                appVolumePanel.add(lblVolumeConfig);
                volume = PreferencesUtil.getFloat(UCChatClient.context, "APP_SETTING_VOLUME", Float.valueOf(1.0f)).floatValue();
                this.appVolumeSlider = new JSlider(0, 0, 100, (int)(volume * 100.0f));
                this.appVolumeSlider.setFont(UIConstants.FONT_12_PLAIN);
                this.appVolumeSlider.setMajorTickSpacing(25);
                this.appVolumeSlider.setPaintTicks(true);
                this.appVolumeSlider.setPaintLabels(true);
                this.appVolumeSlider.setBackground(UIConstants.COLOR_DIALOG_BACKGROUND);
                this.appVolumeSlider.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        float appVolume = (float)PreferencePanel.this.appVolumeSlider.getValue() * 1.0f / 100.0f;
                        if (appVolume > 1.0f) {
                            appVolume = 1.0f;
                        }
                        MixVolume.setVolume(appVolume);
                    }
                });
                appVolumePanel.add(this.appVolumeSlider);
            } else {
                ++y;
            }
            if (this.isWindows()) {
                JPanel micPanel = new JPanel();
                FlowLayout micLayout = new FlowLayout();
                micLayout.setHgap(8);
                micLayout.setVgap(0);
                micPanel.setLayout(micLayout);
                micPanel.setOpaque(false);
                this.mainPanel.add((Component)micPanel, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 35, 0, 10), 0, 0));
                JLabel lblMicConfig = new JLabel();
                lblMicConfig.setText(I18NUtil.getString("setting_label_mic"));
                lblMicConfig.setFont(UIConstants.FONT_12_PLAIN);
                micPanel.add(lblMicConfig);
                JButton btnMic = new JButton();
                btnMic.setText(I18NUtil.getString("setting_label_mic_sys"));
                btnMic.addActionListener(new ActionListener(this){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        try {
                            ProcessBuilder pb = new ProcessBuilder("control", "mmsys.cpl,,1");
                            pb.start();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
                micPanel.add(btnMic);
            }
            JPanel txGainPanel = new JPanel();
            FlowLayout txGainLayout = new FlowLayout();
            txGainLayout.setHgap(8);
            txGainLayout.setVgap(0);
            txGainPanel.setLayout(txGainLayout);
            txGainPanel.setOpaque(false);
            this.mainPanel.add((Component)txGainPanel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 35, 0, 10), 0, 0));
            JLabel lblTxGainConfig = new JLabel();
            lblTxGainConfig.setText(I18NUtil.getString("setting_label_gain_tx"));
            lblTxGainConfig.setFont(UIConstants.FONT_12_PLAIN);
            txGainPanel.add(lblTxGainConfig);
            volume = PreferencesUtil.getTxGain(UCChatClient.context);
            this.txGainSlider = new JSlider(0, 100, 200, (int)(volume * 100.0f));
            this.txGainSlider.setFont(UIConstants.FONT_12_PLAIN);
            this.txGainSlider.setMajorTickSpacing(25);
            this.txGainSlider.setPaintTicks(true);
            this.txGainSlider.setPaintLabels(true);
            this.txGainSlider.setBackground(UIConstants.COLOR_DIALOG_BACKGROUND);
            this.txGainSlider.addChangeListener(e -> {
                int sliderValue = this.txGainSlider.getValue();
                float gain = (float)sliderValue / 100.0f;
                PreferencesUtil.setTxGain(UCChatClient.context, gain);
                System.out.println("TX Gain = " + gain);
            });
            txGainPanel.add(this.txGainSlider);
            Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
            for (i = 100; i <= 200; i += 25) {
                labelTable.put(i, new JLabel(String.format("%.1f", (double)i / 100.0)));
            }
            this.txGainSlider.setLabelTable(labelTable);
            JPanel rxGainPanel = new JPanel();
            FlowLayout rxGainLayout = new FlowLayout();
            rxGainLayout.setHgap(8);
            rxGainLayout.setVgap(0);
            rxGainPanel.setLayout(rxGainLayout);
            rxGainPanel.setOpaque(false);
            this.mainPanel.add((Component)rxGainPanel, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 34), 0, 0));
            lblTxGainConfig = new JLabel();
            lblTxGainConfig.setText(I18NUtil.getString("setting_label_gain_rx"));
            lblTxGainConfig.setFont(UIConstants.FONT_12_PLAIN);
            rxGainPanel.add(lblTxGainConfig);
            volume = PreferencesUtil.getRxGain(UCChatClient.context);
            this.rxGainSlider = new JSlider(0, 100, 200, (int)(volume * 100.0f));
            this.rxGainSlider.setFont(UIConstants.FONT_12_PLAIN);
            this.rxGainSlider.setMajorTickSpacing(25);
            this.rxGainSlider.setPaintTicks(true);
            this.rxGainSlider.setPaintLabels(true);
            this.rxGainSlider.setBackground(UIConstants.COLOR_DIALOG_BACKGROUND);
            this.rxGainSlider.addChangeListener(e -> {
                int sliderValue = this.rxGainSlider.getValue();
                float gain = (float)sliderValue / 100.0f;
                PreferencesUtil.setRxGain(UCChatClient.context, gain);
                System.out.println("RX Gain = " + gain);
            });
            rxGainPanel.add(this.rxGainSlider);
            labelTable = new Hashtable();
            for (i = 100; i <= 200; i += 25) {
                labelTable.put(i, new JLabel(String.format("%.1f", (double)i / 100.0)));
            }
            this.rxGainSlider.setLabelTable(labelTable);
            JPanel xxPanel = new JPanel();
            xxPanel.setOpaque(false);
            FlowLayout layout = new FlowLayout();
            layout.setHgap(10);
            layout.setVgap(0);
            xxPanel.setLayout(layout);
            this.mainPanel.add((Component)xxPanel, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 35, 0, 20), 0, 0));
            this.cbKeybordSound = new JCheckBox();
            this.cbKeybordSound.setText(I18NUtil.getString("setting_label_keyboard_sound"));
            this.cbKeybordSound.setSelected(true);
            this.cbKeybordSound.setOpaque(false);
            this.cbKeybordSound.setFont(UIConstants.FONT_12_PLAIN);
            xxPanel.add(this.cbKeybordSound);
            this.cbConfAutoMute = new JCheckBox();
            this.cbConfAutoMute.setText(I18NUtil.getString("setting_label_conf_auto_mute"));
            this.cbConfAutoMute.setSelected(true);
            this.cbConfAutoMute.setOpaque(false);
            this.cbConfAutoMute.setFont(UIConstants.FONT_12_PLAIN);
            xxPanel.add(this.cbConfAutoMute);
            this.cbNoPopupTransfer = new JCheckBox();
            this.cbNoPopupTransfer.setText(I18NUtil.getString("setting_label_no_popup_transfer"));
            this.cbNoPopupTransfer.setSelected(true);
            this.cbNoPopupTransfer.setOpaque(false);
            this.cbNoPopupTransfer.setFont(UIConstants.FONT_12_PLAIN);
            xxPanel.add(this.cbNoPopupTransfer);
            JLabel notificationLable = new JLabel();
            this.mainPanel.add((Component)notificationLable, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 17, 0, new Insets(15, 20, 0, 20), 0, 0));
            notificationLable.setText(String.format(I18NUtil.getString("setting_label_notification"), I18NUtil.getAppName()));
            notificationLable.setFont(UIConstants.FONT_14_PLAIN);
            JPanel notificationPanel = new JPanel();
            notificationPanel.setOpaque(false);
            layout = new FlowLayout();
            layout.setHgap(10);
            layout.setVgap(0);
            notificationPanel.setLayout(layout);
            this.cbNotificationEnableBtn = new JCheckBox();
            this.cbNotificationEnableBtn.setText(I18NUtil.getString("setting_label_notification_enabled"));
            this.cbNotificationEnableBtn.setSelected(true);
            this.cbNotificationEnableBtn.setOpaque(false);
            this.cbNotificationEnableBtn.setFont(UIConstants.FONT_12_PLAIN);
            notificationPanel.add(this.cbNotificationEnableBtn);
            this.cbDisplayNotificationContentBtn = new JCheckBox();
            this.cbDisplayNotificationContentBtn.setText(I18NUtil.getString("setting_label_notification_display_content"));
            this.cbDisplayNotificationContentBtn.setSelected(true);
            this.cbDisplayNotificationContentBtn.setOpaque(false);
            this.cbDisplayNotificationContentBtn.setFont(UIConstants.FONT_12_PLAIN);
            notificationPanel.add(this.cbDisplayNotificationContentBtn);
            this.mainPanel.add((Component)notificationPanel, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 17, 0, new Insets(6, 35, 0, 20), 0, 0));
            JPanel noticeTypePanel = new JPanel();
            noticeTypePanel.setOpaque(false);
            layout = new FlowLayout();
            layout.setHgap(10);
            layout.setVgap(0);
            noticeTypePanel.setLayout(layout);
            this.rbDefaultNotice = new JRadioButton();
            this.rbDefaultNotice.setText(String.format(I18NUtil.getString("setting_label_notice_type_default"), I18NUtil.getAppName()));
            this.rbDefaultNotice.setSelected(true);
            this.rbDefaultNotice.setOpaque(false);
            this.rbDefaultNotice.setFont(UIConstants.FONT_12_PLAIN);
            this.rbDefaultNotice.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1 && e.getSource() == PreferencePanel.this.rbDefaultNotice) {
                        PreferencePanel.this.noticeRingPanel.setVisible(true);
                        PreferencePanel.this.noticeVolumePanel.setVisible(true);
                    }
                }
            });
            this.buttonGroup4.add(this.rbDefaultNotice);
            noticeTypePanel.add(this.rbDefaultNotice);
            this.rbSystemNotice = new JRadioButton();
            this.rbSystemNotice.setText(String.format(I18NUtil.getString("setting_label_notice_type_system"), I18NUtil.getAppName()));
            this.rbSystemNotice.setOpaque(false);
            this.rbSystemNotice.setFont(UIConstants.FONT_12_PLAIN);
            this.rbSystemNotice.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1 && e.getSource() == PreferencePanel.this.rbSystemNotice) {
                        PreferencePanel.this.noticeRingPanel.setVisible(false);
                        PreferencePanel.this.noticeVolumePanel.setVisible(false);
                    }
                }
            });
            this.buttonGroup4.add(this.rbSystemNotice);
            noticeTypePanel.add(this.rbSystemNotice);
            this.mainPanel.add((Component)noticeTypePanel, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 17, 0, new Insets(6, 35, 0, 20), 0, 0));
            this.noticeRingPanel = new JPanel();
            panelFunctionLayout = new FlowLayout();
            panelFunctionLayout.setAlignment(0);
            panelFunctionLayout.setHgap(8);
            panelFunctionLayout.setVgap(0);
            this.noticeRingPanel.setLayout(panelFunctionLayout);
            this.noticeRingPanel.setOpaque(false);
            this.mainPanel.add((Component)this.noticeRingPanel, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 17, 0, new Insets(6, 35, 0, 20), 0, 0));
            this.lblNoticeConfig = new JLabel();
            this.lblNoticeConfig.setText(I18NUtil.getString("setting_label_ring"));
            this.lblNoticeConfig.setFont(UIConstants.FONT_12_PLAIN);
            this.noticeRingPanel.add(this.lblNoticeConfig);
            this.noticeBox = new JComboBox();
            this.noticeBox.setFont(UIConstants.FONT_12_PLAIN);
            this.noticeBox.setModel(this.noticeBoxModel);
            this.noticeBox.setRenderer(new LanguageSelectionRenderer());
            this.noticeBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LanguageItem item = (LanguageItem)PreferencePanel.this.noticeBoxModel.getSelectedItem();
                    if (item.getId() == 0) {
                        PreferencePanel.this.btnNoticeTest.setEnabled(false);
                    } else {
                        PreferencePanel.this.btnNoticeTest.setEnabled(true);
                    }
                    if (PreferencePanel.this.clip_notice != null && PreferencePanel.this.clip_notice.isRunning()) {
                        PreferencePanel.this.stopNoticeTest();
                        PreferencePanel.this.startNoticeTest();
                    }
                }
            });
            this.noticeRingPanel.add(this.noticeBox);
            this.btnNoticeTest = new ImageLabel(UIConstants.ICON_RING_TONE);
            this.btnNoticeTest.setToolTipText(I18NUtil.getString("btn_ring_tone_test"));
            this.btnNoticeTest.setPreferredSize(new Dimension(24, 24));
            this.btnNoticeTest.setMinimumSize(new Dimension(24, 24));
            this.btnNoticeTest.setMaximumSize(new Dimension(24, 24));
            this.btnNoticeTest.setHorizontalAlignment(0);
            this.btnNoticeTest.setBorder(UIConstants.BORDER_CONFIG_BUTTON);
            this.btnNoticeTest.setCursor(UIConstants.CURSOR_HAND);
            this.btnNoticeTest.setArc(12);
            this.btnNoticeTest.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (PreferencePanel.this.clip_notice != null && PreferencePanel.this.clip_notice.isRunning()) {
                        PreferencePanel.this.stopNoticeTest();
                    } else {
                        PreferencePanel.this.startNoticeTest();
                    }
                }
            });
            this.noticeRingPanel.add(this.btnNoticeTest);
            this.noticeVolumePanel = new JPanel();
            panelFunctionLayout = new FlowLayout();
            panelFunctionLayout.setAlignment(0);
            panelFunctionLayout.setHgap(8);
            panelFunctionLayout.setVgap(0);
            this.noticeVolumePanel.setLayout(panelFunctionLayout);
            this.noticeVolumePanel.setOpaque(false);
            this.mainPanel.add((Component)this.noticeVolumePanel, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 17, 0, new Insets(6, 35, 0, 20), 0, 0));
            JLabel lblVolumeConfig2 = new JLabel();
            lblVolumeConfig2.setText(I18NUtil.getString("setting_label_ring_volume"));
            lblVolumeConfig2.setFont(UIConstants.FONT_12_PLAIN);
            this.noticeVolumePanel.add(lblVolumeConfig2);
            float volume2 = PreferencesUtil.getFloat(UCChatClient.context, "NOTICE_SETTING_VOLUME", Float.valueOf(0.8f)).floatValue();
            this.noticeVolumeSlider = new JSlider(0, 0, 100, (int)(volume2 * 100.0f));
            this.noticeVolumeSlider.setFont(UIConstants.FONT_12_PLAIN);
            this.ringVolumeSlider.setMajorTickSpacing(25);
            this.noticeVolumeSlider.setPaintTicks(true);
            this.noticeVolumeSlider.setPaintLabels(true);
            this.noticeVolumeSlider.setBackground(UIConstants.COLOR_DIALOG_BACKGROUND);
            this.noticeVolumeSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (PreferencePanel.this.clip_notice != null && PreferencePanel.this.clip_notice.isRunning()) {
                        float volume = (float)PreferencePanel.this.noticeVolumeSlider.getValue() * 1.0f / 100.0f;
                        if (volume > 1.0f) {
                            volume = 1.0f;
                        }
                        PreferencePanel.this.clip_notice.adjustVolume(volume);
                    }
                }
            });
            this.noticeVolumePanel.add(this.noticeVolumeSlider);
            this.lblCloseEZDesktop = new JLabel();
            this.mainPanel.add((Component)this.lblCloseEZDesktop, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 17, 0, new Insets(15, 20, 0, 20), 0, 0));
            this.lblCloseEZDesktop.setText(String.format(I18NUtil.getString("setting_label_close_policy"), I18NUtil.getAppName()));
            this.lblCloseEZDesktop.setFont(UIConstants.FONT_14_PLAIN);
            JPanel closePolicyPanel = new JPanel();
            closePolicyPanel.setOpaque(false);
            layout = new FlowLayout();
            layout.setHgap(10);
            layout.setVgap(0);
            closePolicyPanel.setLayout(layout);
            this.rbMinimizeEZDesktop = new JRadioButton();
            this.rbMinimizeEZDesktop.setText(String.format(I18NUtil.getString("setting_label_close_policy_minimize"), I18NUtil.getAppName()));
            this.rbMinimizeEZDesktop.setSelected(true);
            this.rbMinimizeEZDesktop.setOpaque(false);
            this.rbMinimizeEZDesktop.setFont(UIConstants.FONT_12_PLAIN);
            this.buttonGroup1.add(this.rbMinimizeEZDesktop);
            closePolicyPanel.add(this.rbMinimizeEZDesktop);
            this.rbCloseEZDesktop = new JRadioButton();
            this.rbCloseEZDesktop.setText(String.format(I18NUtil.getString("setting_label_close_policy_close"), I18NUtil.getAppName()));
            this.rbCloseEZDesktop.setOpaque(false);
            this.rbCloseEZDesktop.setFont(UIConstants.FONT_12_PLAIN);
            this.buttonGroup1.add(this.rbCloseEZDesktop);
            closePolicyPanel.add(this.rbCloseEZDesktop);
            this.mainPanel.add((Component)closePolicyPanel, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 17, 0, new Insets(6, 35, 0, 20), 0, 0));
            this.lblSensMsgBtn = new JLabel();
            this.mainPanel.add((Component)this.lblSensMsgBtn, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 17, 0, new Insets(15, 20, 0, 20), 0, 0));
            this.lblSensMsgBtn.setText(I18NUtil.getString("setting_label_msg_policy"));
            this.lblSensMsgBtn.setFont(UIConstants.FONT_14_PLAIN);
            JPanel editorEnterPanel = new JPanel();
            editorEnterPanel.setOpaque(false);
            layout = new FlowLayout();
            layout.setHgap(10);
            layout.setVgap(0);
            editorEnterPanel.setLayout(layout);
            this.rbEnterOnly = new JRadioButton();
            this.rbEnterOnly.setText("Enter");
            this.rbEnterOnly.setSelected(true);
            this.rbEnterOnly.setOpaque(false);
            this.rbEnterOnly.setFont(UIConstants.FONT_12_PLAIN);
            this.buttonGroup2.add(this.rbEnterOnly);
            editorEnterPanel.add(this.rbEnterOnly);
            this.rbCtrlEnter = new JRadioButton();
            this.rbCtrlEnter.setText("Ctrl + Enter");
            this.rbCtrlEnter.setOpaque(false);
            this.rbCtrlEnter.setFont(UIConstants.FONT_12_PLAIN);
            this.buttonGroup2.add(this.rbCtrlEnter);
            editorEnterPanel.add(this.rbCtrlEnter);
            this.mainPanel.add((Component)editorEnterPanel, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 17, 0, new Insets(6, 35, 0, 20), 0, 0));
            this.lblPopMapBtn = new JLabel();
            this.mainPanel.add((Component)this.lblPopMapBtn, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 17, 0, new Insets(15, 20, 0, 20), 0, 0));
            this.lblPopMapBtn.setText(I18NUtil.getString("setting_label_map_option"));
            this.lblPopMapBtn.setFont(UIConstants.FONT_14_PLAIN);
            JPanel mapPanel = new JPanel();
            mapPanel.setOpaque(false);
            layout = new FlowLayout();
            layout.setHgap(10);
            layout.setVgap(0);
            mapPanel.setLayout(layout);
            this.rbGoogleMap = new JRadioButton();
            this.rbGoogleMap.setText(I18NUtil.getString("setting_label_map_option_google"));
            this.rbGoogleMap.setSelected(true);
            this.rbGoogleMap.setOpaque(false);
            this.rbGoogleMap.setFont(UIConstants.FONT_12_PLAIN);
            this.buttonGroup3.add(this.rbGoogleMap);
            mapPanel.add(this.rbGoogleMap);
            this.rbQQMap = new JRadioButton();
            this.rbQQMap.setText(I18NUtil.getString("setting_label_map_option_qq"));
            this.rbQQMap.setOpaque(false);
            this.rbQQMap.setFont(UIConstants.FONT_12_PLAIN);
            this.buttonGroup3.add(this.rbQQMap);
            mapPanel.add(this.rbQQMap);
            this.mainPanel.add((Component)mapPanel, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 17, 0, new Insets(6, 35, 0, 20), 0, 0));
            this.lblScreenCaptureBtn = new JLabel();
            this.mainPanel.add((Component)this.lblScreenCaptureBtn, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 17, 0, new Insets(15, 20, 0, 20), 0, 0));
            this.lblScreenCaptureBtn.setText(I18NUtil.getString("setting_label_screen_capture_option"));
            this.lblScreenCaptureBtn.setFont(UIConstants.FONT_14_PLAIN);
            JPanel screenPanel = new JPanel();
            screenPanel.setOpaque(false);
            layout = new FlowLayout();
            layout.setHgap(10);
            layout.setVgap(0);
            screenPanel.setLayout(layout);
            this.cbHideSelf = new JCheckBox();
            String appName = I18NUtil.getAppName();
            this.cbHideSelf.setText(String.format(I18NUtil.getString("setting_label_hide_self"), appName));
            this.cbHideSelf.setSelected(true);
            this.cbHideSelf.setOpaque(false);
            this.cbHideSelf.setFont(UIConstants.FONT_12_PLAIN);
            screenPanel.add(this.cbHideSelf);
            this.cbLastBounds = new JCheckBox();
            this.cbLastBounds.setText(String.format(I18NUtil.getString("setting_label_use_last_bounds"), new Object[0]));
            this.cbLastBounds.setSelected(true);
            this.cbLastBounds.setOpaque(false);
            this.cbLastBounds.setFont(UIConstants.FONT_12_PLAIN);
            screenPanel.add(this.cbLastBounds);
            this.mainPanel.add((Component)screenPanel, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 17, 0, new Insets(6, 35, 0, 20), 0, 0));
            this.lblPadding2 = new JLabel();
            this.mainPanel.add((Component)this.lblPadding2, new GridBagConstraints(0, y++, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            if (this.isWindows()) {
                this.setSize(800, 820);
            } else {
                this.setSize(550, 820);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void loadPreference() {
        PreferencesUtil.ClosePolicy closePolicy = PreferencesUtil.getClosePolicy();
        if (closePolicy == null) {
            this.rbMinimizeEZDesktop.setSelected(true);
        } else {
            switch (closePolicy) {
                case minimize: {
                    this.rbMinimizeEZDesktop.setSelected(true);
                    break;
                }
                case close: {
                    this.rbCloseEZDesktop.setSelected(true);
                }
            }
        }
        PreferencesUtil.ReturnPolicy returnPolicy = PreferencesUtil.getReturnPolicy();
        if (returnPolicy == null) {
            this.rbEnterOnly.setSelected(true);
        } else {
            switch (returnPolicy) {
                case returnOnly: {
                    this.rbEnterOnly.setSelected(true);
                    break;
                }
                case ctrlReturn: {
                    this.rbCtrlEnter.setSelected(true);
                }
            }
        }
        boolean isAutoMuted = PreferencesUtil.isConfAutoMuteEnabled();
        if (isAutoMuted) {
            this.cbConfAutoMute.setSelected(true);
        } else {
            this.cbConfAutoMute.setSelected(false);
        }
        boolean isKeyboardTouchSound = PreferencesUtil.isKeyboardTouchSound();
        if (isKeyboardTouchSound) {
            this.cbKeybordSound.setSelected(true);
        } else {
            this.cbKeybordSound.setSelected(false);
        }
        boolean isNoPopupTransfer = PreferencesUtil.isNoPopupTransferEnabled();
        if (isNoPopupTransfer) {
            this.cbNoPopupTransfer.setSelected(true);
        } else {
            this.cbNoPopupTransfer.setSelected(false);
        }
        boolean isHideSelfScreenCapure = PreferencesUtil.isHideSelfScreenCapure();
        if (isHideSelfScreenCapure) {
            this.cbHideSelf.setSelected(true);
        } else {
            this.cbHideSelf.setSelected(false);
        }
        boolean isLastScreenShotLocUsed = PreferencesUtil.isLastScreenShotLocUsed();
        if (isLastScreenShotLocUsed) {
            this.cbLastBounds.setSelected(true);
        } else {
            this.cbLastBounds.setSelected(false);
        }
        UserDatabase database = UserDatabase.getDB(UCChatClient.context);
        int option = database.getMapOption();
        if (option == 0) {
            this.rbGoogleMap.setSelected(true);
        } else {
            this.rbQQMap.setSelected(true);
        }
        if (database.isNotifyMessageOn()) {
            this.cbNotificationEnableBtn.setSelected(true);
        } else {
            this.cbNotificationEnableBtn.setSelected(false);
        }
        if (database.isShowContent()) {
            this.cbDisplayNotificationContentBtn.setSelected(true);
        } else {
            this.cbDisplayNotificationContentBtn.setSelected(false);
        }
        if (PreferencesUtil.isDefaultPopupNotification(UCChatClient.context)) {
            this.rbDefaultNotice.setSelected(true);
            this.rbSystemNotice.setSelected(false);
        } else {
            this.rbDefaultNotice.setSelected(false);
            this.rbSystemNotice.setSelected(true);
        }
    }

    private void btnConfirmActionPerformed(ActionEvent evt) {
        this.confirmClicked = true;
        if (this.rbMinimizeEZDesktop.isSelected()) {
            PreferencesUtil.setClosePolicy(PreferencesUtil.ClosePolicy.minimize);
        } else {
            PreferencesUtil.setClosePolicy(PreferencesUtil.ClosePolicy.close);
        }
        if (this.rbCtrlEnter.isSelected()) {
            PreferencesUtil.setReturnPolicy(PreferencesUtil.ReturnPolicy.ctrlReturn);
        } else {
            PreferencesUtil.setReturnPolicy(PreferencesUtil.ReturnPolicy.returnOnly);
        }
        if (this.cbConfAutoMute.isSelected()) {
            PreferencesUtil.setConfAutoMute(true);
        } else {
            PreferencesUtil.setConfAutoMute(false);
        }
        if (this.cbKeybordSound.isSelected()) {
            PreferencesUtil.setKeyboardTouchSound(true);
        } else {
            PreferencesUtil.setKeyboardTouchSound(false);
        }
        if (this.cbKeybordSound.isSelected()) {
            PreferencesUtil.setKeyboardTouchSound(true);
        } else {
            PreferencesUtil.setKeyboardTouchSound(false);
        }
        if (this.cbNoPopupTransfer.isSelected()) {
            PreferencesUtil.setNoPopupTransferEnabled(true);
        } else {
            PreferencesUtil.setNoPopupTransferEnabled(false);
        }
        if (this.cbHideSelf.isSelected()) {
            PreferencesUtil.setHideSelfScreenCapure(true);
        } else {
            PreferencesUtil.setHideSelfScreenCapure(false);
        }
        if (this.cbLastBounds.isSelected()) {
            PreferencesUtil.setLastScreenShotLocUsed(true);
        } else {
            PreferencesUtil.setLastScreenShotLocUsed(false);
        }
        BroadcastUtil.sendUpdateActionMapEvent(UCChatClient.context);
        UserDatabase database = UserDatabase.getDB(UCChatClient.context);
        if (this.rbGoogleMap.isSelected()) {
            database.setMapOption(0);
        } else {
            database.setMapOption(1);
        }
        if (this.cbNotificationEnableBtn.isSelected()) {
            database.setNotifyMessageOn(true);
        } else {
            database.setNotifyMessageOn(false);
        }
        if (this.cbDisplayNotificationContentBtn.isSelected()) {
            database.setDisplayContent(true);
        } else {
            database.setDisplayContent(false);
        }
        LanguageItem item = (LanguageItem)this.ringBoxModel.getSelectedItem();
        PreferencesUtil.putInt(UCChatClient.context, "RING_SETTING", item.getId());
        float ringVolume = (float)this.ringVolumeSlider.getValue() * 1.0f / 100.0f;
        if (ringVolume > 1.0f) {
            ringVolume = 1.0f;
        }
        PreferencesUtil.putFloat(UCChatClient.context, "RING_SETTING_VOLUME", Float.valueOf(ringVolume));
        if (this.isWindows()) {
            float appVolume = (float)this.appVolumeSlider.getValue() * 1.0f / 100.0f;
            if (appVolume > 1.0f) {
                appVolume = 1.0f;
            }
            PreferencesUtil.putFloat(UCChatClient.context, "APP_SETTING_VOLUME", Float.valueOf(appVolume));
            MixVolume.setVolume(appVolume);
        }
        LanguageItem item2 = (LanguageItem)this.noticeBoxModel.getSelectedItem();
        PreferencesUtil.putInt(UCChatClient.context, "NOTICE_SETTING", item2.getId());
        float noticeVolume = (float)this.noticeVolumeSlider.getValue() * 1.0f / 100.0f;
        if (noticeVolume > 1.0f) {
            noticeVolume = 1.0f;
        }
        PreferencesUtil.putFloat(UCChatClient.context, "NOTICE_SETTING_VOLUME", Float.valueOf(noticeVolume));
        PreferencesUtil.setDefaultPopupNotification(UCChatClient.context, this.rbDefaultNotice.isSelected());
        BroadcastUtil.sendContactHistoryChangedEvent(UCChatClient.context);
        SipPhoneService.reloadRingTone();
        this.setVisible(false);
    }

    @Override
    public void onAudioClipStop(AudioClipPlayer player) {
        if (player == this.clip_ringin) {
            this.btnTest.setIcon(UIConstants.ICON_RING_TONE);
            this.btnTest.setToolTipText(I18NUtil.getString("btn_ring_tone_test"));
        } else if (player == this.clip_notice) {
            this.btnNoticeTest.setIcon(UIConstants.ICON_RING_TONE);
            this.btnNoticeTest.setToolTipText(I18NUtil.getString("btn_ring_tone_test"));
        }
    }
}

