/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.main;

import com.blisscloud.ezuc.client.chat.ChatRoomItem;
import com.blisscloud.ezuc.client.chat.ChatRoomMember;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.component.MeetmeItemCellRenderer;
import com.blisscloud.ezuc.client.component.SearchField;
import com.blisscloud.ezuc.client.main.SelectMeetmeItemResult;
import com.blisscloud.ezuc.client.model.ToggleListSelectionModel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectMeetmeItemDialog
extends GenericDialog
implements ListSelectionListener {
    private JPanel panelContent;
    private JScrollPane jScrollPane1;
    private JList<ChatRoomItem> listContact;
    private JPanel jPanel1;
    private JLabel lblTitle;
    private SearchField sfContact;
    private JLabel lblSelectionCount;
    private JButton btnConfirm;
    private JButton btnCancel;
    boolean mOK = false;
    boolean mAllowEmptySelection = false;
    DefaultComboBoxModel<ChatRoomItem> listModelContact = new DefaultComboBoxModel();
    List<ChatRoomItem> mCandidateContacts;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                SelectMeetmeItemDialog inst = new SelectMeetmeItemDialog(frame);
                inst.setVisible(true);
            }
        });
    }

    public SelectMeetmeItemDialog(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle(I18NUtil.getAppName());
            this.setModal(true);
            this.setLocationRelativeTo(null);
            this.panelContent = new JPanel();
            GridBagLayout panelContentLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.panelContent, "Center");
            this.panelContent.setLayout(panelContentLayout);
            this.panelContent.setBackground(Color.WHITE);
            this.sfContact = new SearchField();
            this.panelContent.add((Component)this.sfContact, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
            this.sfContact.setSearchCallback(new SearchField.SearchCallback(){

                @Override
                public void doSearch(String key) {
                    SelectMeetmeItemDialog.this.searchContact(key);
                }
            });
            this.lblTitle = new JLabel();
            this.panelContent.add((Component)this.lblTitle, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
            this.lblTitle.setText("");
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(60);
            this.panelContent.add((Component)this.jScrollPane1, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 10, 0, 10), 0, 0));
            this.listContact = new JList();
            this.jScrollPane1.setViewportView(this.listContact);
            this.listContact.setCellRenderer(new MeetmeItemCellRenderer(48));
            this.listContact.setModel(this.listModelContact);
            this.listContact.setSelectionMode(2);
            this.listContact.setSelectionModel(new ToggleListSelectionModel(this.listContact));
            this.listContact.getSelectionModel().addListSelectionListener(this);
            this.lblSelectionCount = new JLabel();
            this.panelContent.add((Component)this.lblSelectionCount, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
            this.lblSelectionCount.setText(I18NUtil.getString("abook_label_contact_selection_count") + " : 0");
            this.jPanel1 = new JPanel();
            FlowLayout jPanel1Layout = new FlowLayout();
            jPanel1Layout.setAlignment(2);
            jPanel1Layout.setHgap(10);
            this.jPanel1.setLayout(jPanel1Layout);
            this.panelContent.add((Component)this.jPanel1, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.jPanel1.setOpaque(false);
            this.btnConfirm = new JButton();
            this.jPanel1.add(this.btnConfirm);
            this.btnConfirm.setText(I18NUtil.getString("common_btn_ok"));
            this.btnConfirm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SelectMeetmeItemDialog.this.btnConfirmActionPerformed(evt);
                }
            });
            this.btnCancel = new JButton();
            this.jPanel1.add(this.btnCancel);
            this.btnCancel.setText(I18NUtil.getString("common_btn_cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SelectMeetmeItemDialog.this.btnCancelActionPerformed(evt);
                }
            });
            this.setSize(330, 500);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void btnConfirmActionPerformed(ActionEvent evt) {
        if (!this.mAllowEmptySelection && this.listContact.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, I18NUtil.getString("chatroom_select_members"), I18NUtil.getString("common_title_error"), 0);
            return;
        }
        this.mOK = true;
        this.dispose();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.mOK = false;
        this.dispose();
    }

    @Override
    protected void onESCPressed() {
        this.mOK = false;
        this.dispose();
    }

    private void searchContact(String key) {
        List<ChatRoomItem> currentSelection = this.listContact.getSelectedValuesList();
        int count = 0;
        this.listModelContact.removeAllElements();
        for (ChatRoomItem m : this.mCandidateContacts) {
            ChatRoomMember crm;
            if (!(m instanceof ChatRoomMember) || ((crm = (ChatRoomMember)m).getJid() == null || crm.getJid().indexOf(key) < 0) && (crm.getTitle() == null || crm.getTitle().indexOf(key) < 0)) continue;
            this.listModelContact.addElement(crm);
            if (currentSelection.contains(crm)) {
                this.listContact.addSelectionInterval(count, count);
            }
            ++count;
        }
    }

    public SelectMeetmeItemResult showDialog(String title, List<ChatRoomItem> candidateContacts) {
        return this.showDialog(title, candidateContacts, null, false);
    }

    public SelectMeetmeItemResult showDialog(String title, List<ChatRoomItem> candidateContacts, List<ChatRoomItem> selectedContacts) {
        return this.showDialog(title, candidateContacts, selectedContacts, false);
    }

    public SelectMeetmeItemResult showDialog(String title, List<ChatRoomItem> candidateContacts, List<ChatRoomItem> selectedContacts, boolean allowEmptySelection) {
        this.lblTitle.setText(title);
        this.mOK = false;
        this.mAllowEmptySelection = allowEmptySelection;
        this.updateContactList(candidateContacts);
        if (selectedContacts != null) {
            for (ChatRoomItem m : selectedContacts) {
                int selectedIndex = candidateContacts.indexOf(m);
                this.listContact.addSelectionInterval(selectedIndex, selectedIndex);
            }
        }
        this.setVisible(true);
        if (this.mOK) {
            SelectMeetmeItemResult res = new SelectMeetmeItemResult();
            List<ChatRoomItem> values = this.listContact.getSelectedValuesList();
            ArrayList<ChatRoomItem> participants = new ArrayList<ChatRoomItem>();
            for (ChatRoomItem item : values) {
                participants.add(item);
            }
            res.setParticipants(participants);
            return res;
        }
        return null;
    }

    public void updateContactList(List<ChatRoomItem> newCandidateContacts) {
        List<ChatRoomItem> oldSelectionList = this.listContact.getSelectedValuesList();
        this.mCandidateContacts = newCandidateContacts;
        this.listModelContact.removeAllElements();
        for (ChatRoomItem m : newCandidateContacts) {
            if (!(m instanceof ChatRoomMember)) continue;
            this.listModelContact.addElement(m);
        }
        if (oldSelectionList != null) {
            for (ChatRoomItem oldItem : oldSelectionList) {
                String oldItemJid = null;
                if (oldItem instanceof ChatRoomMember) {
                    ChatRoomMember oldItemChat = (ChatRoomMember)oldItem;
                    oldItemJid = oldItemChat.getJid();
                }
                ChatRoomItem targetNewItem = null;
                for (ChatRoomItem newItem : newCandidateContacts) {
                    String newItemJid = null;
                    if (newItem instanceof ChatRoomMember) {
                        ChatRoomMember newItemChat = (ChatRoomMember)newItem;
                        newItemJid = newItemChat.getJid();
                    }
                    if (newItemJid == null || oldItemJid == null || !newItemJid.equals(oldItemJid)) continue;
                    targetNewItem = newItem;
                    break;
                }
                if (targetNewItem == null) continue;
                int selectedIndex = newCandidateContacts.indexOf(targetNewItem);
                this.listContact.addSelectionInterval(selectedIndex, selectedIndex);
            }
        }
        String key = this.sfContact.getSearchKey();
        this.searchContact(key);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        List<ChatRoomItem> selection = this.listContact.getSelectedValuesList();
        this.lblSelectionCount.setText(I18NUtil.getString("abook_label_contact_selection_count") + " : " + selection.size());
    }
}

