/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.media;

import com.blisscloud.ezuc.client.media.AudioClipPlayerListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;

public class AudioClipPlayer
implements LineListener {
    Clip clip = null;
    AudioClipPlayerListener p_listener = null;

    public AudioClipPlayer(String filename, AudioClipPlayerListener listener) {
        try {
            FileInputStream inputstream = new FileInputStream(new File(filename));
            AudioInputStream audio_inputstream = AudioSystem.getAudioInputStream(inputstream);
            this.init(audio_inputstream, listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AudioClipPlayer(File file, AudioClipPlayerListener listener) {
        try {
            AudioInputStream audio_inputstream = AudioSystem.getAudioInputStream(new FileInputStream(file));
            this.init(audio_inputstream, listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AudioClipPlayer(InputStream inputstream, AudioClipPlayerListener listener) {
        try {
            AudioInputStream audio_inputstream = AudioSystem.getAudioInputStream(inputstream);
            this.init(audio_inputstream, listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AudioClipPlayer(AudioInputStream audio_inputstream, AudioClipPlayerListener listener) {
        this.init(audio_inputstream, listener);
    }

    void init(AudioInputStream audio_inputstream, AudioClipPlayerListener listener) {
        this.p_listener = listener;
        if (audio_inputstream != null) {
            try {
                AudioFormat format = audio_inputstream.getFormat();
                DataLine.Info info = new DataLine.Info(Clip.class, format);
                this.clip = (Clip)AudioSystem.getLine(info);
                this.clip.addLineListener(this);
                this.clip.open(audio_inputstream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void adjustVolume(float volume) {
        if (volume < 0.0f || volume > 1.0f) {
            throw new IllegalArgumentException("Volume not valid: " + volume);
        }
        FloatControl gainControl = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
        float range = gainControl.getMaximum() - gainControl.getMinimum();
        float gain = range * volume + gainControl.getMinimum();
        gainControl.setValue(gain);
    }

    public void loop() {
        this.loop(0);
    }

    public void loop(int n) {
        this.rewind();
        if (this.clip != null) {
            if (n <= 0) {
                this.clip.loop(-1);
            } else {
                this.clip.loop(n - 1);
            }
        }
    }

    public boolean isRunning() {
        if (this.clip != null) {
            return this.clip.isRunning();
        }
        return false;
    }

    public void play() {
        if (this.clip != null) {
            this.clip.start();
        }
    }

    public void stop() {
        if (this.clip != null) {
            this.clip.stop();
        }
    }

    public void rewind() {
        if (this.clip != null) {
            this.clip.setMicrosecondPosition(0L);
        }
    }

    public void goTo(long millisec) {
        if (this.clip != null) {
            this.clip.setMicrosecondPosition(millisec);
        }
    }

    public void replay() {
        if (this.clip != null) {
            this.rewind();
            this.clip.start();
        }
    }

    @Override
    public void update(LineEvent event) {
        if (event.getType().equals(LineEvent.Type.STOP) && this.p_listener != null) {
            this.p_listener.onAudioClipStop(this);
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("AudioClipPlayer: usage:\n  java AudioClipPlayer <filename>");
            System.exit(0);
        }
        AudioClipPlayer p = new AudioClipPlayer(args[0], null);
        p.play();
    }
}

