/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.outboundfilter;

import com.blisscloud.ezuc.client.resource.I18NUtil;

public enum CallResultType {
    ANSWERED(0),
    NO_ANSWERED(1),
    BUSY(2),
    DND(3),
    CANCELED_CALLER_HANGUP(4),
    CANCELED_ANSWERED_ELSEWHERE(5),
    TRANSFER(6),
    BLOCKED(11),
    FAILED_UNKNOWN(21),
    FAILED_ROUTIG_ERROR(22),
    FAILED_CONGESTION(23),
    NO_DIAL_RUN_OUT_TIME(31),
    NO_DIAL_TIME_QUOTA_EXHAUSTED(32),
    NO_DIAL_NO_PERMISSION(33),
    NO_DIAL_FORBIDDEN_TIME(34),
    NO_DIAL_WRONG_NO(35),
    NO_DIAL_IN_BLOCK_LIST(36),
    NO_DIAL_EMP_OFF_DUTY(37),
    NO_DIAL_TRUNK_LINE_NOT_READY(38);

    private int id;

    private CallResultType(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static CallResultType getValue(int id) {
        switch (id) {
            case 0: {
                return ANSWERED;
            }
            case 1: {
                return NO_ANSWERED;
            }
            case 2: {
                return BUSY;
            }
            case 3: {
                return DND;
            }
            case 4: {
                return CANCELED_CALLER_HANGUP;
            }
            case 5: {
                return CANCELED_ANSWERED_ELSEWHERE;
            }
            case 6: {
                return TRANSFER;
            }
            case 11: {
                return BLOCKED;
            }
            case 21: {
                return FAILED_UNKNOWN;
            }
            case 22: {
                return FAILED_ROUTIG_ERROR;
            }
            case 23: {
                return FAILED_CONGESTION;
            }
            case 31: {
                return NO_DIAL_RUN_OUT_TIME;
            }
            case 32: {
                return NO_DIAL_TIME_QUOTA_EXHAUSTED;
            }
            case 33: {
                return NO_DIAL_NO_PERMISSION;
            }
            case 34: {
                return NO_DIAL_FORBIDDEN_TIME;
            }
            case 35: {
                return NO_DIAL_WRONG_NO;
            }
            case 36: {
                return NO_DIAL_IN_BLOCK_LIST;
            }
            case 37: {
                return NO_DIAL_EMP_OFF_DUTY;
            }
            case 38: {
                return NO_DIAL_TRUNK_LINE_NOT_READY;
            }
        }
        return null;
    }

    public String getCallResult() {
        String result = "";
        CallResultType callType = this;
        result = callType == ANSWERED ? I18NUtil.getString("contactRecord_status_option_answered") : (callType == NO_ANSWERED ? I18NUtil.getString("contactRecord_status_option_noanswer") : (callType == BUSY ? I18NUtil.getString("contactRecord_status_option_busy") : (callType == DND ? I18NUtil.getString("contactRecord_status_option_dnd") : (callType == TRANSFER ? I18NUtil.getString("contactRecord_status_option_transferred") : (callType == CANCELED_CALLER_HANGUP ? I18NUtil.getString("contactRecord_status_option_canceled") : (callType == CANCELED_ANSWERED_ELSEWHERE ? I18NUtil.getString("contactRecord_status_option_answeredelsewhere") : (callType == BLOCKED ? I18NUtil.getString("contactRecord_status_option_block") : (callType == FAILED_UNKNOWN ? I18NUtil.getString("contactRecord_status_option_failed") : (callType == FAILED_ROUTIG_ERROR ? I18NUtil.getString("contactRecord_status_option_failed_routing_error") : (callType == FAILED_CONGESTION ? I18NUtil.getString("contactRecord_status_option_failed_congestion") : (callType == NO_DIAL_RUN_OUT_TIME ? I18NUtil.getString("contactRecord_status_option_totalTimeOver") : (callType == NO_DIAL_TIME_QUOTA_EXHAUSTED ? I18NUtil.getString("contactRecord_status_option_timeQuotaExhausted") : (callType == NO_DIAL_NO_PERMISSION ? I18NUtil.getString("contactRecord_status_option_noPermission") : (callType == NO_DIAL_IN_BLOCK_LIST ? I18NUtil.getString("contactRecord_status_option_inBlockList") : (callType == NO_DIAL_FORBIDDEN_TIME ? I18NUtil.getString("contactRecord_status_option_forbiddenTime") : (callType == NO_DIAL_WRONG_NO ? I18NUtil.getString("contactRecord_status_option_wrong_no") : (callType == NO_DIAL_EMP_OFF_DUTY ? I18NUtil.getString("contactRecord_status_option_emp_off_duty") : (callType == NO_DIAL_TRUNK_LINE_NOT_READY ? I18NUtil.getString("contactRecord_status_option_trunkLineNotReady") : ""))))))))))))))))));
        return result;
    }
}

