/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.phone;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.mobile.ezuc.agent.CallLine;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.PhoneLineInfo;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class ConferenceDialog
extends GenericDialog {
    private static final long serialVersionUID = 2005755156175398787L;
    private JScrollPane jScrollPane;
    private JPanel mainPanel;
    private JButton btnConfirm;
    private ButtonGroup conferenceButtonGroup = new ButtonGroup();
    private JRadioButton multiPartyNewRoomRadioBtn;
    private JCheckBox lineOneCheckBox0;
    private JCheckBox lineOneCheckBox1;
    private JCheckBox lineOneCheckBox2;
    private List<CallLine> meetmeLineList;
    private List<JRadioButton> meetmeLineRadioBtnList = new ArrayList<JRadioButton>();
    private int mLine;

    public ConferenceDialog(JFrame frame, int line) {
        super(frame);
        this.mLine = line;
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle(I18NUtil.getString("conference_dialog_label"));
            this.setModal(true);
            this.setLocationRelativeTo(null);
            BorderLayout thisLayout = new BorderLayout();
            this.setLayout(thisLayout);
            this.setBackground(UIConstants.COLOR_DIALOG_BACKGROUND);
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setVerticalScrollBarPolicy(20);
            this.jScrollPane.setHorizontalScrollBarPolicy(31);
            this.add((Component)this.jScrollPane, "Center");
            this.jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            this.mainPanel = new JPanel();
            this.mainPanel.setOpaque(false);
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.jScrollPane.setViewportView(this.mainPanel);
            GridBagLayout mainLayout = new GridBagLayout();
            this.mainPanel.setLayout(mainLayout);
            int y = 0;
            boolean selected = false;
            List<CallLine> lineList = PhoneAgent.getInstance().getOtherLineAbleToNewConf(this.mLine);
            if (lineList != null && lineList.size() > 0) {
                JPanel radioPanel = new JPanel();
                radioPanel.setOpaque(false);
                FlowLayout layout = new FlowLayout();
                layout.setAlignment(3);
                radioPanel.setLayout(layout);
                this.mainPanel.add((Component)radioPanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
                this.multiPartyNewRoomRadioBtn = new JRadioButton();
                radioPanel.add(this.multiPartyNewRoomRadioBtn);
                this.multiPartyNewRoomRadioBtn.setText(I18NUtil.getString("conference_dialog_multi_new_room_label"));
                this.multiPartyNewRoomRadioBtn.setOpaque(false);
                this.multiPartyNewRoomRadioBtn.setFont(UIConstants.FONT_14_PLAIN);
                if (!selected) {
                    this.multiPartyNewRoomRadioBtn.setSelected(true);
                    selected = true;
                }
                this.conferenceButtonGroup.add(this.multiPartyNewRoomRadioBtn);
                Iterator iterator = lineList.iterator();
                while (iterator.hasNext()) {
                    CallLine callLine = (CallLine)iterator.next();
                    JPanel radioPanel2 = new JPanel();
                    radioPanel2.setOpaque(false);
                    FlowLayout layout2 = new FlowLayout();
                    layout2.setAlignment(3);
                    radioPanel2.setLayout(layout2);
                    JCheckBox box = new JCheckBox();
                    radioPanel2.add(box);
                    this.mainPanel.add((Component)radioPanel2, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 30, 5, 10), 0, 0));
                    box.setText(String.format(I18NUtil.getString("conference_dialog_line_label"), String.valueOf(callLine.getLineId() + 1), callLine.getLineInfo().getMainDispName()));
                    box.setOpaque(false);
                    box.setFont(UIConstants.FONT_14_PLAIN);
                    box.setSelected(true);
                    if (callLine.getLineId() == 0) {
                        this.lineOneCheckBox0 = box;
                        continue;
                    }
                    if (callLine.getLineId() == 1) {
                        this.lineOneCheckBox1 = box;
                        continue;
                    }
                    if (callLine.getLineId() != 2) continue;
                    this.lineOneCheckBox2 = box;
                }
            }
            this.meetmeLineList = PhoneAgent.getInstance().getOtherConferenceLine(this.mLine);
            if (this.meetmeLineList != null && this.meetmeLineList.size() > 0) {
                for (CallLine callLine : this.meetmeLineList) {
                    JPanel radioPanel = new JPanel();
                    radioPanel.setOpaque(false);
                    FlowLayout layout = new FlowLayout();
                    layout.setAlignment(3);
                    radioPanel.setLayout(layout);
                    JRadioButton meetmeLineRadioBtn = new JRadioButton();
                    this.meetmeLineRadioBtnList.add(meetmeLineRadioBtn);
                    radioPanel.add(meetmeLineRadioBtn);
                    this.mainPanel.add((Component)radioPanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
                    String meetmeLineText = String.format(I18NUtil.getString("conference_dialog_join_exist"), String.valueOf(callLine.getLineId() + 1), callLine.getLineInfo().getMainDispName());
                    meetmeLineRadioBtn.setText(meetmeLineText);
                    meetmeLineRadioBtn.setOpaque(false);
                    meetmeLineRadioBtn.setFont(UIConstants.FONT_14_PLAIN);
                    if (!selected) {
                        meetmeLineRadioBtn.setSelected(true);
                        selected = true;
                    }
                    this.conferenceButtonGroup.add(meetmeLineRadioBtn);
                }
            }
            JPanel x = new JPanel();
            x.setOpaque(false);
            this.mainPanel.add((Component)x, new GridBagConstraints(0, y++, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            JPanel btnPanel = new JPanel();
            btnPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            btnPanel.setOpaque(false);
            FlowLayout btnPanelLayout = new FlowLayout();
            btnPanelLayout.setAlignment(1);
            btnPanel.setLayout(btnPanelLayout);
            this.add((Component)btnPanel, "South");
            this.btnConfirm = new JButton();
            btnPanel.add(this.btnConfirm);
            this.btnConfirm.setText(I18NUtil.getString("common_btn_ok"));
            this.btnConfirm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ConferenceDialog.this.btnConfirmActionPerformed(evt);
                }
            });
            JButton btnCancel = new JButton();
            btnPanel.add(btnCancel);
            btnCancel.setText(I18NUtil.getString("common_btn_cancel"));
            btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ConferenceDialog.this.setVisible(false);
                }
            });
            this.setSize(500, 300);
            this.setMinimumSize(new Dimension(500, 250));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void btnConfirmActionPerformed(ActionEvent evt) {
        if (this.multiPartyNewRoomRadioBtn != null && this.multiPartyNewRoomRadioBtn.isSelected()) {
            HashSet<String> participantJidSet = new HashSet<String>();
            participantJidSet.add(PreferencesUtil.getUserJid(UCChatClient.context));
            CallLine currentLine = PhoneAgent.getInstance().getCallLine(this.mLine);
            String sipCallId1 = null;
            String sipCallId2 = null;
            String sipCallId3 = null;
            if (this.mLine == 0) {
                sipCallId1 = currentLine.getSipCallId();
            } else if (this.mLine == 1) {
                sipCallId2 = currentLine.getSipCallId();
            } else if (this.mLine == 2) {
                sipCallId3 = currentLine.getSipCallId();
            }
            PhoneLineInfo lineInfo = currentLine.getLineInfo();
            if (TextUtils.isNotBlank((CharSequence)lineInfo.getJid())) {
                participantJidSet.add(lineInfo.getJid());
            }
            if (this.lineOneCheckBox0 != null && this.lineOneCheckBox0.isSelected()) {
                CallLine line0 = PhoneAgent.getInstance().getCallLine(0);
                sipCallId1 = line0.getSipCallId();
                PhoneLineInfo line0Info = line0.getLineInfo();
                if (TextUtils.isNotBlank((CharSequence)line0Info.getJid())) {
                    participantJidSet.add(line0Info.getJid());
                }
            }
            if (this.lineOneCheckBox1 != null && this.lineOneCheckBox1.isSelected()) {
                CallLine line1 = PhoneAgent.getInstance().getCallLine(1);
                sipCallId2 = line1.getSipCallId();
                PhoneLineInfo line1Info = line1.getLineInfo();
                if (TextUtils.isNotBlank((CharSequence)line1Info.getJid())) {
                    participantJidSet.add(line1Info.getJid());
                }
            }
            if (this.lineOneCheckBox2 != null && this.lineOneCheckBox2.isSelected()) {
                CallLine line2 = PhoneAgent.getInstance().getCallLine(2);
                sipCallId3 = line2.getSipCallId();
                PhoneLineInfo line2Info = line2.getLineInfo();
                if (TextUtils.isNotBlank((CharSequence)line2Info.getJid())) {
                    participantJidSet.add(line2Info.getJid());
                }
            }
            String roomId = UCDBChatRoom.findThreeWayCallingChatRoom(UCChatClient.context, participantJidSet);
            WebAgent.getInstance().makeThreeWayCalling(roomId, participantJidSet, sipCallId1, sipCallId2, sipCallId3);
            this.setVisible(false);
            return;
        }
        if (this.meetmeLineRadioBtnList.size() != 0) {
            for (int i = 0; i < this.meetmeLineRadioBtnList.size(); ++i) {
                JRadioButton btn = this.meetmeLineRadioBtnList.get(i);
                if (!btn.isSelected()) continue;
                CallLine thisLine = PhoneAgent.getInstance().getCallLine(this.mLine);
                CallLine meetmeLine = this.meetmeLineList.get(i);
                WebAgent.getInstance().makeInviteConference(meetmeLine.getLineInfo().getJid(), thisLine.getSipCallId());
                this.setVisible(false);
                return;
            }
        }
        this.setVisible(false);
    }

    public static boolean checkSetEquals(Set<?> set1, Set<?> set2) {
        if (set1 == null || set2 == null) {
            return false;
        }
        if (set1.size() != set2.size()) {
            return false;
        }
        return set1.containsAll(set2);
    }
}

