/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.phone;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.BackgroundImagePanel;
import com.blisscloud.ezuc.client.component.BackgroundImagePanel2;
import com.blisscloud.ezuc.client.component.CustomLineBorder;
import com.blisscloud.ezuc.client.component.EmptyIcon;
import com.blisscloud.ezuc.client.component.MarqueePanel;
import com.blisscloud.ezuc.client.component.MarqueeState;
import com.blisscloud.ezuc.client.main.AgentStateDialog;
import com.blisscloud.ezuc.client.main.MainPanel;
import com.blisscloud.ezuc.client.phone.ConferenceDialog;
import com.blisscloud.ezuc.client.phone.TransferDialog;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Handler;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.CallLine;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.AgentAction;
import com.blisscloud.mobile.ezuc.bean.AgentStatusType;
import com.blisscloud.mobile.ezuc.bean.MediaType;
import com.blisscloud.mobile.ezuc.bean.PhoneLineInfo;
import com.blisscloud.mobile.ezuc.bean.QueueStatus;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.manager.DialoutManager;
import com.blisscloud.mobile.ezuc.phone.CallState;
import com.blisscloud.mobile.ezuc.util.ApiVersion;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class PhoneBarPanel
extends JPanel
implements MarqueePanel.MarqueeContentProvider {
    private static final long serialVersionUID = 4652803311633830574L;
    public static final int ITEM_GAP = 4;
    private JPanel agentStatusGroup;
    private JLabel agentStatus;
    private MarqueePanel marqueePanel;
    private AgentStateDialog agentStateDialog;
    private TransferDialog transferDialog;
    private ConferenceDialog conferenceDialog;
    private PhoneBarContentProvider mProvider;
    private JTextField callNumberField;
    private JLabel lblKeyboard;
    private boolean mSipRegistered = false;
    private JLabel line1Label;
    private JLabel line2Label;
    private JLabel line3Label;
    private JLabel lblCall;
    private JLabel lblHangup;
    private boolean lineEnabled;
    private boolean keyboardEnabled;
    private boolean callEnabled;
    private boolean hangupEnabled;
    private int muteEnabledState = 0;
    private int recEnabledState = 0;
    private int aiEnabledState = 0;
    private int holdEnabledState = 0;
    private boolean transferEnabled;
    private boolean conferenceEnabled;
    private JLabel callInfoLabel;
    private JLabel callTimeLabel;
    private JLabel lblMute;
    private JLabel lblRec;
    private JLabel lblAI;
    private JLabel lblHold;
    private JLabel lblTransfer;
    private JLabel lblConference;
    private boolean timerOn;
    private JProgressBar micLevelBar;
    private Handler callTimeHandler = new Handler("CallTimeHandler3");
    private Runnable callTimeTimer = new Runnable(){

        @Override
        public void run() {
            CallLine callLine = PhoneAgent.getInstance().getCurrentCallLine();
            if (callLine.getLineInfo() != null) {
                String dislTime = callLine.getLineInfo().getCallDuration();
                PhoneBarPanel.this.callTimeLabel.setText(dislTime);
                PhoneBarPanel.this.callTimeHandler.postDelayed(this, 500L);
            }
        }
    };

    public PhoneBarPanel(PhoneBarContentProvider provider) {
        this.mProvider = provider;
        this.initGUI();
        this.applyPhoneState();
    }

    private void initGUI() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.agentStatusGroup = new JPanel();
        this.agentStatusGroup.setVisible(false);
        this.agentStatusGroup.setOpaque(false);
        this.agentStatusGroup.setCursor(UIConstants.CURSOR_HAND);
        this.agentStatusGroup.setLayout(new GridBagLayout());
        this.add((Component)this.agentStatusGroup, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 4), 0, 0));
        this.agentStatus = new JLabel();
        this.agentStatus.setVisible(false);
        this.agentStatusGroup.add((Component)this.agentStatus, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.agentStatus.setText(I18NUtil.getString("agent_state_offline"));
        this.agentStatus.setFont(UIConstants.FONT_12_PLAIN);
        this.agentStatus.setToolTipText(I18NUtil.getString("agent_state_dialog_tooltip"));
        this.agentStatus.setHorizontalAlignment(2);
        this.agentStatus.setBorder(UIConstants.BORDER_CONFIG_BUTTON);
        this.agentStatus.setCursor(UIConstants.CURSOR_HAND);
        this.agentStatus.setIcon(UIConstants.ICON_AGENT_STATE_LOGOUT);
        this.agentStatus.setHorizontalTextPosition(0);
        this.agentStatus.setVerticalTextPosition(3);
        this.agentStatus.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PhoneBarPanel.this.showMenuListForAgent(e);
            }
        });
        this.marqueePanel = new MarqueePanel(this);
        this.marqueePanel.setVisible(false);
        this.marqueePanel.setBackground(Color.BLACK);
        this.marqueePanel.setBorder(new CustomLineBorder(Color.WHITE, 1, 1, 1, 1));
        this.marqueePanel.setCursor(UIConstants.CURSOR_HAND);
        this.marqueePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PhoneBarPanel.this.marqueePanel.getState() == MarqueeState.PAUSED) {
                    PhoneBarPanel.this.marqueePanel.resumeScrolling();
                } else if (PhoneBarPanel.this.marqueePanel.getState() == MarqueeState.RUNNING) {
                    PhoneBarPanel.this.marqueePanel.pauseScrolling();
                }
            }
        });
        this.add((Component)this.marqueePanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        BackgroundImagePanel2 phoneBarPanel = new BackgroundImagePanel2(UIConstants.ICON_TOP_PHONE_BACKGROUND.getImage());
        phoneBarPanel.setOpaque(false);
        phoneBarPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        phoneBarPanel.setPreferredSize(new Dimension(650, 80));
        BorderLayout inputGroupLayout = new BorderLayout();
        inputGroupLayout.setHgap(6);
        phoneBarPanel.setLayout(inputGroupLayout);
        this.add((Component)phoneBarPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        BackgroundImagePanel callPanel = new BackgroundImagePanel(UIConstants.ICON_PHONE_BACKGROUND.getImage(), 20, 2);
        callPanel.setOpaque(false);
        callPanel.setPreferredSize(new Dimension(180, 42));
        phoneBarPanel.add((Component)callPanel, "Center");
        BorderLayout jPanel2Layout1 = new BorderLayout();
        jPanel2Layout1.setHgap(3);
        callPanel.setLayout(jPanel2Layout1);
        callPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.callNumberField = new JTextField();
        callPanel.add((Component)this.callNumberField, "Center");
        this.callNumberField.setFont(UIConstants.FONT_16_BOLD);
        this.callNumberField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
        this.callNumberField.setOpaque(false);
        this.callNumberField.setHorizontalAlignment(4);
        this.callNumberField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                this.checkPopup(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.checkPopup(evt);
            }

            private void checkPopup(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    final String pasteContent = PhoneBarPanel.this.getClipboardContents();
                    if (TextUtils.isBlank((CharSequence)pasteContent)) {
                        return;
                    }
                    JPopupMenu popupMenuMessage = new JPopupMenu();
                    JMenuItem miPaste = new JMenuItem();
                    miPaste.setText(I18NUtil.getString("common_btn_paste"));
                    miPaste.setHorizontalTextPosition(0);
                    miPaste.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            PhoneBarPanel.this.callNumberField.replaceSelection(pasteContent);
                        }
                    });
                    popupMenuMessage.add(miPaste);
                    popupMenuMessage.show(PhoneBarPanel.this.callNumberField, evt.getX(), evt.getY());
                }
            }
        });
        this.callNumberField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhoneBarPanel.this.dialOut();
            }
        });
        this.callNumberField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                CallLine callLine = PhoneAgent.getInstance().getCurrentCallLine();
                if (callLine.getState() == CallState.IDLE) {
                    if ((c < '0' || c > '9') && c != '\b' && c != '*' && c != '#' && c != '+' && c != ',') {
                        e.consume();
                    }
                } else if (callLine.getState() == CallState.INCALL && PhoneBarPanel.this.mProvider.isKeyBoardVisible()) {
                    if ((c < '0' || c > '9') && c != '\b' && c != '*' && c != '#') {
                        e.consume();
                    }
                } else {
                    e.consume();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                PhoneBarPanel.this.mProvider.onKeyBoardKeyPress(e.getKeyChar());
            }

            @Override
            public void keyReleased(KeyEvent e) {
                PhoneBarPanel.this.mProvider.onKeyBoardKeyRelease(e.getKeyChar());
            }
        });
        JPanel statusPanel = new JPanel();
        statusPanel.setOpaque(false);
        statusPanel.setLayout(new BorderLayout());
        statusPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 0, 5));
        callPanel.add((Component)statusPanel, "South");
        this.callTimeLabel = new JLabel();
        this.callTimeLabel.setFont(new Font("Arial, Helvetica, sans-serif", 0, 11));
        statusPanel.add((Component)this.callTimeLabel, "East");
        this.callTimeLabel.setText("");
        this.callInfoLabel = new JLabel();
        this.callInfoLabel.setFont(UIConstants.FONT_11_PLAIN);
        statusPanel.add((Component)this.callInfoLabel, "West");
        this.callInfoLabel.setIcon(UIConstants.ICON_PBAR_STATUS_LEISURE);
        this.callInfoLabel.setText("");
        this.micLevelBar = new JProgressBar(1, 0, 100){

            @Override
            protected void paintComponent(Graphics g) {
                int value = this.getValue();
                int height = this.getHeight();
                int fill = (int)((double)height * ((double)value / (double)this.getMaximum()));
                g.setColor(Color.DARK_GRAY);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(Color.RED);
                g.fillRect(0, height - fill, this.getWidth(), fill);
            }
        };
        this.micLevelBar.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Dimension narrowSize = new Dimension(3, 50);
        this.micLevelBar.setPreferredSize(narrowSize);
        this.micLevelBar.setMinimumSize(narrowSize);
        this.micLevelBar.setMaximumSize(narrowSize);
        this.micLevelBar.setForeground(Color.RED);
        this.micLevelBar.setBackground(Color.DARK_GRAY);
        this.micLevelBar.setStringPainted(false);
        callPanel.add((Component)this.micLevelBar, "East");
        JPanel leftBtnGroup = new JPanel();
        leftBtnGroup.setOpaque(false);
        phoneBarPanel.add((Component)leftBtnGroup, "West");
        leftBtnGroup.setLayout(new GridBagLayout());
        this.lblKeyboard = new JLabel();
        this.lblKeyboard.setCursor(UIConstants.CURSOR_HAND);
        this.lblKeyboard.setIcon(UIConstants.ICON_PBAR_KEYBOARD_DISABLED);
        this.lblKeyboard.setToolTipText(I18NUtil.getString("phone_bar_btn_keyboard"));
        this.lblKeyboard.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (PhoneBarPanel.this.keyboardEnabled) {
                    PhoneBarPanel.this.mProvider.onKeyBoardClicked();
                    PhoneBarPanel.this.lblKeyboard.setIcon(UIConstants.ICON_PBAR_KEYBOARD_DOWN);
                    PhoneBarPanel.this.applyPhoneState();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (PhoneBarPanel.this.keyboardEnabled) {
                    PhoneBarPanel.this.lblKeyboard.setIcon(UIConstants.ICON_PBAR_KEYBOARD_OVER);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (PhoneBarPanel.this.keyboardEnabled) {
                    PhoneBarPanel.this.lblKeyboard.setIcon(UIConstants.ICON_PBAR_KEYBOARD_ENABLED);
                }
            }
        });
        leftBtnGroup.add((Component)this.lblKeyboard, new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.line1Label = new JLabel(UIConstants.ICON_PHONE_LINE_1_OFF_UNSELECTED);
        this.line1Label.setCursor(UIConstants.CURSOR_HAND);
        leftBtnGroup.add((Component)this.line1Label, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 0, 1, 4), 0, 0));
        this.line1Label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (PhoneBarPanel.this.lineEnabled) {
                    PhoneBarPanel.this.switchLineTo(0);
                }
            }
        });
        this.line2Label = new JLabel(UIConstants.ICON_PHONE_LINE_2_OFF_UNSELECTED);
        this.line2Label.setCursor(UIConstants.CURSOR_HAND);
        leftBtnGroup.add((Component)this.line2Label, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 0, 1, 4), 0, 0));
        this.line2Label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (PhoneBarPanel.this.lineEnabled) {
                    PhoneBarPanel.this.switchLineTo(1);
                }
            }
        });
        this.line3Label = new JLabel(UIConstants.ICON_PHONE_LINE_3_OFF_UNSELECTED);
        this.line3Label.setCursor(UIConstants.CURSOR_HAND);
        leftBtnGroup.add((Component)this.line3Label, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 0, 1, 4), 0, 0));
        this.line3Label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (PhoneBarPanel.this.lineEnabled) {
                    PhoneBarPanel.this.switchLineTo(2);
                }
            }
        });
        JPanel rightBtnGroup = new JPanel();
        rightBtnGroup.setOpaque(false);
        phoneBarPanel.add((Component)rightBtnGroup, "East");
        rightBtnGroup.setLayout(new GridBagLayout());
        int x = 0;
        this.lblCall = new JLabel();
        this.lblCall.setIcon(UIConstants.ICON_PBAR_DIAL_DISABLED);
        this.lblCall.setCursor(UIConstants.CURSOR_HAND);
        this.lblCall.setToolTipText(I18NUtil.getString("phone_bar_btn_call"));
        this.lblCall.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (PhoneBarPanel.this.callEnabled) {
                    PhoneBarPanel.this.answerCurrentPhone();
                    CallLine line = PhoneAgent.getInstance().getCurrentCallLine();
                    if (line.getState() == CallState.IDLE) {
                        PhoneBarPanel.this.lblCall.setIcon(UIConstants.ICON_PBAR_DIAL_DOWN);
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                CallLine line;
                if (PhoneBarPanel.this.callEnabled && (line = PhoneAgent.getInstance().getCurrentCallLine()).getState() == CallState.IDLE) {
                    PhoneBarPanel.this.lblCall.setIcon(UIConstants.ICON_PBAR_DIAL_OVER);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CallLine line;
                if (PhoneBarPanel.this.callEnabled && (line = PhoneAgent.getInstance().getCurrentCallLine()).getState() == CallState.IDLE) {
                    PhoneBarPanel.this.lblCall.setIcon(UIConstants.ICON_PBAR_DIAL_ENABLED);
                }
            }
        });
        rightBtnGroup.add((Component)this.lblCall, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.lblHangup = new JLabel();
        this.lblHangup.setIcon(UIConstants.ICON_PBAR_HANGUP_DISABLED);
        this.lblHangup.setCursor(UIConstants.CURSOR_HAND);
        this.lblHangup.setToolTipText(I18NUtil.getString("phone_bar_btn_hangup"));
        this.lblHangup.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (PhoneBarPanel.this.hangupEnabled) {
                    PhoneBarPanel.this.hangupCurrentPhone();
                    CallLine line = PhoneAgent.getInstance().getCurrentCallLine();
                    if (line.getState() != CallState.IDLE) {
                        PhoneBarPanel.this.lblHangup.setIcon(UIConstants.ICON_PBAR_HANGUP_DOWN);
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                CallLine line;
                if (PhoneBarPanel.this.hangupEnabled && (line = PhoneAgent.getInstance().getCurrentCallLine()).getState() != CallState.IDLE) {
                    PhoneBarPanel.this.lblHangup.setIcon(UIConstants.ICON_PBAR_HANGUP_OVER);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CallLine line;
                if (PhoneBarPanel.this.hangupEnabled && (line = PhoneAgent.getInstance().getCurrentCallLine()).getState() != CallState.IDLE) {
                    PhoneBarPanel.this.lblHangup.setIcon(UIConstants.ICON_PBAR_HANGUP_ENABLED);
                }
            }
        });
        rightBtnGroup.add((Component)this.lblHangup, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.lblMute = new JLabel();
        this.lblMute.setIcon(UIConstants.ICON_PHONE_FUN_MUTE_DISABLED);
        this.lblMute.setCursor(UIConstants.CURSOR_HAND);
        this.lblMute.setToolTipText(I18NUtil.getString("phone_bar_btn_mute"));
        this.lblMute.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (PhoneBarPanel.this.muteEnabledState != 0) {
                    PhoneBarPanel.this.muteCurrentPhone();
                }
                if (PhoneBarPanel.this.muteEnabledState == 1) {
                    PhoneBarPanel.this.lblMute.setIcon(UIConstants.ICON_PHONE_FUN_MUTE_DOWN);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (PhoneBarPanel.this.muteEnabledState == 1) {
                    PhoneBarPanel.this.lblMute.setIcon(UIConstants.ICON_PHONE_FUN_MUTE_OVER);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (PhoneBarPanel.this.muteEnabledState == 1) {
                    PhoneBarPanel.this.lblMute.setIcon(UIConstants.ICON_PHONE_FUN_MUTE);
                }
            }
        });
        rightBtnGroup.add((Component)this.lblMute, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.lblRec = new JLabel();
        this.lblRec.setIcon(UIConstants.ICON_PHONE_FUN_REC_DISABLED);
        this.lblRec.setCursor(UIConstants.CURSOR_HAND);
        this.lblRec.setToolTipText(I18NUtil.getString("phone_bar_btn_rec"));
        this.lblRec.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (PhoneBarPanel.this.recEnabledState != 0) {
                    PhoneBarPanel.this.recCurrentPhone();
                }
                if (PhoneBarPanel.this.recEnabledState == 1) {
                    PhoneBarPanel.this.lblRec.setIcon(UIConstants.ICON_PHONE_FUN_REC_DOWN);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (PhoneBarPanel.this.recEnabledState == 1) {
                    PhoneBarPanel.this.lblRec.setIcon(UIConstants.ICON_PHONE_FUN_REC_OVER);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (PhoneBarPanel.this.recEnabledState == 1) {
                    PhoneBarPanel.this.lblRec.setIcon(UIConstants.ICON_PHONE_FUN_REC);
                }
            }
        });
        rightBtnGroup.add((Component)this.lblRec, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lblAI = new JLabel();
        this.lblAI.setIcon(UIConstants.ICON_PHONE_FUN_AI_DISABLED);
        this.lblAI.setCursor(UIConstants.CURSOR_HAND);
        if (PreferencesUtil.isAiAssistanceEnabled(UCChatClient.context)) {
            this.lblAI.setVisible(true);
        } else {
            this.lblAI.setVisible(false);
        }
        this.lblAI.setToolTipText(I18NUtil.getString("phone_bar_btn_ai_assistant"));
        this.lblAI.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (PhoneBarPanel.this.aiEnabledState != 0) {
                    PhoneBarPanel.this.aiCurrentPhone();
                }
                if (PhoneBarPanel.this.aiEnabledState == 1) {
                    PhoneBarPanel.this.lblAI.setIcon(UIConstants.ICON_PHONE_FUN_AI_DOWN);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (PhoneBarPanel.this.aiEnabledState == 1) {
                    PhoneBarPanel.this.lblAI.setIcon(UIConstants.ICON_PHONE_FUN_AI_OVER);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (PhoneBarPanel.this.aiEnabledState == 1) {
                    PhoneBarPanel.this.lblAI.setIcon(UIConstants.ICON_PHONE_FUN_AI);
                }
            }
        });
        rightBtnGroup.add((Component)this.lblAI, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lblHold = new JLabel();
        this.lblHold.setIcon(UIConstants.ICON_PHONE_FUN_HOLD_DISABLED);
        this.lblHold.setCursor(UIConstants.CURSOR_HAND);
        this.lblHold.setToolTipText(I18NUtil.getString("phone_bar_btn_hold"));
        this.lblHold.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (PhoneBarPanel.this.holdEnabledState != 0) {
                    PhoneBarPanel.this.holdCurrentPhone();
                }
                if (PhoneBarPanel.this.holdEnabledState == 1) {
                    PhoneBarPanel.this.lblHold.setIcon(UIConstants.ICON_PHONE_FUN_HOLD_DOWN);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (PhoneBarPanel.this.holdEnabledState == 1) {
                    PhoneBarPanel.this.lblHold.setIcon(UIConstants.ICON_PHONE_FUN_HOLD_OVER);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (PhoneBarPanel.this.holdEnabledState == 1) {
                    PhoneBarPanel.this.lblHold.setIcon(UIConstants.ICON_PHONE_FUN_HOLD);
                }
            }
        });
        rightBtnGroup.add((Component)this.lblHold, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lblTransfer = new JLabel();
        this.lblTransfer.setIcon(UIConstants.ICON_PHONE_FUN_TRANSFER_DISABLED);
        this.lblTransfer.setCursor(UIConstants.CURSOR_HAND);
        this.lblTransfer.setToolTipText(I18NUtil.getString("phone_bar_btn_transfer"));
        this.lblTransfer.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (PhoneBarPanel.this.transferEnabled) {
                    PhoneBarPanel.this.lblTransfer.setIcon(UIConstants.ICON_PHONE_FUN_TRANSFER_DOWN);
                    PhoneBarPanel.this.onClickTransfer();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (PhoneBarPanel.this.transferEnabled) {
                    PhoneBarPanel.this.lblTransfer.setIcon(UIConstants.ICON_PHONE_FUN_TRANSFER_OVER);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (PhoneBarPanel.this.transferEnabled) {
                    PhoneBarPanel.this.lblTransfer.setIcon(UIConstants.ICON_PHONE_FUN_TRANSFER);
                }
            }
        });
        rightBtnGroup.add((Component)this.lblTransfer, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lblConference = new JLabel();
        this.lblConference.setIcon(UIConstants.ICON_PHONE_FUN_CONFERENCE_DISABLED);
        this.lblConference.setCursor(UIConstants.CURSOR_HAND);
        this.lblConference.setToolTipText(I18NUtil.getString("phone_bar_btn_conf"));
        this.lblConference.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (PhoneBarPanel.this.conferenceEnabled) {
                    PhoneBarPanel.this.lblConference.setIcon(UIConstants.ICON_PHONE_FUN_CONFERENCE_DOWN);
                    PhoneBarPanel.this.onClickConference();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (PhoneBarPanel.this.conferenceEnabled) {
                    PhoneBarPanel.this.lblConference.setIcon(UIConstants.ICON_PHONE_FUN_CONFERENCE_OVER);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (PhoneBarPanel.this.conferenceEnabled) {
                    PhoneBarPanel.this.lblConference.setIcon(UIConstants.ICON_PHONE_FUN_CONFERENCE);
                }
            }
        });
        rightBtnGroup.add((Component)this.lblConference, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onPersonalInfoChanged() {
        if (PreferencesUtil.isAiAssistanceEnabled(UCChatClient.context)) {
            this.lblAI.setVisible(true);
        } else {
            this.lblAI.setVisible(false);
        }
    }

    @Override
    public String getMarqueeText() {
        ConcurrentHashMap<Long, QueueStatus> map = WebAgent.queueStatusMap;
        Set<Long> queueSelectedSet = PreferencesUtil.getAgentQueueSelectedSet();
        StringBuffer b = new StringBuffer();
        int index = 0;
        for (Long key : new HashSet(map.keySet())) {
            QueueStatus status = map.get(key);
            if (!queueSelectedSet.contains(status.getSkillId()) || status == null || status.getRequestSize() <= 0) continue;
            if (index != 0) {
                b.append("     ");
            }
            long duration = System.currentTimeMillis() - status.getRequestTime() - status.getTimeShift();
            b.append(status.getSkillName() + " (" + status.getRequestSize() + " " + CommonUtil.getDurationMilliSeconds(duration) + ")");
            ++index;
        }
        return b.toString();
    }

    public String getClipboardContents() {
        boolean hasTransferableText;
        String result = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(clipboard);
        boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (hasTransferableText) {
            try {
                result = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    private void showMenuListForAgent(MouseEvent e) {
        if (!PreferencesUtil.isAgent() || WebAgent.getAgentState() == AgentStatusType.OFFLINE) {
            return;
        }
        JPopupMenu popupAgentStateConfig = new JPopupMenu();
        JMenuItem readyItem = new JMenuItem();
        popupAgentStateConfig.add(readyItem);
        readyItem.setText(I18NUtil.getString("agent_state_dialog_option_ready"));
        readyItem.setIcon(UIConstants.ICON_AGENT_MENU_READY);
        readyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Set<Long> selectedSkillSize;
                if (PreferencesUtil.isAgentQueueEmpty()) {
                    JOptionPane.showMessageDialog(UCChatClient.getInstance(), I18NUtil.getString("agent_state_dialog_failed_skill_zero"), null, 0);
                    return;
                }
                if (ApiVersion.isApi27Later() && (selectedSkillSize = PreferencesUtil.getAgentQueueSelectedSet()).size() <= 0) {
                    JOptionPane.showMessageDialog(UCChatClient.getInstance(), I18NUtil.getString("agent_state_dialog_failed_skill_selected_zero"), null, 0);
                    return;
                }
                PhoneBarPanel.this.mProvider.stopAutoLoginTimer();
                WebAgent.getInstance().changeAgentState(AgentAction.READY, null);
            }
        });
        popupAgentStateConfig.add(new JSeparator());
        ArrayList<JMenuItem> auxMenuList = new ArrayList<JMenuItem>();
        String auxReasonInfo = PreferencesUtil.getAuxReasonInfo();
        if (StringUtils.isBlank((CharSequence)auxReasonInfo)) {
            JMenuItem auxItem = new JMenuItem();
            popupAgentStateConfig.add(auxItem);
            auxItem.setText(I18NUtil.getString("agent_state_dialog_option_aux"));
            auxItem.setIcon(UIConstants.ICON_AGENT_MENU_AUX);
            auxItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PhoneBarPanel.this.mProvider.stopAutoLoginTimer();
                    WebAgent.getInstance().changeAgentState(AgentAction.AUX, 0L);
                }
            });
            auxMenuList.add(auxItem);
        } else {
            try {
                JSONArray ary = new JSONArray(auxReasonInfo);
                if (ary.length() == 0) {
                    JMenuItem auxItem = new JMenuItem();
                    popupAgentStateConfig.add(auxItem);
                    auxItem.setText(I18NUtil.getString("agent_state_dialog_option_aux"));
                    auxItem.setIcon(UIConstants.ICON_AGENT_MENU_AUX);
                    auxItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            PhoneBarPanel.this.mProvider.stopAutoLoginTimer();
                            WebAgent.getInstance().changeAgentState(AgentAction.AUX, 0L);
                        }
                    });
                    auxMenuList.add(auxItem);
                } else {
                    for (int i = 0; i < ary.length(); ++i) {
                        JSONObject obj = ary.getJSONObject(i);
                        final Long reasonId = obj.getLong("id");
                        JMenuItem auxItem = new JMenuItem();
                        popupAgentStateConfig.add(auxItem);
                        String name = obj.getString("name");
                        if (name.contains(".")) {
                            auxItem.setText(I18NUtil.getString(name));
                        } else {
                            auxItem.setText(name);
                        }
                        if (reasonId == 0L) {
                            auxItem.setIcon(UIConstants.ICON_AGENT_MENU_AWAY);
                        } else if (reasonId == 1L) {
                            auxItem.setIcon(UIConstants.ICON_AGENT_MENU_EAT);
                        } else if (reasonId == 2L) {
                            auxItem.setIcon(UIConstants.ICON_AGENT_MENU_MEETING);
                        } else if (reasonId == 3L) {
                            auxItem.setIcon(UIConstants.ICON_AGENT_MENU_WC);
                        } else if (reasonId == 4L) {
                            auxItem.setIcon(UIConstants.ICON_AGENT_MENU_TRAIN);
                        } else if (reasonId == 5L) {
                            auxItem.setIcon(UIConstants.ICON_AGENT_MENU_REST);
                        } else {
                            auxItem.setIcon(UIConstants.ICON_AGENT_MENU_AUX);
                        }
                        auxItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent evt) {
                                PhoneBarPanel.this.mProvider.stopAutoLoginTimer();
                                WebAgent.getInstance().changeAgentState(AgentAction.AUX, reasonId);
                            }
                        });
                        auxMenuList.add(auxItem);
                    }
                }
            }
            catch (Throwable ary) {
                // empty catch block
            }
        }
        popupAgentStateConfig.add(new JSeparator());
        JMenuItem loginItem = new JMenuItem();
        popupAgentStateConfig.add(loginItem);
        loginItem.setText(I18NUtil.getString("agent_state_dialog_option_login"));
        loginItem.setIcon(EmptyIcon.SIZE_20);
        loginItem.addActionListener(new ActionListener(this){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (PreferencesUtil.isAgentQueueEmpty()) {
                    JOptionPane.showMessageDialog(UCChatClient.getInstance(), I18NUtil.getString("agent_state_dialog_failed_skill_zero_for_login"), null, 0);
                    return;
                }
                HashSet<MediaType> newLoginTypes = new HashSet<MediaType>();
                if (PreferencesUtil.isPhoneAgent()) {
                    newLoginTypes.add(MediaType.PHONE);
                }
                if (PreferencesUtil.isChatAgent()) {
                    newLoginTypes.add(MediaType.CHAT);
                }
                if (ApiVersion.isApi27Later()) {
                    Set<Long> selectedSkillSize = PreferencesUtil.getAgentQueueSelectedSet();
                    if (selectedSkillSize.size() <= 0) {
                        JOptionPane.showMessageDialog(UCChatClient.getInstance(), I18NUtil.getString("agent_state_dialog_failed_skill_selected_zero_for_login"), null, 0);
                        return;
                    }
                    WebAgent.getInstance().agentLogin(newLoginTypes, selectedSkillSize);
                } else {
                    WebAgent.getInstance().agentLogin(newLoginTypes);
                }
            }
        });
        JMenuItem logoutItem = new JMenuItem();
        popupAgentStateConfig.add(logoutItem);
        logoutItem.setText(I18NUtil.getString("agent_state_dialog_option_logout"));
        logoutItem.setIcon(EmptyIcon.SIZE_20);
        logoutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhoneBarPanel.this.mProvider.stopAutoLoginTimer();
                WebAgent.getInstance().agentLogout();
            }
        });
        popupAgentStateConfig.add(new JSeparator());
        JMenuItem autoReadyItem = new JMenuItem();
        popupAgentStateConfig.add(autoReadyItem);
        if (PreferencesUtil.getAutoReadyOption() == 1) {
            autoReadyItem.setText(I18NUtil.getString("agent_state_dialog_auto_ready_off_1"));
        } else if (PreferencesUtil.getAutoReadyOption() == 2) {
            autoReadyItem.setText(I18NUtil.getString("agent_state_dialog_auto_ready_off_2"));
        } else {
            autoReadyItem.setText(I18NUtil.getString("agent_state_dialog_auto_ready_on"));
        }
        autoReadyItem.setIcon(EmptyIcon.SIZE_20);
        autoReadyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (PreferencesUtil.getAutoReadyOption() != 0) {
                    PreferencesUtil.setAutoReadyOption(0);
                    PhoneBarPanel.this.mProvider.stopAutoLoginTimer();
                } else {
                    PhoneBarPanel.this.miAgentStateActionPerformed();
                }
            }
        });
        JMenuItem advancedItem = new JMenuItem();
        popupAgentStateConfig.add(advancedItem);
        advancedItem.setText(I18NUtil.getString("agent_state_dialog_label"));
        advancedItem.setIcon(UIConstants.ICON_AGENT_MENU_OFF);
        advancedItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhoneBarPanel.this.miAgentStateActionPerformed();
            }
        });
        AgentStatusType state = WebAgent.getAgentState();
        if (state == AgentStatusType.LOGOUT) {
            readyItem.setEnabled(false);
            for (JMenuItem auxItem : auxMenuList) {
                auxItem.setEnabled(false);
            }
            loginItem.setEnabled(true);
            logoutItem.setEnabled(false);
            autoReadyItem.setEnabled(false);
        } else if (state == AgentStatusType.LOGIN) {
            readyItem.setEnabled(true);
            for (JMenuItem auxItem : auxMenuList) {
                auxItem.setEnabled(false);
            }
            loginItem.setEnabled(false);
            logoutItem.setEnabled(true);
            autoReadyItem.setEnabled(true);
        } else if (state == AgentStatusType.READY) {
            readyItem.setEnabled(false);
            for (JMenuItem auxItem : auxMenuList) {
                auxItem.setEnabled(true);
            }
            loginItem.setEnabled(false);
            logoutItem.setEnabled(true);
            autoReadyItem.setEnabled(true);
        } else if (state == AgentStatusType.ACW) {
            readyItem.setEnabled(true);
            for (JMenuItem auxItem : auxMenuList) {
                auxItem.setEnabled(true);
            }
            loginItem.setEnabled(false);
            logoutItem.setEnabled(true);
            autoReadyItem.setEnabled(true);
        } else if (state == AgentStatusType.AUX) {
            readyItem.setEnabled(true);
            for (JMenuItem auxItem : auxMenuList) {
                auxItem.setEnabled(true);
            }
            loginItem.setEnabled(false);
            logoutItem.setEnabled(true);
            autoReadyItem.setEnabled(true);
        } else if (state == AgentStatusType.BUSY) {
            readyItem.setEnabled(false);
            for (JMenuItem auxItem : auxMenuList) {
                auxItem.setEnabled(false);
            }
            loginItem.setEnabled(false);
            logoutItem.setEnabled(true);
            autoReadyItem.setEnabled(true);
        } else if (state == AgentStatusType.RING) {
            readyItem.setEnabled(false);
            for (JMenuItem auxItem : auxMenuList) {
                auxItem.setEnabled(false);
            }
            loginItem.setEnabled(false);
            logoutItem.setEnabled(true);
            autoReadyItem.setEnabled(true);
        }
        popupAgentStateConfig.show(this.agentStatusGroup, e.getX(), this.agentStatusGroup.getHeight());
    }

    public void miAgentStateActionPerformed() {
        if (this.agentStateDialog != null) {
            this.agentStateDialog.dispose();
            this.agentStateDialog = null;
        }
        if (!PreferencesUtil.isAgent()) {
            return;
        }
        this.agentStateDialog = new AgentStateDialog(UCChatClient.getInstance());
        Dimension d = this.agentStateDialog.getSize();
        int x = UCChatClient.getInstance().getX() + (UCChatClient.getInstance().getWidth() - (int)d.getWidth()) / 2;
        int y = UCChatClient.getInstance().getY() + (UCChatClient.getInstance().getHeight() - (int)d.getHeight()) / 2;
        this.agentStateDialog.setLocation(x, y);
        this.agentStateDialog.setVisible(true);
        this.agentStateDialog = null;
    }

    public void onWebDisconnected() {
        if (this.agentStateDialog != null) {
            this.agentStateDialog.dispose();
            this.agentStateDialog = null;
        }
        if (this.transferDialog != null) {
            this.transferDialog.dispose();
            this.transferDialog = null;
        }
        if (this.conferenceDialog != null) {
            this.conferenceDialog.dispose();
            this.conferenceDialog = null;
        }
    }

    public void configAgentStatus() {
        long restTimeToReady;
        Object suffixInfo = "";
        if (ApiVersion.isApi27Later()) {
            Object queueInfo = this.getQueueInfo();
            if (((String)queueInfo).length() > 0) {
                queueInfo = "(" + (String)queueInfo + ")";
            }
            if (((String)queueInfo).length() > 0) {
                suffixInfo = (String)suffixInfo + (String)queueInfo;
            }
        }
        StringBuffer extraInfo = new StringBuffer();
        extraInfo.append("<html><div style='text-align: center;'>");
        AgentStatusType state = WebAgent.getAgentState();
        Object stateStr = I18NUtil.getString("agent_state_offline");
        if (state == AgentStatusType.READY) {
            stateStr = I18NUtil.getString("agent_state_ready") + (String)suffixInfo;
            this.agentStatus.setIcon(UIConstants.ICON_AGENT_STATE_READY);
        } else if (state == AgentStatusType.ACW) {
            stateStr = I18NUtil.getString("agent_state_acw") + (String)suffixInfo;
            this.agentStatus.setIcon(UIConstants.ICON_AGENT_STATE_ACW);
        } else if (state == AgentStatusType.LOGIN) {
            stateStr = I18NUtil.getString("agent_state_login") + (String)suffixInfo;
            this.agentStatus.setIcon(UIConstants.ICON_AGENT_STATE_LOGIN);
        } else if (state == AgentStatusType.AUX) {
            stateStr = I18NUtil.getString("agent_state_aux");
            if (WebAgent.auxReasonId != null) {
                String auxReasonInfo = PreferencesUtil.getAuxReasonInfo();
                if (StringUtils.isNotBlank((CharSequence)auxReasonInfo)) {
                    try {
                        JSONArray ary = new JSONArray(auxReasonInfo);
                        for (int i = 0; i < ary.length(); ++i) {
                            JSONObject obj = ary.getJSONObject(i);
                            if (obj.getLong("id") != WebAgent.auxReasonId.longValue()) continue;
                            stateStr = obj.getString("name");
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                stateStr = (String)stateStr + (String)suffixInfo;
                if (WebAgent.auxReasonId == 0L) {
                    this.agentStatus.setIcon(UIConstants.ICON_AGENT_STATE_AWAY);
                } else if (WebAgent.auxReasonId == 1L) {
                    this.agentStatus.setIcon(UIConstants.ICON_AGENT_STATE_EAT);
                } else if (WebAgent.auxReasonId == 2L) {
                    this.agentStatus.setIcon(UIConstants.ICON_AGENT_STATE_MEETING);
                } else if (WebAgent.auxReasonId == 3L) {
                    this.agentStatus.setIcon(UIConstants.ICON_AGENT_STATE_WC);
                } else if (WebAgent.auxReasonId == 4L) {
                    this.agentStatus.setIcon(UIConstants.ICON_AGENT_STATE_TRAIN);
                } else if (WebAgent.auxReasonId == 5L) {
                    this.agentStatus.setIcon(UIConstants.ICON_AGENT_STATE_REST);
                } else {
                    this.agentStatus.setIcon(UIConstants.ICON_AGENT_STATE_AUX);
                }
            } else {
                stateStr = (String)stateStr + (String)suffixInfo;
                this.agentStatus.setIcon(UIConstants.ICON_AGENT_STATE_AUX);
            }
        } else if (state == AgentStatusType.BUSY) {
            stateStr = I18NUtil.getString("agent_state_busy") + (String)suffixInfo;
            this.agentStatus.setIcon(UIConstants.ICON_AGENT_STATE_BUSY);
        } else if (state == AgentStatusType.RING) {
            stateStr = I18NUtil.getString("agent_state_ring") + (String)suffixInfo;
            this.agentStatus.setIcon(UIConstants.ICON_AGENT_STATE_RING);
        } else if (state == AgentStatusType.LOGOUT) {
            stateStr = I18NUtil.getString("agent_state_logout");
            this.agentStatus.setIcon(UIConstants.ICON_AGENT_STATE_LOGOUT);
        } else if (state == AgentStatusType.OFFLINE) {
            stateStr = I18NUtil.getString("agent_state_offline");
            this.agentStatus.setIcon(UIConstants.ICON_AGENT_STATE_LOGOUT);
        }
        if (state == AgentStatusType.READY || state == AgentStatusType.ACW || state == AgentStatusType.LOGIN || state == AgentStatusType.AUX) {
            extraInfo.append((String)stateStr);
            extraInfo.append(" ");
            extraInfo.append(WebAgent.getAgentStateDuration());
        } else {
            extraInfo.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            extraInfo.append((String)stateStr);
            extraInfo.append("&nbsp;&nbsp;&nbsp;&nbsp;");
        }
        if (state == AgentStatusType.ACW && PreferencesUtil.getAutoReadyOption() == 1 && (restTimeToReady = (this.mProvider.getAutoLoginTime() - System.currentTimeMillis()) / 1000L) > 0L) {
            extraInfo.append("<br>");
            extraInfo.append("(");
            extraInfo.append(String.format(I18NUtil.getString("agent_state_dialog_auto_ready_timer"), String.valueOf(restTimeToReady)));
            extraInfo.append(")");
        }
        extraInfo.append("</div></html>");
        this.agentStatus.setText(extraInfo.toString());
    }

    private String getQueueInfo() {
        StringBuffer buffer = new StringBuffer();
        int totalSize = 0;
        try {
            String queueInfoStr = PreferencesUtil.getAgentQueueInfo();
            if (StringUtils.isNotBlank((CharSequence)queueInfoStr)) {
                JSONArray ary = new JSONArray(queueInfoStr);
                totalSize = ary.length();
            }
        }
        catch (Throwable t) {
            Log.e(MainPanel.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
        }
        int selectedSize = PreferencesUtil.getAgentQueueSelectedSet().size();
        if (totalSize != selectedSize) {
            buffer.append(selectedSize + "/" + totalSize);
        }
        return buffer.toString();
    }

    public void enableMarquee() {
        this.marqueePanel.setVisible(true);
        if (this.marqueePanel.getState() == MarqueeState.STOP) {
            this.marqueePanel.startScrolling();
        }
    }

    public void disableMarquee() {
        this.marqueePanel.setVisible(false);
        this.marqueePanel.stopScrolling();
    }

    public void enableAgent() {
        this.agentStatusGroup.setVisible(true);
        this.agentStatus.setVisible(true);
    }

    public void disableAgent() {
        this.agentStatusGroup.setVisible(false);
        this.agentStatus.setVisible(false);
    }

    public void onKeyEnter(String key) {
        CallLine callLine = PhoneAgent.getInstance().getCurrentCallLine();
        if (callLine.getState() == CallState.IDLE) {
            this.callNumberField.setText(this.callNumberField.getText() + key);
        } else if (callLine.getState() == CallState.INCALL && this.mProvider.isKeyBoardVisible()) {
            this.callNumberField.setText(this.callNumberField.getText() + key);
        }
    }

    public Point getKeyBoradBtnLoc() {
        return this.lblKeyboard.getLocationOnScreen();
    }

    public void onPhoneRegisterSuccess() {
        Log.d(PhoneBarPanel.class.getSimpleName(), "phone_registerSuccess");
        if (!this.mSipRegistered) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PhoneBarPanel.this.applyPhoneState();
                }
            });
        }
        this.mSipRegistered = true;
    }

    public void onPhoneRegisterFail(String result) {
        Log.d(PhoneBarPanel.class.getSimpleName(), "phone_registerFail result:" + result);
        this.mSipRegistered = false;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PhoneBarPanel.this.applyPhoneState();
            }
        });
    }

    public void onPhoneUnregisterDone(String result) {
        Log.d(PhoneBarPanel.class.getSimpleName(), "phone_unregisterDone result:" + result);
        this.mSipRegistered = false;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PhoneBarPanel.this.applyPhoneState();
            }
        });
    }

    public void onPhoneStateChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PhoneBarPanel.this.applyPhoneState();
            }
        });
    }

    private void switchLineTo(int line) {
        PhoneAgent.getInstance().switchCurrentLine(line);
        this.applyPhoneState();
    }

    private void answerCurrentPhone() {
        CallLine callLine = PhoneAgent.getInstance().getCurrentCallLine();
        if (callLine.getState() == CallState.INCOMING_CALL) {
            PhoneAgent.getInstance().answerLine(callLine.getLineId());
        } else if (callLine.getState() == CallState.IDLE) {
            this.dialOut();
        }
    }

    private void dialOut() {
        CallLine callLine = PhoneAgent.getInstance().getCurrentCallLine();
        if (callLine.getState() == CallState.IDLE) {
            if (TextUtils.isBlank((CharSequence)this.callNumberField.getText())) {
                this.callNumberField.requestFocus();
            } else {
                String input = this.callNumberField.getText();
                if (TextUtils.isNotBlank((CharSequence)input)) {
                    DialoutManager.directDialNumberForPad(UCChatClient.context, input.trim(), null);
                    this.mProvider.onKeyBoardClosed();
                }
            }
        }
    }

    private void hangupCurrentPhone() {
        CallLine callLine = PhoneAgent.getInstance().getCurrentCallLine();
        if (callLine.getState() == CallState.IDLE) {
            Log.w(PhoneBarPanel.class.getSimpleName(), "line " + callLine.getLineId() + " not in incoming state, cannot answer it.");
            return;
        }
        if (callLine.getState() == CallState.INCOMING_CALL) {
            PhoneAgent.getInstance().rejectLine(callLine.getLineId());
        } else {
            PhoneAgent.getInstance().hangupLine(callLine.getLineId());
        }
    }

    private void holdCurrentPhone() {
        CallLine callLine = PhoneAgent.getInstance().getCurrentCallLine();
        PhoneAgent.getInstance().toggleHold(callLine.getLineId());
    }

    private void muteCurrentPhone() {
        CallLine callLine = PhoneAgent.getInstance().getCurrentCallLine();
        PhoneAgent.getInstance().toggleMute(callLine.getLineId());
    }

    private void recCurrentPhone() {
        if (!PreferencesUtil.hasRecordingLicense(UCChatClient.context)) {
            ToastUtil.show(UCChatClient.context, I18NUtil.getString("permission_no_rec_license"), 10);
            return;
        }
        CallLine callLine = PhoneAgent.getInstance().getCurrentCallLine();
        if (callLine.getState() == CallState.HOLD && !callLine.isRecordingFlag()) {
            ToastUtil.show(UCChatClient.context, I18NUtil.getString("call_record_not_allow_while_hold"), 20);
            return;
        }
        PhoneAgent.getInstance().toggleRecording(callLine.getLineId());
    }

    private void aiCurrentPhone() {
        if (!PreferencesUtil.isAiAssistanceEnabled(UCChatClient.context)) {
            ToastUtil.show(UCChatClient.context, I18NUtil.getString("permission_no_ai_license"), 10);
            return;
        }
        String savedAgent = PreferencesUtil.getAiAgentSelected(UCChatClient.context);
        if (StringUtils.isBlank((CharSequence)savedAgent)) {
            this.miAgentStateActionPerformed();
            String savedAgent2 = PreferencesUtil.getAiAgentSelected(UCChatClient.context);
            if (StringUtils.isNotBlank((CharSequence)savedAgent2)) {
                WebAgent.getInstance().toggleAiAssistance();
            }
            return;
        }
        WebAgent.getInstance().toggleAiAssistance();
    }

    private void onClickTransfer() {
        List<CallLine> lineList;
        int currentLine = PhoneAgent.getInstance().getCurrentLineIndex();
        if (PreferencesUtil.isNoPopupTransferEnabled() && (lineList = PhoneAgent.getInstance().getOtherLineAbleToTransfer(currentLine)) != null && lineList.size() == 1) {
            CallLine callLine1 = PhoneAgent.getInstance().getCallLine(currentLine);
            CallLine callLine2 = lineList.get(0);
            WebAgent.getInstance().makeTwoStepTransfer(callLine1.getSipCallId(), callLine2.getSipCallId());
            return;
        }
        if (this.transferDialog != null) {
            this.transferDialog.dispose();
            this.transferDialog = null;
        }
        this.transferDialog = new TransferDialog((JFrame)UCChatClient.getInstance(), currentLine);
        Dimension d = this.transferDialog.getSize();
        int x = UCChatClient.getInstance().getX() + (UCChatClient.getInstance().getWidth() - (int)d.getWidth()) / 2;
        int y = UCChatClient.getInstance().getY() + (UCChatClient.getInstance().getHeight() - (int)d.getHeight()) / 2;
        this.transferDialog.setLocation(x, y);
        this.transferDialog.setVisible(true);
        this.transferDialog = null;
    }

    public void onMicLevel(int level) {
        SwingUtilities.invokeLater(() -> {
            int target = level;
            int current = this.micLevelBar.getValue();
            if (Math.abs(target - current) > 10) {
                this.micLevelBar.setValue(target);
            } else {
                this.micLevelBar.setValue((current + target) / 2);
            }
        });
    }

    private void onClickConference() {
        int currentLineIndex = PhoneAgent.getInstance().getCurrentLineIndex();
        List<CallLine> lineList = PhoneAgent.getInstance().getOtherLineAbleToNewConf(currentLineIndex);
        List<CallLine> meetmeLineList = PhoneAgent.getInstance().getOtherConferenceLine(currentLineIndex);
        if (meetmeLineList.size() == 0 && lineList.size() == 1) {
            CallLine otherLine;
            HashSet<String> participantJidSet = new HashSet<String>();
            participantJidSet.add(PreferencesUtil.getUserJid(UCChatClient.context));
            CallLine currentLine = PhoneAgent.getInstance().getCallLine(currentLineIndex);
            String sipCallId1 = null;
            String sipCallId2 = null;
            String sipCallId3 = null;
            if (currentLineIndex == 0) {
                sipCallId1 = currentLine.getSipCallId();
            } else if (currentLineIndex == 1) {
                sipCallId2 = currentLine.getSipCallId();
            } else if (currentLineIndex == 2) {
                sipCallId3 = currentLine.getSipCallId();
            }
            PhoneLineInfo lineInfo = currentLine.getLineInfo();
            if (TextUtils.isNotBlank((CharSequence)lineInfo.getJid())) {
                participantJidSet.add(lineInfo.getJid());
            }
            if ((otherLine = lineList.get(0)).getLineId() == 0) {
                sipCallId1 = otherLine.getSipCallId();
            } else if (otherLine.getLineId() == 1) {
                sipCallId2 = otherLine.getSipCallId();
            } else if (otherLine.getLineId() == 2) {
                sipCallId3 = otherLine.getSipCallId();
            }
            PhoneLineInfo otherLineInfo = otherLine.getLineInfo();
            if (TextUtils.isNotBlank((CharSequence)otherLineInfo.getJid())) {
                participantJidSet.add(otherLineInfo.getJid());
            }
            String roomId = UCDBChatRoom.findThreeWayCallingChatRoom(UCChatClient.context, participantJidSet);
            WebAgent.getInstance().makeThreeWayCalling(roomId, participantJidSet, sipCallId1, sipCallId2, sipCallId3);
            return;
        }
        if (meetmeLineList.size() == 1 && lineList.size() == 0) {
            CallLine currentLine = PhoneAgent.getInstance().getCallLine(currentLineIndex);
            CallLine meetmeLine = meetmeLineList.get(0);
            WebAgent.getInstance().makeInviteConference(meetmeLine.getLineInfo().getJid(), currentLine.getSipCallId());
            return;
        }
        if (this.conferenceDialog != null) {
            this.conferenceDialog.dispose();
            this.conferenceDialog = null;
        }
        this.conferenceDialog = new ConferenceDialog((JFrame)UCChatClient.getInstance(), currentLineIndex);
        Dimension d = this.conferenceDialog.getSize();
        int x = UCChatClient.getInstance().getX() + (UCChatClient.getInstance().getWidth() - (int)d.getWidth()) / 2;
        int y = UCChatClient.getInstance().getY() + (UCChatClient.getInstance().getHeight() - (int)d.getHeight()) / 2;
        this.conferenceDialog.setLocation(x, y);
        this.conferenceDialog.setVisible(true);
        this.conferenceDialog = null;
    }

    private void applyPhoneState() {
        if (!this.mSipRegistered) {
            this.lblKeyboard.setIcon(UIConstants.ICON_PBAR_KEYBOARD_DISABLED);
            this.line1Label.setIcon(UIConstants.ICON_PHONE_LINE_1_OFF_UNSELECTED);
            this.line2Label.setIcon(UIConstants.ICON_PHONE_LINE_2_OFF_UNSELECTED);
            this.line3Label.setIcon(UIConstants.ICON_PHONE_LINE_3_OFF_UNSELECTED);
            this.lblCall.setIcon(UIConstants.ICON_PBAR_DIAL_DISABLED);
            this.lblHangup.setIcon(UIConstants.ICON_PBAR_HANGUP_DISABLED);
            this.callInfoLabel.setIcon(UIConstants.ICON_PBAR_STATUS_LEISURE);
            this.callInfoLabel.setText("");
            this.callTimeLabel.setText("");
            this.lineEnabled = false;
            this.keyboardEnabled = false;
            this.callEnabled = false;
            this.hangupEnabled = false;
            this.muteEnabledState = 0;
            this.recEnabledState = 0;
            this.holdEnabledState = 0;
            this.transferEnabled = false;
            this.conferenceEnabled = false;
            this.callNumberField.setText("");
            this.callNumberField.setEditable(false);
            this.callNumberField.setCaretColor(this.getBackground());
            this.callNumberField.setHorizontalAlignment(4);
        } else {
            if (PhoneAgent.getInstance().isCallIdle()) {
                this.callTimeHandler.removeCallbacks(this.callTimeTimer);
                this.timerOn = false;
            } else if (!this.timerOn) {
                this.timerOn = true;
                this.callTimeHandler.postDelayed(this.callTimeTimer, 0L);
            }
            this.lineEnabled = true;
            this.keyboardEnabled = true;
            this.lblKeyboard.setIcon(UIConstants.ICON_PBAR_KEYBOARD_ENABLED);
            int current = PhoneAgent.getInstance().getCurrentLineIndex();
            for (CallLine callLine : PhoneAgent.getInstance().getCallLineAry()) {
                if (callLine.getLineId() == current) {
                    String info = "";
                    if (callLine.getState() == CallState.INCOMING_CALL) {
                        this.lblCall.setIcon(UIConstants.ICON_PBAR_RINGING);
                        this.lblCall.setToolTipText(I18NUtil.getString("phone_bar_btn_answer"));
                        this.callEnabled = true;
                        this.lblHangup.setIcon(UIConstants.ICON_PBAR_HANGUP_ENABLED);
                        this.lblHangup.setToolTipText(I18NUtil.getString("phone_bar_btn_hangup"));
                        this.hangupEnabled = true;
                        if (callLine.getLineId() == 0) {
                            this.line1Label.setIcon(UIConstants.ICON_PHONE_LINE_1_RING_SELECTED);
                        } else if (callLine.getLineId() == 1) {
                            this.line2Label.setIcon(UIConstants.ICON_PHONE_LINE_2_RING_SELECTED);
                        } else if (callLine.getLineId() == 2) {
                            this.line3Label.setIcon(UIConstants.ICON_PHONE_LINE_3_RING_SELECTED);
                        }
                        this.lblHold.setIcon(UIConstants.ICON_PHONE_FUN_HOLD_DISABLED);
                        this.lblHold.setToolTipText(null);
                        this.holdEnabledState = 0;
                        this.lblMute.setIcon(UIConstants.ICON_PHONE_FUN_MUTE_DISABLED);
                        this.lblMute.setToolTipText(null);
                        this.muteEnabledState = 0;
                        this.lblRec.setIcon(UIConstants.ICON_PHONE_FUN_REC_DISABLED);
                        this.lblRec.setToolTipText(null);
                        this.recEnabledState = 0;
                        this.lblAI.setIcon(UIConstants.ICON_PHONE_FUN_AI_DISABLED);
                        this.lblAI.setToolTipText(null);
                        this.aiEnabledState = 0;
                        this.lblTransfer.setIcon(UIConstants.ICON_PHONE_FUN_TRANSFER_DISABLED);
                        this.lblTransfer.setToolTipText(null);
                        this.transferEnabled = false;
                        this.lblConference.setIcon(UIConstants.ICON_PHONE_FUN_CONFERENCE_DISABLED);
                        this.lblConference.setToolTipText(null);
                        this.conferenceEnabled = false;
                        info = I18NUtil.getString("phone_notification_ringing");
                        this.callNumberField.setText(callLine.getLineInfo().getMainDispName());
                        this.callNumberField.setEditable(false);
                        this.callNumberField.setCaretColor(this.getBackground());
                        this.callNumberField.setHorizontalAlignment(0);
                    } else if (callLine.getState() == CallState.INCALL) {
                        this.lblCall.setIcon(UIConstants.ICON_PBAR_TALKING);
                        this.lblCall.setToolTipText(null);
                        this.callEnabled = true;
                        this.lblHangup.setIcon(UIConstants.ICON_PBAR_HANGUP_ENABLED);
                        this.lblHangup.setToolTipText(I18NUtil.getString("phone_bar_btn_hangup"));
                        this.hangupEnabled = true;
                        if (callLine.getLineId() == 0) {
                            this.line1Label.setIcon(UIConstants.ICON_PHONE_LINE_1_TALKING_SELECTED);
                        } else if (callLine.getLineId() == 1) {
                            this.line2Label.setIcon(UIConstants.ICON_PHONE_LINE_2_TALKING_SELECTED);
                        } else if (callLine.getLineId() == 2) {
                            this.line3Label.setIcon(UIConstants.ICON_PHONE_LINE_3_TALKING_SELECTED);
                        }
                        this.lblHold.setIcon(UIConstants.ICON_PHONE_FUN_HOLD);
                        this.lblHold.setToolTipText(I18NUtil.getString("phone_bar_btn_hold"));
                        this.holdEnabledState = 1;
                        if (callLine.isMute()) {
                            this.lblMute.setIcon(UIConstants.ICON_PHONE_FUN_MUTE_DOWN);
                            this.lblMute.setToolTipText(I18NUtil.getString("phone_bar_btn_unmute"));
                            this.muteEnabledState = 2;
                        } else {
                            this.lblMute.setIcon(UIConstants.ICON_PHONE_FUN_MUTE);
                            this.lblMute.setToolTipText(I18NUtil.getString("phone_bar_btn_mute"));
                            this.muteEnabledState = 1;
                        }
                        if (callLine.isRecordingFlag()) {
                            this.lblRec.setIcon(UIConstants.ICON_PHONE_FUN_REC_DOWN);
                            this.lblRec.setToolTipText(I18NUtil.getString("phone_bar_btn_unrec"));
                            this.recEnabledState = 2;
                        } else {
                            this.lblRec.setIcon(UIConstants.ICON_PHONE_FUN_REC);
                            this.lblRec.setToolTipText(I18NUtil.getString("phone_bar_btn_rec"));
                            this.recEnabledState = 1;
                        }
                        if (callLine.isAIAssistanceFlag()) {
                            this.lblAI.setIcon(UIConstants.ICON_PHONE_FUN_AI_DOWN);
                            this.lblAI.setToolTipText(I18NUtil.getString("phone_bar_btn_un_ai_assistant"));
                            this.aiEnabledState = 2;
                        } else {
                            this.lblAI.setIcon(UIConstants.ICON_PHONE_FUN_AI);
                            this.lblAI.setToolTipText(I18NUtil.getString("phone_bar_btn_ai_assistant"));
                            this.aiEnabledState = 1;
                        }
                        boolean transferAvailable = PhoneAgent.getInstance().checkTransferFuncAvailable(callLine.getLineId());
                        conferenceAvailable = PhoneAgent.getInstance().checkConferenceferFuncAvailable(callLine.getLineId());
                        if (transferAvailable) {
                            this.lblTransfer.setIcon(UIConstants.ICON_PHONE_FUN_TRANSFER);
                            this.lblTransfer.setToolTipText(I18NUtil.getString("phone_bar_btn_transfer"));
                            this.transferEnabled = true;
                        } else {
                            this.lblTransfer.setIcon(UIConstants.ICON_PHONE_FUN_TRANSFER_DISABLED);
                            this.lblTransfer.setToolTipText(null);
                            this.transferEnabled = false;
                        }
                        if (conferenceAvailable) {
                            this.lblConference.setIcon(UIConstants.ICON_PHONE_FUN_CONFERENCE);
                            this.lblConference.setToolTipText(I18NUtil.getString("phone_bar_btn_conf"));
                            this.conferenceEnabled = true;
                        } else {
                            this.lblConference.setIcon(UIConstants.ICON_PHONE_FUN_CONFERENCE_DISABLED);
                            this.lblConference.setToolTipText(null);
                            this.conferenceEnabled = false;
                        }
                        info = I18NUtil.getString("phone_notification_talking");
                        if (this.mProvider.isKeyBoardVisible()) {
                            this.callNumberField.setText("");
                            this.callNumberField.setEditable(true);
                            this.callNumberField.setCaretColor(Color.LIGHT_GRAY);
                            this.callNumberField.setHorizontalAlignment(4);
                        } else {
                            this.callNumberField.setText(callLine.getLineInfo().getMainDispName());
                            this.callNumberField.setEditable(false);
                            this.callNumberField.setCaretColor(this.getBackground());
                            this.callNumberField.setHorizontalAlignment(0);
                        }
                    } else if (callLine.getState() == CallState.HOLD) {
                        this.lblCall.setIcon(UIConstants.ICON_PBAR_TALKING);
                        this.lblCall.setToolTipText(null);
                        this.callEnabled = true;
                        this.lblHangup.setIcon(UIConstants.ICON_PBAR_HANGUP_ENABLED);
                        this.lblHangup.setToolTipText(I18NUtil.getString("phone_bar_btn_hangup"));
                        this.hangupEnabled = true;
                        if (callLine.getLineId() == 0) {
                            this.line1Label.setIcon(UIConstants.ICON_PHONE_LINE_1_HOLD_SELECTED);
                        } else if (callLine.getLineId() == 1) {
                            this.line2Label.setIcon(UIConstants.ICON_PHONE_LINE_2_HOLD_SELECTED);
                        } else if (callLine.getLineId() == 2) {
                            this.line3Label.setIcon(UIConstants.ICON_PHONE_LINE_3_HOLD_SELECTED);
                        }
                        this.lblHold.setIcon(UIConstants.ICON_PHONE_FUN_HOLD_DOWN);
                        this.lblHold.setToolTipText(I18NUtil.getString("phone_bar_btn_unhold"));
                        this.holdEnabledState = 2;
                        if (callLine.isMute()) {
                            this.lblMute.setIcon(UIConstants.ICON_PHONE_FUN_MUTE_DOWN);
                            this.lblMute.setToolTipText(I18NUtil.getString("phone_bar_btn_unmute"));
                            this.muteEnabledState = 2;
                        } else {
                            this.lblMute.setIcon(UIConstants.ICON_PHONE_FUN_MUTE);
                            this.lblMute.setToolTipText(I18NUtil.getString("phone_bar_btn_mute"));
                            this.muteEnabledState = 1;
                        }
                        if (callLine.isRecordingFlag()) {
                            this.lblRec.setIcon(UIConstants.ICON_PHONE_FUN_REC_DOWN);
                            this.lblRec.setToolTipText(I18NUtil.getString("phone_bar_btn_unrec"));
                            this.recEnabledState = 2;
                        } else {
                            this.lblRec.setIcon(UIConstants.ICON_PHONE_FUN_REC_DISABLED);
                            this.lblRec.setToolTipText(null);
                            this.recEnabledState = 0;
                        }
                        if (callLine.isAIAssistanceFlag()) {
                            this.lblAI.setIcon(UIConstants.ICON_PHONE_FUN_AI_DOWN);
                            this.lblAI.setToolTipText(I18NUtil.getString("phone_bar_btn_un_ai_assistant"));
                            this.aiEnabledState = 2;
                        } else {
                            this.lblAI.setIcon(UIConstants.ICON_PHONE_FUN_AI_DISABLED);
                            this.lblAI.setToolTipText(null);
                            this.aiEnabledState = 0;
                        }
                        boolean transferAvailable = PhoneAgent.getInstance().checkTransferFuncAvailable(callLine.getLineId());
                        conferenceAvailable = PhoneAgent.getInstance().checkConferenceferFuncAvailable(callLine.getLineId());
                        if (transferAvailable) {
                            this.lblTransfer.setIcon(UIConstants.ICON_PHONE_FUN_TRANSFER);
                            this.lblTransfer.setToolTipText(I18NUtil.getString("phone_bar_btn_transfer"));
                            this.transferEnabled = true;
                        } else {
                            this.lblTransfer.setIcon(UIConstants.ICON_PHONE_FUN_TRANSFER_DISABLED);
                            this.lblTransfer.setToolTipText(null);
                            this.transferEnabled = false;
                        }
                        if (conferenceAvailable) {
                            this.lblConference.setIcon(UIConstants.ICON_PHONE_FUN_CONFERENCE);
                            this.lblConference.setToolTipText(I18NUtil.getString("phone_bar_btn_conf"));
                            this.conferenceEnabled = true;
                        } else {
                            this.lblConference.setIcon(UIConstants.ICON_PHONE_FUN_CONFERENCE_DISABLED);
                            this.lblConference.setToolTipText(null);
                            this.conferenceEnabled = false;
                        }
                        info = I18NUtil.getString("phone_notification_hold");
                        this.callNumberField.setText(callLine.getLineInfo().getMainDispName());
                        this.callNumberField.setEditable(false);
                        this.callNumberField.setCaretColor(this.getBackground());
                        this.callNumberField.setHorizontalAlignment(0);
                    } else if (callLine.getState() == CallState.OUTGOING_CALL) {
                        this.lblCall.setIcon(UIConstants.ICON_PBAR_DIALING);
                        this.lblCall.setToolTipText(I18NUtil.getString("phone_bar_btn_call"));
                        this.callEnabled = true;
                        this.lblHangup.setIcon(UIConstants.ICON_PBAR_HANGUP_ENABLED);
                        this.lblHangup.setToolTipText(I18NUtil.getString("phone_bar_btn_hangup"));
                        this.hangupEnabled = true;
                        if (callLine.getLineId() == 0) {
                            this.line1Label.setIcon(UIConstants.ICON_PHONE_LINE_1_TALKING_SELECTED);
                        } else if (callLine.getLineId() == 1) {
                            this.line2Label.setIcon(UIConstants.ICON_PHONE_LINE_2_TALKING_SELECTED);
                        } else if (callLine.getLineId() == 2) {
                            this.line3Label.setIcon(UIConstants.ICON_PHONE_LINE_3_TALKING_SELECTED);
                        }
                        this.lblHold.setIcon(UIConstants.ICON_PHONE_FUN_HOLD_DISABLED);
                        this.lblHold.setToolTipText(null);
                        this.holdEnabledState = 0;
                        if (callLine.isMute()) {
                            this.lblMute.setIcon(UIConstants.ICON_PHONE_FUN_MUTE_DOWN);
                            this.lblMute.setToolTipText(I18NUtil.getString("phone_bar_btn_unmute"));
                            this.muteEnabledState = 2;
                        } else {
                            this.lblMute.setIcon(UIConstants.ICON_PHONE_FUN_MUTE);
                            this.lblMute.setToolTipText(I18NUtil.getString("phone_bar_btn_mute"));
                            this.muteEnabledState = 1;
                        }
                        if (callLine.isRecordingFlag()) {
                            this.lblRec.setIcon(UIConstants.ICON_PHONE_FUN_REC_DOWN);
                            this.lblRec.setToolTipText(I18NUtil.getString("phone_bar_btn_unrec"));
                            this.recEnabledState = 2;
                        } else {
                            this.lblRec.setIcon(UIConstants.ICON_PHONE_FUN_REC);
                            this.lblRec.setToolTipText(I18NUtil.getString("phone_bar_btn_rec"));
                            this.recEnabledState = 1;
                        }
                        if (callLine.isRecordingFlag()) {
                            this.lblAI.setIcon(UIConstants.ICON_PHONE_FUN_AI_DOWN);
                            this.lblAI.setToolTipText(I18NUtil.getString("phone_bar_btn_un_ai_assistant"));
                            this.aiEnabledState = 2;
                        } else {
                            this.lblAI.setIcon(UIConstants.ICON_PHONE_FUN_AI);
                            this.lblAI.setToolTipText(I18NUtil.getString("phone_bar_btn_ai_assistant"));
                            this.aiEnabledState = 1;
                        }
                        this.lblTransfer.setIcon(UIConstants.ICON_PHONE_FUN_TRANSFER_DISABLED);
                        this.lblTransfer.setToolTipText(null);
                        this.transferEnabled = false;
                        this.lblConference.setIcon(UIConstants.ICON_PHONE_FUN_CONFERENCE_DISABLED);
                        this.lblConference.setToolTipText(null);
                        this.conferenceEnabled = false;
                        info = I18NUtil.getString("phone_notification_dialing");
                        this.callNumberField.setText(callLine.getLineInfo().getMainDispName());
                        this.callNumberField.setEditable(false);
                        this.callNumberField.setCaretColor(this.getBackground());
                        this.callNumberField.setHorizontalAlignment(0);
                    } else {
                        this.lblCall.setIcon(UIConstants.ICON_PBAR_DIAL_ENABLED);
                        this.lblCall.setToolTipText(I18NUtil.getString("phone_bar_btn_call"));
                        this.callEnabled = true;
                        this.lblHangup.setIcon(UIConstants.ICON_PBAR_HANGUP_DISABLED);
                        this.lblHangup.setToolTipText(null);
                        this.hangupEnabled = false;
                        if (callLine.getLineId() == 0) {
                            this.line1Label.setIcon(UIConstants.ICON_PHONE_LINE_1_OFF_SELECTED);
                        } else if (callLine.getLineId() == 1) {
                            this.line2Label.setIcon(UIConstants.ICON_PHONE_LINE_2_OFF_SELECTED);
                        } else if (callLine.getLineId() == 2) {
                            this.line3Label.setIcon(UIConstants.ICON_PHONE_LINE_3_OFF_SELECTED);
                        }
                        this.lblHold.setIcon(UIConstants.ICON_PHONE_FUN_HOLD_DISABLED);
                        this.lblHold.setToolTipText(null);
                        this.holdEnabledState = 0;
                        this.lblMute.setIcon(UIConstants.ICON_PHONE_FUN_MUTE_DISABLED);
                        this.lblMute.setToolTipText(null);
                        this.muteEnabledState = 0;
                        this.lblRec.setIcon(UIConstants.ICON_PHONE_FUN_REC_DISABLED);
                        this.lblRec.setToolTipText(null);
                        this.recEnabledState = 0;
                        this.lblAI.setIcon(UIConstants.ICON_PHONE_FUN_AI_DISABLED);
                        this.lblAI.setToolTipText(null);
                        this.aiEnabledState = 0;
                        this.lblTransfer.setIcon(UIConstants.ICON_PHONE_FUN_TRANSFER_DISABLED);
                        this.lblTransfer.setToolTipText(null);
                        this.transferEnabled = false;
                        this.callNumberField.setText("");
                        this.callNumberField.setEditable(true);
                        this.callNumberField.setCaretColor(Color.LIGHT_GRAY);
                        this.callNumberField.setHorizontalAlignment(4);
                        this.callTimeLabel.setText("");
                    }
                    StringBuffer buffer = new StringBuffer();
                    if (callLine.isMute() || callLine.isRecordingFlag()) {
                        buffer.append("(");
                        if (callLine.isMute()) {
                            buffer.append(I18NUtil.getString("call_notice_call_muted"));
                        }
                        if (callLine.isRecordingFlag()) {
                            if (buffer.length() != 0) {
                                buffer.append(" ");
                            }
                            buffer.append(I18NUtil.getString("call_notice_call_recording_on"));
                        }
                        buffer.append(")");
                    }
                    if (callLine.isRecordingFlag()) {
                        this.callInfoLabel.setIcon(UIConstants.ICON_PBAR_STATUS_RECORDING);
                    } else {
                        this.callInfoLabel.setIcon(UIConstants.ICON_PBAR_STATUS_LEISURE);
                    }
                    this.callInfoLabel.setText(info + buffer.toString());
                    continue;
                }
                if (callLine.getState() == CallState.INCOMING_CALL) {
                    if (callLine.getLineId() == 0) {
                        this.line1Label.setIcon(UIConstants.ICON_PHONE_LINE_1_RING_UNSELECTED);
                        continue;
                    }
                    if (callLine.getLineId() == 1) {
                        this.line2Label.setIcon(UIConstants.ICON_PHONE_LINE_2_RING_UNSELECTED);
                        continue;
                    }
                    if (callLine.getLineId() != 2) continue;
                    this.line3Label.setIcon(UIConstants.ICON_PHONE_LINE_3_RING_UNSELECTED);
                    continue;
                }
                if (callLine.getState() == CallState.INCALL) {
                    if (callLine.getLineId() == 0) {
                        this.line1Label.setIcon(UIConstants.ICON_PHONE_LINE_1_TALKING_UNSELECTED);
                        continue;
                    }
                    if (callLine.getLineId() == 1) {
                        this.line2Label.setIcon(UIConstants.ICON_PHONE_LINE_2_TALKING_UNSELECTED);
                        continue;
                    }
                    if (callLine.getLineId() != 2) continue;
                    this.line3Label.setIcon(UIConstants.ICON_PHONE_LINE_3_TALKING_UNSELECTED);
                    continue;
                }
                if (callLine.getState() == CallState.HOLD) {
                    if (callLine.getLineId() == 0) {
                        this.line1Label.setIcon(UIConstants.ICON_PHONE_LINE_1_HOLD_UNSELECTED);
                        continue;
                    }
                    if (callLine.getLineId() == 1) {
                        this.line2Label.setIcon(UIConstants.ICON_PHONE_LINE_2_HOLD_UNSELECTED);
                        continue;
                    }
                    if (callLine.getLineId() != 2) continue;
                    this.line3Label.setIcon(UIConstants.ICON_PHONE_LINE_3_HOLD_UNSELECTED);
                    continue;
                }
                if (callLine.getState() == CallState.OUTGOING_CALL) {
                    if (callLine.getLineId() == 0) {
                        this.line1Label.setIcon(UIConstants.ICON_PHONE_LINE_1_TALKING_UNSELECTED);
                        continue;
                    }
                    if (callLine.getLineId() == 1) {
                        this.line2Label.setIcon(UIConstants.ICON_PHONE_LINE_2_TALKING_UNSELECTED);
                        continue;
                    }
                    if (callLine.getLineId() != 2) continue;
                    this.line3Label.setIcon(UIConstants.ICON_PHONE_LINE_3_TALKING_UNSELECTED);
                    continue;
                }
                if (callLine.getLineId() == 0) {
                    this.line1Label.setIcon(UIConstants.ICON_PHONE_LINE_1_OFF_UNSELECTED);
                    continue;
                }
                if (callLine.getLineId() == 1) {
                    this.line2Label.setIcon(UIConstants.ICON_PHONE_LINE_2_OFF_UNSELECTED);
                    continue;
                }
                if (callLine.getLineId() != 2) continue;
                this.line3Label.setIcon(UIConstants.ICON_PHONE_LINE_3_OFF_UNSELECTED);
            }
        }
    }

    public static interface PhoneBarContentProvider {
        public long getAutoLoginTime();

        public void stopAutoLoginTimer();

        public void startAutoLoginTimer(long var1);

        public void onKeyBoardClicked();

        public void onKeyBoardClosed();

        public boolean isKeyBoardVisible();

        public void onKeyBoardKeyPress(char var1);

        public void onKeyBoardKeyRelease(char var1);
    }
}

