/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.phone;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.PersonalPhoto;
import com.blisscloud.ezuc.client.component.RoundedCornerLabel;
import com.blisscloud.ezuc.client.component.RoundedCornerPanel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.PhotoTask;
import com.blisscloud.ezuc.client.util.ThumbnailCache;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.CallLine;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.bean.PhoneLineInfo;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.db.UCDBExternalContact;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.PhotoType;
import com.blisscloud.mobile.ezuc.phone.CallState;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.KeyUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.commons.lang3.StringUtils;

public class PhoneIncomeWindow
extends JFrame
implements PhotoTask.IPhotoCallBack {
    private static final int ALPHA_MAX = 255;
    private static final int ALPHA_MIN = 150;
    private static final int ALPHA_DIFF = 4;
    private static final int ALPHA_DURATION = 80;
    private RoundedCornerPanel contentPane;
    private JLabel lblLogo;
    private JTextField lblCallerName;
    private RoundedCornerLabel lblRefuseCall;
    private JSeparator jSeparator1;
    private RoundedCornerLabel lblAnswerCall;
    private PersonalPhoto mCallerPhoto;
    private JLabel lblClose;
    private PhotoTask mPhotoTask;
    private JPopupMenu popupMenu;
    private int mLineIndex = -1;
    private int alpha = 150;
    private int increment = 4;
    private Timer timer1;
    Point pressedPoint;
    Point pressedLocation;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PhoneIncomeWindow inst = new PhoneIncomeWindow();
                inst.setLocationRelativeTo(null);
                inst.setVisible(true);
            }
        });
    }

    public PhoneIncomeWindow() {
        this.setTitle(I18NUtil.getAppName());
        this.setIconImages(UIConstants.APP_ICONS);
        this.setFocusableWindowState(false);
        this.initGUI();
        this.initPopupMenu();
        this.timer1 = new Timer(80, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ld2) {
                PhoneIncomeWindow.this.alpha += PhoneIncomeWindow.this.increment;
                if (PhoneIncomeWindow.this.alpha > 255) {
                    PhoneIncomeWindow.this.alpha = 255;
                    PhoneIncomeWindow.this.increment = -4;
                } else if (PhoneIncomeWindow.this.alpha < 150) {
                    PhoneIncomeWindow.this.alpha = 150;
                    PhoneIncomeWindow.this.increment = 4;
                }
                PhoneIncomeWindow.this.contentPane.setFromColor(new Color(128, 128, 128, PhoneIncomeWindow.this.alpha));
                PhoneIncomeWindow.this.contentPane.setToColor(new Color(32, 32, 32, PhoneIncomeWindow.this.alpha));
                PhoneIncomeWindow.this.contentPane.repaint();
            }
        });
    }

    private void initPopupMenu() {
        JMenuItem miCopy = new JMenuItem();
        miCopy.setText(I18NUtil.getString("common_btn_copy"));
        miCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (PhoneIncomeWindow.this.lblCallerName != null) {
                    String selection = PhoneIncomeWindow.this.lblCallerName.getSelectedText();
                    StringSelection stringSelection = new StringSelection(selection);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, null);
                }
            }
        });
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(miCopy);
    }

    private void initGUI() {
        try {
            this.setDefaultCloseOperation(2);
            this.setUndecorated(true);
            String osName = System.getProperties().getProperty("os.name").toLowerCase();
            this.contentPane = new RoundedCornerPanel(8, 1.0f, new Color(0x606060), 1, new Color(128, 128, 128, 150), new Color(32, 32, 32, 150));
            GridBagLayout contentPaneLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.contentPane, "Center");
            this.contentPane.setLayout(contentPaneLayout);
            this.contentPane.setPreferredSize(new Dimension(473, 143));
            this.contentPane.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent evt) {
                    PhoneIncomeWindow.this.lblLogoMouseDragged(evt);
                }
            });
            this.contentPane.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    PhoneIncomeWindow.this.lblLogoMousePressed(evt);
                }

                @Override
                public void mouseClicked(MouseEvent evt) {
                    PhoneIncomeWindow.this.dispose();
                    UCChatClient.getInstance().handleMoveToFront();
                }
            });
            this.lblLogo = new JLabel();
            this.contentPane.add((Component)this.lblLogo, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(4, 8, 4, 0), 0, 0));
            this.lblLogo.setIcon(UIConstants.ICON_LOGO20);
            this.lblLogo.setText(I18NUtil.getAppName());
            this.lblLogo.setFont(UIConstants.FONT_12_PLAIN);
            this.lblLogo.setForeground(Color.LIGHT_GRAY);
            this.lblLogo.setPreferredSize(new Dimension(20, 20));
            this.lblClose = new JLabel();
            this.contentPane.add((Component)this.lblClose, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(4, 0, 4, 8), 0, 0));
            this.lblClose.setIcon(UIConstants.ICON_CLOSE);
            this.lblClose.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    PhoneIncomeWindow.this.dispose();
                    UCChatClient.getInstance().handleMoveToFront();
                    PreferencesUtil.setPopupIncoming(UCChatClient.context, "-1,-1");
                    UCChatClient.getInstance().handleMoveToFront();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    PhoneIncomeWindow.this.lblClose.setIcon(UIConstants.ICON_CLOSE_OVER);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    PhoneIncomeWindow.this.lblClose.setIcon(UIConstants.ICON_CLOSE);
                }
            });
            this.jSeparator1 = new JSeparator();
            this.contentPane.add((Component)this.jSeparator1, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator1.setForeground(new Color(0x808080));
            this.jSeparator1.setBackground(new Color(0x707070));
            this.mCallerPhoto = new PersonalPhoto();
            if (osName.indexOf("mac") >= 0) {
                this.contentPane.add((Component)this.mCallerPhoto, new GridBagConstraints(0, 2, 1, 2, 0.0, 1.0, 18, 0, new Insets(5, 10, 5, 0), 0, 0));
            } else {
                this.contentPane.add((Component)this.mCallerPhoto, new GridBagConstraints(0, 2, 1, 2, 0.0, 1.0, 18, 0, new Insets(12, 12, 12, 0), 0, 0));
            }
            this.mCallerPhoto.setPreferredSize(new Dimension(80, 80));
            this.lblCallerName = new JTextField();
            if (osName.indexOf("mac") >= 0) {
                this.contentPane.add((Component)this.lblCallerName, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 18, 0, new Insets(10, 20, 8, 0), 0, 0));
            } else {
                this.contentPane.add((Component)this.lblCallerName, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 18, 0, new Insets(15, 20, 8, 0), 0, 0));
            }
            this.lblCallerName.setText(String.format(I18NUtil.getString("phone_notification_ringing_with_name"), "\u9673\u5c0f\u59b9"));
            this.lblCallerName.setFont(UIConstants.FONT_16_BOLD);
            this.lblCallerName.setForeground(new Color(0xF1F1F1));
            this.lblCallerName.setBorder(null);
            this.lblCallerName.setOpaque(false);
            this.lblCallerName.setEditable(false);
            this.lblCallerName.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    String selection;
                    if (SwingUtilities.isRightMouseButton(evt) && StringUtils.isNotBlank((CharSequence)(selection = PhoneIncomeWindow.this.lblCallerName.getSelectedText()))) {
                        PhoneIncomeWindow.this.popupMenu.show(PhoneIncomeWindow.this.lblCallerName, evt.getX(), evt.getY());
                    }
                    if (evt.getClickCount() == 2) {
                        PhoneIncomeWindow.this.lblCallerName.selectAll();
                    }
                }
            });
            this.lblRefuseCall = new RoundedCornerLabel(I18NUtil.getString("call_btn_reject"), UIConstants.ICON_HANGUP, UIConstants.BACKGROUND_HANGUP_NORMAL, UIConstants.BACKGROUND_HANGUP_OVER, UIConstants.BACKGROUND_HANGUP_PRESSED);
            this.contentPane.add((Component)this.lblRefuseCall, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 20, 8, 0), 0, 0));
            this.lblRefuseCall.setForeground(Color.WHITE);
            this.lblRefuseCall.setFont(UIConstants.FONT_14_BOLD);
            this.lblRefuseCall.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    PhoneIncomeWindow.this.onClickHangup();
                }
            });
            this.lblAnswerCall = new RoundedCornerLabel(I18NUtil.getString("call_btn_answer"), UIConstants.ICON_DIAL, UIConstants.BACKGROUND_CALL_NORMAL, UIConstants.BACKGROUND_CALL_OVER, UIConstants.BACKGROUND_CALL_PRESSED);
            this.contentPane.add((Component)this.lblAnswerCall, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 12, 8, 80), 0, 0));
            this.lblAnswerCall.setForeground(Color.WHITE);
            this.lblAnswerCall.setFont(UIConstants.FONT_14_BOLD);
            this.lblAnswerCall.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    PhoneIncomeWindow.this.onClickAnswer();
                }
            });
            this.setSize(400, 150);
            this.setBackground(new Color(0, 0, 0, 0));
            this.setAlwaysOnTop(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onClickHangup() {
        PhoneAgent.getInstance().rejectLine(this.mLineIndex);
        this.dispose();
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.timer1.start();
        } else {
            this.timer1.stop();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mLineIndex = -1;
        this.timer1.stop();
    }

    private void onClickAnswer() {
        CallLine callLine = PhoneAgent.getInstance().getCallLine(this.mLineIndex);
        if (callLine.getState() == CallState.INCOMING_CALL) {
            PhoneAgent.getInstance().answerLine(this.mLineIndex);
            UCChatClient.getInstance().toFront();
        }
    }

    private void lblLogoMousePressed(MouseEvent evt) {
        this.pressedPoint = evt.getLocationOnScreen();
        this.pressedLocation = this.getLocation();
    }

    private void lblLogoMouseDragged(MouseEvent evt) {
        Point currentPoint = evt.getLocationOnScreen();
        int diffX = currentPoint.x - this.pressedPoint.x;
        int diffY = currentPoint.y - this.pressedPoint.y;
        int x = this.pressedLocation.x + diffX;
        int y = this.pressedLocation.y + diffY;
        this.setLocation(x, y);
        PreferencesUtil.setPopupIncoming(UCChatClient.context, x + "," + y);
    }

    public void setCallerInfo(CallLine callLine) {
        PhoneLineInfo lineInfo = callLine.getLineInfo();
        if (lineInfo == null) {
            Log.w(PhoneIncomeWindow.class.getSimpleName(), "line info is null, please check .... ");
            return;
        }
        this.mLineIndex = callLine.getLineId();
        String content = String.format(I18NUtil.getString("phone_notification_ringing_with_name"), lineInfo.getMainDispName());
        this.lblCallerName.setText(content);
        Activity ctx = UCChatClient.context;
        if (lineInfo.getType() == 1) {
            LiteContact contact = ContactManager.getContact((Context)ctx, lineInfo.getJid());
            this.fetchPhoto(contact);
        } else if (lineInfo.getType() == 2) {
            Image img = UIConstants.ICON_PHONE_PUBLIC_PHONE200.getImage();
            this.mCallerPhoto.setImage(img);
        } else if (lineInfo.getType() == 6) {
            LiteMyContact myContact = UCDBExternalContact.getExternalContactById(UCChatClient.context, JidUtil.trimExternalContactId(lineInfo.getJid()));
            this.fetchPhoto(myContact);
        } else if (lineInfo.getType() == 8) {
            this.mCallerPhoto.setImage(UIConstants.ICON_PERSON32.getImage());
        } else if (lineInfo.getType() == 4) {
            ArrayList<String> participantJidList = UCDBChatRoom.findChatRoomParticipants((Context)ctx, lineInfo.getJid());
            this.mCallerPhoto.setImage(GraphicUtil.getChatRoomImage(ctx, participantJidList, null, false, true));
        } else if (lineInfo.getType() == 5) {
            this.mCallerPhoto.setImage(UIConstants.ICON_PHONE_CONFERENCE.getImage());
        } else {
            this.mCallerPhoto.setImage(ThumbnailCache.getInstance().getDefaultImage(ctx));
        }
    }

    protected void fetchPhoto(LiteContact contact) {
        if (this.mPhotoTask != null) {
            this.mPhotoTask.cancel(true);
            this.mPhotoTask = null;
        }
        if (contact != null && contact.isPhotoFlag()) {
            BufferedImage img = ContactManager.getPhotoWithRefresh(UCChatClient.context, PhotoType.BIG, KeyUtil.genEmpKey(contact), true);
            if (img != null) {
                img = GraphicUtil.getPresencedPersonalPhoto(64, 64, img, null, true);
                this.mCallerPhoto.setImage(img);
            } else {
                img = ContactManager.getPhotoWithRefresh(UCChatClient.context, PhotoType.SMALL, KeyUtil.genEmpKey(contact), true);
                if (img != null) {
                    img = GraphicUtil.getPresencedPersonalPhoto(64, 64, img, null, true);
                    this.mCallerPhoto.setImage(img);
                } else {
                    this.mCallerPhoto.setImage(UIConstants.ICON_PERSON32.getImage());
                }
                this.mPhotoTask = new PhotoTask();
                this.mPhotoTask.setCallBack(this);
                this.mPhotoTask.execute("/ucrm/employee/showBigPhoto?employeeId=", contact.getId(), this, contact.getJid());
            }
        } else {
            this.mCallerPhoto.setImage(UIConstants.ICON_PERSON64.getImage());
        }
    }

    protected void fetchPhoto(LiteMyContact contact) {
        if (this.mPhotoTask != null) {
            this.mPhotoTask.cancel(true);
            this.mPhotoTask = null;
        }
        if (contact != null && contact.isPhotoFlag()) {
            BufferedImage img = ContactManager.getExternalPhotoWithRefresh(UCChatClient.context, PhotoType.BIG, contact.getId(), true);
            if (img != null) {
                img = GraphicUtil.getPresencedPersonalPhoto(32, 32, img, null, true);
                this.mCallerPhoto.setImage(img);
            } else {
                img = ContactManager.getExternalPhotoWithRefresh(UCChatClient.context, PhotoType.SMALL, contact.getId(), true);
                if (img != null) {
                    img = GraphicUtil.getPresencedPersonalPhoto(32, 32, img, null, true);
                    this.mCallerPhoto.setImage(img);
                } else {
                    this.mCallerPhoto.setImage(UIConstants.ICON_PERSON32.getImage());
                }
                this.mPhotoTask = new PhotoTask();
                this.mPhotoTask.setCallBack(this);
                this.mPhotoTask.execute("/ucrm/contact/showBigPhoto?contactId=", contact.getId(), this, String.valueOf(contact.getId()));
            }
        } else {
            this.mCallerPhoto.setImage(UIConstants.ICON_PERSON32.getImage());
        }
    }

    @Override
    public void loadSuccess(Image bitmap) {
        if (bitmap != null) {
            this.mCallerPhoto.setImage(bitmap);
        } else {
            this.mCallerPhoto.setImage(UIConstants.ICON_PERSON32.getImage());
        }
    }

    @Override
    public void loadFail(String info) {
        Log.e(PhoneIncomeWindow.class.getSimpleName(), "load image fail: " + info);
    }

    public int getLineIndex() {
        return this.mLineIndex;
    }
}

