/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.phone;

import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.RoundedCornerPanel;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PhoneKeyBoard
extends JPanel {
    private static final long serialVersionUID = -6184621195320528117L;
    private static final String KEY_1 = "1";
    private static final String KEY_2 = "2";
    private static final String KEY_3 = "3";
    private static final String KEY_4 = "4";
    private static final String KEY_5 = "5";
    private static final String KEY_6 = "6";
    private static final String KEY_7 = "7";
    private static final String KEY_8 = "8";
    private static final String KEY_9 = "9";
    private static final String KEY_0 = "0";
    private static final String KEY_COMMA = ",";
    private static final String KEY_STAR = "*";
    private static final String KEY_POUND = "#";
    private static final String KEY_PLUS = "+";
    private JLabel lblSharp;
    private JLabel lblStar;
    private JLabel lbl0;
    private JLabel lbl9;
    private JLabel lbl8;
    private JLabel lbl7;
    private JLabel lbl6;
    private JLabel lbl5;
    private JLabel lbl4;
    private JLabel lbl3;
    private JLabel lbl2;
    private JLabel lbl1;
    private boolean voiceEnabled;
    private PhoneKeyBoardListener listener;

    public PhoneKeyBoard(PhoneKeyBoardListener listener) {
        this.listener = listener;
        this.initGUI();
        this.setVoiceEnabled(false);
    }

    private void initGUI() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        RoundedCornerPanel x = new RoundedCornerPanel(30, 1.0f);
        x.setLayout(new GridBagLayout());
        x.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)x, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lbl1 = new JLabel();
        x.add((Component)this.lbl1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lbl1.setIcon(UIConstants.icon_1);
        this.lbl1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.lbl1.setIcon(UIConstants.icon_1);
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.lbl1.setIcon(UIConstants.icon_1over);
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.onKeyClicked(PhoneKeyBoard.KEY_1);
                }
            }
        });
        this.lbl2 = new JLabel();
        x.add((Component)this.lbl2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lbl2.setIcon(UIConstants.icon_2);
        this.lbl2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.lbl2.setIcon(UIConstants.icon_2);
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.lbl2.setIcon(UIConstants.icon_2over);
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.onKeyClicked(PhoneKeyBoard.KEY_2);
                }
            }
        });
        this.lbl3 = new JLabel();
        x.add((Component)this.lbl3, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lbl3.setIcon(UIConstants.icon_3);
        this.lbl3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.lbl3.setIcon(UIConstants.icon_3);
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.lbl3.setIcon(UIConstants.icon_3over);
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.onKeyClicked(PhoneKeyBoard.KEY_3);
                }
            }
        });
        this.lbl4 = new JLabel();
        x.add((Component)this.lbl4, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lbl4.setIcon(UIConstants.icon_4);
        this.lbl4.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.lbl4.setIcon(UIConstants.icon_4);
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.lbl4.setIcon(UIConstants.icon_4over);
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.onKeyClicked(PhoneKeyBoard.KEY_4);
                }
            }
        });
        this.lbl5 = new JLabel();
        x.add((Component)this.lbl5, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lbl5.setIcon(UIConstants.icon_5);
        this.lbl5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.lbl5.setIcon(UIConstants.icon_5);
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.lbl5.setIcon(UIConstants.icon_5over);
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.onKeyClicked(PhoneKeyBoard.KEY_5);
                }
            }
        });
        this.lbl6 = new JLabel();
        x.add((Component)this.lbl6, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lbl6.setIcon(UIConstants.icon_6);
        this.lbl6.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.lbl6.setIcon(UIConstants.icon_6);
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.lbl6.setIcon(UIConstants.icon_6over);
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.onKeyClicked(PhoneKeyBoard.KEY_6);
                }
            }
        });
        this.lbl7 = new JLabel();
        x.add((Component)this.lbl7, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lbl7.setIcon(UIConstants.icon_7);
        this.lbl7.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.lbl7.setIcon(UIConstants.icon_7);
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.lbl7.setIcon(UIConstants.icon_7over);
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.onKeyClicked(PhoneKeyBoard.KEY_7);
                }
            }
        });
        this.lbl8 = new JLabel();
        x.add((Component)this.lbl8, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lbl8.setIcon(UIConstants.icon_8);
        this.lbl8.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.lbl8.setIcon(UIConstants.icon_8);
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.lbl8.setIcon(UIConstants.icon_8over);
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.onKeyClicked(PhoneKeyBoard.KEY_8);
                }
            }
        });
        this.lbl9 = new JLabel();
        x.add((Component)this.lbl9, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lbl9.setIcon(UIConstants.icon_9);
        this.lbl9.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.lbl9.setIcon(UIConstants.icon_9);
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.lbl9.setIcon(UIConstants.icon_9over);
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.onKeyClicked(PhoneKeyBoard.KEY_9);
                }
            }
        });
        this.lblStar = new JLabel();
        x.add((Component)this.lblStar, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lblStar.setIcon(UIConstants.icon_star);
        this.lblStar.addMouseListener(new MouseAdapter(){
            long t = 0L;

            @Override
            public void mouseExited(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.lblStar.setIcon(UIConstants.icon_star);
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.lblStar.setIcon(UIConstants.icon_starover);
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                this.t = System.currentTimeMillis();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (System.currentTimeMillis() - this.t > 300L) {
                    PhoneKeyBoard.this.onKeyClicked(PhoneKeyBoard.KEY_COMMA);
                } else if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.onKeyClicked(PhoneKeyBoard.KEY_STAR);
                }
                this.t = 0L;
            }
        });
        this.lbl0 = new JLabel();
        x.add((Component)this.lbl0, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lbl0.setIcon(UIConstants.icon_0);
        this.lbl0.addMouseListener(new MouseAdapter(){
            long t = 0L;

            @Override
            public void mouseExited(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.lbl0.setIcon(UIConstants.icon_0);
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.lbl0.setIcon(UIConstants.icon_0over);
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                this.t = System.currentTimeMillis();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (System.currentTimeMillis() - this.t > 300L) {
                    PhoneKeyBoard.this.onKeyClicked(PhoneKeyBoard.KEY_PLUS);
                } else if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.onKeyClicked(PhoneKeyBoard.KEY_0);
                }
                this.t = 0L;
            }
        });
        this.lblSharp = new JLabel();
        x.add((Component)this.lblSharp, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lblSharp.setIcon(UIConstants.icon_pound);
        this.lblSharp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.lblSharp.setIcon(UIConstants.icon_pound);
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.lblSharp.setIcon(UIConstants.icon_poundover);
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                if (PhoneKeyBoard.this.voiceEnabled) {
                    PhoneKeyBoard.this.onKeyClicked(PhoneKeyBoard.KEY_POUND);
                }
            }
        });
    }

    public void onKeyBoardKeyPress(char c) {
        if (!this.voiceEnabled) {
            return;
        }
        if (c == '1') {
            this.lbl1.setIcon(UIConstants.icon_1over);
        } else if (c == '2') {
            this.lbl2.setIcon(UIConstants.icon_2over);
        } else if (c == '3') {
            this.lbl3.setIcon(UIConstants.icon_3over);
        } else if (c == '4') {
            this.lbl4.setIcon(UIConstants.icon_4over);
        } else if (c == '5') {
            this.lbl5.setIcon(UIConstants.icon_5over);
        } else if (c == '6') {
            this.lbl6.setIcon(UIConstants.icon_6over);
        } else if (c == '7') {
            this.lbl7.setIcon(UIConstants.icon_7over);
        } else if (c == '8') {
            this.lbl8.setIcon(UIConstants.icon_8over);
        } else if (c == '9') {
            this.lbl9.setIcon(UIConstants.icon_9over);
        } else if (c == '0') {
            this.lbl0.setIcon(UIConstants.icon_0over);
        } else if (c == '*') {
            this.lblStar.setIcon(UIConstants.icon_starover);
        } else if (c == '#') {
            this.lblSharp.setIcon(UIConstants.icon_poundover);
        }
    }

    public void onKeyBoardKeyRelease(char c) {
        if (!this.voiceEnabled) {
            return;
        }
        if (c == '1') {
            this.lbl1.setIcon(UIConstants.icon_1);
            this.sendDTMF('1');
        } else if (c == '2') {
            this.lbl2.setIcon(UIConstants.icon_2);
            this.sendDTMF('2');
        } else if (c == '3') {
            this.lbl3.setIcon(UIConstants.icon_3);
            this.sendDTMF('3');
        } else if (c == '4') {
            this.lbl4.setIcon(UIConstants.icon_4);
            this.sendDTMF('4');
        } else if (c == '5') {
            this.lbl5.setIcon(UIConstants.icon_5);
            this.sendDTMF('5');
        } else if (c == '6') {
            this.lbl6.setIcon(UIConstants.icon_6);
            this.sendDTMF('6');
        } else if (c == '7') {
            this.lbl7.setIcon(UIConstants.icon_7);
            this.sendDTMF('7');
        } else if (c == '8') {
            this.lbl8.setIcon(UIConstants.icon_8);
            this.sendDTMF('8');
        } else if (c == '9') {
            this.lbl9.setIcon(UIConstants.icon_9);
            this.sendDTMF('9');
        } else if (c == '0') {
            this.lbl0.setIcon(UIConstants.icon_0);
            this.sendDTMF('0');
        } else if (c == '*') {
            this.lblStar.setIcon(UIConstants.icon_star);
            this.sendDTMF('*');
        } else if (c == '#') {
            this.lblSharp.setIcon(UIConstants.icon_pound);
            this.sendDTMF('#');
        }
    }

    private void onKeyClicked(String key) {
        this.listener.onKeyClicked(key);
        if (!key.equalsIgnoreCase(KEY_COMMA) && !key.equalsIgnoreCase(KEY_PLUS)) {
            this.sendDTMF(key.charAt(0));
        }
    }

    private void sendDTMF(char c) {
        PhoneAgent.getInstance().sendDTMF(c, 250);
    }

    private void setVoiceEnabled(boolean enabled) {
        this.voiceEnabled = enabled;
        this.lbl1.setEnabled(enabled);
        this.lbl2.setEnabled(enabled);
        this.lbl3.setEnabled(enabled);
        this.lbl4.setEnabled(enabled);
        this.lbl5.setEnabled(enabled);
        this.lbl6.setEnabled(enabled);
        this.lbl7.setEnabled(enabled);
        this.lbl8.setEnabled(enabled);
        this.lbl9.setEnabled(enabled);
        this.lbl0.setEnabled(enabled);
        this.lblStar.setEnabled(enabled);
        this.lblSharp.setEnabled(enabled);
    }

    public void onPhoneRegisterSuccess() {
        Log.d(PhoneKeyBoard.class.getSimpleName(), "phone_registerSuccess");
        this.setVoiceEnabled(true);
    }

    public void onPhoneRegisterFail(String result) {
        Log.d(PhoneKeyBoard.class.getSimpleName(), "phone_registerFail result:" + result);
        this.setVoiceEnabled(false);
    }

    public void onPhoneUnregisterDone(String result) {
        Log.d(PhoneKeyBoard.class.getSimpleName(), "phone_unregisterDone result:" + result);
        this.setVoiceEnabled(false);
    }

    public static interface PhoneKeyBoardListener {
        public void onKeyClicked(String var1);
    }
}

