/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.phone;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.web.LiteSite;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.main.TransferItemBean;
import com.blisscloud.ezuc.client.main.TransferItemRenderer;
import com.blisscloud.ezuc.client.main.TransferMyOtherDeviceRenderer;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.mobile.ezuc.agent.CallLine;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.Device;
import com.blisscloud.mobile.ezuc.db.UCDBGroup;
import com.blisscloud.mobile.ezuc.db.UCDBSite;
import com.blisscloud.mobile.ezuc.manager.DeviceManager;
import com.blisscloud.mobile.ezuc.manager.SiteManager;
import com.blisscloud.mobile.ezuc.util.ApiVersion;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class TransferDialog
extends GenericDialog {
    private static final long serialVersionUID = 2005755156175398787L;
    private JScrollPane jScrollPane;
    private JPanel mainPanel;
    private JButton btnConfirm;
    private ButtonGroup transferButtonGroup = new ButtonGroup();
    private JRadioButton transferToLastExtenRadioBtn;
    private JRadioButton transferToSatisfactionRadioBtn;
    private JRadioButton transferToExtenRadioBtn;
    private JRadioButton parkCallRadioBtn;
    private JRadioButton transferToMyFavoriateRadioBtn;
    private JRadioButton transferToMyDeviceRadioBtn;
    private JTextField extFiled;
    private int mLine;
    private JComboBox<TransferItemBean> myFavoriateBox;
    private DefaultComboBoxModel<TransferItemBean> myFavoriateModel = new DefaultComboBoxModel();
    private JComboBox<String> myLastExtenBox;
    private DefaultComboBoxModel<String> myLastExtenModel = new DefaultComboBoxModel();
    private JComboBox<TransferItemBean> satisfactionBox;
    private DefaultComboBoxModel<TransferItemBean> satisfactionModel = new DefaultComboBoxModel();
    private List<CallLine> lineList;
    private List<JRadioButton> lineRadioBtnList = new ArrayList<JRadioButton>();
    private JComboBox<Device> myOtherDeviceBox;
    private DefaultComboBoxModel<Device> myOtherDeviceModel = new DefaultComboBoxModel();

    public TransferDialog(JFrame frame, int line) {
        super(frame);
        this.mLine = line;
        this.initGUI();
    }

    private void initGUI() {
        try {
            List<String> extenList;
            JSONObject obj;
            String satis;
            JPanel radioPanel;
            this.setTitle(I18NUtil.getString("transfer_dialog_label"));
            this.setModal(true);
            this.setLocationRelativeTo(null);
            BorderLayout thisLayout = new BorderLayout();
            this.setLayout(thisLayout);
            this.setBackground(UIConstants.COLOR_DIALOG_BACKGROUND);
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setVerticalScrollBarPolicy(20);
            this.jScrollPane.setHorizontalScrollBarPolicy(31);
            this.add((Component)this.jScrollPane, "Center");
            this.jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            this.mainPanel = new JPanel();
            this.mainPanel.setOpaque(false);
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.jScrollPane.setViewportView(this.mainPanel);
            GridBagLayout mainLayout = new GridBagLayout();
            this.mainPanel.setLayout(mainLayout);
            int y = 0;
            boolean selected = false;
            this.lineList = PhoneAgent.getInstance().getOtherLineAbleToTransfer(this.mLine);
            if (this.lineList != null && this.lineList.size() > 0) {
                for (CallLine callLine : this.lineList) {
                    radioPanel = new JPanel();
                    radioPanel.setOpaque(false);
                    FlowLayout flowLayout = new FlowLayout();
                    flowLayout.setAlignment(3);
                    radioPanel.setLayout(flowLayout);
                    JRadioButton transferToLineRadioBtn = new JRadioButton();
                    this.lineRadioBtnList.add(transferToLineRadioBtn);
                    radioPanel.add(transferToLineRadioBtn);
                    this.mainPanel.add((Component)radioPanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
                    String transLineText = String.format(I18NUtil.getString("transfer_dialog_line_label"), String.valueOf(callLine.getLineId() + 1), callLine.getLineInfo().getMainDispName());
                    transferToLineRadioBtn.setText(transLineText);
                    transferToLineRadioBtn.setOpaque(false);
                    transferToLineRadioBtn.setFont(UIConstants.FONT_14_PLAIN);
                    if (!selected) {
                        transferToLineRadioBtn.setSelected(true);
                        selected = true;
                    }
                    this.transferButtonGroup.add(transferToLineRadioBtn);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(satis = PreferencesUtil.getSatisfactionSetting(UCChatClient.context))) && (obj = new JSONObject(satis)).has("satisfactionSurveyList")) {
                radioPanel = new JPanel();
                radioPanel.setOpaque(false);
                FlowLayout flowLayout = new FlowLayout();
                flowLayout.setAlignment(3);
                radioPanel.setLayout(flowLayout);
                this.mainPanel.add((Component)radioPanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
                this.transferToSatisfactionRadioBtn = new JRadioButton();
                radioPanel.add(this.transferToSatisfactionRadioBtn);
                this.transferToSatisfactionRadioBtn.setText(I18NUtil.getString("transfer_dialog_satisfaction_label"));
                this.transferToSatisfactionRadioBtn.setOpaque(false);
                this.transferToSatisfactionRadioBtn.setFont(UIConstants.FONT_14_PLAIN);
                if (!selected) {
                    this.transferToSatisfactionRadioBtn.setSelected(true);
                    selected = true;
                }
                this.transferButtonGroup.add(this.transferToSatisfactionRadioBtn);
                this.satisfactionBox = new JComboBox();
                this.satisfactionBox.setFont(UIConstants.FONT_14_PLAIN);
                this.satisfactionBox.setRenderer(new TransferItemRenderer());
                this.satisfactionBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TransferDialog.this.transferToSatisfactionRadioBtn.setSelected(true);
                    }
                });
                long mySiteId = PreferencesUtil.getSipUsePbxSite(UCChatClient.context);
                JSONArray ary = obj.getJSONArray("satisfactionSurveyList");
                TransferItemBean targetItem = null;
                for (int i = 0; i < ary.length(); ++i) {
                    int siteId;
                    JSONObject itemObj = ary.getJSONObject(i);
                    String name = "";
                    String ext = "";
                    if (!itemObj.has("siteId") || mySiteId != (long)(siteId = itemObj.getInt("siteId"))) continue;
                    if (itemObj.has("name")) {
                        name = itemObj.getString("name");
                    }
                    if (itemObj.has("ext")) {
                        ext = itemObj.getString("ext");
                    }
                    TransferItemBean bean = new TransferItemBean(name, ext);
                    this.satisfactionModel.addElement(bean);
                    if (!itemObj.has("defaultSurvey") || !itemObj.getBoolean("defaultSurvey")) continue;
                    targetItem = bean;
                }
                if (targetItem != null) {
                    this.satisfactionModel.setSelectedItem(targetItem);
                }
                this.satisfactionBox.setModel(this.satisfactionModel);
                radioPanel.add(this.satisfactionBox);
            }
            if ((extenList = PreferencesUtil.getLastExtenList(UCChatClient.context)).size() > 0) {
                JPanel radioPanel2 = new JPanel();
                radioPanel2.setOpaque(false);
                FlowLayout layout2 = new FlowLayout();
                layout2.setAlignment(3);
                radioPanel2.setLayout(layout2);
                this.mainPanel.add((Component)radioPanel2, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
                this.transferToLastExtenRadioBtn = new JRadioButton();
                radioPanel2.add(this.transferToLastExtenRadioBtn);
                this.transferToLastExtenRadioBtn.setText(I18NUtil.getString("transfer_dialog_last_ext_label"));
                this.transferToLastExtenRadioBtn.setOpaque(false);
                this.transferToLastExtenRadioBtn.setFont(UIConstants.FONT_14_PLAIN);
                if (!selected) {
                    this.transferToLastExtenRadioBtn.setSelected(true);
                    selected = true;
                }
                this.transferButtonGroup.add(this.transferToLastExtenRadioBtn);
                this.myLastExtenBox = new JComboBox();
                this.myLastExtenBox.setFont(UIConstants.FONT_14_PLAIN);
                this.myLastExtenBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TransferDialog.this.transferToLastExtenRadioBtn.setSelected(true);
                    }
                });
                for (String exten : extenList) {
                    this.myLastExtenModel.addElement(exten);
                }
                this.myLastExtenBox.setModel(this.myLastExtenModel);
                radioPanel2.add(this.myLastExtenBox);
            }
            JPanel radioPanel3 = new JPanel();
            radioPanel3.setOpaque(false);
            FlowLayout layout3 = new FlowLayout();
            layout3.setAlignment(3);
            radioPanel3.setLayout(layout3);
            this.mainPanel.add((Component)radioPanel3, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
            this.transferToExtenRadioBtn = new JRadioButton();
            radioPanel3.add(this.transferToExtenRadioBtn);
            this.transferToExtenRadioBtn.setText(I18NUtil.getString("transfer_dialog_ext_label"));
            this.transferToExtenRadioBtn.setOpaque(false);
            this.transferToExtenRadioBtn.setFont(UIConstants.FONT_14_PLAIN);
            if (!selected) {
                this.transferToExtenRadioBtn.setSelected(true);
                selected = true;
            }
            this.transferButtonGroup.add(this.transferToExtenRadioBtn);
            this.extFiled = new JTextField();
            this.extFiled.enableInputMethods(false);
            this.extFiled.setPreferredSize(new Dimension(100, 28));
            radioPanel3.add(this.extFiled);
            this.extFiled.setFont(UIConstants.FONT_14_PLAIN);
            this.extFiled.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                    TransferDialog.this.transferToExtenRadioBtn.setSelected(true);
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }
            });
            if (ApiVersion.isApi28Later()) {
                JPanel radioPanel2 = new JPanel();
                radioPanel2.setOpaque(false);
                FlowLayout layout = new FlowLayout();
                layout.setAlignment(3);
                radioPanel2.setLayout(layout);
                this.mainPanel.add((Component)radioPanel2, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
                this.parkCallRadioBtn = new JRadioButton();
                radioPanel2.add(this.parkCallRadioBtn);
                this.parkCallRadioBtn.setText(I18NUtil.getString("transfer_dialog_park_call"));
                this.parkCallRadioBtn.setOpaque(false);
                this.parkCallRadioBtn.setFont(UIConstants.FONT_14_PLAIN);
                if (!selected) {
                    this.parkCallRadioBtn.setSelected(true);
                    selected = true;
                }
                this.transferButtonGroup.add(this.parkCallRadioBtn);
            }
            ArrayList<LiteContact> empList = new ArrayList<LiteContact>();
            List<Object> resultList = UCDBGroup.findMyFavoriteGroup(UCChatClient.context, null, false, false);
            if (resultList != null) {
                for (Object e : resultList) {
                    if (!(e instanceof LiteContact)) continue;
                    empList.add((LiteContact)e);
                }
            }
            if (empList.size() > 0) {
                radioPanel = new JPanel();
                radioPanel.setOpaque(false);
                FlowLayout flowLayout = new FlowLayout();
                flowLayout.setAlignment(3);
                radioPanel.setLayout(flowLayout);
                this.mainPanel.add((Component)radioPanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
                this.transferToMyFavoriateRadioBtn = new JRadioButton();
                radioPanel.add(this.transferToMyFavoriateRadioBtn);
                this.transferToMyFavoriateRadioBtn.setText(I18NUtil.getString("transfer_dialog_my_favoriate_label"));
                this.transferToMyFavoriateRadioBtn.setSelected(false);
                this.transferToMyFavoriateRadioBtn.setOpaque(false);
                this.transferToMyFavoriateRadioBtn.setFont(UIConstants.FONT_14_PLAIN);
                this.transferButtonGroup.add(this.transferToMyFavoriateRadioBtn);
                this.myFavoriateBox = new JComboBox();
                this.myFavoriateBox.setFont(UIConstants.FONT_14_PLAIN);
                this.myFavoriateBox.setRenderer(new TransferItemRenderer());
                this.myFavoriateBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TransferDialog.this.transferToMyFavoriateRadioBtn.setSelected(true);
                    }
                });
                for (LiteContact contact : empList) {
                    ArrayList<String> extList = contact.getExtList();
                    if (extList == null || extList.size() == 0) continue;
                    for (String s : extList) {
                        String[] siext = s.split("_");
                        if (siext.length != 2) continue;
                        String destSitePrefix = siext[0];
                        String destSiteExt = siext[1];
                        LiteSite targetSite = UCDBSite.getSiteByPrefix(UCChatClient.context, destSitePrefix);
                        String[] sitePrefix = TransferDialog.getCrossSitePrefix(UCChatClient.context, targetSite);
                        String numberToDial = sitePrefix[0] + destSiteExt;
                        this.myFavoriateModel.addElement(new TransferItemBean(contact.getDispName(), numberToDial));
                    }
                }
                this.myFavoriateBox.setModel(this.myFavoriateModel);
                radioPanel.add(this.myFavoriateBox);
            }
            String localMachineId = PreferencesUtil.getString(UCChatClient.context, "SIP_USER_NAME", "");
            Map<Long, List<Device>> deviceMapt = DeviceManager.getDeviceInfos(UCChatClient.context);
            ArrayList<Device> deviceList = new ArrayList<Device>();
            for (List<Device> list : deviceMapt.values()) {
                for (Device d : list) {
                    if (d.getDeviceId().equalsIgnoreCase(localMachineId) || !d.isRegistered() && d.getDeviceType() != 1) continue;
                    deviceList.add(d);
                }
            }
            if (deviceList.size() > 0) {
                JPanel jPanel = new JPanel();
                jPanel.setOpaque(false);
                FlowLayout layout4 = new FlowLayout();
                layout4.setAlignment(3);
                jPanel.setLayout(layout4);
                this.mainPanel.add((Component)jPanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
                this.transferToMyDeviceRadioBtn = new JRadioButton();
                jPanel.add(this.transferToMyDeviceRadioBtn);
                this.transferToMyDeviceRadioBtn.setText(I18NUtil.getString("transfer_dialog_my_device_label"));
                this.transferToMyDeviceRadioBtn.setSelected(false);
                this.transferToMyDeviceRadioBtn.setOpaque(false);
                this.transferToMyDeviceRadioBtn.setFont(UIConstants.FONT_14_PLAIN);
                this.transferButtonGroup.add(this.transferToMyDeviceRadioBtn);
                this.myOtherDeviceBox = new JComboBox();
                this.myOtherDeviceBox.setFont(UIConstants.FONT_14_PLAIN);
                this.myOtherDeviceBox.setRenderer(new TransferMyOtherDeviceRenderer());
                this.myOtherDeviceBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TransferDialog.this.transferToMyDeviceRadioBtn.setSelected(true);
                    }
                });
                for (Device device : deviceList) {
                    this.myOtherDeviceModel.addElement(device);
                }
                this.myOtherDeviceBox.setModel(this.myOtherDeviceModel);
                jPanel.add(this.myOtherDeviceBox);
            }
            JPanel x = new JPanel();
            x.setOpaque(false);
            this.mainPanel.add((Component)x, new GridBagConstraints(0, y++, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            JPanel btnPanel = new JPanel();
            btnPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            btnPanel.setOpaque(false);
            FlowLayout btnPanelLayout = new FlowLayout();
            btnPanelLayout.setAlignment(1);
            btnPanel.setLayout(btnPanelLayout);
            this.add((Component)btnPanel, "South");
            this.btnConfirm = new JButton();
            btnPanel.add(this.btnConfirm);
            this.btnConfirm.setText(I18NUtil.getString("common_btn_ok"));
            this.btnConfirm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TransferDialog.this.btnConfirmActionPerformed(evt);
                }
            });
            JButton btnCancel = new JButton();
            btnPanel.add(btnCancel);
            btnCancel.setText(I18NUtil.getString("common_btn_cancel"));
            btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TransferDialog.this.setVisible(false);
                }
            });
            this.setSize(500, 400);
            this.setMinimumSize(new Dimension(500, 300));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String[] getCrossSitePrefix(Context ctx, LiteSite targetSite) {
        long mySiteId = PreferencesUtil.getSipUsePbxSite(ctx);
        String[] sitePrefix = new String[]{"", ""};
        if (targetSite != null && targetSite.getId() != mySiteId) {
            sitePrefix[0] = targetSite.getPrefix();
            sitePrefix[1] = targetSite.getName();
        }
        return sitePrefix;
    }

    private String getMyExt() {
        String result = null;
        LiteContact myInfo = PreferencesUtil.getUserInfo(UCChatClient.context);
        ArrayList<String> extList = myInfo.getExtList();
        String myPrefix = SiteManager.getSitePrefixById(UCChatClient.context, PreferencesUtil.getSipUsePbxSite(UCChatClient.context));
        for (String ext : extList) {
            if (ext.indexOf(myPrefix + "_") != 0) continue;
            result = ext.substring(myPrefix.length() + 1);
            break;
        }
        return result;
    }

    private void btnConfirmActionPerformed(ActionEvent evt) {
        if (this.lineRadioBtnList.size() != 0) {
            for (int i = 0; i < this.lineRadioBtnList.size(); ++i) {
                JRadioButton btn = this.lineRadioBtnList.get(i);
                if (!btn.isSelected()) continue;
                CallLine callLine1 = PhoneAgent.getInstance().getCallLine(this.mLine);
                CallLine callLine2 = this.lineList.get(i);
                WebAgent.getInstance().makeTwoStepTransfer(callLine1.getSipCallId(), callLine2.getSipCallId());
                this.setVisible(false);
                return;
            }
        }
        if (this.transferToSatisfactionRadioBtn != null && this.transferToSatisfactionRadioBtn.isSelected()) {
            TransferItemBean itemObj = (TransferItemBean)this.satisfactionBox.getSelectedItem();
            if (itemObj == null) {
                return;
            }
            PhoneAgent.getInstance().transfer(this.mLine, itemObj.getExt());
            this.setVisible(false);
            return;
        }
        if (this.transferToMyDeviceRadioBtn != null && this.transferToMyDeviceRadioBtn.isSelected()) {
            Device item = (Device)this.myOtherDeviceBox.getSelectedItem();
            if (item == null) {
                return;
            }
            String s = "BCDEVICEID__" + item.getDeviceId() + "__" + this.getMyExt();
            PhoneAgent.getInstance().transfer(this.mLine, s);
            this.setVisible(false);
            return;
        }
        if (this.transferToExtenRadioBtn != null && this.transferToExtenRadioBtn.isSelected()) {
            if (StringUtils.isBlank((CharSequence)this.extFiled.getText())) {
                this.extFiled.requestFocus();
                JOptionPane.showMessageDialog(this, I18NUtil.getString("transfer_dialog_validation_ext_not_found"), I18NUtil.getString("common_title_error"), 0);
                return;
            }
            String ext = this.extFiled.getText().trim();
            PreferencesUtil.saveLastExten(UCChatClient.context, ext);
            PhoneAgent.getInstance().transfer(this.mLine, ext);
            this.setVisible(false);
            return;
        }
        if (this.transferToLastExtenRadioBtn != null && this.transferToLastExtenRadioBtn.isSelected()) {
            String exten = (String)this.myLastExtenBox.getSelectedItem();
            if (StringUtils.isBlank((CharSequence)exten)) {
                return;
            }
            PreferencesUtil.saveLastExten(UCChatClient.context, exten);
            PhoneAgent.getInstance().transfer(this.mLine, exten);
            this.setVisible(false);
            return;
        }
        if (this.transferToMyFavoriateRadioBtn != null && this.transferToMyFavoriateRadioBtn.isSelected()) {
            TransferItemBean item = (TransferItemBean)this.myFavoriateBox.getSelectedItem();
            if (item == null) {
                return;
            }
            PhoneAgent.getInstance().transfer(this.mLine, item.getExt().trim());
            this.setVisible(false);
            return;
        }
        if (this.parkCallRadioBtn != null && this.parkCallRadioBtn.isSelected()) {
            CallLine callLine1 = PhoneAgent.getInstance().getCallLine(this.mLine);
            WebAgent.getInstance().parkCall(callLine1.getSipCallId());
            this.setVisible(false);
            return;
        }
        this.setVisible(false);
    }

    public static boolean checkSetEquals(Set<?> set1, Set<?> set2) {
        if (set1 == null || set2 == null) {
            return false;
        }
        if (set1.size() != set2.size()) {
            return false;
        }
        return set1.containsAll(set2);
    }

    public JRadioButton getTransferToSatisfactionRadioBtn() {
        return this.transferToSatisfactionRadioBtn;
    }

    public void setTransferToSatisfactionRadioBtn(JRadioButton transferToSatisfactionRadioBtn) {
        this.transferToSatisfactionRadioBtn = transferToSatisfactionRadioBtn;
    }
}

