/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.resource;

import com.blisscloud.ezuc.client.resource.XMLResourceBundle;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class XMLResourceBundleControl
extends ResourceBundle.Control {
    private static String XML = "xml";

    @Override
    public List<String> getFormats(String baseName) {
        return Collections.singletonList(XML);
    }

    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        InputStream stream;
        if (baseName == null || locale == null || format == null || loader == null) {
            throw new NullPointerException();
        }
        XMLResourceBundle bundle = null;
        if (!format.equals(XML)) {
            return null;
        }
        String bundleName = this.toBundleName(baseName, locale);
        String resourceName = this.toResourceName(bundleName, format);
        URL url = loader.getResource(resourceName);
        if (url == null) {
            return null;
        }
        URLConnection connection = url.openConnection();
        if (connection == null) {
            return null;
        }
        if (reload) {
            connection.setUseCaches(false);
        }
        if ((stream = connection.getInputStream()) == null) {
            return null;
        }
        BufferedInputStream bis = new BufferedInputStream(stream);
        bundle = new XMLResourceBundle(bis);
        bis.close();
        return bundle;
    }

    public static void main(String[] args) {
        ResourceBundle bundle = ResourceBundle.getBundle("Strings", new XMLResourceBundleControl());
        String string = bundle.getString("Key");
        System.out.println("Key: " + string);
    }
}

