/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.summary;

import com.blisscloud.ezuc.client.summary.SummaryItemNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Objects;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;

public class RadioBtnNodeEditor
extends AbstractCellEditor
implements TreeCellEditor {
    private final JPanel panel = new JPanel(new BorderLayout());
    private final DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
    private final JRadioButton radioButton = new JRadioButton();
    private SummaryItemNode itemNode;

    public RadioBtnNodeEditor() {
        this.radioButton.setOpaque(false);
        this.radioButton.setFocusable(false);
        this.radioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RadioBtnNodeEditor.this.stopCellEditing();
            }
        });
        this.panel.setFocusable(false);
        this.panel.setRequestFocusEnabled(false);
        this.panel.setOpaque(false);
        this.panel.add((Component)this.radioButton, "West");
        this.renderer.setLeafIcon(null);
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        JLabel l = (JLabel)this.renderer.getTreeCellRendererComponent(tree, value, true, expanded, leaf, row, true);
        l.setFont(tree.getFont());
        if (value instanceof SummaryItemNode) {
            this.itemNode = (SummaryItemNode)value;
            this.radioButton.setEnabled(tree.isEnabled());
            this.radioButton.setFont(tree.getFont());
            this.radioButton.setIcon(null);
            l.setText(this.itemNode.getName());
            this.radioButton.setSelected(this.itemNode.getStatus() == SummaryItemNode.SummaryStatus.SELECTED);
            this.panel.add(l);
            return this.panel;
        }
        return l;
    }

    @Override
    public Object getCellEditorValue() {
        SummaryItemNode tempNode = new SummaryItemNode();
        tempNode.setId(this.itemNode.getId());
        tempNode.setStatus(this.radioButton.isSelected() ? SummaryItemNode.SummaryStatus.SELECTED : SummaryItemNode.SummaryStatus.DESELECTED);
        return tempNode;
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent && e.getSource() instanceof JTree) {
            TreePath path;
            MouseEvent me = (MouseEvent)e;
            JTree tree = (JTree)e.getSource();
            Rectangle r = tree.getPathBounds(path = tree.getPathForLocation(me.getX(), me.getY()));
            if (Objects.isNull(r)) {
                return false;
            }
            Dimension d = this.radioButton.getPreferredSize();
            r.setSize(new Dimension(d.width, r.height));
            if (r.contains(me.getX(), me.getY())) {
                return true;
            }
        }
        return false;
    }
}

