/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.summary;

import com.blisscloud.ezuc.client.cc.SummaryItem;
import com.blisscloud.ezuc.client.cc.SummaryTreeCache;
import com.blisscloud.ezuc.client.cc.SummaryType;
import com.blisscloud.ezuc.client.summary.SummaryItemNode;
import com.blisscloud.ezuc.client.summary.SummaryTypeNode;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;

public class SummaryTreeModel
implements TreeModel {
    private long mRootTypeId;
    private SummaryTypeNode mRoot = null;
    private List<TreeModelListener> treeModelListenerList = new ArrayList<TreeModelListener>();
    private boolean mMultiEnabled;

    public SummaryTreeModel(long rootTypeId, ArrayList<Long> itemSelectedList, boolean multiEnabled) {
        this.mRootTypeId = rootTypeId;
        this.mMultiEnabled = multiEnabled;
        if (!this.mMultiEnabled && itemSelectedList.size() > 1) {
            ArrayList<Long> filterList = new ArrayList<Long>();
            filterList.add(itemSelectedList.get(0));
            itemSelectedList = filterList;
        }
        SummaryType osType = SummaryTreeCache.iSummaryTypesMap.get(this.mRootTypeId);
        this.mRoot = this.convertCacheTypeNode(osType, null, itemSelectedList);
        this.filterKey(null);
    }

    private SummaryTypeNode convertCacheTypeNode(SummaryType osType, SummaryTypeNode pType, ArrayList<Long> itemSelectedList) {
        int i;
        SummaryTypeNode typeNode = new SummaryTypeNode();
        typeNode.setId(osType.getId());
        typeNode.setName(osType.getName());
        typeNode.setParent(pType);
        for (i = 0; i < SummaryTreeCache.iSummaryTypeList.size(); ++i) {
            SummaryType ocType = SummaryTreeCache.iSummaryTypeList.get(i);
            if (ocType.getParentId() == null || !ocType.getParentId().equals(osType.getId())) continue;
            typeNode.addChild(this.convertCacheTypeNode(ocType, typeNode, itemSelectedList));
        }
        for (i = 0; i < SummaryTreeCache.iSummaryItemList.size(); ++i) {
            SummaryItem ocItem = SummaryTreeCache.iSummaryItemList.get(i);
            if (!ocItem.getParentId().equals(osType.getId()) || ocItem.isArchived()) continue;
            typeNode.addChild(this.convertCacheItemNode(ocItem, typeNode, itemSelectedList));
        }
        return typeNode;
    }

    private SummaryItemNode convertCacheItemNode(SummaryItem osItem, SummaryTypeNode pType, ArrayList<Long> itemSelectedList) {
        SummaryItemNode itemNode = new SummaryItemNode();
        itemNode.setId(osItem.getId());
        itemNode.setName(osItem.getName());
        itemNode.setParent(pType);
        if (itemSelectedList.contains(osItem.getId())) {
            itemNode.setStatus(SummaryItemNode.SummaryStatus.SELECTED);
        }
        return itemNode;
    }

    public List<SummaryItemNode> getSelectedNodeList() {
        ArrayList<SummaryItemNode> nodeList = new ArrayList<SummaryItemNode>();
        this.checkSelected(nodeList, this.mRoot);
        return nodeList;
    }

    private void checkSelected(List<SummaryItemNode> nodeList, SummaryTypeNode node) {
        for (Object obj : node.getChildList()) {
            if (obj instanceof SummaryItemNode) {
                SummaryItemNode itemNode = (SummaryItemNode)obj;
                if (itemNode.getStatus() != SummaryItemNode.SummaryStatus.SELECTED) continue;
                nodeList.add(itemNode);
                continue;
            }
            if (!(obj instanceof SummaryTypeNode)) continue;
            this.checkSelected(nodeList, (SummaryTypeNode)obj);
        }
    }

    public List<Long> getSelectedIdList() {
        ArrayList<Long> nodeList = new ArrayList<Long>();
        this.checkIdSelected(nodeList, this.mRoot);
        return nodeList;
    }

    private void checkIdSelected(List<Long> nodeList, SummaryTypeNode node) {
        for (Object obj : node.getChildList()) {
            if (obj instanceof SummaryItemNode) {
                SummaryItemNode itemNode = (SummaryItemNode)obj;
                if (itemNode.getStatus() != SummaryItemNode.SummaryStatus.SELECTED) continue;
                nodeList.add(itemNode.getId());
                continue;
            }
            if (!(obj instanceof SummaryTypeNode)) continue;
            this.checkIdSelected(nodeList, (SummaryTypeNode)obj);
        }
    }

    public void filterKey(String filterKey) {
        this.filterNode(this.mRoot, filterKey != null ? filterKey.trim() : null, false);
        this.organizeShowList(this.mRoot);
    }

    private void organizeShowList(SummaryTypeNode node) {
        node.organize();
        for (Object obj : node.getChildList()) {
            if (!(obj instanceof SummaryTypeNode)) continue;
            this.organizeShowList((SummaryTypeNode)obj);
        }
    }

    private void filterNode(SummaryTypeNode typeNode, String filterKey, boolean parentMatchKey) {
        boolean nodeMatchKey = false;
        if (typeNode == this.mRoot) {
            typeNode.setShow(true);
        } else if (StringUtils.isBlank((CharSequence)filterKey)) {
            typeNode.setShow(true);
        } else if (typeNode.getName().toLowerCase().contains(filterKey.toLowerCase())) {
            typeNode.setShow(true);
            nodeMatchKey = true;
        } else {
            typeNode.setShow(parentMatchKey);
        }
        for (Object obj : typeNode.getChildList()) {
            if (obj instanceof SummaryItemNode) {
                SummaryItemNode itemNode = (SummaryItemNode)obj;
                if (itemNode.getStatus() == SummaryItemNode.SummaryStatus.SELECTED) {
                    itemNode.setShow(true);
                    this.checkParentShow(itemNode.getParent());
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)filterKey)) {
                    itemNode.setShow(true);
                    this.checkParentShow(itemNode.getParent());
                    continue;
                }
                if (itemNode.getName().toLowerCase().contains(filterKey.toLowerCase())) {
                    itemNode.setShow(true);
                    this.checkParentShow(itemNode.getParent());
                    continue;
                }
                if (parentMatchKey || nodeMatchKey) {
                    itemNode.setShow(true);
                    this.checkParentShow(itemNode.getParent());
                    continue;
                }
                itemNode.setShow(false);
                continue;
            }
            if (!(obj instanceof SummaryTypeNode)) continue;
            this.filterNode((SummaryTypeNode)obj, filterKey, parentMatchKey ? true : nodeMatchKey);
        }
    }

    private void checkParentShow(SummaryTypeNode node) {
        if (node == null) {
            return;
        }
        node.setShow(true);
        this.checkParentShow(node.getParent());
    }

    @Override
    public Object getRoot() {
        return this.mRoot;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof SummaryTypeNode) {
            SummaryTypeNode t = (SummaryTypeNode)parent;
            return t.getShowChildList().get(index);
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof SummaryTypeNode) {
            SummaryTypeNode t = (SummaryTypeNode)parent;
            return t.getShowChildList().size();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        return !(node instanceof SummaryTypeNode);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        SummaryTypeNode p = (SummaryTypeNode)parent;
        ArrayList<Object> childList = p.getShowChildList();
        for (int i = 0; i < childList.size(); ++i) {
            Object obj = childList.get(i);
            if (!obj.equals(child)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        SummaryItemNode aNode = (SummaryItemNode)path.getLastPathComponent();
        SummaryItemNode newNode = (SummaryItemNode)newValue;
        if (!this.mMultiEnabled && newNode.getStatus() == SummaryItemNode.SummaryStatus.SELECTED) {
            this.uncheckAll();
        }
        aNode.setStatus(newNode.getStatus());
        for (TreeModelListener listener : this.treeModelListenerList) {
            listener.treeNodesChanged(null);
        }
    }

    private void uncheckAll() {
        this.uncheckNode(this.mRoot);
    }

    private void uncheckNode(SummaryTypeNode type) {
        for (Object obj : type.getChildList()) {
            SummaryItemNode item;
            if (obj instanceof SummaryTypeNode) {
                this.uncheckNode((SummaryTypeNode)obj);
                continue;
            }
            if (!(obj instanceof SummaryItemNode) || (item = (SummaryItemNode)obj).getStatus() != SummaryItemNode.SummaryStatus.SELECTED) continue;
            item.setStatus(SummaryItemNode.SummaryStatus.DESELECTED);
        }
    }

    public void swichItemState(SummaryItemNode n) {
        if (!this.mMultiEnabled && n.getStatus() == SummaryItemNode.SummaryStatus.SELECTED) {
            return;
        }
        if (!this.mMultiEnabled && n.getStatus() == SummaryItemNode.SummaryStatus.DESELECTED) {
            this.uncheckAll();
        }
        if (n.getStatus() == SummaryItemNode.SummaryStatus.SELECTED) {
            n.setStatus(SummaryItemNode.SummaryStatus.DESELECTED);
        } else {
            n.setStatus(SummaryItemNode.SummaryStatus.SELECTED);
        }
        for (TreeModelListener listener : this.treeModelListenerList) {
            listener.treeNodesChanged(null);
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListenerList.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListenerList.remove(l);
    }
}

