/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.tool;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class RoundedSelectionPanel
extends JPanel {
    protected int strokeSize = 0;
    private Color strokeColor = Color.GRAY;
    protected boolean highQuality = true;
    protected Dimension arcs = new Dimension(10, 10);
    protected int shadowGap = 5;
    protected int shadowOffset = 4;
    protected int shadowAlpha = 150;
    private boolean mDashBorder = false;

    public RoundedSelectionPanel(boolean dashBorder) {
        this.setOpaque(false);
        this.mDashBorder = dashBorder;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth();
        int height = this.getHeight();
        int shadowGap = this.shadowGap;
        Graphics2D graphics = (Graphics2D)g;
        if (this.highQuality) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        shadowGap = 1;
        graphics.setColor(Color.WHITE);
        graphics.fillRoundRect(0, 0, width - shadowGap, height - shadowGap, this.arcs.width, this.arcs.height);
        graphics.setColor(this.strokeColor);
        if (this.mDashBorder) {
            graphics.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f}, 0.0f));
        } else {
            graphics.setStroke(new BasicStroke(this.strokeSize));
        }
        graphics.drawRoundRect(0, 0, width - shadowGap, height - shadowGap, this.arcs.width, this.arcs.height);
        graphics.setStroke(new BasicStroke());
    }
}

