/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.util;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.client.annotation.MigratedFromMobileApp;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.sorter.NameListGenericSorter;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.mobile.ezuc.bean.ChatRoomInfo;
import com.blisscloud.mobile.ezuc.bean.DeletedContact;
import com.blisscloud.mobile.ezuc.bean.MessageChannel;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.DeletedContactManager;
import com.blisscloud.mobile.ezuc.manager.OutboundPrefixManager;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@MigratedFromMobileApp
public class ChatRoomUtil {
    public static String getMobileContactRoomTitle(Context ctx, ChatRoomInfo chatRoom, String name) {
        if (name == null) {
            if (chatRoom == null || TextUtils.isBlank((CharSequence)chatRoom.getSubject())) {
                return "(" + I18NUtil.getString("common_msg_not_exist") + ")";
            }
            return chatRoom.getSubject().trim() + " (" + I18NUtil.getString("common_msg_not_exist") + ")";
        }
        return name.trim();
    }

    public static String getMyContactRoomTitle(Context ctx, ChatRoomInfo chatRoom, LiteMyContact contact) {
        if (contact == null) {
            if (chatRoom == null || TextUtils.isBlank((CharSequence)chatRoom.getSubject())) {
                return "(" + I18NUtil.getString("common_msg_not_exist") + ")";
            }
            return chatRoom.getSubject().trim() + " (" + I18NUtil.getString("common_msg_not_exist") + ")";
        }
        return contact.getName();
    }

    public static String getMessageChannelRoomTitle(Context ctx, ChatRoomInfo chatRoom, MessageChannel channel, String jid) {
        if (channel == null) {
            DeletedContact delContact = DeletedContactManager.getDeletedContact(ctx, jid);
            if (delContact != null) {
                String contactName = DeletedContactManager.getContactShortName(ctx, delContact);
                return (contactName != null ? contactName : "") + " (" + I18NUtil.getString("common_msg_not_exist") + ")";
            }
            if (chatRoom == null || TextUtils.isBlank((CharSequence)chatRoom.getSubject())) {
                return JidUtil.getJidName(jid) + " (" + I18NUtil.getString("common_msg_not_exist") + ")";
            }
            return chatRoom.getSubject().trim() + " (" + I18NUtil.getString("common_msg_not_exist") + ")";
        }
        return channel.getName();
    }

    public static String getEmpRoomTitle(Context ctx, ChatRoomInfo chatRoom, LiteContact contact, String jid) {
        if (contact == null) {
            DeletedContact delContact = DeletedContactManager.getDeletedContact(ctx, jid);
            if (delContact != null) {
                String contactName = DeletedContactManager.getContactFullName(delContact);
                return (contactName != null ? contactName : "") + " (" + I18NUtil.getString("common_msg_not_exist") + ")";
            }
            if (chatRoom == null || TextUtils.isBlank((CharSequence)chatRoom.getSubject())) {
                return JidUtil.getJidName(jid) + " (" + I18NUtil.getString("common_msg_not_exist") + ")";
            }
            return chatRoom.getSubject().trim() + " (" + I18NUtil.getString("common_msg_not_exist") + ")";
        }
        return ContactManager.getContactFullName(contact);
    }

    public static String getLocationRoomTitle(Context ctx, ChatRoomInfo chatRoom, LiteContact contact, String jid) {
        if (contact == null) {
            DeletedContact delContact = DeletedContactManager.getDeletedContact(ctx, jid);
            if (delContact != null) {
                String contactName = delContact.getOtherName();
                if (StringUtils.isBlank((CharSequence)contactName)) {
                    contactName = I18NUtil.getString("abook_label_public_phone");
                }
                return contactName + " (" + I18NUtil.getString("common_msg_not_exist") + ")";
            }
            if (chatRoom == null || TextUtils.isEmpty((CharSequence)chatRoom.getSubject())) {
                String contactName = I18NUtil.getString("abook_label_public_phone");
                return contactName + " (" + I18NUtil.getString("common_msg_not_exist") + ")";
            }
            return chatRoom.getSubject().trim() + " (" + I18NUtil.getString("common_msg_not_exist") + ")";
        }
        return contact.getDispName();
    }

    private static String genConfRoomTitle(Context context, LiteConferenceRoom room, boolean hasRoomNo, boolean hasLock) {
        if (room == null || room.getName() == null || "".equals(room.getName().trim()) || "i18n.multi.conference".equals(room.getName().trim())) {
            return I18NUtil.getString("conference_label");
        }
        Object v = room.getName();
        if (hasRoomNo) {
            String roomNo = OutboundPrefixManager.getMeetmePrefix(context) + room.getRoomNo();
            v = (String)v + " (" + roomNo + ")";
        }
        if (hasLock && room.isLocked()) {
            v = (String)v + " (" + I18NUtil.getString("conference_locked_s") + ")";
        }
        return v;
    }

    public static String genConfRoomTitleSimple(Context context, LiteConferenceRoom room) {
        if (room == null || room.getName() == null || "".equals(room.getName().trim()) || "i18n.multi.conference".equals(room.getName().trim())) {
            return I18NUtil.getString("conference_label");
        }
        return room.getName();
    }

    public static String getConfRoomTitle(Context ctx, ChatRoomInfo chatRoom, LiteConferenceRoom room) {
        return ChatRoomUtil.getConfRoomTitle(ctx, chatRoom, room, true, true);
    }

    public static String getConfRoomTitle(Context ctx, ChatRoomInfo chatRoom, LiteConferenceRoom room, boolean hasRoomNo, boolean hasLock) {
        if (room != null) {
            return ChatRoomUtil.genConfRoomTitle(ctx, room, hasRoomNo, hasLock);
        }
        if (chatRoom != null && ChatRoomManager.nameExist(chatRoom)) {
            return chatRoom.getSubject() + " (" + I18NUtil.getString("conference_notice_room_deleted") + ")";
        }
        return I18NUtil.getString("conference_label") + " (" + I18NUtil.getString("conference_notice_room_deleted") + ")";
    }

    public static String getChatRoomTitle(Context ctx, ChatRoomInfo chatRoom) {
        if (chatRoom == null) {
            return I18NUtil.getString("chatroom_label") + " (" + I18NUtil.getString("conference_notice_room_deleted") + ")";
        }
        if ("i18n.three.way.calling".equals(chatRoom.getSubject())) {
            return I18NUtil.getString("call_type_three_way_calling");
        }
        if (ChatRoomManager.nameExist(chatRoom)) {
            return chatRoom.getSubject();
        }
        return I18NUtil.getString("chatroom_label");
    }

    public static String getChatRoomTitleForList(Context ctx, ChatRoomInfo chatRoom, List<String> participants, Map<String, LiteContact> contactsMap) {
        if (chatRoom == null) {
            return I18NUtil.getString("chatroom_label") + " (" + I18NUtil.getString("conference_notice_room_deleted") + ")";
        }
        if ("i18n.three.way.calling".equals(chatRoom.getSubject())) {
            return I18NUtil.getString("call_type_three_way_calling");
        }
        if (ChatRoomManager.nameExist(chatRoom)) {
            return chatRoom.getSubject();
        }
        ArrayList<String> nameList = new ArrayList<String>();
        for (int k = 0; participants != null && k < participants.size(); ++k) {
            String jid = participants.get(k);
            LiteContact xcontact = ContactManager.getContact(ctx, contactsMap, jid);
            if (xcontact == null) continue;
            nameList.add(ContactManager.getContactShortName(ctx, xcontact));
        }
        Collections.sort(nameList, new NameListGenericSorter());
        String comma = I18NUtil.getString("comma");
        StringBuffer titleStr = new StringBuffer();
        for (int jj = 0; jj < nameList.size(); ++jj) {
            String name = (String)nameList.get(jj);
            if (jj != 0) {
                titleStr.append(comma);
            }
            titleStr.append(name);
        }
        return titleStr.toString();
    }
}

