/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.util;

import com.blisscloud.ezuc.client.resource.I18NUtil;

public class CustomerUtils {
    public static String getExpireTime(long countdown) {
        if (countdown <= 0L) {
            return String.format(I18NUtil.getString("wechat_remain"), "00:00");
        }
        long hour = countdown / 1000L / 60L / 60L;
        long minius = countdown / 1000L / 60L % 60L;
        long days = hour / 24L;
        long hourRest = hour % 24L;
        String suffix = CustomerUtils.twoDigit(hourRest) + ":" + CustomerUtils.twoDigit(minius);
        if (days > 1L) {
            return String.format(I18NUtil.getString("wechat_remain_more_days"), String.valueOf(days), suffix);
        }
        if (days > 0L) {
            return String.format(I18NUtil.getString("wechat_remain_more_day"), String.valueOf(days), suffix);
        }
        return String.format(I18NUtil.getString("wechat_remain"), suffix);
    }

    private static String twoDigit(long d) {
        if (d < 10L) {
            return "0" + d;
        }
        return String.valueOf(d);
    }

    public static String getExpireTimeRemaining(long countdown) {
        long minius;
        long hour = countdown <= 0L ? 0L : countdown / 1000L / 60L / 60L;
        long l = minius = countdown <= 0L ? 0L : countdown / 1000L / 60L % 60L;
        if (hour == 0L && minius == 0L) {
            return I18NUtil.getString("wechat_service_is_closed");
        }
        return String.format(I18NUtil.getString("wechat_countdown_remaining"), "" + hour, "" + minius);
    }
}

