/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.util;

import java.io.File;

public class FileUploadException
extends RuntimeException {
    public static final int TYPE_NOT_FOUND = 0;
    public static final int TYPE_SIZE_EXCEED = 10;
    public static final int TYPE_UNSUPPORTED_TYPE = 20;
    public static final int TYPE_FAIL = 30;
    int type;
    File file;
    Exception cause;

    public FileUploadException(int type, File file) {
        this.type = type;
        this.file = file;
    }

    public FileUploadException(int type, File file, Exception cause) {
        this.type = type;
        this.file = file;
        this.cause = cause;
    }

    public int getType() {
        return this.type;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public Exception getCause() {
        return this.cause;
    }

    @Override
    public String getMessage() {
        switch (this.type) {
            case 0: {
                return "file is null or not found " + String.valueOf(this.file) != null ? this.file.getAbsolutePath() : "";
            }
            case 10: {
                return "file size exceed! " + String.valueOf(this.file) != null ? this.file.getAbsolutePath() : "";
            }
            case 20: {
                return "unsupported file type " + String.valueOf(this.file) != null ? this.file.getAbsolutePath() : "";
            }
            case 30: {
                return "upload failed " + (this.cause != null ? this.cause.getMessage() : "");
            }
        }
        return "";
    }
}

