/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.util;

import com.blisscloud.ezuc.client.util.simulate.AsyncTask;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.listener.IProgressUpdateListener;
import com.blisscloud.mobile.ezuc.util.CommonUtil;

public class HttpDownloadUtil
extends AsyncTask<Void, Long, Void>
implements IProgressUpdateListener {
    private static final int CONNECTIONTIMEOUT = 15000;
    private final Context mCtx;
    private final String mURL;
    private final IDownloadListener mListener;
    private boolean mFail = true;
    private boolean mCompleted = false;
    private Thread mRequestThread;
    private boolean mTerminated;
    private long mPercent = 0L;

    public HttpDownloadUtil(Context ctx, String url, IDownloadListener listener) {
        this.mCtx = ctx;
        this.mURL = url;
        this.mListener = listener;
        this.mTerminated = false;
    }

    @Override
    protected void onCancelled(Void result) {
        this.mTerminated = true;
        super.onCancelled(result);
    }

    protected Void doInBackground(Void ... arg0) {
        long startTime = System.currentTimeMillis();
        Request request = new Request();
        this.mRequestThread = new Thread((Runnable)request, "HttpDownloadUtil");
        this.mRequestThread.start();
        long duration = 0L;
        try {
            do {
                Thread.sleep(300L);
            } while (!this.mCompleted && (duration = System.currentTimeMillis() - startTime) < 15000L && !this.mTerminated);
        }
        catch (InterruptedException e) {
            Log.e(this.getClass().getSimpleName(), "HttpRequestUtil", e);
        }
        if (this.mRequestThread.isAlive()) {
            Log.i(this.getClass().getSimpleName(), "HttpRequestUtil stop request thread");
            this.mRequestThread.interrupt();
            this.mRequestThread = null;
        }
        return null;
    }

    protected void onProgressUpdate(Long ... values) {
        if (this.mListener != null && !this.isCancelled() && values != null && values.length > 0) {
            this.mListener.onProgessUpdate(values[0].intValue());
        }
        super.onProgressUpdate(values);
    }

    @Override
    protected void onPostExecute(Void result) {
        super.onPostExecute(result);
        if (this.mListener != null && !this.isCancelled()) {
            this.mListener.onRequestCompleted(this.mFail);
        }
    }

    @Override
    public void onProgessUpdate(long value) {
        this.mPercent = value;
        this.publishProgress(this.mPercent);
    }

    public static interface IDownloadListener {
        public void onProgessUpdate(int var1);

        public void onRequestCompleted(boolean var1);
    }

    private class Request
    implements Runnable {
        private Request() {
        }

        @Override
        public void run() {
            HttpDownloadUtil.this.mFail = CommonUtil.doHttpRequest(HttpDownloadUtil.this.mCtx, HttpDownloadUtil.this.mURL, HttpDownloadUtil.this, true);
            HttpDownloadUtil.this.mCompleted = true;
        }
    }
}

