/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.util;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.client.annotation.MigratedFromMobileApp;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.sorter.NameListGenericSorter;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@MigratedFromMobileApp
public class MessageContentUtil {
    public static LiteContact getFromContact(Context context, Map<String, LiteContact> userCacheMap, String fromJid) {
        LiteContact contact = null;
        if (userCacheMap.containsKey(fromJid)) {
            contact = userCacheMap.get(fromJid);
        } else {
            contact = ContactManager.getContact(context, fromJid);
            if (contact != null) {
                userCacheMap.put(fromJid, contact);
            }
        }
        return contact;
    }

    public static String convertMessage(Context ctx, Message msg, Map<String, LiteContact> userCacheMap, boolean isConfRoom) {
        String rContext;
        block110: {
            int msgType = msg.getMsgType();
            rContext = "";
            if (msgType == 201) {
                rContext = msg.getContent();
                try {
                    JSONObject jsonObj = new JSONObject(msg.getContent());
                    if (jsonObj.has("promptType") && jsonObj.getInt("promptType") == 19) {
                        UCDBMessage.updateChatMsgType(ctx, msg.getPacketId(), 318);
                        rContext = I18NUtil.getString("customer_notice_msg_send_failed");
                    }
                }
                catch (JSONException t) {
                    Log.e(MessageContentUtil.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
                }
            } else if (msgType == 311) {
                rContext = I18NUtil.getString("customer_notice_unregistration");
            } else if (msgType == 312) {
                rContext = I18NUtil.getString("customer_notice_timeout");
            } else if (msgType == 313) {
                rContext = I18NUtil.getString("customer_notice_closed_by_agent_self");
                try {
                    JSONObject jsonObj = new JSONObject(msg.getContent());
                    if (!jsonObj.has("executer")) break block110;
                    String executor = jsonObj.getString("executer");
                    LiteContact self = PreferencesUtil.getUserInfo(ctx);
                    String executorJid = executor + "@blisscloud.com";
                    if (self != null && !self.getJid().equals(executorJid)) {
                        String actorName = ContactManager.getContactShortName(ctx, userCacheMap, executorJid);
                        rContext = String.format(I18NUtil.getString("customer_notice_closed_by_agent_other"), actorName);
                    }
                }
                catch (JSONException t) {
                    Log.e(MessageContentUtil.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
                }
            } else if (msgType == 314) {
                try {
                    JSONObject jsonObj = new JSONObject(msg.getContent());
                    if (jsonObj.has("executer")) {
                        String executor;
                        String actorName = executor = jsonObj.getString("executer");
                        String executerType = "user";
                        if (jsonObj.has("executerType")) {
                            executerType = jsonObj.getString("executerType");
                        }
                        if (!executerType.equals("admin")) {
                            String executorJid = executor + "@blisscloud.com";
                            actorName = ContactManager.getContactShortName(ctx, userCacheMap, executorJid);
                        }
                        rContext = String.format(I18NUtil.getString("customer_notice_closed_by_admin"), actorName);
                    }
                }
                catch (JSONException t) {
                    Log.e(MessageContentUtil.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
                }
            } else if (msgType == 315) {
                try {
                    LiteContact self;
                    JSONObject jsonObj = new JSONObject(msg.getContent());
                    if (jsonObj.has("transferor")) {
                        String transferor = jsonObj.getString("transferor");
                        String transferorJid = transferor + "@blisscloud.com";
                        self = PreferencesUtil.getUserInfo(ctx);
                        if (self != null && !self.getJid().equals(transferorJid)) {
                            rContext = String.format(I18NUtil.getString("customer_notice_sys_reassign_from_you"), new Object[0]);
                        }
                    }
                    if (!jsonObj.has("transferee")) break block110;
                    String transferee = jsonObj.getString("transferee");
                    String transfereeJid = transferee + "@blisscloud.com";
                    self = PreferencesUtil.getUserInfo(ctx);
                    if (self != null && !self.getJid().equals(transfereeJid)) {
                        rContext = String.format(I18NUtil.getString("customer_notice_sys_reassign_to_you"), new Object[0]);
                    }
                }
                catch (JSONException t) {
                    Log.e(MessageContentUtil.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
                }
            } else if (msgType == 316) {
                try {
                    JSONObject jsonObj = new JSONObject(msg.getContent());
                    String adminTransfer = jsonObj.optString("adminTransfer", "0");
                    if ("1".equals(adminTransfer)) {
                        LiteContact self;
                        String executor;
                        String actorName = executor = jsonObj.getString("executer");
                        String executerType = "user";
                        if (jsonObj.has("executerType")) {
                            executerType = jsonObj.getString("executerType");
                        }
                        if (!executerType.equals("admin")) {
                            String executorJid = executor + "@blisscloud.com";
                            actorName = ContactManager.getContactShortName(ctx, userCacheMap, executorJid);
                        }
                        String transferorJid = null;
                        String transfereeJid = null;
                        if (jsonObj.has("transferor")) {
                            transferorJid = jsonObj.getString("transferor") + "@blisscloud.com";
                        }
                        if (jsonObj.has("transferee")) {
                            transfereeJid = jsonObj.getString("transferee") + "@blisscloud.com";
                        }
                        if ((self = PreferencesUtil.getUserInfo(ctx)) != null) {
                            if (self.getJid().equals(transfereeJid)) {
                                rContext = String.format(I18NUtil.getString("customer_notice_admin_reassign_to_you"), actorName);
                            }
                            if (self.getJid().equals(transferorJid)) {
                                String transfereeName = ContactManager.getContactShortName(ctx, userCacheMap, transfereeJid);
                                rContext = String.format(I18NUtil.getString("customer_notice_admin_reassign_from_you"), actorName, transfereeName);
                            }
                        }
                    } else {
                        LiteContact self;
                        String transferorJid = null;
                        String transfereeJid = null;
                        if (jsonObj.has("transferor")) {
                            transferorJid = jsonObj.getString("transferor") + "@blisscloud.com";
                        }
                        if (jsonObj.has("transferee")) {
                            transfereeJid = jsonObj.getString("transferee") + "@blisscloud.com";
                        }
                        if ((self = PreferencesUtil.getUserInfo(ctx)) != null) {
                            String actorName;
                            if (self.getJid().equals(transfereeJid)) {
                                actorName = ContactManager.getContactShortName(ctx, userCacheMap, transferorJid);
                                rContext = String.format(I18NUtil.getString("customer_notice_agent_reassign_to_you"), actorName);
                            }
                            if (self.getJid().equals(transferorJid)) {
                                actorName = ContactManager.getContactShortName(ctx, userCacheMap, transfereeJid);
                                rContext = String.format(I18NUtil.getString("customer_notice_agent_reassign_from_you"), actorName);
                            }
                        }
                    }
                }
                catch (JSONException t) {
                    Log.e(MessageContentUtil.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
                }
            } else if (msgType == 317) {
                rContext = I18NUtil.getString("customer_notice_sys_closed");
            } else if (msgType == 318) {
                rContext = I18NUtil.getString("customer_notice_msg_send_failed");
            } else if (msgType == 251 || msgType == 252) {
                rContext = String.format(isConfRoom ? I18NUtil.getString("chat_join_conf_room_you_self") : I18NUtil.getString("chat_join_chat_room_you_self"), new Object[0]);
            } else if (msgType == 253) {
                String actorName = ContactManager.getContactShortName(ctx, userCacheMap, msg.getFromJid());
                rContext = String.format(isConfRoom ? I18NUtil.getString("chat_join_conf_room_other_you") : I18NUtil.getString("chat_join_chat_room_other_you"), actorName);
            } else if (msgType == 254 || msgType == 255) {
                String joinMembers = MessageContentUtil.getMembers(ctx, userCacheMap, msg.getToJid());
                rContext = String.format(isConfRoom ? I18NUtil.getString("chat_join_conf_room_you_other_self") : I18NUtil.getString("chat_join_chat_room_you_other_self"), joinMembers);
            } else if (msgType == 256) {
                String actorName = ContactManager.getContactShortName(ctx, userCacheMap, msg.getFromJid());
                String joinMembers = MessageContentUtil.getMembers(ctx, userCacheMap, msg.getToJid());
                rContext = String.format(isConfRoom ? I18NUtil.getString("chat_join_conf_room_you_other_other") : I18NUtil.getString("chat_join_chat_room_you_other_other"), actorName, joinMembers);
            } else if (msgType == 257) {
                String joinMembers = MessageContentUtil.getMembers(ctx, userCacheMap, msg.getToJid());
                rContext = String.format(isConfRoom ? I18NUtil.getString("chat_join_conf_room_other_self") : I18NUtil.getString("chat_join_chat_room_other_self"), joinMembers);
            } else if (msgType == 258) {
                String joinMembers = MessageContentUtil.getMembers(ctx, userCacheMap, msg.getToJid());
                rContext = String.format(isConfRoom ? I18NUtil.getString("chat_join_conf_room_you_other") : I18NUtil.getString("chat_join_chat_room_you_other"), joinMembers);
            } else if (msgType == 259) {
                String actorName = ContactManager.getContactShortName(ctx, userCacheMap, msg.getFromJid());
                String joinMembers = MessageContentUtil.getMembers(ctx, userCacheMap, msg.getToJid());
                rContext = String.format(isConfRoom ? I18NUtil.getString("chat_join_conf_room_other_other") : I18NUtil.getString("chat_join_chat_room_other_other"), actorName, joinMembers);
            } else if (msgType == 261 || msgType == 262) {
                rContext = String.format(isConfRoom ? I18NUtil.getString("chat_leave_conf_room_you_self") : I18NUtil.getString("chat_leave_chat_room_you_self"), new Object[0]);
            } else if (msgType == 263) {
                String actorName = ContactManager.getContactShortName(ctx, userCacheMap, msg.getFromJid());
                rContext = String.format(isConfRoom ? I18NUtil.getString("chat_leave_conf_room_other_you") : I18NUtil.getString("chat_leave_chat_room_other_you"), actorName);
            } else if (msgType == 264 || msgType == 265) {
                String joinMembers = MessageContentUtil.getMembers(ctx, userCacheMap, msg.getToJid());
                rContext = String.format(isConfRoom ? I18NUtil.getString("chat_leave_conf_room_you_other_self") : I18NUtil.getString("chat_leave_chat_room_you_other_self"), joinMembers);
            } else if (msgType == 266) {
                String actorName = ContactManager.getContactShortName(ctx, userCacheMap, msg.getFromJid());
                String joinMembers = MessageContentUtil.getMembers(ctx, userCacheMap, msg.getToJid());
                rContext = String.format(isConfRoom ? I18NUtil.getString("chat_leave_conf_room_you_other_other") : I18NUtil.getString("chat_leave_chat_room_you_other_other"), actorName, joinMembers);
            } else if (msgType == 267) {
                String joinMembers = MessageContentUtil.getMembers(ctx, userCacheMap, msg.getToJid());
                rContext = String.format(isConfRoom ? I18NUtil.getString("chat_leave_conf_room_other_self") : I18NUtil.getString("chat_leave_chat_room_other_self"), joinMembers);
            } else if (msgType == 268) {
                String joinMembers = MessageContentUtil.getMembers(ctx, userCacheMap, msg.getToJid());
                rContext = String.format(isConfRoom ? I18NUtil.getString("chat_leave_conf_room_you_other") : I18NUtil.getString("chat_leave_chat_room_you_other"), joinMembers);
            } else if (msgType == 269) {
                String actorName = ContactManager.getContactShortName(ctx, userCacheMap, msg.getFromJid());
                String joinMembers = MessageContentUtil.getMembers(ctx, userCacheMap, msg.getToJid());
                rContext = msg.getFromJid() != null && msg.getToJid() != null && msg.getFromJid().equals(msg.getToJid()) ? String.format(isConfRoom ? I18NUtil.getString("chat_leave_conf_room_other_self") : I18NUtil.getString("chat_leave_chat_room_other_self"), joinMembers) : String.format(isConfRoom ? I18NUtil.getString("chat_leave_conf_room_other_other") : I18NUtil.getString("chat_leave_chat_room_other_other"), actorName, joinMembers);
            } else if (msgType == 213) {
                rContext = isConfRoom ? I18NUtil.getString("chat_join_conf_room_you_self") : I18NUtil.getString("chat_join_chat_room_you_self");
            } else if (msgType == 210) {
                try {
                    Type listType = new TypeToken<List<String>>(){}.getType();
                    List jidList = (List)new Gson().fromJson(msg.getContent(), listType);
                    if (jidList.size() == 2) {
                        String fromJid = (String)jidList.get(0);
                        String toJid = (String)jidList.get(1);
                        String name1 = ContactManager.getContactShortName(ctx, userCacheMap, fromJid);
                        String name2 = ContactManager.getContactShortName(ctx, userCacheMap, toJid);
                        rContext = String.format(isConfRoom ? I18NUtil.getString("chat_join_conf_room_other_other") : I18NUtil.getString("chat_join_chat_room_other_other"), name1, name2);
                        break block110;
                    }
                    if (jidList.size() == 1) {
                        String fromJid = (String)jidList.get(0);
                        String name = ContactManager.getContactShortName(ctx, userCacheMap, fromJid);
                        rContext = String.format(isConfRoom ? I18NUtil.getString("chat_join_conf_room_other_self") : I18NUtil.getString("chat_join_chat_room_other_self"), name);
                        break block110;
                    }
                    rContext = "";
                }
                catch (Throwable t) {
                    Log.e(MessageContentUtil.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
                    rContext = "";
                }
            } else if (msgType == 211) {
                try {
                    if (msg.getContent() != null) {
                        Type strType = new TypeToken<String>(){}.getType();
                        String fromJid = (String)new Gson().fromJson(msg.getContent(), strType);
                        String name = ContactManager.getContactShortName(ctx, userCacheMap, fromJid);
                        rContext = String.format(isConfRoom ? I18NUtil.getString("chat_join_conf_room_other_you") : I18NUtil.getString("chat_join_chat_room_other_you"), name);
                        break block110;
                    }
                    rContext = isConfRoom ? I18NUtil.getString("chat_join_conf_room_you_self") : I18NUtil.getString("chat_join_chat_room_you_self");
                }
                catch (Throwable t) {
                    Log.e(MessageContentUtil.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
                    rContext = "";
                }
            } else if (msgType == 212) {
                try {
                    Type listType = new TypeToken<List<String>>(){}.getType();
                    List jidList = (List)new Gson().fromJson(msg.getContent(), listType);
                    String joinMembers = MessageContentUtil.getMembers(ctx, userCacheMap, jidList);
                    rContext = String.format(isConfRoom ? I18NUtil.getString("chat_join_conf_room_you_other") : I18NUtil.getString("chat_join_chat_room_you_other"), joinMembers);
                }
                catch (Throwable t) {
                    Log.e(MessageContentUtil.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
                    rContext = "";
                }
            } else if (msgType == 214) {
                String name = ContactManager.getContactShortName(ctx, userCacheMap, msg.getFromJid());
                rContext = String.format(isConfRoom ? I18NUtil.getString("chat_leave_conf_room_other_self") : I18NUtil.getString("chat_leave_chat_room_other_self"), name);
            } else if (msgType == 215) {
                rContext = String.format(isConfRoom ? I18NUtil.getString("chat_leave_conf_room_you_self") : I18NUtil.getString("chat_leave_chat_room_you_self"), new Object[0]);
            } else if (msgType == 216) {
                String name = ContactManager.getContactShortName(ctx, userCacheMap, msg.getFromJid());
                rContext = String.format(isConfRoom ? I18NUtil.getString("chat_leave_conf_room_other_you") : I18NUtil.getString("chat_leave_chat_room_other_you"), name);
            } else if (msgType == 231) {
                rContext = String.format(I18NUtil.getString("chat_meetme_join_chat_room"), new Object[0]);
            } else if (msgType == 232) {
                Object name = ContactManager.getContactShortName(ctx, userCacheMap, msg.getFromJid());
                if (name == null) {
                    name = msg.getContent() + " ";
                }
                rContext = String.format(I18NUtil.getString("chat_meetme_join_chat_room_other"), name);
            } else if (msgType == 233) {
                rContext = String.format(I18NUtil.getString("chat_meetme_leave_chat_room"), new Object[0]);
            } else if (msgType == 234) {
                Object name = ContactManager.getContactShortName(ctx, userCacheMap, msg.getFromJid());
                if (name == null) {
                    name = msg.getContent() + " ";
                }
                rContext = String.format(I18NUtil.getString("chat_meetme_leave_chat_room_other"), name);
            }
        }
        return "  " + rContext + "  ";
    }

    private static String getMembers(Context ctx, Map<String, LiteContact> userCacheMap, String memberJid) {
        StringBuffer nameListBuffer = new StringBuffer();
        ArrayList<String> nameList = new ArrayList<String>();
        String[] toJidAry = memberJid.split(",");
        for (int k = 0; toJidAry != null && k < toJidAry.length; ++k) {
            nameList.add(ContactManager.getContactShortName(ctx, userCacheMap, toJidAry[k]));
        }
        Collections.sort(nameList, new NameListGenericSorter());
        String comma = I18NUtil.getString("comma");
        for (int k = 0; k < nameList.size(); ++k) {
            String name = (String)nameList.get(k);
            if (k != 0) {
                nameListBuffer.append(comma);
            }
            nameListBuffer.append(name);
        }
        return nameListBuffer.toString();
    }

    private static String getMembers(Context ctx, Map<String, LiteContact> userCacheMap, List<String> jidList) {
        StringBuffer nameListBuffer = new StringBuffer();
        ArrayList<String> nameList = new ArrayList<String>();
        for (int k = 0; jidList != null && k < jidList.size(); ++k) {
            nameList.add(ContactManager.getContactShortName(ctx, userCacheMap, jidList.get(k)));
        }
        Collections.sort(nameList, new NameListGenericSorter());
        String comma = I18NUtil.getString("comma");
        for (int k = 0; k < nameList.size(); ++k) {
            String name = (String)nameList.get(k);
            if (k != 0) {
                nameListBuffer.append(comma);
            }
            nameListBuffer.append(name);
        }
        return nameListBuffer.toString();
    }
}

