/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.util;

import com.blisscloud.ezuc.client.annotation.MigratedFromMobileApp;
import com.blisscloud.ezuc.client.util.Utils;
import com.blisscloud.ezuc.client.util.simulate.AsyncTask;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

@MigratedFromMobileApp
public class PhotoTask
extends AsyncTask<Object, Void, Image> {
    private IPhotoCallBack mCallBack;
    private String mUrlsub;
    private String mJid;
    private Long mId;

    public IPhotoCallBack getCallBack() {
        return this.mCallBack;
    }

    public void setCallBack(IPhotoCallBack callBack) {
        this.mCallBack = callBack;
    }

    private boolean checkParameters(Object ... params) {
        return params != null && params.length > 3 && params[0] instanceof String && params[1] instanceof Long && params[2] instanceof Context && params[3] instanceof String;
    }

    @Override
    protected Image doInBackground(Object ... params) {
        if (!this.checkParameters(params)) {
            return null;
        }
        BufferedImage bitmap = null;
        this.mUrlsub = (String)params[0];
        this.mId = (Long)params[1];
        Context ctx = (Context)params[2];
        this.mJid = (String)params[3];
        boolean external = "/ucrm/contact/showBigPhoto?contactId=".equals(this.mUrlsub);
        bitmap = external ? FileUtil.readContactBigPhoto(this.mId) : FileUtil.readJidBigPhoto(this.mJid);
        if (bitmap == null) {
            return this.getPhotoFromWebSite(ctx, external);
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image getPhotoFromWebSite(Context ctx, boolean external) {
        StringBuilder urlBuilder = new StringBuilder();
        String url = null;
        InputStream is = null;
        BufferedImage bitmap = null;
        HttpClient mHttpClient = null;
        try {
            urlBuilder.append("https://");
            urlBuilder.append(CommonUtil.getHttpsIpPort(ctx));
            urlBuilder.append(this.mUrlsub);
            urlBuilder.append(this.mId);
            url = urlBuilder.toString();
            mHttpClient = CommonUtil.getHttpsClient(ctx, true);
            if (url == null || mHttpClient == null) {
                Image image = null;
                return image;
            }
            HttpGet request = new HttpGet();
            request.setURI(new URI(url));
            HttpResponse response = mHttpClient.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() != 200) {
                request.abort();
                Image image = null;
                Utils.closeStream(is);
                return image;
            }
            is = response.getEntity().getContent();
            if (external) {
                FileUtil.writeContactBigPhoto(this.mId, is);
                bitmap = FileUtil.readContactBigPhoto(this.mId);
            } else {
                FileUtil.writeJidBigPhoto(this.mJid, is);
                bitmap = FileUtil.readJidBigPhoto(this.mJid);
            }
            Utils.closeStream(is);
        }
        catch (Exception e) {
            Log.e(this.getClass().getSimpleName(), "doInBackground fail ", e);
            if (external) {
                FileUtil.deleteContactBigPhoto(this.mId);
            } else {
                FileUtil.deleteJidBigPhoto(this.mJid);
            }
        }
        finally {
            Utils.closeStream(is);
        }
        return bitmap;
    }

    @Override
    protected void onPostExecute(Image result) {
        super.onPostExecute(result);
        if (result != null) {
            if (this.mCallBack != null) {
                this.mCallBack.loadSuccess(result);
            }
        } else if (this.mCallBack != null) {
            this.mCallBack.loadFail(this.mUrlsub + "/" + this.mJid);
        }
    }

    @Override
    protected void onCancelled(Image result) {
        if (result != null) {
            result = null;
        }
        super.onCancelled(result);
    }

    public static interface IPhotoCallBack {
        public void loadSuccess(Image var1);

        public void loadFail(String var1);
    }
}

