/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.util;

public class TransferUtil {
    public static String calculateSpeed(long bytediff, long timediff) {
        double kB = TransferUtil.calculateSpeedLong(bytediff, timediff);
        if (bytediff == 0L && timediff == 0L) {
            return "";
        }
        if (kB < 1024.0) {
            String KB = Double.toString(kB);
            KB = TransferUtil.splitAtDot(KB, 1);
            return KB + "kB/s";
        }
        String MB = Double.toString(kB / 1024.0);
        MB = TransferUtil.splitAtDot(MB, 1);
        return MB + "MB/s";
    }

    public static double calculateSpeedLong(long bytediff, long timediff) {
        timediff = timediff == 0L ? 1L : timediff;
        double kB = (double)(bytediff / timediff) * 1000.0 / 1024.0;
        return kB;
    }

    public static String calculateEstimate(long currentsize, long totalsize, long timestart, long timenow) {
        long timediff = timenow - timestart;
        long sizeleft = totalsize - currentsize;
        currentsize = currentsize == 0L ? 1L : currentsize;
        long x = sizeleft * timediff / currentsize;
        return TransferUtil.convertSecondstoHHMMSS(Math.round(x /= 1000L));
    }

    public static String convertSecondstoHHMMSS(int second) {
        int hours = Math.round(second / 3600);
        int minutes = Math.round(second / 60 % 60);
        int seconds = Math.round(second % 60);
        String hh = hours < 10 ? "0" + hours : "" + hours;
        String mm = minutes < 10 ? "0" + minutes : "" + minutes;
        String ss = seconds < 10 ? "0" + seconds : "" + seconds;
        return hh + ":" + mm + ":" + ss;
    }

    public static String getAppropriateByteWithSuffix(long bytes) {
        if (bytes >= 0x10000000000L) {
            String x = TransferUtil.splitAtDot("" + bytes / 0x10000000000L, 2);
            return x + " TB";
        }
        if (bytes >= 0x40000000L) {
            String x = TransferUtil.splitAtDot("" + bytes / 0x40000000L, 2);
            return x + " GB";
        }
        if (bytes >= 0x100000L) {
            String x = TransferUtil.splitAtDot("" + bytes / 0x100000L, 2);
            return x + " MB";
        }
        if (bytes >= 1024L) {
            String x = TransferUtil.splitAtDot("" + bytes / 1024L, 2);
            return x + " KB";
        }
        return bytes + " B";
    }

    private static String splitAtDot(String string, int significantdigits) {
        if (string.contains(".")) {
            String s = string.replace(".", "T").split("T")[1];
            if (s.length() >= significantdigits) {
                return string.substring(0, string.indexOf(".") + 1 + significantdigits);
            }
            return string.substring(0, string.indexOf(".") + 1 + s.length());
        }
        return string;
    }
}

