/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.util;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.annotation.MigratedFromMobileApp;
import com.blisscloud.ezuc.client.util.PackageInfo;
import com.blisscloud.ezuc.client.util.simulate.Bundle;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import java.util.Properties;

@MigratedFromMobileApp
public class VersionCheckUtils {
    public static PackageInfo getVersionInfo(Context ctx) {
        Properties versionProp = new Properties();
        try {
            versionProp.load(UCChatClient.class.getResourceAsStream("/version.info"));
            String releaseVersion = versionProp.getProperty("release.version");
            int releaseVersionCode = Integer.parseInt(versionProp.getProperty("release.version.code"));
            PackageInfo info = new PackageInfo();
            info.setVersionInfo(releaseVersion);
            info.setVersionCode(releaseVersionCode);
            return info;
        }
        catch (Exception e) {
            Log.e(VersionCheckUtils.class.getSimpleName(), e.getLocalizedMessage(), e);
            return null;
        }
    }

    public static boolean isSameVersion(Bundle extras, int nowVersion) {
        if (!extras.containsKey("versionCode")) {
            return false;
        }
        int versionCode = extras.getInt("versionCode");
        return nowVersion < versionCode;
    }
}

